/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.color;

import java.awt.Color;
import org.geotools.brewer.color.BrewerPalette;
import org.geotools.brewer.color.ColorBrewer;
import org.geotools.feature.Feature;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.function.ClassificationFunction;

public class PaletteFunction
extends FunctionExpressionImpl
implements FunctionExpression {
    ClassificationFunction classifier;
    String paletteName;
    FilterFactory ff;

    public PaletteFunction() {
        this(FilterFactoryFinder.createFilterFactory());
    }

    public PaletteFunction(FilterFactory factory) {
        super("Palette");
        this.ff = factory;
    }

    public void setFilterFactory(FilterFactory factory) {
        this.ff = factory;
    }

    public int getArgCount() {
        return 2;
    }

    public Expression[] getArgs() {
        Expression[] ret = new Expression[]{this.classifier, this.ff.createLiteralExpression(this.paletteName)};
        return ret;
    }

    public void setArgs(Expression[] args) {
        this.classifier = (ClassificationFunction)args[0];
        this.paletteName = ((LiteralExpression)args[1]).getLiteral().toString();
    }

    public Expression getEvaluationExpression() {
        return this.classifier.getExpression();
    }

    public void setEvaluationExpression(Expression e) {
        this.classifier.setExpression(e);
    }

    public ClassificationFunction getClassifier() {
        return this.classifier;
    }

    public void setClassifier(ClassificationFunction cf) {
        this.classifier = cf;
    }

    public int getNumberOfClasses() {
        return this.classifier.getNumberOfClasses();
    }

    public void setNumberOfClasses(int i) {
        this.classifier.setNumberOfClasses(i);
    }

    public String getPaletteName() {
        return this.paletteName;
    }

    public void setPaletteName(String s) {
        this.paletteName = s;
    }

    private String intToHex(int i) {
        String prelim = Integer.toHexString(i);
        while (prelim.length() < 2) {
            prelim = "0" + prelim;
        }
        if (prelim.length() > 2) {
            prelim = prelim.substring(0, 1);
        }
        return prelim;
    }

    public Object evaluate(Feature feature) {
        int classNum = this.classifier.getNumberOfClasses();
        ColorBrewer brewer = new ColorBrewer();
        int klass = (Integer)this.classifier.evaluate(feature);
        BrewerPalette pal = brewer.getPalette(this.paletteName);
        Color[] colors = pal.getColors(classNum);
        String color = "#" + this.intToHex(colors[klass].getRed()) + this.intToHex(colors[klass].getGreen()) + this.intToHex(colors[klass].getBlue());
        return color;
    }

    public String toString() {
        return "Color Brewer palette";
    }
}

