/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.brewer.color;

import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.function.ClassificationFunction;
import org.geotools.filter.function.CustomClassifierFunction;
import org.geotools.filter.function.ExplicitClassificationFunction;
import org.geotools.filter.function.RangedClassificationFunction;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Graphic;
import org.geotools.styling.Mark;
import org.geotools.styling.Rule;
import org.geotools.styling.Stroke;
import org.geotools.styling.StyleBuilder;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.Symbolizer;

public class StyleGenerator {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.brewer.color");
    public static final int ELSEMODE_IGNORE = 0;
    public static final int ELSEMODE_INCLUDEASMIN = 1;
    public static final int ELSEMODE_INCLUDEASMAX = 2;
    private Color[] colors;
    private int numClasses;
    private Expression expression;
    private FeatureCollection collection;
    private FilterFactory ff;
    private StyleFactory sf;
    private StyleBuilder sb;
    private ClassificationFunction function;
    private double opacity = 0.5;
    private Stroke defaultStroke;
    private String typeId;
    private String titleSpacer = " to ";
    private int elseMode = 0;

    public StyleGenerator(Color[] colors, ClassificationFunction function, String typeId) {
        this.colors = colors;
        this.numClasses = function.getNumberOfClasses();
        this.expression = function.getExpression();
        this.collection = function.getCollection();
        this.function = function;
        this.typeId = typeId;
        this.ff = FilterFactoryFinder.createFilterFactory();
        this.sf = StyleFactoryFinder.createStyleFactory();
        this.sb = new StyleBuilder(this.sf, this.ff);
        this.defaultStroke = this.sb.createStroke();
    }

    public FeatureCollection getCollection() {
        return this.collection;
    }

    public void setCollection(FeatureCollection collection) {
        this.collection = collection;
    }

    public Color[] getColors() {
        return this.colors;
    }

    public void setColors(Color[] colors) {
        this.colors = colors;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression) {
        this.expression = expression;
    }

    public int getNumClasses() {
        return this.numClasses;
    }

    public void setNumClasses(int numClasses) {
        this.numClasses = numClasses;
    }

    public double getOpacity() {
        return this.opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    public Stroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void setDefaultStroke(Stroke defaultStroke) {
        this.defaultStroke = defaultStroke;
    }

    public ClassificationFunction getClassifier() {
        return this.function;
    }

    public void setClassifier(ClassificationFunction function) {
        this.function = function;
    }

    public void setTypeId(String typeId) {
        this.typeId = typeId;
    }

    public void setTitleSpacer(String titleSpacer) {
        this.titleSpacer = titleSpacer;
    }

    public void setElseMode(int elseMode) {
        this.elseMode = elseMode;
    }

    private Color getColor(int index) {
        if (this.elseMode == 0) {
            return this.colors[index];
        }
        if (this.elseMode == 1) {
            return this.colors[index + 1];
        }
        if (this.elseMode == 2) {
            return this.colors[index];
        }
        return null;
    }

    private Color getElseColor() {
        if (this.elseMode == 1) {
            return this.colors[0];
        }
        if (this.elseMode == 2) {
            return this.colors[this.colors.length - 1];
        }
        return null;
    }

    public FeatureTypeStyle createFeatureTypeStyle(GeometryAttributeType geometryAttrType) throws IllegalFilterException {
        FeatureTypeStyle fts = this.sf.createFeatureTypeStyle();
        this.numClasses = this.elseMode == 0 ? this.function.getNumberOfClasses() : this.function.getNumberOfClasses() + 1;
        if (this.function instanceof RangedClassificationFunction) {
            RangedClassificationFunction ranged = (RangedClassificationFunction)this.function;
            Object localMin = null;
            Object localMax = null;
            for (int i = 0; i < this.function.getNumberOfClasses(); ++i) {
                localMin = ranged.getMin(i);
                localMax = ranged.getMax(i);
                Rule rule = this.createRuleRanged(localMin, localMax, geometryAttrType, i);
                fts.addRule(rule);
            }
        } else if (this.function instanceof ExplicitClassificationFunction) {
            ExplicitClassificationFunction explicit = (ExplicitClassificationFunction)this.function;
            for (int i = 0; i < this.function.getNumberOfClasses(); ++i) {
                Set value = (Set)explicit.getValue(i);
                Rule rule = this.createRuleExplicit(value, geometryAttrType, i);
                fts.addRule(rule);
            }
        } else if (this.function instanceof CustomClassifierFunction) {
            CustomClassifierFunction custom = (CustomClassifierFunction)this.function;
            for (int i = 0; i < this.function.getNumberOfClasses(); ++i) {
                Rule rule = null;
                if (custom.hasExplicit(i)) {
                    rule = this.createRuleExplicit((Set)custom.getValue(i), geometryAttrType, i);
                } else if (custom.hasRanged(i)) {
                    rule = this.createRuleRanged(custom.getMin(i), custom.getMax(i), geometryAttrType, i);
                }
                if (rule == null) continue;
                fts.addRule(rule);
            }
        } else {
            LOGGER.log(Level.SEVERE, "Error: Classifier not found");
        }
        if (this.elseMode != 0) {
            Symbolizer symb = this.createSymbolizer(this.sb, geometryAttrType, this.getElseColor(), this.opacity, this.defaultStroke);
            Rule elseRule = this.sb.createRule(symb);
            elseRule.setIsElseFilter(true);
            elseRule.setTitle("Else");
            elseRule.setName("else");
            fts.addRule(elseRule);
        }
        Rule[] rule = fts.getRules();
        if (this.elseMode == 1) {
            for (int i = rule.length - 1; i > 0; --i) {
                Rule tempRule = rule[i];
                rule[i] = rule[i - 1];
                rule[i - 1] = tempRule;
            }
        }
        fts.setSemanticTypeIdentifiers(new String[]{"generic:geometry", "colorbrewer:" + this.typeId});
        return fts;
    }

    private Symbolizer createSymbolizer(StyleBuilder sb, GeometryAttributeType geometryAttrType, Color color, double opacity, Stroke defaultStroke) {
        Symbolizer symb;
        if (defaultStroke == null) {
            defaultStroke = sb.createStroke(Color.BLACK, 1.0, opacity);
        }
        if (geometryAttrType.getType() == MultiPolygon.class || geometryAttrType.getType() == Polygon.class) {
            Fill fill = sb.createFill(color, opacity);
            symb = sb.createPolygonSymbolizer(defaultStroke, fill);
        } else if (geometryAttrType.getType() == LineString.class) {
            symb = sb.createLineSymbolizer(color);
        } else if (geometryAttrType.getType() == MultiPoint.class || geometryAttrType.getType() == Point.class) {
            Fill fill = sb.createFill(color, opacity);
            Mark square = sb.createMark("square", fill, defaultStroke);
            Graphic graphic = sb.createGraphic(null, square, null);
            symb = sb.createPointSymbolizer(graphic);
        } else {
            symb = sb.createLineSymbolizer(color);
        }
        return symb;
    }

    private Object chopInteger(Object value) {
        if (value instanceof Number && value.toString().endsWith(".0")) {
            return new Integer(((Number)value).intValue());
        }
        return value;
    }

    private String getRuleName(int count) {
        String strVal = new Integer(count).toString();
        if (strVal.length() == 1) {
            return "rule0" + strVal;
        }
        return "rule" + strVal;
    }

    private Rule createRuleRanged(Object localMin, Object localMax, GeometryAttributeType geometryAttrType, int i) throws IllegalFilterException {
        localMin = this.chopInteger(localMin);
        localMax = this.chopInteger(localMax);
        String title = "";
        if (localMin != null) {
            title = title + localMin;
        }
        title = title + this.titleSpacer;
        if (localMax != null) {
            title = title + localMax;
        }
        Filter filter = null;
        if (localMin == localMax) {
            CompareFilter eqFilter = this.ff.createCompareFilter((short)14);
            eqFilter.addLeftValue(this.expression);
            eqFilter.addRightValue(this.ff.createLiteralExpression(localMax));
            filter = eqFilter;
        } else {
            LogicFilter andFilter = null;
            CompareFilter lowBoundFilter = null;
            CompareFilter hiBoundFilter = null;
            if (localMin != null) {
                lowBoundFilter = this.ff.createCompareFilter((short)18);
                lowBoundFilter.addLeftValue(this.expression);
                lowBoundFilter.addRightValue(this.ff.createLiteralExpression(localMin));
            }
            if (localMax != null) {
                hiBoundFilter = i == this.function.getNumberOfClasses() - 1 ? this.ff.createCompareFilter((short)17) : this.ff.createCompareFilter((short)15);
                hiBoundFilter.addLeftValue(this.expression);
                hiBoundFilter.addRightValue(this.ff.createLiteralExpression(localMax));
            }
            if (localMin != null && localMax != null) {
                andFilter = this.ff.createLogicFilter(lowBoundFilter, hiBoundFilter, (short)2);
                filter = andFilter;
            } else if (localMin == null && localMax != null) {
                filter = hiBoundFilter;
            } else if (localMin != null && localMax == null) {
                filter = lowBoundFilter;
            }
        }
        Symbolizer symb = this.createSymbolizer(this.sb, geometryAttrType, this.getColor(i), this.opacity, this.defaultStroke);
        Rule rule = this.sb.createRule(symb);
        rule.setFilter(filter);
        rule.setTitle(title);
        rule.setName(this.getRuleName(i + 1));
        return rule;
    }

    private Rule createRuleExplicit(Set value, GeometryAttributeType geometryAttrType, int i) {
        LogicFilter orFilter;
        Object[] items = value.toArray();
        Arrays.sort(items);
        try {
            orFilter = this.ff.createLogicFilter((short)1);
        }
        catch (IllegalFilterException e1) {
            LOGGER.log(Level.SEVERE, "Couldn't create filter", e1);
            return null;
        }
        CompareFilter filter = null;
        String title = "";
        for (int item = 0; item < items.length; ++item) {
            try {
                filter = this.ff.createCompareFilter((short)14);
                filter.addLeftValue(this.expression);
                Expression rExpr = items[item] == null ? this.ff.createNullFilter().getNullCheckValue() : this.ff.createLiteralExpression(items[item]);
                filter.addRightValue(rExpr);
            }
            catch (IllegalFilterException e) {
                LOGGER.log(Level.SEVERE, "Error during rule filter construction", e);
                return null;
            }
            title = items[item] == null ? title + "NULL" : title + items[item].toString();
            if (item + 1 != items.length) {
                title = title + ", ";
            }
            try {
                orFilter.addFilter(filter);
                continue;
            }
            catch (IllegalFilterException e) {
                LOGGER.log(Level.SEVERE, "Couldn't add filter to logicFilter", e);
            }
        }
        Symbolizer symb = this.createSymbolizer(this.sb, geometryAttrType, this.getColor(i), this.opacity, this.defaultStroke);
        Rule rule = this.sb.createRule(symb);
        if (items.length > 1) {
            rule.setFilter(orFilter);
        } else {
            rule.setFilter(filter);
        }
        rule.setTitle(title);
        rule.setName(this.getRuleName(i + 1));
        return rule;
    }

    public static void modifyFTS(FeatureTypeStyle fts, int ruleIndex, String styleExpression) throws IllegalFilterException {
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        Rule[] rule = fts.getRules();
        Rule thisRule = rule[ruleIndex];
        Filter filter = thisRule.getFilter();
        short filterType = filter.getFilterType();
        if (filterType == 2) {
            String[] newValue = styleExpression.split("\\.\\.");
            if (newValue.length != 2) {
                throw new IllegalArgumentException("StyleExpression has incorrect syntax; min..max expected.");
            }
            Iterator iterator = ((LogicFilter)filter).getFilterIterator();
            CompareFilter filter1 = (CompareFilter)iterator.next();
            CompareFilter filter2 = (CompareFilter)iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("This method currently only supports logical filters with exactly 2 children.");
            }
            if (!filter1.getRightValue().equals(filter2.getLeftValue())) {
                throw new IllegalArgumentException("Subfilters or subExpressions in incorrect order");
            }
            if (filter1.getLeftValue().toString() != newValue[0]) {
                filter1.addLeftValue(ff.createLiteralExpression(newValue[0]));
            }
            if (filter2.getRightValue().toString() != newValue[1]) {
                filter2.addRightValue(ff.createLiteralExpression(newValue[1]));
            }
            thisRule.setFilter(filter);
        } else if (filterType == 1 || filterType == 14) {
            Expression attrExpression;
            if (filterType == 1) {
                Iterator iterator = ((LogicFilter)filter).getFilterIterator();
                attrExpression = ((CompareFilter)iterator.next()).getLeftValue();
            } else {
                attrExpression = ((CompareFilter)filter).getLeftValue();
            }
            rule[ruleIndex].setFilter(StyleGenerator.toExplicitFilter(styleExpression, attrExpression));
        } else {
            throw new IllegalArgumentException("Unrecognized filter type.");
        }
    }

    public static String toStyleExpression(Filter filter) {
        short filterType = filter.getFilterType();
        if (filterType == 2) {
            return StyleGenerator.toRangedStyleExpression((LogicFilter)filter);
        }
        return StyleGenerator.toExplicitStyleExpression(filter);
    }

    public static String[] toStyleExpression(Filter[] filter) {
        String[] styleExpression = new String[filter.length];
        for (int i = 0; i < filter.length; ++i) {
            styleExpression[i] = StyleGenerator.toStyleExpression(filter[i]);
        }
        return styleExpression;
    }

    public static Filter[] toFilter(String[] styleExpression, FeatureType[] featureType, String[] attributeTypeName) throws IllegalFilterException {
        int i;
        Filter[] filter = new Filter[styleExpression.length];
        boolean[] isRangedExpr = new boolean[styleExpression.length];
        ArrayList<String> min = new ArrayList<String>();
        String[] max = new String[styleExpression.length];
        for (i = 0; i < styleExpression.length; ++i) {
            if (StyleGenerator.isRanged(styleExpression[i])) {
                isRangedExpr[i] = true;
                String[] exprPart = styleExpression[i].split("\\.\\.");
                min.add(exprPart[0]);
                max[i] = exprPart[1];
                continue;
            }
            isRangedExpr[i] = false;
        }
        for (i = 0; i < styleExpression.length; ++i) {
            if (isRangedExpr[i]) {
                boolean upperBoundClosed = true;
                if (min.contains(max[i])) {
                    upperBoundClosed = false;
                }
                filter[i] = StyleGenerator.toRangedFilter(styleExpression[i], featureType[i], attributeTypeName[i], upperBoundClosed);
                continue;
            }
            filter[i] = StyleGenerator.toExplicitFilter(styleExpression[i], featureType[i], attributeTypeName[i]);
        }
        return filter;
    }

    public static Filter toRangedFilter(String styleExpression, FeatureType featureType, String attributeTypeName, boolean upperBoundClosed) throws IllegalFilterException {
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        AttributeExpression attrib = ff.createAttributeExpression(attributeTypeName);
        String[] strs = styleExpression.split("\\.\\.");
        if (strs.length != 2) {
            throw new IllegalArgumentException("A ranged filter could not be created from the styleExpression given.");
        }
        LiteralExpression localMin = ff.createLiteralExpression(strs[0]);
        LiteralExpression localMax = ff.createLiteralExpression(strs[1]);
        CompareFilter lowerBound = ff.createCompareFilter((short)17);
        lowerBound.addLeftValue(localMin);
        lowerBound.addRightValue(attrib);
        CompareFilter upperBound = upperBoundClosed ? ff.createCompareFilter((short)17) : ff.createCompareFilter((short)15);
        upperBound.addLeftValue(attrib);
        upperBound.addRightValue(localMax);
        LogicFilter filter = ff.createLogicFilter(lowerBound, upperBound, (short)2);
        return filter;
    }

    /*
     * WARNING - void declaration
     */
    private static String toRangedStyleExpression(Filter filter) {
        if (filter instanceof LogicFilter) {
            void var10_10;
            void var7_7;
            void var8_9;
            void var9_8;
            Expression max2;
            Expression min2;
            Expression max1;
            Expression min1;
            LogicFilter lFilter = (LogicFilter)filter;
            if (lFilter.getFilterType() != 2) {
                throw new IllegalArgumentException("Only logic filters constructed using the LOGIC_AND filterType are currently supported by this method.");
            }
            Iterator iterator = lFilter.getFilterIterator();
            Filter filter1 = (Filter)iterator.next();
            Filter filter2 = (Filter)iterator.next();
            if (iterator.hasNext()) {
                throw new IllegalArgumentException("This method currently only supports logical filters with exactly 2 children.");
            }
            if (!(filter1 instanceof CompareFilter) || !(filter2 instanceof CompareFilter)) {
                throw new IllegalArgumentException("Only compare filters as logical filter children are currently supported by this method.");
            }
            short filterType1 = filter1.getFilterType();
            short filterType2 = filter2.getFilterType();
            if (filterType1 == 15 || filterType1 == 17) {
                min1 = ((CompareFilter)filter1).getLeftValue();
                max1 = ((CompareFilter)filter1).getRightValue();
            } else if (filterType1 == 16 || filterType1 == 18) {
                min1 = ((CompareFilter)filter1).getRightValue();
                max1 = ((CompareFilter)filter1).getLeftValue();
            } else {
                throw new IllegalArgumentException("Unsupported FilterType");
            }
            if (filterType2 == 15 || filterType2 == 17) {
                min2 = ((CompareFilter)filter2).getLeftValue();
                max2 = ((CompareFilter)filter2).getRightValue();
            } else if (filterType2 == 16 || filterType2 == 18) {
                min2 = ((CompareFilter)filter2).getRightValue();
                max2 = ((CompareFilter)filter2).getLeftValue();
            } else {
                throw new IllegalArgumentException("Unsupported FilterType");
            }
            if (var9_8.equals(var8_9)) {
                return var7_7.toString() + ".." + var10_10.toString();
            }
            if (var10_10.equals(var7_7)) {
                return var8_9.toString() + ".." + var9_8.toString();
            }
            throw new IllegalArgumentException("Couldn't find the expected arrangement of Expressions");
        }
        if (filter instanceof CompareFilter) {
            // empty if block
        }
        throw new UnsupportedOperationException("Don't know how to handle this filter");
    }

    public static boolean isRanged(String styleExpression) {
        return styleExpression.matches(".+\\.{2}.+");
    }

    public static Filter toExplicitFilter(String styleExpression, FeatureType featureType, String attributeTypeName) throws IllegalFilterException {
        String expr = styleExpression.replaceAll(",\\s+", ",");
        String[] attribValue = expr.split(",");
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        CompareFilter cFilter = ff.createCompareFilter((short)14);
        AttributeExpression attribExpr = ff.createAttributeExpression(attributeTypeName);
        cFilter.addLeftValue(attribExpr);
        cFilter.addRightValue(ff.createLiteralExpression(attribValue[0]));
        if (attribValue.length == 1) {
            return cFilter;
        }
        LogicFilter lFilter = ff.createLogicFilter((short)1);
        lFilter.addFilter(cFilter);
        for (int i = 1; i < attribValue.length; ++i) {
            cFilter = ff.createCompareFilter((short)14);
            cFilter.addLeftValue(attribExpr);
            cFilter.addRightValue(ff.createLiteralExpression(attribValue[i]));
            lFilter.addFilter(cFilter);
        }
        return lFilter;
    }

    public static Filter toExplicitFilter(String styleExpression, Expression attribExpr) throws IllegalFilterException {
        String expr = styleExpression.replaceAll(",\\s+", ",");
        String[] attribValue = expr.split(",");
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        CompareFilter cFilter = ff.createCompareFilter((short)14);
        cFilter.addLeftValue(attribExpr);
        cFilter.addRightValue(ff.createLiteralExpression(attribValue[0]));
        if (attribValue.length == 1) {
            return cFilter;
        }
        LogicFilter lFilter = ff.createLogicFilter((short)1);
        lFilter.addFilter(cFilter);
        for (int i = 1; i < attribValue.length; ++i) {
            cFilter = ff.createCompareFilter((short)14);
            cFilter.addLeftValue(attribExpr);
            cFilter.addRightValue(ff.createLiteralExpression(attribValue[i]));
            lFilter.addFilter(cFilter);
        }
        return lFilter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String toExplicitStyleExpression(Filter filter) {
        short filterType = filter.getFilterType();
        String styleExpression = "";
        if (filterType == 14) {
            CompareFilter compareFilter = (CompareFilter)filter;
            Expression leftExpression = compareFilter.getLeftValue();
            Expression rightExpression = compareFilter.getRightValue();
            if (leftExpression instanceof AttributeExpression && rightExpression instanceof LiteralExpression) {
                return rightExpression.toString();
            }
            if (!(leftExpression instanceof LiteralExpression)) throw new IllegalArgumentException("Could not extract an Explicit Style Expression from the CompareFilter");
            if (!(rightExpression instanceof AttributeExpression)) throw new IllegalArgumentException("Could not extract an Explicit Style Expression from the CompareFilter");
            return leftExpression.toString();
        }
        if (filterType != 1) return styleExpression;
        LogicFilter parentFilter = (LogicFilter)filter;
        Iterator iterator = parentFilter.getFilterIterator();
        while (iterator.hasNext()) {
            styleExpression = styleExpression + StyleGenerator.toExplicitStyleExpression((Filter)iterator.next());
            if (!iterator.hasNext()) continue;
            styleExpression = styleExpression + ", ";
        }
        return styleExpression;
    }
}

