/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.adaptable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.geotools.catalog.ResolveAdapterFactory;
import org.geotools.catalog.adaptable.AdaptingResolve;
import org.geotools.catalog.adaptable.AdaptingResolveAware;

public abstract class ResolveAdapterFactoryFinder {
    public ResolveAdapterFactory find(AdaptingResolve decorator, Class adaptee) throws IllegalStateException {
        if (decorator.resolve == null) {
            return null;
        }
        Collection factories = this.getResolveAdapterFactories();
        ArrayList<ResolveAdapterFactory> matches = new ArrayList<ResolveAdapterFactory>();
        Iterator f = factories.iterator();
        while (f.hasNext()) {
            ResolveAdapterFactory factory = (ResolveAdapterFactory)f.next();
            if (factory instanceof AdaptingResolveAware) {
                ((AdaptingResolveAware)factory).setAdaptingResolve(decorator);
            }
            if (!factory.canAdapt(decorator.resolve, adaptee)) continue;
            matches.add(factory);
        }
        if (matches.isEmpty()) {
            return null;
        }
        if (matches.size() != 1) {
            String msg = "Multiple adapters found.";
            throw new IllegalStateException(msg);
        }
        return (ResolveAdapterFactory)matches.get(0);
    }

    public Collection getResolveAdapterFactories() {
        return Collections.EMPTY_LIST;
    }
}

