/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.catalog.styling;

import java.io.File;
import java.io.FileFilter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.geotools.catalog.Catalog;
import org.geotools.catalog.Service;
import org.geotools.catalog.ServiceFactory;
import org.geotools.catalog.styling.SLDService;

public class SLDServiceFactory
implements ServiceFactory {
    static String SLD_NAMESPACE = "http://www.opengis.net/sld";
    static String KEY = "sldFile";

    public Service createService(Catalog parent, URI id, Map params) {
        return new SLDService(parent, new File(id));
    }

    public boolean canProcess(URI uri) {
        File file = new File(uri);
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles(new FileFilter(){

                public boolean accept(File pathname) {
                    return SLDServiceFactory.isSLDFile(pathname);
                }
            });
            return files.length > 0;
        }
        return SLDServiceFactory.isSLDFile(file);
    }

    public Map createParams(URI uri) {
        if (this.canProcess(uri)) {
            HashMap<String, URI> map = new HashMap<String, URI>();
            map.put(KEY, uri);
            return map;
        }
        return null;
    }

    static boolean isSLDFile(File file) {
        String filename = file.getName();
        if (filename.length() > 3) {
            String ext = filename.substring(filename.length() - 4);
            return ext.equalsIgnoreCase(".sld") || ext.equalsIgnoreCase(".xml");
        }
        return false;
    }
}

