/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import [Lorg.opengis.parameter.GeneralParameterValue;;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.collection.CollectionDataStore;
import org.geotools.data.coverage.grid.AbstractGridCoverage2DReader;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.type.GeometricAttributeType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.geometry.Envelope2D;
import org.geotools.resources.CRSUtilities;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class DataUtilities {
    static Map typeMap = new HashMap();

    public static File urlToFile(URL url) {
        String auth = url.getAuthority();
        String path = url.getPath();
        File f = null;
        f = auth != null && !auth.equals("") ? new File("//" + auth + path) : new File(path);
        return f;
    }

    public static String[] attributeNames(FeatureType featureType) {
        String[] names = new String[featureType.getAttributeCount()];
        int count = featureType.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            names[i] = featureType.getAttributeType(i).getName();
        }
        return names;
    }

    public static String[] attributeNames(Filter filter) {
        if (filter == null) {
            return new String[0];
        }
        final HashSet set = new HashSet();
        DataUtilities.traverse(filter, (FilterVisitor)new AbstractFilterVisitor(){

            public void visit(AttributeExpression attributeExpression) {
                set.add(attributeExpression.getAttributePath());
            }
        });
        if (set.size() == 0) {
            return new String[0];
        }
        String[] names = new String[set.size()];
        int index = 0;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            names[index] = (String)i.next();
            ++index;
        }
        return names;
    }

    public static String[] attributeNames(Expression expression) {
        if (expression == null) {
            return new String[0];
        }
        final HashSet set = new HashSet();
        DataUtilities.traverse(expression, (FilterVisitor)new AbstractFilterVisitor(){

            public void visit(AttributeExpression attributeExpression) {
                set.add(attributeExpression.getAttributePath());
            }
        });
        if (set.size() == 0) {
            return new String[0];
        }
        String[] names = new String[set.size()];
        int index = 0;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            names[index] = (String)i.next();
            ++index;
        }
        return names;
    }

    public static void traverse(Filter filter, FilterVisitor visitor) {
        DataUtilities.traverse(DataUtilities.traverseDepth(filter), visitor);
    }

    public static void traverse(Expression expression, FilterVisitor visitor) {
        DataUtilities.traverse(DataUtilities.traverseDepth(expression), visitor);
    }

    public static void traverse(Set set, FilterVisitor visitor) {
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Object here = i.next();
            if (here instanceof BetweenFilter) {
                visitor.visit((BetweenFilter)here);
                continue;
            }
            if (here instanceof CompareFilter) {
                visitor.visit((CompareFilter)here);
                continue;
            }
            if (here instanceof GeometryFilter) {
                visitor.visit((GeometryFilter)here);
                continue;
            }
            if (here instanceof LikeFilter) {
                visitor.visit((LikeFilter)here);
                continue;
            }
            if (here instanceof LogicFilter) {
                visitor.visit((LogicFilter)here);
                continue;
            }
            if (here instanceof NullFilter) {
                visitor.visit((NullFilter)here);
                continue;
            }
            if (here instanceof FidFilter) {
                visitor.visit((FidFilter)here);
                continue;
            }
            if (here instanceof Filter) {
                visitor.visit((Filter)here);
                continue;
            }
            if (here instanceof AttributeExpression) {
                visitor.visit((AttributeExpression)here);
                continue;
            }
            if (here instanceof LiteralExpression) {
                visitor.visit((LiteralExpression)here);
                continue;
            }
            if (here instanceof MathExpression) {
                visitor.visit((MathExpression)here);
                continue;
            }
            if (here instanceof FunctionExpression) {
                visitor.visit((FunctionExpression)here);
                continue;
            }
            if (!(here instanceof Expression)) continue;
            visitor.visit((Filter)here);
        }
    }

    public static Set traverseDepth(Filter filter) {
        final HashSet set = new HashSet();
        Traversal traverse = new Traversal(){

            void traverse(Filter f) {
                set.add(f);
            }

            void traverse(Expression expression) {
                set.add(expression);
            }
        };
        filter.accept((FilterVisitor)traverse);
        return set;
    }

    public static Set traverseDepth(Expression expression) {
        final HashSet set = new HashSet();
        Traversal traverse = new Traversal(){

            void traverse(Filter f) {
                set.add(f);
            }

            void traverse(Expression expr) {
                set.add(expr);
            }
        };
        expression.accept((FilterVisitor)traverse);
        return set;
    }

    public static int compare(FeatureType typeA, FeatureType typeB) {
        int countB;
        if (typeA == typeB) {
            return 0;
        }
        if (typeA == null) {
            return -1;
        }
        if (typeB == null) {
            return -1;
        }
        int countA = typeA.getAttributeCount();
        if (countA > (countB = typeB.getAttributeCount())) {
            return -1;
        }
        int match = 0;
        for (int i = 0; i < countA; ++i) {
            AttributeType a = typeA.getAttributeType(i);
            if (DataUtilities.isMatch(a, typeB.getAttributeType(i))) {
                ++match;
                continue;
            }
            if (DataUtilities.isMatch(a, typeB.getAttributeType(a.getName()))) continue;
            return -1;
        }
        if (countA == countB && match == countA) {
            return 0;
        }
        return 1;
    }

    public static boolean isMatch(AttributeType a, AttributeType b) {
        if (a == b) {
            return true;
        }
        if (b == null) {
            return false;
        }
        if (a == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        return a.getName().equals(b.getName()) && a.getClass().equals(b.getClass());
    }

    public static Feature reType(FeatureType featureType, Feature feature) throws IllegalAttributeException {
        FeatureType origional = feature.getFeatureType();
        if (featureType.equals(origional)) {
            return featureType.duplicate(feature);
        }
        String id = feature.getID();
        int numAtts = featureType.getAttributeCount();
        Object[] attributes = new Object[numAtts];
        for (int i = 0; i < numAtts; ++i) {
            AttributeType curAttType = featureType.getAttributeType(i);
            String xpath = curAttType.getName();
            attributes[i] = curAttType.duplicate(feature.getAttribute(xpath));
        }
        return featureType.create(attributes, id);
    }

    public static Feature template(FeatureType featureType) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType));
    }

    public static Feature template(FeatureType featureType, String featureID) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType), featureID);
    }

    public static Object[] defaultValues(FeatureType featureType) throws IllegalAttributeException {
        return DataUtilities.defaultValues(featureType, null);
    }

    public static Feature template(FeatureType featureType, Object[] atts) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType, atts));
    }

    public static Feature template(FeatureType featureType, String string, Object[] emptyAtts) throws IllegalAttributeException {
        return featureType.create(DataUtilities.defaultValues(featureType, emptyAtts), string);
    }

    public static Object defaultValue(Class type) {
        if (type == String.class || type == Object.class) {
            return "";
        }
        if (type == Integer.class) {
            return new Integer(0);
        }
        if (type == Double.class) {
            return new Double(0.0);
        }
        if (type == Long.class) {
            return new Long(0L);
        }
        if (type == Short.class) {
            return new Short(0);
        }
        if (type == Float.class) {
            return new Float(0.0f);
        }
        if (type == Character.class) {
            return new Character(' ');
        }
        GeometryFactory fac = new GeometryFactory();
        Coordinate coordinate = new Coordinate(0.0, 0.0);
        Point point = fac.createPoint(coordinate);
        if (type == Point.class) {
            return point;
        }
        if (type == MultiPoint.class) {
            return fac.createMultiPoint(new Point[]{point});
        }
        if (type == LineString.class) {
            return fac.createLineString(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        }
        LinearRing linearRing = fac.createLinearRing(new Coordinate[]{coordinate, coordinate, coordinate, coordinate});
        if (type == LinearRing.class) {
            return linearRing;
        }
        if (type == MultiLineString.class) {
            return fac.createMultiLineString(new LineString[]{linearRing});
        }
        Polygon polygon = fac.createPolygon(linearRing, new LinearRing[0]);
        if (type == Polygon.class) {
            return polygon;
        }
        if (type == MultiPolygon.class) {
            return fac.createMultiPolygon(new Polygon[]{polygon});
        }
        throw new IllegalArgumentException(type + " is not supported by this method");
    }

    public static Object[] defaultValues(FeatureType featureType, Object[] values) throws IllegalAttributeException {
        if (values == null) {
            values = new Object[featureType.getAttributeCount()];
        } else if (values.length != featureType.getAttributeCount()) {
            throw new ArrayIndexOutOfBoundsException("values");
        }
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            values[i] = DataUtilities.defaultValue(featureType.getAttributeType(i));
        }
        return values;
    }

    public static Object defaultValue(AttributeType attributeType) throws IllegalAttributeException {
        Object value = attributeType.createDefaultValue();
        if (value == null && !attributeType.isNillable()) {
            throw new IllegalAttributeException("Got null default value for non-null type.");
        }
        return value;
    }

    public static FeatureReader reader(final Feature[] features) throws IOException {
        if (features == null || features.length == 0) {
            throw new IOException("Provided features where empty");
        }
        return new FeatureReader(){
            Feature[] array;
            int offset;
            {
                this.array = features;
                this.offset = -1;
            }

            public FeatureType getFeatureType() {
                return features[0].getFeatureType();
            }

            public Feature next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more features");
                }
                return this.array[++this.offset];
            }

            public boolean hasNext() {
                return this.array != null && this.offset < this.array.length - 1;
            }

            public void close() {
                this.array = null;
                this.offset = -1;
            }
        };
    }

    public static FeatureSource source(final Feature[] featureArray) {
        final FeatureType featureType = featureArray == null || featureArray.length == 0 ? DefaultFeatureType.EMPTY : featureArray[0].getFeatureType();
        AbstractDataStore arrayStore = new AbstractDataStore(){

            public String[] getTypeNames() {
                return new String[]{featureType.getTypeName()};
            }

            public FeatureType getSchema(String typeName) throws IOException {
                if (typeName != null && typeName.equals(featureType.getTypeName())) {
                    return featureType;
                }
                throw new IOException(typeName + " not available");
            }

            protected FeatureReader getFeatureReader(String typeName) throws IOException {
                return DataUtilities.reader(featureArray);
            }
        };
        try {
            return arrayStore.getFeatureSource(arrayStore.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with the geotools code, this exception should not happen", e);
        }
    }

    public static FeatureSource source(FeatureCollection collection) {
        if (collection == null) {
            throw new NullPointerException();
        }
        CollectionDataStore store = new CollectionDataStore(collection);
        try {
            return store.getFeatureSource(store.getTypeNames()[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Something is wrong with the geotools code, this exception should not happen", e);
        }
    }

    public static FeatureResults results(Feature[] featureArray) throws IOException {
        return DataUtilities.results(DataUtilities.collection(featureArray));
    }

    public static FeatureResults results(final FeatureCollection collection) throws IOException {
        if (collection.size() == 0) {
            throw new IOException("Provided collection was empty");
        }
        return new FeatureResults(){

            public FeatureType getSchema() {
                return collection.features().next().getFeatureType();
            }

            public FeatureReader reader() throws IOException {
                return DataUtilities.reader((Collection)collection);
            }

            public Envelope getBounds() {
                return collection.getBounds();
            }

            public int getCount() {
                return collection.size();
            }

            public FeatureCollection collection() {
                return collection;
            }
        };
    }

    public static FeatureReader reader(Collection collection) throws IOException {
        return DataUtilities.reader(collection.toArray(new Feature[collection.size()]));
    }

    public static FeatureCollection collection(Feature[] features) {
        FeatureCollection collection = FeatureCollections.newCollection();
        int length = features.length;
        for (int i = 0; i < length; ++i) {
            collection.add((Object)features[i]);
        }
        return collection;
    }

    public static boolean attributesEqual(Object att, Object otherAtt) {
        if (att == null) {
            if (otherAtt != null) {
                return false;
            }
        } else if (!att.equals(otherAtt)) {
            if (att instanceof Geometry && otherAtt instanceof Geometry) {
                if (!((Geometry)att).equals((Geometry)otherAtt)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public static FeatureType createSubType(FeatureType featureType, String[] properties, CoordinateReferenceSystem override) throws SchemaException {
        return DataUtilities.createSubType(featureType, properties, override, featureType.getTypeName(), featureType.getNamespace());
    }

    public static FeatureType createSubType(FeatureType featureType, String[] properties, CoordinateReferenceSystem override, String typeName, URI namespace) throws SchemaException {
        if (properties == null && override == null) {
            return featureType;
        }
        if (properties == null) {
            properties = new String[featureType.getAttributeCount()];
            for (int i = 0; i < properties.length; ++i) {
                properties[i] = featureType.getAttributeType(i).getName();
            }
        }
        boolean same = featureType.getAttributeCount() == properties.length && featureType.getTypeName().equals(typeName) && featureType.getNamespace().equals(namespace);
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            AttributeType type = featureType.getAttributeType(i);
            same = type.getName().equals(properties[i]) && (override == null || !(type instanceof GeometryAttributeType) || DataUtilities.assertEquals(override, ((GeometryAttributeType)type).getCoordinateSystem()));
        }
        if (same) {
            return featureType;
        }
        AttributeType[] types = new AttributeType[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = featureType.getAttributeType(properties[i]);
            if (override == null || !(types[i] instanceof GeometryAttributeType)) continue;
            types[i] = new GeometricAttributeType((GeometricAttributeType)types[i], override);
        }
        if (typeName == null) {
            typeName = featureType.getTypeName();
        }
        if (namespace == null) {
            namespace = featureType.getNamespace();
        }
        return FeatureTypeFactory.newFeatureType(types, typeName, namespace);
    }

    private static boolean assertEquals(Object o1, Object o2) {
        return o1 == null && o2 == null ? true : (o1 != null ? o1.equals(o2) : false);
    }

    public static FeatureType createSubType(FeatureType featureType, String[] properties) throws SchemaException {
        if (properties == null) {
            return featureType;
        }
        boolean same = featureType.getAttributeCount() == properties.length;
        for (int i = 0; i < featureType.getAttributeCount() && same; ++i) {
            same = featureType.getAttributeType(i).getName().equals(properties[i]);
        }
        if (same) {
            return featureType;
        }
        AttributeType[] types = new AttributeType[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            types[i] = featureType.getAttributeType(properties[i]);
        }
        return FeatureTypeFactory.newFeatureType(types, featureType.getTypeName(), featureType.getNamespace());
    }

    public static FeatureType createType(String identification, String typeSpec) throws SchemaException {
        int split = identification.lastIndexOf(46);
        String namespace = split == -1 ? null : identification.substring(0, split);
        String typeName = split == -1 ? identification : identification.substring(split + 1);
        FeatureTypeFactory typeFactory = FeatureTypeFactory.newInstance(typeName);
        try {
            if (namespace != null) {
                typeFactory.setNamespace(new URI(namespace));
            }
        }
        catch (URISyntaxException badNamespace) {
            throw new SchemaException((Throwable)badNamespace);
        }
        typeFactory.setName(typeName);
        String[] types = typeSpec.split(",");
        int geometryIndex = -1;
        GeometryAttributeType geometryAttribute = null;
        for (int i = 0; i < types.length; ++i) {
            if (types[i].startsWith("*")) {
                types[i] = types[i].substring(1);
                geometryIndex = i;
            }
            AttributeType attributeType = DataUtilities.createAttribute(types[i]);
            typeFactory.addType(attributeType);
            if (geometryAttribute != null || !(attributeType instanceof GeometryAttributeType)) continue;
            if (geometryIndex == -1) {
                geometryAttribute = (GeometryAttributeType)attributeType;
                continue;
            }
            if (geometryIndex != i) continue;
            geometryAttribute = (GeometryAttributeType)attributeType;
        }
        if (geometryAttribute != null) {
            typeFactory.setDefaultGeometry(geometryAttribute);
        }
        return typeFactory.getFeatureType();
    }

    public static Feature parse(FeatureType type, String fid, String[] text) throws IllegalAttributeException {
        Object[] attributes = new Object[text.length];
        for (int i = 0; i < text.length; ++i) {
            attributes[i] = type.getAttributeType(i).parse((Object)text[i]);
        }
        return type.create(attributes, fid);
    }

    public static String spec(FeatureType featureType) {
        AttributeType[] types = featureType.getAttributeTypes();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < types.length; ++i) {
            buf.append(types[i].getName());
            buf.append(":");
            buf.append(DataUtilities.typeMap(types[i].getType()));
            if (i >= types.length - 1) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    static Class type(String typeName) throws ClassNotFoundException {
        if (typeMap.containsKey(typeName)) {
            return (Class)typeMap.get(typeName);
        }
        return Class.forName(typeName);
    }

    static String typeMap(Class type) {
        Iterator i = typeMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (!entry.getValue().equals(type)) continue;
            return (String)entry.getKey();
        }
        return type.getName();
    }

    public static Query mixQueries(Query firstQuery, Query secondQuery, String handle) {
        if (firstQuery == null || secondQuery == null) {
            throw new NullPointerException("got a null query argument");
        }
        if (firstQuery.equals(Query.ALL)) {
            return secondQuery;
        }
        if (secondQuery.equals(Query.ALL)) {
            return firstQuery;
        }
        if (firstQuery.getTypeName() != null && secondQuery.getTypeName() != null && !firstQuery.getTypeName().equals(secondQuery.getTypeName())) {
            String msg = "Type names do not match: " + firstQuery.getTypeName() + " != " + secondQuery.getTypeName();
            throw new IllegalArgumentException(msg);
        }
        int maxFeatures = Math.min(firstQuery.getMaxFeatures(), secondQuery.getMaxFeatures());
        String[] propNames = DataUtilities.joinAttributes(firstQuery.getPropertyNames(), secondQuery.getPropertyNames());
        Filter filter = firstQuery.getFilter();
        Filter filter2 = secondQuery.getFilter();
        if (filter == null || filter.equals(Filter.NONE)) {
            filter = filter2;
        } else if (filter2 != null && !filter2.equals(Filter.NONE)) {
            filter = filter.and(filter2);
        }
        String typeName = firstQuery.getTypeName() != null ? firstQuery.getTypeName() : secondQuery.getTypeName();
        return new DefaultQuery(typeName, filter, maxFeatures, propNames, handle);
    }

    private static String[] joinAttributes(String[] atts1, String[] atts2) {
        String[] propNames = null;
        LinkedList<String> atts = new LinkedList<String>();
        if (atts1 != null) {
            atts.addAll(Arrays.asList(atts1));
        }
        if (atts2 != null) {
            for (int i = 0; i < atts2.length; ++i) {
                if (atts.contains(atts2[i])) continue;
                atts.add(atts2[i]);
            }
        }
        propNames = new String[atts.size()];
        atts.toArray(propNames);
        return propNames;
    }

    static AttributeType createAttribute(String typeSpec) throws SchemaException {
        String type;
        String name;
        int split = typeSpec.indexOf(":");
        String hint = null;
        if (split == -1) {
            name = typeSpec;
            type = "String";
        } else {
            name = typeSpec.substring(0, split);
            int split2 = typeSpec.indexOf(":", split + 1);
            if (split2 == -1) {
                type = typeSpec.substring(split + 1);
            } else {
                type = typeSpec.substring(split + 1, split2);
                hint = typeSpec.substring(split2 + 1);
            }
        }
        try {
            if (hint != null && hint.indexOf("nillable") != -1) {
                return AttributeTypeFactory.newAttributeType(name, DataUtilities.type(type), true);
            }
            return AttributeTypeFactory.newAttributeType(name, DataUtilities.type(type));
        }
        catch (ClassNotFoundException e) {
            throw new SchemaException("Could not type " + name + " as:" + type);
        }
    }

    public static final FeatureCollection wrapGc(GridCoverage gridCoverage) throws TransformException, FactoryConfigurationError, SchemaException, IllegalAttributeException {
        PrecisionModel pm = new PrecisionModel();
        GeometryFactory gf = new GeometryFactory(pm, 0);
        Envelope2D rect = ((GridCoverage2D)gridCoverage).getEnvelope2D();
        CoordinateReferenceSystem sourceCrs = CRSUtilities.getCRS2D((CoordinateReferenceSystem)((GridCoverage2D)gridCoverage).getCoordinateReferenceSystem());
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        LinearRing ring = gf.createLinearRing(coord);
        Polygon bounds = new Polygon(ring, null, gf);
        GeometricAttributeType geom = new GeometricAttributeType("geom", Polygon.class, true, 1, 1, null, sourceCrs, null);
        AttributeType grid = AttributeTypeFactory.newAttributeType("grid", GridCoverage2D.class);
        AttributeType[] attTypes = new AttributeType[]{geom, grid};
        String typeName = "GridCoverage";
        DefaultFeatureType schema = (DefaultFeatureType)FeatureTypeBuilder.newFeatureType(attTypes, "GridCoverage");
        Feature feature = schema.create(new Object[]{bounds, gridCoverage});
        FeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Object)feature);
        return collection;
    }

    public static final FeatureCollection wrapGcReader(AbstractGridCoverage2DReader gridCoverageReader, GeneralParameterValue[] params) throws TransformException, FactoryConfigurationError, SchemaException, IllegalAttributeException {
        PrecisionModel pm = new PrecisionModel();
        GeometryFactory gf = new GeometryFactory(pm, 0);
        Rectangle2D rect = gridCoverageReader.getOriginalEnvelope().toRectangle2D();
        CoordinateReferenceSystem sourceCrs = CRSUtilities.getCRS2D((CoordinateReferenceSystem)gridCoverageReader.getCrs());
        Coordinate[] coord = new Coordinate[]{new Coordinate(rect.getMinX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMinY()), new Coordinate(rect.getMaxX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMaxY()), new Coordinate(rect.getMinX(), rect.getMinY())};
        LinearRing ring = gf.createLinearRing(coord);
        Polygon bounds = new Polygon(ring, null, gf);
        GeometricAttributeType geom = new GeometricAttributeType("geom", Polygon.class, true, 1, 1, null, sourceCrs, null);
        AttributeType grid = AttributeTypeFactory.newAttributeType("grid", AbstractGridCoverage2DReader.class);
        AttributeType paramsAttr = AttributeTypeFactory.newAttributeType("params", GeneralParameterValue;.class);
        AttributeType[] attTypes = new AttributeType[]{geom, grid, paramsAttr};
        String typeName = "GridCoverage";
        DefaultFeatureType schema = (DefaultFeatureType)FeatureTypeBuilder.newFeatureType(attTypes, "GridCoverage");
        Feature feature = schema.create(new Object[]{bounds, gridCoverageReader, params});
        FeatureCollection collection = FeatureCollections.newCollection();
        collection.add((Object)feature);
        return collection;
    }

    static {
        typeMap.put("String", String.class);
        typeMap.put("string", String.class);
        typeMap.put("\"\"", String.class);
        typeMap.put("Integer", Integer.class);
        typeMap.put("int", Integer.class);
        typeMap.put("0", Integer.class);
        typeMap.put("Double", Double.class);
        typeMap.put("double", Double.class);
        typeMap.put("0.0", Double.class);
        typeMap.put("Float", Float.class);
        typeMap.put("float", Float.class);
        typeMap.put("0.0f", Float.class);
        typeMap.put("Boolean", Boolean.class);
        typeMap.put("true", Boolean.class);
        typeMap.put("false", Boolean.class);
        typeMap.put("Geometry", Geometry.class);
        typeMap.put("Point", Point.class);
        typeMap.put("LineString", LineString.class);
        typeMap.put("Polygon", Polygon.class);
        typeMap.put("MultiPoint", MultiPoint.class);
        typeMap.put("MultiLineString", MultiLineString.class);
        typeMap.put("MultiPolygon", MultiPolygon.class);
        typeMap.put("GeometryCollection", GeometryCollection.class);
        typeMap.put("Date", Date.class);
    }

    public static abstract class Traversal
    extends AbstractFilterVisitor {
        abstract void traverse(Filter var1);

        abstract void traverse(Expression var1);

        public void visit(BetweenFilter betweenFilter) {
            this.traverse(betweenFilter.getLeftValue());
            this.visit(betweenFilter.getLeftValue());
            this.traverse(betweenFilter.getMiddleValue());
            this.visit(betweenFilter.getMiddleValue());
            this.traverse(betweenFilter.getRightValue());
            this.visit(betweenFilter.getRightValue());
        }

        public void visit(CompareFilter compareFilter) {
            this.traverse(compareFilter.getLeftValue());
            this.visit(compareFilter.getLeftValue());
            this.traverse(compareFilter.getRightValue());
            this.visit(compareFilter.getRightValue());
        }

        public void visit(GeometryFilter geometryFilter) {
            this.traverse(geometryFilter.getLeftGeometry());
            this.visit(geometryFilter.getLeftGeometry());
            this.traverse(geometryFilter.getRightGeometry());
            this.visit(geometryFilter.getRightGeometry());
        }

        public void visit(LikeFilter likeFilter) {
            this.traverse(likeFilter.getValue());
            this.visit(likeFilter.getValue());
        }

        public void visit(LogicFilter logicFilter) {
            Iterator i = logicFilter.getFilterIterator();
            while (i.hasNext()) {
                Filter f = (Filter)i.next();
                this.traverse(f);
                this.visit(f);
            }
        }

        public void visit(NullFilter nullFilter) {
            this.traverse(nullFilter.getNullCheckValue());
            this.visit(nullFilter.getNullCheckValue());
        }

        public void visit(MathExpression mathExpression) {
            this.traverse(mathExpression.getLeftValue());
            this.visit(mathExpression.getLeftValue());
            this.traverse(mathExpression.getRightValue());
            this.visit(mathExpression.getRightValue());
        }

        public void visit(FunctionExpression functionExpression) {
            Expression[] args = functionExpression.getArgs();
            for (int i = 0; i < args.length; ++i) {
                this.traverse(args[i]);
                this.visit(args[i]);
            }
        }
    }

    public static abstract class AbstractFilterVisitor
    implements FilterVisitor {
        public void visit(Filter filter) {
            if (filter instanceof BetweenFilter) {
                this.visit((BetweenFilter)filter);
            } else if (filter instanceof CompareFilter) {
                this.visit((CompareFilter)filter);
            } else if (filter instanceof GeometryFilter) {
                this.visit((GeometryFilter)filter);
            } else if (filter instanceof LikeFilter) {
                this.visit((LikeFilter)filter);
            } else if (filter instanceof LogicFilter) {
                this.visit((LogicFilter)filter);
            } else if (filter instanceof NullFilter) {
                this.visit((NullFilter)filter);
            } else if (filter instanceof FidFilter) {
                this.visit((FidFilter)filter);
            }
        }

        public void visit(BetweenFilter betweenFilter) {
        }

        public void visit(CompareFilter comparefilter) {
        }

        public void visit(GeometryFilter geometryFilter) {
        }

        public void visit(LikeFilter likeFilter) {
        }

        public void visit(LogicFilter logicFilter) {
        }

        public void visit(NullFilter nullFilter) {
        }

        public void visit(FidFilter fidFilter) {
        }

        public void visit(AttributeExpression attributeExpression) {
        }

        public void visit(Expression expression) {
            if (expression instanceof AttributeExpression) {
                this.visit((AttributeExpression)expression);
            } else if (expression instanceof LiteralExpression) {
                this.visit((LiteralExpression)expression);
            } else if (expression instanceof MathExpression) {
                this.visit((MathExpression)expression);
            } else if (expression instanceof FunctionExpression) {
                this.visit((FunctionExpression)expression);
            }
        }

        public void visit(LiteralExpression literalExpression) {
        }

        public void visit(MathExpression mathExpression) {
        }

        public void visit(FunctionExpression functionExpression) {
        }
    }
}

