/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid;

import java.util.Map;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.factory.Hints;
import org.geotools.image.imageio.GeoToolsWriteParams;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractGridFormat
implements Format {
    protected Map mInfo;
    protected ParameterValueGroup readParameters;
    protected ParameterValueGroup writeParameters;
    private static CoordinateReferenceSystem crs;
    public static final DefaultParameterDescriptor READ_GRIDGEOMETRY2D;
    public static final DefaultParameterDescriptor GEOTOOLS_WRITE_PARAMS;

    public String getName() {
        return (String)this.mInfo.get("name");
    }

    public String getDescription() {
        return (String)this.mInfo.get("description");
    }

    public String getVendor() {
        return (String)this.mInfo.get("vendor");
    }

    public String getDocURL() {
        return (String)this.mInfo.get("docURL");
    }

    public String getVersion() {
        return (String)this.mInfo.get("version");
    }

    public abstract GridCoverageReader getReader(Object var1);

    public abstract GridCoverageReader getReader(Object var1, Hints var2);

    public abstract GridCoverageWriter getWriter(Object var1);

    public abstract boolean accepts(Object var1);

    public boolean equals(Format f) {
        return f.getClass() == this.getClass();
    }

    public ParameterValueGroup getReadParameters() {
        return this.readParameters;
    }

    public ParameterValueGroup getWriteParameters() {
        return this.writeParameters;
    }

    public static CoordinateReferenceSystem getDefaultCRS() {
        return crs;
    }

    public abstract GeoToolsWriteParams getDefaultImageIOWriteParameters();

    static {
        try {
            crs = CRS.decode((String)"EPSG:4326", (boolean)true);
        }
        catch (NoSuchAuthorityCodeException e) {
            crs = DefaultGeographicCRS.WGS84;
        }
        catch (FactoryException e) {
            crs = DefaultGeographicCRS.WGS84;
        }
        READ_GRIDGEOMETRY2D = new DefaultParameterDescriptor("ReadGridGeometry2D", GridGeometry2D.class, null, null);
        GEOTOOLS_WRITE_PARAMS = new DefaultParameterDescriptor("WriteParameters", GeoToolsWriteParams.class, null, null);
    }
}

