/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.GridFormatFinder;
import org.geotools.data.coverage.grid.file.FSCatalogEntry;
import org.geotools.data.coverage.grid.file.FormatFileFilter;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageExchange;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;

public class FileSystemGridCoverageExchange
implements GridCoverageExchange {
    private File root;
    private boolean recursive;
    private Format[] formats;
    private List entries;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileSystemGridCoverageExchange() {
        this.formats = GridFormatFinder.getFormatArray();
    }

    public FileSystemGridCoverageExchange(File root) {
        this.root = root;
        this.formats = GridFormatFinder.getFormatArray();
    }

    public void refresh() {
        if (this.root != null) {
            this.entries = new ArrayList();
            this.refresh(this.root);
        }
    }

    private void refresh(File file) {
        if (file.isDirectory()) {
            File[] files = file.listFiles(new FormatFileFilter(this.formats, this.recursive));
            int length = files.length;
            for (int j = 0; j < length; ++j) {
                if (files[j].isFile()) {
                    this.entries.add(new FSCatalogEntry(files[j], this.formats));
                }
                if (!files[j].isDirectory() || !this.recursive) continue;
                this.refresh(files[j]);
            }
        } else if (file.isFile()) {
            this.entries.add(new FSCatalogEntry(file, this.formats));
        }
    }

    public void add(File f) {
        if (!this.entries.contains(f)) {
            this.entries.add(new FSCatalogEntry(f, this.formats));
        }
    }

    public Format[] getFormats() {
        Format[] f = new Format[this.formats.length];
        System.arraycopy(this.formats, 0, f, 0, this.formats.length);
        return f;
    }

    public GridCoverageReader getReader(Object source) throws IOException {
        if (!$assertionsDisabled && !(source instanceof FSCatalogEntry)) {
            throw new AssertionError();
        }
        FSCatalogEntry entry = (FSCatalogEntry)source;
        Format format = entry.getMetadata(0).getFormat();
        return ((AbstractGridFormat)format).getReader(source);
    }

    public GridCoverageWriter getWriter(Object destination, Format format) throws IOException {
        if (!($assertionsDisabled || destination instanceof File || destination instanceof FileOutputStream || destination instanceof FileWriter)) {
            throw new AssertionError();
        }
        return ((AbstractGridFormat)format).getWriter(destination);
    }

    public void dispose() throws IOException {
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean setDataSource(Object datasource) {
        URL url = null;
        if (datasource instanceof String) {
            try {
                url = new URL((String)datasource);
            }
            catch (MalformedURLException malformedURLException) {}
        } else if (datasource instanceof URL) {
            url = (URL)datasource;
        } else if (datasource instanceof File) {
            this.root = (File)datasource;
            this.refresh();
        }
        if (url != null && url.getFile().length() > 0) {
            this.root = new File(url.getFile());
            this.refresh(this.root);
            return true;
        }
        return false;
    }

    public boolean isRecursive() {
        return this.recursive;
    }

    public void setRecursive(boolean recursive) {
        this.recursive = recursive;
        if (this.root != null) {
            this.refresh(this.root);
        }
    }

    public List getFiles() {
        return Collections.unmodifiableList(this.entries);
    }

    static {
        $assertionsDisabled = !FileSystemGridCoverageExchange.class.desiredAssertionStatus();
    }
}

