/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid.stream;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.GridFormatFactorySpi;
import org.geotools.data.coverage.grid.GridFormatFinder;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageExchange;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;

public class StreamGridCoverageExchange
implements GridCoverageExchange {
    Set formats = new HashSet();

    public StreamGridCoverageExchange() {
        Iterator iter = GridFormatFinder.getAvailableFormats().iterator();
        while (iter.hasNext()) {
            GridFormatFactorySpi factory = (GridFormatFactorySpi)iter.next();
            this.formats.add(factory.createFormat());
        }
    }

    public boolean isLegalSource(Object source) {
        if (source instanceof InputStream) {
            return true;
        }
        if (source instanceof String) {
            return true;
        }
        if (source instanceof URL) {
            return true;
        }
        if (source instanceof File) {
            return true;
        }
        return source instanceof Reader;
    }

    public GridCoverageWriter getWriter(Object destination, Format format) throws IOException {
        return ((AbstractGridFormat)format).getWriter(destination);
    }

    public boolean isLegalDestination(Object destination) {
        if (destination instanceof OutputStream) {
            return true;
        }
        if (destination instanceof String) {
            return true;
        }
        if (destination instanceof URL) {
            return true;
        }
        if (destination instanceof File) {
            return true;
        }
        return destination instanceof Writer;
    }

    public Format[] getFormats() {
        Format[] f = new Format[this.formats.size()];
        this.formats.toArray(f);
        return f;
    }

    public GridCoverageReader getReader(Object arg0) throws IOException {
        Iterator iter = this.formats.iterator();
        while (iter.hasNext()) {
            Format f = (Format)iter.next();
            if (!((AbstractGridFormat)f).accepts(arg0)) continue;
            return ((AbstractGridFormat)f).getReader(arg0);
        }
        return null;
    }

    public void dispose() throws IOException {
    }

    public boolean isAvailable() {
        return true;
    }

    public boolean setDataSource(Object datasource) {
        return this.isLegalSource(datasource);
    }
}

