/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureResults;
import org.geotools.data.crs.ForceCoordinateSystemFeatureResults;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.FactoryFinder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.OperationNotFoundException;
import org.opengis.referencing.operation.TransformException;

public class ReprojectFeatureResults
extends DataFeatureCollection
implements FeatureResults {
    FeatureResults results;
    FeatureType schema;
    MathTransform transform;

    public ReprojectFeatureResults(FeatureResults results, CoordinateReferenceSystem destinationCS) throws IOException, SchemaException, TransformException, OperationNotFoundException, NoSuchElementException, FactoryException {
        super(results.getSchema().getNamespace() + "/" + results.getSchema().getTypeName(), results.getSchema());
        if (destinationCS == null) {
            throw new NullPointerException("CoordinateSystem required");
        }
        FeatureType type = results.getSchema();
        CoordinateReferenceSystem originalCs = type.getDefaultGeometry().getCoordinateSystem();
        if (results instanceof ReprojectFeatureResults) {
            originalCs = ((ReprojectFeatureResults)results).getOrigin().getSchema().getDefaultGeometry().getCoordinateSystem();
        }
        if (destinationCS.equals(originalCs)) {
            throw new IllegalArgumentException("CoordinateSystem " + destinationCS + " already used (check before using wrapper)");
        }
        this.schema = FeatureTypes.transform(type, destinationCS);
        this.results = results;
        this.transform = CRS.findMathTransform((CoordinateReferenceSystem)originalCs, (CoordinateReferenceSystem)destinationCS, (boolean)true);
        if (results instanceof ForceCoordinateSystemFeatureResults) {
            ForceCoordinateSystemFeatureResults forced = (ForceCoordinateSystemFeatureResults)results;
            this.results = forced.getOrigin();
        }
        if (results instanceof ReprojectFeatureResults) {
            ReprojectFeatureResults reproject = (ReprojectFeatureResults)results;
            this.results = reproject.getOrigin();
            this.transform = FactoryFinder.getMathTransformFactory(null).createConcatenatedTransform(reproject.transform, this.transform);
        }
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public FeatureReader reader() throws IOException {
        return new ReprojectFeatureReader(this.results.reader(), this.schema, this.transform);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Envelope getBounds() {
        Envelope envelope;
        FeatureReader r = null;
        try {
            try {
                Envelope newBBox = new Envelope();
                r = this.reader();
                while (r.hasNext()) {
                    Feature feature = r.next();
                    Geometry defaultGeometry = feature.getDefaultGeometry();
                    if (defaultGeometry == null) continue;
                    Envelope internal = defaultGeometry.getEnvelopeInternal();
                    newBBox.expandToInclude(internal);
                }
                envelope = newBBox;
                Object var7_7 = null;
                if (r == null) return envelope;
            }
            catch (Exception e) {
                throw new RuntimeException("Exception occurred while computing reprojected bounds", e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (r == null) throw throwable;
            try {
                r.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw throwable;
            }
        }
        try {}
        catch (IOException e2) {
            // empty catch block
            return envelope;
        }
        r.close();
        return envelope;
    }

    public int getCount() throws IOException {
        return this.results.getCount();
    }

    public FeatureCollection collection() throws IOException {
        FeatureCollection collection = FeatureCollections.newCollection();
        try {
            FeatureReader reader = this.reader();
            while (reader.hasNext()) {
                collection.add((Object)reader.next());
            }
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("This should not happen", (Throwable)e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("This should not happen", (Throwable)e);
        }
        return collection;
    }

    public FeatureResults getOrigin() {
        return this.results;
    }
}

