/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;
import org.geotools.filter.visitor.ClientTransactionAccessor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.sort.SortOrder;

public class DefaultSQLBuilder
implements SQLBuilder {
    protected SQLEncoder encoder;
    protected FeatureType ft;
    protected ClientTransactionAccessor accessor;
    private Filter lastFilter = null;
    private Filter lastPreFilter = null;
    private Filter lastPostFilter = null;

    public DefaultSQLBuilder() {
        this(new SQLEncoder());
    }

    public DefaultSQLBuilder(SQLEncoder encoder) {
        this(encoder, null, null);
    }

    public DefaultSQLBuilder(SQLEncoder encoder, FeatureType featureType, ClientTransactionAccessor accessor) {
        this.encoder = encoder;
        this.ft = featureType;
        this.accessor = accessor;
    }

    public Filter getPostQueryFilter(Filter filter) {
        if (!(filter == null || this.lastFilter != null && filter.equals(this.lastFilter))) {
            this.splitFilter(filter);
        }
        return this.lastPostFilter;
    }

    public Filter getPreQueryFilter(Filter filter) {
        if (!(filter == null || this.lastFilter != null && filter.equals(this.lastFilter))) {
            this.splitFilter(filter);
        }
        return this.lastPreFilter;
    }

    protected void splitFilter(Filter filter) {
        this.lastFilter = filter;
        FilterCapabilities cap = this.encoder.getCapabilities();
        PostPreProcessFilterSplittingVisitor pfv = new PostPreProcessFilterSplittingVisitor(cap, this.ft, this.accessor);
        filter.accept((FilterVisitor)pfv);
        this.lastPreFilter = pfv.getFilterPre();
        this.lastPostFilter = pfv.getFilterPost();
    }

    public void sqlFrom(StringBuffer sql, String typeName) {
        sql.append(" FROM ");
        sql.append(this.encoder.escapeName(typeName));
    }

    public void sqlWhere(StringBuffer sql, Filter preFilter) throws SQLEncoderException {
        if (preFilter != null && preFilter != Filter.NONE) {
            String where = this.encoder.encode(preFilter);
            sql.append(" ");
            sql.append(where);
        }
    }

    public String buildSQLQuery(String typeName, FIDMapper mapper, AttributeType[] attrTypes, Filter filter) throws SQLEncoderException {
        StringBuffer sqlBuffer = new StringBuffer();
        sqlBuffer.append("SELECT ");
        this.sqlColumns(sqlBuffer, mapper, attrTypes);
        this.sqlFrom(sqlBuffer, typeName);
        this.encoder.setFIDMapper(mapper);
        this.sqlWhere(sqlBuffer, filter);
        String sqlStmt = sqlBuffer.toString();
        return sqlStmt;
    }

    public void sqlColumns(StringBuffer sql, FIDMapper mapper, AttributeType[] attributes) {
        int i;
        for (i = 0; i < mapper.getColumnCount(); ++i) {
            sql.append(this.encoder.escapeName(mapper.getColumnName(i)) + ", ");
        }
        for (i = 0; i < attributes.length; ++i) {
            if (attributes[i] instanceof GeometryAttributeType) {
                this.sqlGeometryColumn(sql, attributes[i]);
            } else {
                sql.append(this.encoder.escapeName(attributes[i].getName()));
            }
            if (i >= attributes.length - 1) continue;
            sql.append(", ");
        }
    }

    public void sqlGeometryColumn(StringBuffer sql, AttributeType geomAttribute) {
        sql.append(this.encoder.escapeName(geomAttribute.getName()));
    }

    public void sqlOrderBy(StringBuffer sql, SortBy[] sortBy) throws SQLEncoderException {
        sql.append(" ORDER BY ");
        for (int i = 0; i < sortBy.length; ++i) {
            sql.append(this.encoder.escapeName(sortBy[i].getPropertyName().getPropertyName()));
            if (SortOrder.DESCENDING.equals(sortBy[i].getSortOrder())) {
                sql.append(" DESC");
            } else {
                sql.append(" ASC");
            }
            if (i >= sortBy.length - 1) continue;
            sql.append(", ");
        }
    }
}

