/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.jdbc.JDBC1DataStore;
import org.geotools.data.jdbc.JDBCFeatureCollection;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoderException;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class JDBCFeatureSource
implements FeatureSource {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    private FeatureType featureType;
    private JDBC1DataStore dataStore;

    public JDBCFeatureSource(JDBC1DataStore jdbcDataStore, FeatureType featureType) {
        this.featureType = featureType;
        this.dataStore = jdbcDataStore;
    }

    public DataStore getDataStore() {
        return this.getJDBCDataStore();
    }

    public JDBC1DataStore getJDBCDataStore() {
        return this.dataStore;
    }

    public void addFeatureListener(FeatureListener listener) {
        this.getJDBCDataStore().listenerManager.addFeatureListener(this, listener);
    }

    public void removeFeatureListener(FeatureListener listener) {
        this.getJDBCDataStore().listenerManager.removeFeatureListener(this, listener);
    }

    public Transaction getTransaction() {
        return Transaction.AUTO_COMMIT;
    }

    public FeatureCollection getFeatures(Query request) throws IOException {
        String typeName = this.featureType.getTypeName();
        if (request.getTypeName() != null && !typeName.equals(request.getTypeName())) {
            throw new IOException("Cannot query " + typeName + " with:" + request);
        }
        if (request.getTypeName() == null) {
            request = new DefaultQuery(this.featureType.getTypeName(), request.getFilter(), request.getMaxFeatures(), request.getPropertyNames(), request.getHandle());
        }
        return new JDBCFeatureCollection(this, request);
    }

    public FeatureCollection getFeatures(Filter filter) throws IOException {
        return this.getFeatures(new DefaultQuery(this.featureType.getTypeName(), filter));
    }

    public FeatureCollection getFeatures() throws IOException {
        return this.getFeatures(Filter.NONE);
    }

    public Envelope getBounds() throws IOException {
        return this.getBounds(Query.ALL);
    }

    public Envelope getBounds(Query query) throws IOException {
        if (query.getFilter() == Filter.ALL) {
            if (this.featureType != null) {
                return new ReferencedEnvelope(new Envelope(), this.featureType.getDefaultGeometry().getCoordinateSystem());
            }
            return new Envelope();
        }
        return null;
    }

    public int getCount(Query query) throws IOException {
        return this.count(query, this.getTransaction());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Query query, Transaction transaction) throws IOException {
        Filter filter = query.getFilter();
        if (filter == Filter.ALL) {
            return 0;
        }
        JDBC1DataStore jdbc = this.getJDBCDataStore();
        SQLBuilder sqlBuilder = jdbc.getSqlBuilder(this.featureType.getTypeName());
        Filter postFilter = sqlBuilder.getPostQueryFilter(filter);
        if (postFilter != null && postFilter != Filter.NONE) {
            return -1;
        }
        Connection conn = null;
        try {
            conn = jdbc.getConnection(transaction);
            String typeName = this.getSchema().getTypeName();
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT COUNT(*) as cnt");
            sqlBuilder.sqlFrom(sql, typeName);
            sqlBuilder.sqlWhere(sql, filter);
            LOGGER.finer("SQL: " + sql);
            Statement statement = conn.createStatement();
            ResultSet results = statement.executeQuery(sql.toString());
            results.next();
            int count = results.getInt("cnt");
            results.close();
            statement.close();
            int n = count;
            return n;
        }
        catch (SQLException sqlException) {
            JDBCUtils.close(conn, transaction, sqlException);
            conn = null;
            throw new DataSourceException("Could not count " + query.getHandle(), (Throwable)sqlException);
        }
        catch (SQLEncoderException e) {
            int n = -1;
            return n;
        }
        finally {
            JDBCUtils.close(conn, transaction, null);
        }
    }

    public FeatureType getSchema() {
        return this.featureType;
    }

    protected Connection getConnection() throws IOException {
        return this.getJDBCDataStore().getConnection(this.getTransaction());
    }

    protected void close(Connection conn, Transaction trans, SQLException sqle) {
        JDBCUtils.close(conn, trans, sqle);
    }

    protected void close(ResultSet rs) {
        JDBCUtils.close(rs);
    }

    protected void close(Statement statement) {
        JDBCUtils.close(statement);
    }
}

