/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureLockException;
import org.geotools.data.FeatureReader;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.MutableFIDFeature;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.GeometryAttributeType;

public abstract class JDBCTextFeatureWriter
extends JDBCFeatureWriter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    protected FIDMapper mapper = null;
    final int STATE_WAIT = 1;
    final int STATE_SUCCESS = 2;
    final int STATE_FAILURE = 3;

    public JDBCTextFeatureWriter(FeatureReader fReader, QueryData queryData) throws IOException {
        super(fReader, queryData);
        this.mapper = queryData.getMapper();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doInsert(MutableFIDFeature current) throws IOException, SQLException {
        Statement statement;
        block9: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("inserting into postgis feature " + current);
            }
            statement = null;
            Connection conn = null;
            conn = this.queryData.getConnection();
            statement = conn.createStatement();
            String sql = this.makeInsertSql(current);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(sql);
            }
            statement.executeUpdate(sql);
            if (this.mapper.getColumnCount() <= 0 || !this.mapper.hasAutoIncrementColumns()) break block9;
            current.setID(this.mapper.createID(conn, current, statement));
        }
        Object var7_6 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            String msg = "Error closing JDBC Statement";
            LOGGER.log(Level.WARNING, msg, e);
        }
        return;
        {
            catch (SQLException sqle) {
                String msg = "SQL Exception writing geometry column" + sqle.getLocalizedMessage();
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC Statement";
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw throwable;
        }
    }

    protected String makeInsertSql(Feature feature) throws IOException {
        String attrValue;
        int i;
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType featureType = ftInfo.getSchema();
        String tableName = this.encodeName(featureType.getTypeName());
        AttributeType[] attributeTypes = featureType.getAttributeTypes();
        StringBuffer statementSQL = new StringBuffer("INSERT INTO " + tableName + " (");
        if (!this.mapper.returnFIDColumnsAsAttributes()) {
            for (i = 0; i < this.mapper.getColumnCount(); ++i) {
                if (this.mapper.isAutoIncrement(i)) continue;
                statementSQL.append(this.mapper.getColumnName(i)).append(",");
            }
        }
        for (i = 0; i < attributeTypes.length; ++i) {
            String colName = this.encodeColumnName(attributeTypes[i].getName());
            statementSQL.append(colName).append(",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        statementSQL.append(" VALUES (");
        if (!this.mapper.returnFIDColumnsAsAttributes() && !this.mapper.hasAutoIncrementColumns()) {
            String FID = this.mapper.createID(this.queryData.getConnection(), feature, null);
            if (this.current instanceof MutableFIDFeature) {
                ((MutableFIDFeature)this.current).setID(FID);
            }
            Object[] primaryKey = this.mapper.getPKAttributes(FID);
            for (int i2 = 0; i2 < primaryKey.length; ++i2) {
                if (this.mapper.isAutoIncrement(i2)) continue;
                attrValue = this.addQuotes(primaryKey[i2]);
                statementSQL.append(attrValue).append(",");
            }
        }
        Object[] attributes = feature.getAttributes(null);
        for (int i3 = 0; i3 < attributeTypes.length; ++i3) {
            if (attributeTypes[i3] instanceof GeometryAttributeType) {
                String geomName = attributeTypes[i3].getName();
                int srid = ftInfo.getSRID(geomName);
                Geometry geometry = (Geometry)attributes[i3];
                attrValue = geometry == null ? "NULL" : this.getGeometryInsertText(geometry, srid);
            } else {
                attrValue = this.addQuotes(attributes[i3]);
            }
            statementSQL.append(attrValue + ",");
        }
        statementSQL.setCharAt(statementSQL.length() - 1, ')');
        return statementSQL.toString();
    }

    protected String addQuotes(Object value) {
        String retString = value != null ? (value instanceof Number ? value.toString() : "'" + this.doubleQuote(value) + "'") : "null";
        return retString;
    }

    String doubleQuote(Object obj) {
        return obj.toString().replaceAll("'", "''");
    }

    protected String encodeName(String tableName) {
        return tableName;
    }

    protected String encodeColumnName(String colName) {
        return this.encodeName(colName);
    }

    protected abstract String getGeometryInsertText(Geometry var1, int var2) throws IOException;

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void remove() throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("inserting into postgis feature " + this.current);
        }
        Statement statement = null;
        Connection conn = null;
        conn = this.queryData.getConnection();
        statement = conn.createStatement();
        Envelope bounds = this.live.getBounds();
        String sql = this.makeDeleteSql(this.current);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(sql);
        }
        statement.executeUpdate(sql);
        this.listenerManager.fireFeaturesRemoved(this.getFeatureType().getTypeName(), this.queryData.getTransaction(), bounds, false);
        Object var6_7 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            String msg = "Error closing JDBC Statement";
            LOGGER.log(Level.WARNING, msg, e);
        }
        return;
        {
            catch (SQLException sqle) {
                String msg = "SQL Exception writing geometry column";
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC Statement";
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw throwable;
        }
    }

    protected String makeDeleteSql(Feature feature) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType fetureType = ftInfo.getSchema();
        String tableName = this.encodeName(fetureType.getTypeName());
        StringBuffer statementSQL = new StringBuffer("DELETE FROM " + tableName + " WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(feature.getID());
        for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
            statementSQL.append(this.encodeColumnName(this.mapper.getColumnName(i))).append(" = ").append(this.addQuotes(pkValues[i]));
            if (i >= this.mapper.getColumnCount() - 1) continue;
            statementSQL.append(" AND ");
        }
        return statementSQL.toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void doUpdate(Feature live, Feature current) throws IOException, SQLException {
        String sql;
        boolean hasLock;
        Statement statement;
        block19: {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("updating postgis feature " + current);
            }
            statement = null;
            Connection conn = null;
            conn = this.queryData.getConnection();
            statement = conn.createStatement();
            hasLock = false;
            sql = this.makeSelectForUpdateSql(current);
            if (sql == null) {
                LOGGER.fine("Lock acquisition not attempted, JDBCTextFeatureWriter may block during concurrent updates");
            } else {
                ResultSet result = null;
                result = statement.executeQuery(sql);
                if (result != null) {
                    System.out.println(result.toString());
                }
                hasLock = true;
                Object var10_10 = null;
                if (result == null) break block19;
                try {
                    result.close();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                result = null;
                {
                    break block19;
                    catch (SQLException e) {
                        LOGGER.severe(e.getLocalizedMessage());
                        throw new FeatureLockException("Your feature is locked!", current.getID(), e);
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (result == null) throw throwable;
                    try {
                        result.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                    result = null;
                    throw throwable;
                }
            }
        }
        if (sql != null && !hasLock) throw new IOException("Feature Lock failed; giving up");
        sql = this.makeUpdateSql(live, current);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(sql);
        }
        statement.executeUpdate(sql);
        Object var13_16 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            String msg = "Error closing JDBC Statement";
            LOGGER.log(Level.WARNING, msg, e);
        }
        return;
        {
            catch (SQLException sqle) {
                String msg = "SQL Exception writing geometry column";
                LOGGER.log(Level.SEVERE, msg, sqle);
                this.queryData.close(sqle);
                throw new DataSourceException(msg, (Throwable)sqle);
            }
        }
        catch (Throwable throwable) {
            Object var13_17 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                throw throwable;
            }
            catch (SQLException e) {
                String msg = "Error closing JDBC Statement";
                LOGGER.log(Level.WARNING, msg, e);
            }
            throw throwable;
        }
    }

    protected String makeSelectForUpdateSql(Feature current) {
        return null;
    }

    protected String makeUpdateSql(Feature live, Feature current) throws IOException {
        FeatureTypeInfo ftInfo = this.queryData.getFeatureTypeInfo();
        FeatureType featureType = ftInfo.getSchema();
        AttributeType[] attributes = featureType.getAttributeTypes();
        String tableName = this.encodeName(featureType.getTypeName());
        StringBuffer statementSQL = new StringBuffer("UPDATE " + tableName + " SET ");
        for (int i = 0; i < current.getNumberOfAttributes(); ++i) {
            Object liveAtt;
            Object currAtt = current.getAttribute(i);
            if (DataUtilities.attributesEqual(currAtt, liveAtt = live.getAttribute(i))) continue;
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.fine("modifying att# " + i + " to " + currAtt);
            }
            String attrValue = null;
            if (attributes[i] instanceof GeometryAttributeType) {
                String geomName = attributes[i].getName();
                int srid = ftInfo.getSRID(geomName);
                Geometry geometry = (Geometry)currAtt;
                attrValue = geometry == null ? "NULL" : this.getGeometryInsertText(geometry, srid);
            } else {
                attrValue = this.addQuotes(currAtt);
            }
            String colName = this.encodeColumnName(attributes[i].getName());
            statementSQL.append(colName).append(" = ").append(attrValue).append(", ");
        }
        statementSQL.setLength(statementSQL.length() - 2);
        statementSQL.append(" WHERE ");
        Object[] pkValues = this.mapper.getPKAttributes(current.getID());
        for (int i = 0; i < this.mapper.getColumnCount(); ++i) {
            statementSQL.append(this.mapper.getColumnName(i)).append(" = ").append(this.addQuotes(pkValues[i]));
            if (i >= this.mapper.getColumnCount() - 1) continue;
            statementSQL.append(" AND ");
        }
        return statementSQL.toString();
    }

    protected boolean useQueryDataForInsert() {
        return false;
    }
}

