/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.geotools.filter.Filter;

public class MemoryDataStore
extends AbstractDataStore {
    protected Map memory = new HashMap();
    protected Map schema = new HashMap();

    public MemoryDataStore() {
        super(true);
    }

    public MemoryDataStore(FeatureCollection collection) {
        this.addFeatures((Collection)collection);
    }

    public MemoryDataStore(Feature[] array) {
        this.addFeatures(array);
    }

    public MemoryDataStore(FeatureReader reader) throws IOException {
        this.addFeatures(reader);
    }

    public void addFeatures(FeatureReader reader) throws IOException {
        try {
            LinkedHashMap<String, Feature> featureMap = new LinkedHashMap<String, Feature>();
            Feature feature = reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided FeatureReader is closed");
            }
            FeatureType featureType = feature.getFeatureType();
            String typeName = featureType.getTypeName();
            featureMap.put(feature.getID(), feature);
            while (reader.hasNext()) {
                feature = reader.next();
                featureMap.put(feature.getID(), feature);
            }
            this.schema.put(typeName, featureType);
            this.memory.put(typeName, featureMap);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Problem using reader", (Throwable)e);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Provided FeatureCollection is empty");
        }
        Map map = this.memory;
        synchronized (map) {
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                this.addFeatureInternal((Feature)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(Feature[] features) {
        if (features == null || features.length == 0) {
            throw new IllegalArgumentException("Provided features are empty");
        }
        Map map = this.memory;
        synchronized (map) {
            for (int i = 0; i < features.length; ++i) {
                this.addFeatureInternal(features[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(Feature feature) {
        Map map = this.memory;
        synchronized (map) {
            this.addFeatureInternal(feature);
        }
    }

    private void addFeatureInternal(Feature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Provided Feature is empty");
        }
        FeatureType featureType = feature.getFeatureType();
        String typeName = featureType.getTypeName();
        if (!this.memory.containsKey(typeName)) {
            try {
                this.createSchema(featureType);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Map featuresMap = (Map)this.memory.get(typeName);
        featuresMap.put(feature.getID(), feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map features(String typeName) throws IOException {
        Map map = this.memory;
        synchronized (map) {
            if (this.memory.containsKey(typeName)) {
                return (Map)this.memory.get(typeName);
            }
        }
        throw new IOException("Type name " + typeName + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTypeNames() {
        Map map = this.memory;
        synchronized (map) {
            String[] types = new String[this.schema.size()];
            int index = 0;
            Iterator i = this.schema.keySet().iterator();
            while (i.hasNext()) {
                types[index] = (String)i.next();
                ++index;
            }
            return types;
        }
    }

    public FeatureType getSchema(String typeName) throws IOException {
        Map map = this.memory;
        synchronized (map) {
            if (this.schema.containsKey(typeName)) {
                return (FeatureType)this.schema.get(typeName);
            }
            throw new SchemaNotFoundException(typeName);
        }
    }

    public void createSchema(FeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        if (this.memory.containsKey(typeName)) {
            throw new IOException(typeName + " already exists");
        }
        LinkedHashMap featuresMap = new LinkedHashMap();
        this.schema.put(typeName, featureType);
        this.memory.put(typeName, featuresMap);
    }

    public FeatureReader getFeatureReader(final String typeName) throws IOException {
        return new FeatureReader(){
            FeatureType featureType;
            Iterator iterator;
            {
                this.featureType = MemoryDataStore.this.getSchema(typeName);
                this.iterator = MemoryDataStore.this.features(typeName).values().iterator();
            }

            public FeatureType getFeatureType() {
                return this.featureType;
            }

            public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                if (this.iterator == null) {
                    throw new IOException("Feature Reader has been closed");
                }
                try {
                    return this.featureType.duplicate((Feature)this.iterator.next());
                }
                catch (NoSuchElementException end) {
                    throw new DataSourceException("There are no more Features", (Throwable)end);
                }
            }

            public boolean hasNext() {
                return this.iterator != null && this.iterator.hasNext();
            }

            public void close() {
                if (this.iterator != null) {
                    this.iterator = null;
                }
                if (this.featureType != null) {
                    this.featureType = null;
                }
            }
        };
    }

    public FeatureWriter createFeatureWriter(final String typeName, final Transaction transaction) throws IOException {
        return new FeatureWriter(){
            FeatureType featureType;
            Map contents;
            Iterator iterator;
            SimpleFeature live;
            Feature current;
            {
                this.featureType = MemoryDataStore.this.getSchema(typeName);
                this.contents = MemoryDataStore.this.features(typeName);
                this.iterator = this.contents.values().iterator();
                this.live = null;
                this.current = null;
            }

            public FeatureType getFeatureType() {
                return this.featureType;
            }

            public Feature next() throws IOException, NoSuchElementException {
                if (this.hasNext()) {
                    this.live = (SimpleFeature)this.iterator.next();
                    try {
                        this.current = this.featureType.duplicate((Feature)this.live);
                    }
                    catch (IllegalAttributeException e) {
                        throw new DataSourceException("Unable to edit " + this.live.getID() + " of " + typeName);
                    }
                }
                this.live = null;
                try {
                    this.current = DataUtilities.template(this.featureType);
                }
                catch (IllegalAttributeException e) {
                    throw new DataSourceException("Unable to add additional Features of " + typeName);
                }
                return this.current;
            }

            public void remove() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                if (this.current == null) {
                    throw new IOException("No feature available to remove");
                }
                if (this.live != null) {
                    this.iterator.remove();
                    MemoryDataStore.this.listenerManager.fireFeaturesRemoved(typeName, transaction, this.live.getBounds(), true);
                    this.live = null;
                    this.current = null;
                } else {
                    this.current = null;
                }
            }

            public void write() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                if (this.current == null) {
                    throw new IOException("No feature available to write");
                }
                if (this.live != null) {
                    if (this.live.equals(this.current)) {
                        this.live = null;
                        this.current = null;
                    } else {
                        try {
                            this.live.setAttributes(this.current.getAttributes(null));
                        }
                        catch (IllegalAttributeException e) {
                            throw new DataSourceException("Unable to accept modifications to " + this.live.getID() + " on " + typeName);
                        }
                        Envelope bounds = new Envelope();
                        bounds.expandToInclude(this.live.getBounds());
                        bounds.expandToInclude(this.current.getBounds());
                        MemoryDataStore.this.listenerManager.fireFeaturesChanged(typeName, transaction, bounds, true);
                        this.live = null;
                        this.current = null;
                    }
                } else {
                    this.contents.put(this.current.getID(), this.current);
                    MemoryDataStore.this.listenerManager.fireFeaturesAdded(typeName, transaction, this.current.getBounds(), true);
                    this.current = null;
                }
            }

            public boolean hasNext() throws IOException {
                if (this.contents == null) {
                    throw new IOException("FeatureWriter has been closed");
                }
                return this.iterator != null && this.iterator.hasNext();
            }

            public void close() {
                if (this.iterator != null) {
                    this.iterator = null;
                }
                if (this.featureType != null) {
                    this.featureType = null;
                }
                this.contents = null;
                this.current = null;
                this.live = null;
            }
        };
    }

    protected Envelope getBounds(Query query) throws IOException {
        String typeName = query.getTypeName();
        Map contents = this.features(typeName);
        Iterator iterator = contents.values().iterator();
        Envelope envelope = null;
        if (iterator.hasNext()) {
            int count = 1;
            Filter filter = query.getFilter();
            Feature first = (Feature)iterator.next();
            envelope = new Envelope(first.getDefaultGeometry().getEnvelopeInternal());
            while (iterator.hasNext() && count < query.getMaxFeatures()) {
                Feature feature = (Feature)iterator.next();
                if (!filter.contains(feature)) continue;
                ++count;
                envelope.expandToInclude(feature.getDefaultGeometry().getEnvelopeInternal());
            }
        }
        return envelope;
    }

    protected int getCount(Query query) throws IOException {
        String typeName = query.getTypeName();
        Map contents = this.features(typeName);
        Iterator iterator = contents.values().iterator();
        int count = 0;
        Filter filter = query.getFilter();
        while (iterator.hasNext() && count < query.getMaxFeatures()) {
            if (!filter.contains((Feature)iterator.next())) continue;
            ++count;
        }
        return count;
    }
}

