/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.AbstractFeatureLocking;
import org.geotools.data.AbstractFeatureSource;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureReader;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.EmptyFeatureWriter;
import org.geotools.data.FeatureListener;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.store.TypeDiffState;
import org.geotools.data.store.TypeEntry;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.geometry.jts.JTS;
import org.geotools.util.SimpleInternationalString;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

final class ActiveTypeEntry
implements TypeEntry {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data.store");
    DataStore parent;
    private final FeatureType schema;
    private final Map metadata;
    private FeatureListenerManager listeners = new FeatureListenerManager();
    int count;
    Envelope bounds;
    public FeatureListenerManager listenerManager = new FeatureListenerManager();

    public ActiveTypeEntry(DataStore parent, FeatureType schema, Map metadata) {
        this.schema = schema;
        this.metadata = metadata;
        this.parent = parent;
    }

    public InternationalString getDisplayName() {
        return new SimpleInternationalString(this.schema.getTypeName());
    }

    public InternationalString getDescription() {
        return null;
    }

    public FeatureType getFeatureType() {
        return null;
    }

    public synchronized Envelope getBounds() {
        if (this.bounds != null) {
            this.bounds = this.createBounds();
        }
        return this.bounds;
    }

    protected Envelope createBounds() {
        Envelope bbox;
        try {
            FeatureSource source = this.getFeatureSource();
            bbox = source.getBounds();
            if (bbox == null) {
                bbox = source.getFeatures().getBounds();
            }
            try {
                CoordinateReferenceSystem cs = source.getSchema().getDefaultGeometry().getCoordinateSystem();
                bbox = JTS.toGeographic(bbox, cs);
            }
            catch (Error badRepoject) {
                badRepoject.printStackTrace();
            }
        }
        catch (Exception e) {
            bbox = new Envelope();
        }
        return bbox;
    }

    public int getCount() {
        if (this.count != -1) {
            return this.count;
        }
        try {
            FeatureSource source = this.getFeatureSource();
            this.count = source.getCount(Query.ALL);
            if (this.count == -1) {
                this.count = source.getFeatures().getCount();
            }
        }
        catch (IOException e) {
            this.bounds = new Envelope();
        }
        return this.count;
    }

    public String getDataName() {
        return this.schema.getNamespace().toString() + ":" + this.schema.getTypeName();
    }

    public Object resource() {
        try {
            return this.getFeatureSource();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String[] getMetadataNames() {
        return this.metadata.keySet().toArray(new String[this.metadata.size()]);
    }

    public Map metadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public String getTypeName() {
        return this.schema.getTypeName();
    }

    public FeatureType getSchema() {
        return this.schema;
    }

    public FeatureSource getFeatureSource() throws IOException {
        return this.createFeatureSource();
    }

    public FeatureReader reader(Query query, Transaction transaction) throws IOException {
        Filter filter = query.getFilter();
        String typeName = query.getTypeName();
        String[] propertyNames = query.getPropertyNames();
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.NONE?");
        }
        if (typeName == null) {
            throw new NullPointerException("getFeatureReader requires typeName: use getTypeNames() for a list of available types");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        FeatureType featureType = this.schema;
        if (propertyNames != null || query.getCoordinateSystem() != null) {
            try {
                featureType = DataUtilities.createSubType(featureType, propertyNames, query.getCoordinateSystem());
            }
            catch (SchemaException e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
                throw new DataSourceException("Could not create Feature Type for query", (Throwable)e);
            }
        }
        if (filter == Filter.ALL || filter.equals(Filter.ALL)) {
            return new EmptyFeatureReader(featureType);
        }
        if ((filter = this.getUnsupportedFilter(filter)) == null) {
            throw new NullPointerException("getUnsupportedFilter shouldn't return null. Do you mean Filter.NONE?");
        }
        FeatureReader reader = this.createReader(query);
        if (!filter.equals(Filter.NONE)) {
            reader = new FilteringFeatureReader(reader, filter);
        }
        if (transaction != Transaction.AUTO_COMMIT) {
            Diff diff = this.state(transaction).diff();
            reader = new DiffFeatureReader(reader, diff);
        }
        if (!featureType.equals(reader.getFeatureType())) {
            LOGGER.fine("Recasting feature type to subtype by using a ReTypeFeatureReader");
            reader = new ReTypeFeatureReader(reader, featureType, false);
        }
        if (query.getMaxFeatures() != Integer.MAX_VALUE) {
            reader = new MaxFeatureReader(reader, query.getMaxFeatures());
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeDiffState state(Transaction transaction) {
        Transaction transaction2 = transaction;
        synchronized (transaction2) {
            TypeDiffState state = (TypeDiffState)transaction.getState((Object)this);
            if (state == null) {
                state = new TypeDiffState(this);
                transaction.putState((Object)this, (Transaction.State)state);
            }
            return state;
        }
    }

    public void fireAdded(Feature newFeature, Transaction transaction) {
        Envelope bounds = newFeature != null ? newFeature.getBounds() : null;
        this.listenerManager.fireFeaturesAdded(this.schema.getTypeName(), transaction, bounds, false);
    }

    public void fireRemoved(Feature removedFeature, Transaction transaction) {
        Envelope bounds = removedFeature != null ? removedFeature.getBounds() : null;
        this.listenerManager.fireFeaturesRemoved(this.schema.getTypeName(), transaction, bounds, false);
    }

    public void fireChanged(Feature before, Feature after, Transaction transaction) {
        String typeName = after.getFeatureType().getTypeName();
        Envelope bounds = new Envelope();
        bounds.expandToInclude(before.getBounds());
        bounds.expandToInclude(after.getBounds());
        this.listenerManager.fireFeaturesChanged(typeName, transaction, bounds, false);
    }

    protected FeatureSource createFeatureSource() {
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listeners.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listeners.addFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return ActiveTypeEntry.this.schema;
            }
        };
    }

    protected FeatureSource createFeatureSource(final FeatureType featureType) {
        return new AbstractFeatureSource(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return featureType;
            }
        };
    }

    protected FeatureStore createFeatureStore() {
        return new AbstractFeatureStore(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return ActiveTypeEntry.this.schema;
            }
        };
    }

    protected FeatureLocking createFeatureLocking() {
        return new AbstractFeatureLocking(){

            public DataStore getDataStore() {
                return ActiveTypeEntry.this.parent;
            }

            public void addFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.addFeatureListener(this, listener);
            }

            public void removeFeatureListener(FeatureListener listener) {
                ActiveTypeEntry.this.listenerManager.removeFeatureListener(this, listener);
            }

            public FeatureType getSchema() {
                return ActiveTypeEntry.this.schema;
            }
        };
    }

    public FeatureReader createReader() {
        return new EmptyFeatureReader(this.schema);
    }

    protected FeatureReader createReader(Query query) throws IOException {
        return this.createReader();
    }

    protected Filter getUnsupportedFilter(Filter filter) {
        return filter;
    }

    public FeatureWriter writer(Transaction transaction) throws IOException {
        if (transaction == null) {
            throw new NullPointerException("getFeatureWriter requires Transaction: did you mean to use Transaction.AUTO_COMMIT?");
        }
        FeatureWriter writer = transaction == Transaction.AUTO_COMMIT ? this.createWriter() : this.state(transaction).writer();
        if (this.parent.getLockingManager() != null && this.parent.getLockingManager() instanceof InProcessLockingManager) {
            InProcessLockingManager lockingManger = (InProcessLockingManager)this.parent.getLockingManager();
            writer = lockingManger.checkedWriter(writer, transaction);
        }
        return writer;
    }

    protected FeatureWriter createWriter() {
        return new EmptyFeatureWriter(this.schema);
    }

    protected FeatureWriter createAppend(Transaction transaction) throws IOException {
        FeatureWriter writer = this.writer(transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }
}

