/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.store.FeatureReaderIterator;
import org.geotools.data.store.FeatureWriterIterator;
import org.geotools.data.store.NoContentIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureList;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.feature.collection.FeatureState;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.feature.type.FeatureAttributeType;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.filter.Filter;
import org.geotools.filter.SortBy;
import org.geotools.filter.SortBy2;
import org.geotools.util.NullProgressListener;
import org.geotools.util.ProgressListener;
import org.geotools.xml.gml.GMLSchema;

public abstract class DataFeatureCollection
implements FeatureCollection {
    private List listeners = new ArrayList(2);
    private static int unique = 0;
    private final Set open = new HashSet();
    private FeatureCollection parent;
    private final String ID;
    FeatureType featureType;

    protected DataFeatureCollection() {
        this("features" + unique++);
    }

    protected DataFeatureCollection(String id) {
        this.ID = id;
        this.featureType = null;
    }

    protected DataFeatureCollection(String id, FeatureType featureType) {
        this.ID = id;
        this.featureType = featureType;
    }

    protected void fireChange(Feature[] features, int type) {
        CollectionEvent cEvent = new CollectionEvent((FeatureCollection)this, features, type);
        int ii = this.listeners.size();
        for (int i = 0; i < ii; ++i) {
            ((CollectionListener)this.listeners.get(i)).collectionChanged(cEvent);
        }
    }

    protected void fireChange(Feature feature, int type) {
        this.fireChange(new Feature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        Feature[] features = new Feature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    public abstract FeatureType getSchema();

    public abstract FeatureReader reader() throws IOException;

    public abstract Envelope getBounds();

    public abstract int getCount() throws IOException;

    public abstract FeatureCollection collection() throws IOException;

    protected FeatureWriter writer() throws IOException {
        throw new UnsupportedOperationException("Modification of this collection is not supported");
    }

    public void addListener(CollectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionListener listener) {
        this.listeners.remove(listener);
    }

    public FeatureIterator features() {
        DelegateFeatureIterator iterator = new DelegateFeatureIterator(this, this.iterator());
        this.open.add(iterator);
        return iterator;
    }

    public final Iterator iterator() {
        Iterator iterator = this.openIterator();
        this.open.add(iterator);
        return iterator;
    }

    protected Iterator openIterator() {
        try {
            return new FeatureWriterIterator(this.writer());
        }
        catch (IOException badWriter) {
            return new NoContentIterator(badWriter);
        }
        catch (UnsupportedOperationException readOnly) {
            try {
                return new FeatureReaderIterator(this.reader());
            }
            catch (IOException e) {
                return new NoContentIterator(e);
            }
        }
    }

    public void close(FeatureIterator iterator) {
        iterator.close();
        this.open.remove(iterator);
    }

    public final void close(Iterator close) {
        this.closeIterator(close);
        this.open.remove(close);
    }

    protected void closeIterator(Iterator close) {
        if (close != null) {
            if (close instanceof FeatureReaderIterator) {
                FeatureReaderIterator iterator = (FeatureReaderIterator)close;
                iterator.close();
            } else if (close instanceof FeatureWriterIterator) {
                FeatureWriterIterator iterator = (FeatureWriterIterator)close;
                iterator.close();
            }
        }
    }

    public int size() {
        try {
            return this.getCount();
        }
        catch (IOException e) {
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            Object iterator = i.next();
            try {
                if (iterator instanceof Iterator) {
                    this.closeIterator((Iterator)iterator);
                }
                if (!(iterator instanceof FeatureIterator)) continue;
                ((FeatureIterator)iterator).close();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isEmpty() {
        boolean bl;
        FeatureReader reader;
        block12: {
            reader = null;
            reader = this.reader();
            bl = !reader.hasNext();
            Object var5_5 = null;
            if (reader == null) break block12;
            try {
                reader.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        return bl;
        {
            catch (IOException e) {
                boolean bl2;
                block13: {
                    bl2 = true;
                    Object var5_6 = null;
                    if (reader == null) break block13;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return bl2;
                catch (IOException e3) {
                    boolean bl3;
                    block14: {
                        try {
                            bl3 = true;
                            Object var5_7 = null;
                            if (reader == null) break block14;
                        }
                        catch (Throwable throwable) {
                            block15: {
                                Object var5_8 = null;
                                if (reader == null) break block15;
                                try {
                                    reader.close();
                                }
                                catch (IOException e2) {}
                            }
                            throw throwable;
                        }
                        try {
                            reader.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    return bl3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object o) {
        block23: {
            block22: {
                if (!(o instanceof Feature)) {
                    return false;
                }
                value = (Feature)o;
                ID = value.getID();
                reader = null;
                try {
                    try {
                        block21: {
                            reader = this.reader();
                            try {
                                while (reader.hasNext()) {
                                    feature = reader.next();
                                    if (!ID.equals(feature.getID()) || !value.equals(feature)) continue;
                                    var6_11 = true;
                                    break block21;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (IOException e) {
                                var6_12 = false;
                                var8_18 = null;
                                if (reader == null) return var6_12;
                                try {
                                    reader.close();
                                    return var6_12;
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var6_12;
                            }
                            catch (NoSuchElementException e) {
                                var6_13 = false;
                                var8_19 = null;
                                if (reader == null) return var6_13;
                                ** try [egrp 4[TRYBLOCK] [18 : 155->165)] { 
lbl33:
                                // 1 sources

                                reader.close();
                                return var6_13;
lbl35:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var6_13;
                            }
                            catch (IllegalAttributeException e) {
                                var6_14 = false;
                                var8_20 = null;
                                if (reader == null) return var6_14;
                                ** try [egrp 4[TRYBLOCK] [18 : 155->165)] { 
lbl44:
                                // 1 sources

                                reader.close();
                                return var6_14;
lbl46:
                                // 1 sources

                                catch (IOException e) {
                                    // empty catch block
                                }
                                return var6_14;
                            }
                        }
                        var8_16 = null;
                        if (reader == null) return var6_11;
                        break block22;
lbl-1000:
                        // 1 sources

                        {
                            feature = false;
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        var6_15 = false;
                        var8_21 = null;
                        if (reader == null) return var6_15;
                        ** try [egrp 4[TRYBLOCK] [18 : 155->165)] { 
lbl62:
                        // 1 sources

                        reader.close();
                        return var6_15;
lbl64:
                        // 1 sources

                        catch (IOException e) {
                            // empty catch block
                        }
                        return var6_15;
                    }
                }
                catch (Throwable var7_30) {
                    var8_22 = null;
                    if (reader == null) throw var7_30;
                    try {}
                    catch (IOException e) {
                        throw var7_30;
                    }
                    reader.close();
                    throw var7_30;
                }
            }
            try {}
            catch (IOException e) {
                // empty catch block
                return var6_11;
            }
            reader.close();
            return var6_11;
        }
        var8_17 = null;
        if (reader == null) return feature;
        try {}
        catch (IOException e) {
            // empty catch block
            return feature;
        }
        reader.close();
        return feature;
    }

    public Object[] toArray() {
        return null;
    }

    public Object[] toArray(Object[] arg0) {
        return null;
    }

    public boolean add(Object arg0) {
        return false;
    }

    public boolean remove(Object arg0) {
        return false;
    }

    public boolean containsAll(Collection arg0) {
        return false;
    }

    public boolean addAll(Collection arg0) {
        return false;
    }

    public boolean removeAll(Collection arg0) {
        return false;
    }

    public boolean retainAll(Collection arg0) {
        return false;
    }

    public void clear() {
    }

    public synchronized FeatureType getFeatureType() {
        if (this.featureType == null) {
            LinkedList<FeatureAttributeType> ats = new LinkedList<FeatureAttributeType>();
            ats.add(new FeatureAttributeType(this.getSchema().getTypeName(), this.getSchema(), false));
            this.featureType = new DefaultFeatureType("AbstractFeatureCollectionType", GMLSchema.NAMESPACE, ats, new LinkedList(), null);
        }
        return this.featureType;
    }

    public FeatureCollection getParent() {
        return this.parent;
    }

    public void setParent(FeatureCollection collection) {
        this.parent = collection;
    }

    public String getID() {
        return this.ID;
    }

    public Object[] getAttributes(Object[] attributes) {
        List list = (List)this.getAttribute(0);
        return list.toArray(attributes);
    }

    public Object getAttribute(String xPath) {
        if (xPath.indexOf(this.featureType.getTypeName()) > -1) {
            if (xPath.endsWith("]")) {
                return this.getAttribute(0);
            }
            return this.getAttribute(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getAttribute(int index) {
        if (index != 0) return null;
        reader = null;
        try {
            try {
                reader = this.reader();
                schema = this.getSchema();
                list = new ArrayList<Feature>();
                while (reader.hasNext()) {
                    feature = reader.next();
                    copy = schema.duplicate(feature);
                    copy.setParent((FeatureCollection)this);
                    list.add(copy);
                }
                var5_11 = list;
                var8_13 = null;
                if (reader == null) return var5_11;
            }
            catch (IOException e) {
                var4_8 = null;
                var8_14 = null;
                if (reader == null) return var4_8;
                try {
                    reader.close();
                    return var4_8;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return var4_8;
            }
            catch (NoSuchElementException e) {
                var4_9 = null;
                var8_15 = null;
                if (reader == null) return var4_9;
                ** try [egrp 2[TRYBLOCK] [8 : 127->136)] { 
lbl37:
                // 1 sources

                reader.close();
                return var4_9;
lbl39:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var4_9;
            }
            catch (IllegalAttributeException e) {
                var4_10 = null;
                var8_16 = null;
                if (reader == null) return var4_10;
                ** try [egrp 2[TRYBLOCK] [8 : 127->136)] { 
lbl48:
                // 1 sources

                reader.close();
                return var4_10;
lbl50:
                // 1 sources

                catch (IOException e) {
                    // empty catch block
                }
                return var4_10;
            }
        }
        catch (Throwable var7_23) {
            var8_17 = null;
            if (reader == null) throw var7_23;
            ** try [egrp 2[TRYBLOCK] [8 : 127->136)] { 
lbl58:
            // 1 sources

            reader.close();
            throw var7_23;
lbl60:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            throw var7_23;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return var5_11;
        }
        reader.close();
        return var5_11;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        if (position != 0) return;
        if (!(val instanceof Collection)) return;
        Collection list = (Collection)val;
        if (!FeatureState.isFeatures(list)) {
            return;
        }
        FeatureWriter writer = null;
        try {
            try {
                writer = this.writer();
                while (writer.hasNext()) {
                    writer.next();
                    writer.remove();
                }
                Feature feature = null;
                Iterator i = list.iterator();
                while (i.hasNext()) {
                    feature = (Feature)i.next();
                    Feature newFeature = writer.next();
                    newFeature.setParent((FeatureCollection)this);
                    Object[] values = feature.getAttributes(null);
                    for (int a = 0; a < values.length; ++a) {
                        newFeature.setAttribute(a, values[a]);
                    }
                    writer.write();
                }
                Object var11_11 = null;
                if (writer == null) return;
            }
            catch (IOException io) {
                throw (ArrayIndexOutOfBoundsException)new ArrayIndexOutOfBoundsException().initCause(io);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException io) {
                throw (IllegalAttributeException)new IllegalAttributeException("Unsuccessful:" + io).initCause((Throwable)io);
            }
        }
        try {}
        catch (IOException io) {
            throw (IllegalAttributeException)new IllegalAttributeException("Unsuccessful:" + io).initCause((Throwable)io);
        }
        writer.close();
    }

    public int getNumberOfAttributes() {
        return this.size();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        if (xPath.indexOf(this.featureType.getTypeName()) > -1 && !xPath.endsWith("]")) {
            this.setAttribute(0, attribute);
        }
    }

    public Geometry getDefaultGeometry() {
        return null;
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        throw new IllegalAttributeException("DefaultGeometry not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        Iterator iterator = null;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            float size = this.size();
            float position = 0.0f;
            progress.started();
            iterator = this.iterator();
            while (!progress.isCanceled() && iterator.hasNext()) {
                try {
                    Feature feature = (Feature)iterator.next();
                    visitor.visit(feature);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                }
                float f = position;
                position = f + 1.0f;
                progress.progress(f / size);
            }
        }
        catch (Throwable throwable) {
            progress.complete();
            this.close(iterator);
            throw throwable;
        }
        progress.complete();
        this.close(iterator);
    }

    public FeatureCollection subCollection(Filter filter) {
        return new SubFeatureCollection(this, filter);
    }

    public FeatureList sort(SortBy order) {
        if (order instanceof SortBy2) {
            SortBy2 advanced = (SortBy2)order;
            return this.sort(advanced);
        }
        return null;
    }

    public FeatureList sort(SortBy2 order) {
        return null;
    }
}

