/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.filter.AbstractFilterImpl;
import org.geotools.filter.FidFilter;
import org.geotools.filter.FilterFactoryFinder;
import org.opengis.filter.FeatureId;
import org.opengis.filter.FilterVisitor;

public class FidFilterImpl
extends AbstractFilterImpl
implements FidFilter {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.core");
    private Set fids = new HashSet();

    protected FidFilterImpl() {
        super(FilterFactoryFinder.createFilterFactory());
        this.filterType = (short)22;
    }

    protected FidFilterImpl(String initialFid) {
        super(FilterFactoryFinder.createFilterFactory());
        this.filterType = (short)22;
        this.addFid(initialFid);
    }

    public final void addFid(String fid) {
        LOGGER.finest("got fid: " + fid);
        this.fids.add(fid);
    }

    public boolean evaluate(Feature feature) {
        if (feature == null) {
            return false;
        }
        return this.fids.contains(feature.getID());
    }

    public String toString() {
        StringBuffer fidFilter = new StringBuffer();
        Iterator fidIterator = this.fids.iterator();
        while (fidIterator.hasNext()) {
            fidFilter.append(fidIterator.next().toString());
            if (!fidIterator.hasNext()) continue;
            fidFilter.append(", ");
        }
        return "[ " + fidFilter.toString() + " ]";
    }

    public boolean equals(Object filter) {
        LOGGER.finest("condition: " + filter);
        if (filter != null && filter.getClass() == this.getClass()) {
            LOGGER.finest("condition: " + ((FidFilterImpl)filter).filterType);
            if (((FidFilterImpl)filter).filterType == 22) {
                return ((Object)this.fids).equals(((FidFilterImpl)filter).getFidsSet());
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return ((Object)this.fids).hashCode();
    }

    public final String[] getFids() {
        return this.fids.toArray(new String[0]);
    }

    public Set getIDs() {
        return this.getFidsSet();
    }

    public void setIDs(Set ids) {
        this.fids = ids;
    }

    public Set getFidsSet() {
        return this.fids;
    }

    public void removeAllFids(Collection fidsToRemove) {
        this.fids.removeAll(fidsToRemove);
    }

    public void addAllFids(Collection fidsToAdd) {
        this.fids.addAll(fidsToAdd);
    }

    public final void removeFid(String fid) {
        this.fids.remove(fid);
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((FeatureId)this, extraData);
    }
}

