/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Date;
import org.geotools.feature.Feature;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Literal;

public class LiteralExpressionImpl
extends DefaultExpression
implements LiteralExpression {
    private Object literal = null;

    protected LiteralExpressionImpl() {
    }

    protected LiteralExpressionImpl(Object literal) throws IllegalFilterException {
        this.setLiteral(literal);
    }

    protected LiteralExpressionImpl(short value) {
        try {
            this.setLiteral(new Short(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Short");
        }
    }

    protected LiteralExpressionImpl(int value) {
        try {
            this.setLiteral(new Integer(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Integers");
        }
    }

    protected LiteralExpressionImpl(double value) {
        try {
            this.setLiteral(new Double(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Doubles");
        }
    }

    protected LiteralExpressionImpl(long value) {
        try {
            this.setLiteral(new Long(value));
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Doubles");
        }
    }

    protected LiteralExpressionImpl(String value) {
        try {
            this.setLiteral(value);
        }
        catch (IllegalFilterException ile) {
            throw new AssertionError((Object)"LiteralExpressionImpl is broken, it should accept Strings");
        }
    }

    public short getType() {
        return this.expressionType;
    }

    public final void setLiteral(Object literal) throws IllegalFilterException {
        this.setValue(literal);
    }

    public final Object getLiteral() {
        return this.getValue();
    }

    public Object getValue() {
        return this.literal;
    }

    public final void setValue(Object literal) {
        if (literal instanceof Double) {
            this.expressionType = (short)101;
        } else if (literal instanceof Integer) {
            this.expressionType = (short)102;
        } else if (literal instanceof Long) {
            this.expressionType = (short)100;
        } else if (literal instanceof Short) {
            this.expressionType = (short)102;
        } else if (literal instanceof String) {
            this.expressionType = (short)103;
        } else if (literal instanceof Geometry) {
            this.expressionType = (short)104;
        } else if (literal instanceof Boolean) {
            this.expressionType = (short)115;
        } else if (literal instanceof Date) {
            this.expressionType = (short)116;
        } else {
            throw new IllegalFilterException("Attempted to add a literal with non-supported type (ie. not Double, Integer, String).");
        }
        this.literal = literal;
    }

    public Object evaluate(Feature feature) throws IllegalArgumentException {
        return this.literal;
    }

    public String toString() {
        return this.literal == null ? "NULL" : this.literal.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralExpressionImpl) {
            boolean isEqual;
            LiteralExpressionImpl expLit = (LiteralExpressionImpl)obj;
            boolean bl = isEqual = expLit.getType() == this.expressionType;
            if (!isEqual) {
                return false;
            }
            if (expLit == null && this.literal == null) {
                return true;
            }
            if (this.expressionType == 104) {
                return ((Geometry)this.literal).equals((Geometry)expLit.getLiteral());
            }
            if (this.expressionType == 102) {
                return ((Integer)this.literal).equals((Integer)expLit.getLiteral());
            }
            if (this.expressionType == 103) {
                return ((String)this.literal).equals((String)expLit.getLiteral());
            }
            if (this.expressionType == 101) {
                return ((Double)this.literal).equals((Double)expLit.getLiteral());
            }
            if (this.expressionType == 115) {
                return ((Boolean)this.literal).equals((Boolean)expLit.getLiteral());
            }
            if (this.expressionType == 116) {
                return ((Date)this.literal).equals((Date)expLit.getLiteral());
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.literal == null ? 0 : this.literal.hashCode());
        result = 37 * result + this.expressionType;
        return result;
    }

    public Object accept(ExpressionVisitor visitor, Object extraData) {
        return visitor.visit((Literal)this, extraData);
    }
}

