/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.visitor.AbstractFilterVisitor;

public class Collection_MinFunction
extends FunctionExpressionImpl
implements FunctionExpression {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.filter.function");
    FeatureCollection previousFeatureCollection = null;
    Object min = null;

    public Collection_MinFunction() {
        super("Collection_Min");
    }

    public int getArgCount() {
        return 1;
    }

    public static CalcResult calculateMin(FeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        MinVisitor minVisitor = new MinVisitor(expression);
        collection.accepts((FeatureVisitor)minVisitor, null);
        return minVisitor.getResult();
    }

    public void setArgs(Expression[] args) {
        if (args.length != 1) {
            throw new IllegalArgumentException("Require a single argument for minimum");
        }
        ArrayList<Expression> params = new ArrayList<Expression>();
        Expression expr = args[0];
        params.add(expr);
        this.setParameters(params);
        expr.accept((FilterVisitor)new AbstractFilterVisitor(){

            public void visit(AttributeExpression expression) {
                String xpath = expression.getAttributePath();
                if (xpath.startsWith("featureMembers/*/")) {
                    xpath = xpath.substring(17);
                } else if (xpath.startsWith("featureMember/*/")) {
                    xpath = xpath.substring(16);
                }
                try {
                    expression.setAttributePath(xpath);
                }
                catch (IllegalFilterException illegalFilterException) {
                    // empty catch block
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(Feature feature) {
        FeatureCollection featureCollection = feature instanceof FeatureCollection ? (FeatureCollection)feature : feature.getParent();
        if (featureCollection == null) {
            return new Integer(0);
        }
        FeatureCollection featureCollection2 = featureCollection;
        synchronized (featureCollection2) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.min = null;
                try {
                    Expression expr = (Expression)this.getParameters().get(0);
                    CalcResult result = Collection_MinFunction.calculateMin(featureCollection, expr);
                    if (result != null) {
                        this.min = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.min;
    }

    public void setExpression(Expression e) {
        List params = this.getParameters();
        params.set(0, e);
    }

    public Expression[] getArgs() {
        List params = this.getParameters();
        Expression[] args = params.toArray(new Expression[params.size()]);
        return args;
    }
}

