/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.MaxVisitor;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.Expression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.function.RangedClassificationFunction;
import org.geotools.util.NullProgressListener;

public class EqualIntervalFunction
extends RangedClassificationFunction {
    Comparable globalMin = null;
    Comparable globalMax = null;
    Comparable[] localMin = null;
    Comparable[] localMax = null;
    Object[] values = null;
    boolean isValid = false;
    boolean isNumber = false;

    public EqualIntervalFunction() {
        super("EqualInterval");
    }

    public void setParameters(List params) {
        int argCount = this.getArgCount();
        if (params.size() != argCount) {
            throw new IllegalArgumentException("Expect " + argCount + " parameters");
        }
        this.setExpression((Expression)params.get(0));
        LiteralExpression literalClasses = (LiteralExpression)params.get(1);
        Integer valueClass = (Integer)literalClasses.getValue();
        this.setNumberOfClasses(valueClass);
    }

    private void calculateMinAndMax() {
        try {
            MinVisitor minVisit = new MinVisitor(this.getExpression());
            if (this.progress == null) {
                this.progress = new NullProgressListener();
            }
            this.fc.accepts((FeatureVisitor)minVisit, this.progress);
            if (this.progress.isCanceled()) {
                return;
            }
            this.globalMin = (Comparable)minVisit.getResult().getValue();
            MaxVisitor maxVisit = new MaxVisitor(this.getExpression());
            this.fc.accepts((FeatureVisitor)maxVisit, this.progress);
            if (this.progress.isCanceled()) {
                return;
            }
            this.globalMax = (Comparable)maxVisit.getResult().getValue();
            if (!(this.globalMin instanceof Number) || !(this.globalMax instanceof Number)) {
                UniqueVisitor uniqueVisit = new UniqueVisitor(this.getExpression());
                this.fc.accepts((FeatureVisitor)uniqueVisit, null);
                List result = uniqueVisit.getResult().toList();
                Collections.sort(result);
                this.values = result.toArray();
            }
        }
        catch (IllegalFilterException e) {
            e.printStackTrace();
            this.isValid = false;
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            this.isValid = false;
            return;
        }
        int classNum = this.getNumberOfClasses();
        this.localMin = new Comparable[classNum];
        this.localMax = new Comparable[classNum];
        if (this.globalMin instanceof Number && this.globalMax instanceof Number) {
            double slotWidth = this.calculateSlotWidth();
            this.isNumber = true;
            for (int i = 0; i < classNum; ++i) {
                this.localMin[i] = new Double(((Number)((Object)this.globalMin)).doubleValue() + (double)i * slotWidth);
                this.localMax[i] = new Double(((Number)((Object)this.globalMax)).doubleValue() - (double)(classNum - i - 1) * slotWidth);
                int decPlaces = this.decimalPlaces(slotWidth);
                if (decPlaces > -1) {
                    this.localMin[i] = new Double(this.round(((Number)((Object)this.localMin[i])).doubleValue(), decPlaces));
                    this.localMax[i] = new Double(this.round(((Number)((Object)this.localMax[i])).doubleValue(), decPlaces));
                }
                if (i == 0) {
                    if (this.localMin[i].compareTo(new Double(((Number)((Object)this.globalMin)).doubleValue())) < 0) {
                        this.localMin[i] = new Double(this.fixRound(((Number)((Object)this.localMin[i])).doubleValue(), decPlaces, false));
                    }
                } else if (i == classNum - 1 && this.localMax[i].compareTo(new Double(((Number)((Object)this.globalMax)).doubleValue())) > 0) {
                    this.localMax[i] = new Double(this.fixRound(((Number)((Object)this.localMax[i])).doubleValue(), decPlaces, true));
                }
                if (i == 0 || this.localMin[i].equals(this.localMax[i - 1])) continue;
                this.localMin[i] = this.localMax[i - 1];
            }
        } else {
            this.isNumber = false;
            int binPop = new Double(Math.ceil((double)this.values.length / (double)classNum)).intValue();
            int lastBigBin = this.values.length % classNum;
            lastBigBin = lastBigBin == 0 ? classNum : --lastBigBin;
            int itemIndex = 0;
            for (int binIndex = 0; binIndex < classNum; ++binIndex) {
                this.localMin[binIndex] = (Comparable)this.values[itemIndex];
                this.localMax[binIndex] = binIndex == classNum - 1 ? (Comparable)this.values[itemIndex] : (Comparable)this.values[(itemIndex += binPop) + 1];
                if (lastBigBin != binIndex) continue;
                --binPop;
            }
        }
        this.isValid = true;
    }

    private double calculateSlotWidth() {
        int classNum = this.getNumberOfClasses();
        return (((Number)((Object)this.globalMax)).doubleValue() - ((Number)((Object)this.globalMin)).doubleValue()) / (double)classNum;
    }

    protected int calculateSlot(Object val) {
        if (!this.isValid) {
            return -1;
        }
        int classNum = this.getNumberOfClasses();
        if (this.globalMax.compareTo(val) < 1) {
            return classNum - 1;
        }
        Double doubleVal = new Double(((Number)val).doubleValue());
        for (int i = 0; i < classNum; ++i) {
            if (this.localMin[i].compareTo(doubleVal) >= 1 || this.localMax[i].compareTo(doubleVal) <= 0) continue;
            return i;
        }
        return -1;
    }

    public Object evaluate(Feature feature) {
        FeatureCollection coll = feature.getParent();
        if (coll == null) {
            return null;
        }
        if (!coll.equals(this.fc)) {
            this.fc = coll;
            this.calculateMinAndMax();
        }
        int slot = this.calculateSlot(this.getExpression().evaluate(feature));
        return new Integer(slot);
    }

    public void setExpression(Expression e) {
        super.setExpression(e);
        this.isValid = false;
        if (this.fc != null) {
            this.calculateMinAndMax();
        }
    }

    public Object getMin(int index) {
        if (this.fc == null) {
            return null;
        }
        if (!this.isValid) {
            this.calculateMinAndMax();
        }
        return this.localMin[index];
    }

    public Object getMax(int index) {
        if (this.fc == null) {
            return null;
        }
        if (!this.isValid) {
            this.calculateMinAndMax();
        }
        return this.localMax[index];
    }

    public int getArgCount() {
        return 2;
    }
}

