/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.visitor.AverageVisitor;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureVisitor;
import org.geotools.feature.visitor.StandardDeviationVisitor;
import org.geotools.filter.Expression;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.function.RangedClassificationFunction;
import org.geotools.util.NullProgressListener;

public class StandardDeviationFunction
extends RangedClassificationFunction {
    double standardDeviation;
    double average;
    boolean isValid = false;

    public StandardDeviationFunction() {
        super("StandardDeviation");
    }

    private void calculate() throws IllegalFilterException, IOException {
        AverageVisitor averageVisit = new AverageVisitor(this.getExpression());
        if (this.progress == null) {
            this.progress = new NullProgressListener();
        }
        this.fc.accepts((FeatureVisitor)averageVisit, this.progress);
        if (this.progress.isCanceled()) {
            return;
        }
        CalcResult calcResult = averageVisit.getResult();
        if (calcResult == null) {
            return;
        }
        this.average = calcResult.toDouble();
        StandardDeviationVisitor sdVisit = new StandardDeviationVisitor(this.getExpression(), this.average);
        this.fc.accepts((FeatureVisitor)sdVisit, this.progress);
        if (this.progress.isCanceled()) {
            return;
        }
        calcResult = sdVisit.getResult();
        if (calcResult == null) {
            return;
        }
        this.standardDeviation = calcResult.toDouble();
        this.isValid = true;
    }

    private int calculateSlot(Object val) {
        if (val == null) {
            return -1;
        }
        double value = Double.parseDouble(val.toString());
        if (this.isValid) {
            int classNum = this.getNumberOfClasses();
            double firstBoundary = this.average - ((double)classNum / 2.0 - 1.0) * this.standardDeviation;
            for (int i = 0; i < classNum - 1; ++i) {
                if (!(value < firstBoundary + (double)i * this.standardDeviation)) continue;
                return i;
            }
            return classNum - 1;
        }
        return -1;
    }

    public Object evaluate(Feature feature) {
        FeatureCollection fcNew = feature instanceof FeatureCollection ? (FeatureCollection)feature : feature.getParent();
        if (fcNew == null) {
            return new Integer(0);
        }
        if (!fcNew.equals(this.fc) || !this.isValid) {
            this.fc = fcNew;
            try {
                this.calculate();
            }
            catch (IllegalFilterException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        int slot = this.calculateSlot(this.getExpression().getValue(feature));
        return new Integer(slot);
    }

    public void setExpression(Expression e) {
        super.setExpression(e);
        if (this.fc != null) {
            try {
                this.calculate();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public Object getMin(int index) {
        int classNum = this.getNumberOfClasses();
        if (index <= 0 || index >= classNum) {
            return null;
        }
        return new Double(this.average - ((double)classNum / 2.0 - (double)index) * this.standardDeviation);
    }

    public Object getMax(int index) {
        int classNum = this.getNumberOfClasses();
        if (index < 0 || index >= classNum - 1) {
            return null;
        }
        return new Double(this.average - ((double)classNum / 2.0 - 1.0 - (double)index) * this.standardDeviation);
    }

    public int getArgCount() {
        return 2;
    }
}

