/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.spatial;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import org.geotools.feature.Feature;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.GeometryFilterImpl;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;

public class IntersectsImpl
extends GeometryFilterImpl
implements Intersects {
    public IntersectsImpl(FilterFactory factory, Expression e1, Expression e2) {
        super(factory, e1, e2);
        this.filterType = (short)7;
    }

    public boolean evaluate(Feature feature) {
        if (!this.validate(feature)) {
            return false;
        }
        Geometry left = this.getLeftGeometry(feature);
        Geometry right = this.getRightGeometry(feature);
        if (right == null || left == null) {
            return false;
        }
        Envelope envLeft = left.getEnvelopeInternal();
        Envelope envRight = right.getEnvelopeInternal();
        if (envLeft == null || envRight == null) {
            return false;
        }
        if (envRight.intersects(envLeft)) {
            return left.intersects(right);
        }
        return false;
    }

    public Object accept(FilterVisitor visitor, Object extraData) {
        return visitor.visit((Intersects)this, extraData);
    }
}

