/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import org.geotools.feature.FeatureType;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.BetweenFilter;
import org.geotools.filter.CompareFilter;
import org.geotools.filter.Expression;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;
import org.geotools.filter.GeometryFilter;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LikeFilter;
import org.geotools.filter.LiteralExpression;
import org.geotools.filter.LogicFilter;
import org.geotools.filter.MathExpression;
import org.geotools.filter.NullFilter;
import org.geotools.filter.visitor.ClientTransactionAccessor;

public class PostPreProcessFilterSplittingVisitor
implements FilterVisitor {
    private static final Logger logger = Logger.getLogger("org.geotools.filter");
    private Stack postStack = new Stack();
    private Stack preStack = new Stack();
    private Set changedStack = new HashSet();
    private FilterCapabilities fcs = null;
    private FeatureType parent = null;
    private Filter original = null;
    private ClientTransactionAccessor transactionAccessor;

    private PostPreProcessFilterSplittingVisitor() {
    }

    public PostPreProcessFilterSplittingVisitor(FilterCapabilities fcs, FeatureType parent, ClientTransactionAccessor transactionAccessor) {
        this.fcs = fcs;
        this.parent = parent;
        this.transactionAccessor = transactionAccessor;
    }

    public Filter getFilterPost() {
        if (!this.changedStack.isEmpty()) {
            return this.original;
        }
        if (this.postStack.size() > 1) {
            logger.warning("Too many post stack items after run: " + this.postStack.size());
        }
        Filter f = this.postStack.isEmpty() ? Filter.NONE : (Filter)this.postStack.peek();
        return f;
    }

    public Filter getFilterPre() {
        Filter deleteFilter;
        Filter f;
        if (this.preStack.isEmpty()) {
            return Filter.NONE;
        }
        if (this.preStack.size() > 1) {
            logger.warning("Too many pre stack items after run: " + this.preStack.size());
        }
        Filter filter = f = this.preStack.isEmpty() ? Filter.NONE : (Filter)this.preStack.peek();
        if (this.transactionAccessor != null && f != null && f != Filter.ALL && (deleteFilter = this.transactionAccessor.getDeleteFilter()) != null) {
            f = deleteFilter == Filter.ALL ? Filter.ALL : f.and(deleteFilter.not());
        }
        if (this.changedStack.isEmpty()) {
            return f;
        }
        Iterator iter = this.changedStack.iterator();
        Filter updateFilter = (Filter)iter.next();
        while (iter.hasNext()) {
            Filter next = (Filter)iter.next();
            if (next == Filter.NONE) {
                updateFilter = next;
                break;
            }
            updateFilter = updateFilter.or(next);
        }
        if (updateFilter == Filter.NONE || f == Filter.NONE) {
            return Filter.NONE;
        }
        return f.or(updateFilter);
    }

    public void visit(Filter filter) {
        if (filter == Filter.NONE) {
            return;
        }
        if (filter == Filter.ALL) {
            if (this.fcs.supports((short)-12345)) {
                this.preStack.push(filter);
            } else {
                this.postStack.push(filter);
            }
            return;
        }
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.postStack.isEmpty()) {
            this.postStack.push(filter);
            logger.fine("@see org.geotools.filter.FilterVisitor#visit(org.geotools.filter.Filter)" + filter.toString());
        } else {
            switch (filter.getFilterType()) {
                case 19: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 23: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 22: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 24: {
                    this.visit((GeometryFilter)filter);
                    break;
                }
                case 20: {
                    this.visit((LikeFilter)filter);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.visit((LogicFilter)filter);
                    break;
                }
                case 21: {
                    this.visit((NullFilter)filter);
                    break;
                }
                default: {
                    this.postStack.push(filter);
                    logger.warning(filter.toString() + " marked for post-processing in PostPreProcessFilterSplittingVisitor");
                }
            }
        }
    }

    public void visit(BetweenFilter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (this.fcs.supports(4096L)) {
            int i = this.postStack.size();
            Expression leftValue = filter.getLeftValue();
            Expression middleValue = filter.getMiddleValue();
            Expression rightValue = filter.getRightValue();
            if (leftValue == null || rightValue == null || middleValue == null) {
                this.postStack.push(filter);
                return;
            }
            leftValue.accept((FilterVisitor)this);
            if (i < this.postStack.size()) {
                this.postStack.pop();
                this.postStack.push(filter);
                return;
            }
            middleValue.accept((FilterVisitor)this);
            if (i < this.postStack.size()) {
                this.preStack.pop();
                this.postStack.pop();
                this.postStack.push(filter);
                return;
            }
            rightValue.accept((FilterVisitor)this);
            if (i < this.postStack.size()) {
                this.preStack.pop();
                this.preStack.pop();
                this.postStack.pop();
                this.postStack.push(filter);
                return;
            }
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            this.postStack.push(filter);
        }
    }

    public void visit(CompareFilter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(0x3F0000L)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        Expression leftValue = filter.getLeftValue();
        Expression rightValue = filter.getRightValue();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(filter);
            return;
        }
        leftValue.accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightValue.accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public void visit(GeometryFilter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        switch (filter.getFilterType()) {
            case 4: {
                if (this.fcs.supports(1L)) break;
                this.postStack.push(filter);
                return;
            }
            case 13: {
                if (this.fcs.supports(512L)) break;
                this.postStack.push(filter);
                return;
            }
            case 11: {
                if (this.fcs.supports(128L)) break;
                this.postStack.push(filter);
                return;
            }
            case 9: {
                if (this.fcs.supports(32L)) break;
                this.postStack.push(filter);
                return;
            }
            case 6: {
                if (this.fcs.supports(4L)) break;
                this.postStack.push(filter);
                return;
            }
            case 24: {
                if (this.fcs.supports(1024L)) break;
                this.postStack.push(filter);
                return;
            }
            case 5: {
                if (this.fcs.supports(2L)) break;
                this.postStack.push(filter);
                return;
            }
            case 7: {
                if (this.fcs.supports(8L)) break;
                this.postStack.push(filter);
                return;
            }
            case 12: {
                if (this.fcs.supports(256L)) break;
                this.postStack.push(filter);
                return;
            }
            case 8: {
                if (this.fcs.supports(16L)) break;
                this.postStack.push(filter);
                return;
            }
            case 10: {
                if (this.fcs.supports(64L)) break;
                this.postStack.push(filter);
                return;
            }
            default: {
                this.postStack.push(filter);
                return;
            }
        }
        int i = this.postStack.size();
        Expression leftGeometry = filter.getLeftGeometry();
        Expression rightGeometry = filter.getRightGeometry();
        if (leftGeometry == null || rightGeometry == null) {
            this.postStack.push(filter);
            return;
        }
        leftGeometry.accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        rightGeometry.accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public void visit(LikeFilter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(2048L)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        filter.getValue().accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
            return;
        }
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public void visit(LogicFilter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(0x3800000L)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        int j = this.preStack.size();
        if (filter.getFilterType() == 3) {
            Iterator it = filter.getFilterIterator();
            if (it.hasNext()) {
                Filter next = (Filter)it.next();
                next.accept((FilterVisitor)this);
                if (i < this.postStack.size()) {
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                } else {
                    this.popToSize(this.preStack, j);
                    this.preStack.push(filter);
                }
            }
        } else if (filter.getFilterType() == 1) {
            try {
                Filter orReplacement = this.translateOr(filter);
                orReplacement.accept((FilterVisitor)this);
            }
            catch (IllegalFilterException e) {
                this.popToSize(this.preStack, j);
                this.postStack.push(filter);
                return;
            }
            if (this.postStack.size() > i) {
                this.popToSize(this.postStack, i);
                this.postStack.push(filter);
                return;
            }
            this.preStack.pop();
            this.preStack.push(filter);
        } else {
            Iterator it = filter.getFilterIterator();
            while (it.hasNext()) {
                Filter next = (Filter)it.next();
                next.accept((FilterVisitor)this);
            }
            if (i < this.postStack.size()) {
                if (filter.getFilterType() == 2) {
                    Filter f = (Filter)this.postStack.pop();
                    while (this.postStack.size() > i) {
                        f = f.and((Filter)this.postStack.pop());
                    }
                    this.postStack.push(f);
                    if (j < this.preStack.size()) {
                        f = (Filter)this.preStack.pop();
                        while (this.preStack.size() > j) {
                            f = f.and((Filter)this.preStack.pop());
                        }
                        this.preStack.push(f);
                    }
                } else {
                    logger.warning("LogicFilter found which is not 'and, or, not");
                    this.popToSize(this.postStack, i);
                    this.popToSize(this.preStack, j);
                    this.postStack.push(filter);
                }
            } else {
                this.popToSize(this.preStack, j);
                this.preStack.push(filter);
            }
        }
    }

    private void popToSize(Stack stack, int j) {
        while (j < stack.size()) {
            stack.pop();
        }
    }

    public void visit(NullFilter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.fcs.supports(8192L)) {
            this.postStack.push(filter);
            return;
        }
        int i = this.postStack.size();
        filter.getNullCheckValue().accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(filter);
        }
        this.preStack.pop();
        this.preStack.push(filter);
    }

    public void visit(FidFilter filter) {
        if (this.original == null) {
            this.original = filter;
        }
        if (!this.postStack.isEmpty()) {
            this.postStack.push(filter);
        }
        this.preStack.push(filter);
    }

    public void visit(AttributeExpression expression) {
        if (this.parent != null && this.parent.getAttributeType(expression.getAttributePath()) == null) {
            throw new IllegalArgumentException("Property '" + expression.getPropertyName() + "' could not be found in " + this.parent.getTypeName());
        }
        if (this.transactionAccessor != null) {
            Filter updateFilter = this.transactionAccessor.getUpdateFilter(expression.getAttributePath());
            if (updateFilter != null) {
                this.changedStack.add(updateFilter);
                this.preStack.push(updateFilter);
            } else {
                this.preStack.push(expression);
            }
        } else {
            this.preStack.push(expression);
        }
    }

    public void visit(Expression expression) {
        this.postStack.push(expression);
        logger.warning("@see org.geotools.filter.FilterVisitor#visit(org.geotools.filter.Expression)");
    }

    public void visit(LiteralExpression expression) {
        if (expression.getLiteral() == null) {
            this.postStack.push(expression);
        }
        this.preStack.push(expression);
    }

    public void visit(MathExpression expression) {
        if (!this.fcs.supports(16384L)) {
            this.postStack.push(expression);
            return;
        }
        int i = this.postStack.size();
        Expression leftValue = expression.getLeftValue();
        Expression rightValue = expression.getRightValue();
        if (leftValue == null || rightValue == null) {
            this.postStack.push(expression);
            return;
        }
        leftValue.accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        rightValue.accept((FilterVisitor)this);
        if (i < this.postStack.size()) {
            this.preStack.pop();
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        this.preStack.pop();
        this.preStack.pop();
        this.preStack.push(expression);
    }

    public void visit(FunctionExpression expression) {
        if (!this.fcs.supports(32768L) || !this.fcs.supports(expression.getClass())) {
            this.postStack.push(expression);
            return;
        }
        if (expression.getName() == null) {
            this.postStack.push(expression);
            return;
        }
        int i = this.postStack.size();
        int j = this.preStack.size();
        for (int k = 0; k < expression.getArgCount(); ++k) {
            expression.getArgs()[k].accept((FilterVisitor)this);
            if (i >= this.postStack.size()) continue;
            while (j < this.preStack.size()) {
                this.preStack.pop();
            }
            this.postStack.pop();
            this.postStack.push(expression);
            return;
        }
        while (j < this.preStack.size()) {
            this.preStack.pop();
        }
        this.preStack.push(expression);
    }

    public Filter translateOr(LogicFilter filter) throws IllegalFilterException {
        if (filter.getFilterType() != 1) {
            return filter;
        }
        FilterFactory ff = FilterFactoryFinder.createFilterFactory();
        LogicFilter and = ff.createLogicFilter((short)2);
        Iterator i = filter.getFilterIterator();
        while (i.hasNext()) {
            Filter f = (Filter)i.next();
            if (f.getFilterType() == 3) {
                and.addFilter((Filter)((LogicFilter)f).getFilterIterator().next());
                continue;
            }
            and.addFilter(f.not());
        }
        return and.not();
    }

    public static class WFSBBoxFilterVisitor
    implements FilterVisitor {
        Envelope maxbbox;

        public WFSBBoxFilterVisitor(Envelope fsd) {
            this.maxbbox = fsd;
        }

        public void visit(Filter filter) {
            if (Filter.NONE == filter) {
                return;
            }
            switch (filter.getFilterType()) {
                case 19: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 23: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 22: {
                    this.visit((BetweenFilter)filter);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 24: {
                    this.visit((GeometryFilter)filter);
                    break;
                }
                case 20: {
                    this.visit((LikeFilter)filter);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.visit((LogicFilter)filter);
                    break;
                }
                case 21: {
                    this.visit((NullFilter)filter);
                    break;
                }
            }
        }

        public void visit(BetweenFilter filter) {
            if (filter != null) {
                if (filter.getLeftValue() != null) {
                    filter.getLeftValue().accept((FilterVisitor)this);
                }
                if (filter.getRightValue() != null) {
                    filter.getRightValue().accept((FilterVisitor)this);
                }
                if (filter.getMiddleValue() != null) {
                    filter.getMiddleValue().accept((FilterVisitor)this);
                }
            }
        }

        public void visit(CompareFilter filter) {
            if (filter != null) {
                if (filter.getLeftValue() != null) {
                    filter.getLeftValue().accept((FilterVisitor)this);
                }
                if (filter.getRightValue() != null) {
                    filter.getRightValue().accept((FilterVisitor)this);
                }
            }
        }

        public void visit(GeometryFilter filter) {
            if (filter != null) {
                Expression leftGeometry = filter.getLeftGeometry();
                Expression rightGeometry = filter.getRightGeometry();
                switch (filter.getFilterType()) {
                    case 4: {
                        Envelope bbox = null;
                        LiteralExpression le = null;
                        if (leftGeometry != null && leftGeometry.getType() == 104) {
                            le = (LiteralExpression)leftGeometry;
                            if (le != null && le.getLiteral() != null && le.getLiteral() instanceof Geometry) {
                                bbox = ((Geometry)le.getLiteral()).getEnvelopeInternal();
                            }
                        } else if (rightGeometry != null && rightGeometry.getType() == 104 && (le = (LiteralExpression)rightGeometry) != null && le.getLiteral() != null && le.getLiteral() instanceof Geometry) {
                            Geometry g = (Geometry)le.getLiteral();
                            bbox = g.getEnvelopeInternal();
                        }
                        if (bbox != null) {
                            boolean changed = false;
                            double minx = bbox.getMinX();
                            double miny = bbox.getMinY();
                            double maxx = bbox.getMaxX();
                            double maxy = bbox.getMaxY();
                            if (minx < this.maxbbox.getMinX()) {
                                minx = this.maxbbox.getMinX();
                                changed = true;
                            }
                            if (maxx > this.maxbbox.getMaxX()) {
                                maxx = this.maxbbox.getMaxX();
                                changed = true;
                            }
                            if (miny < this.maxbbox.getMinY()) {
                                miny = this.maxbbox.getMinY();
                                changed = true;
                            }
                            if (maxy > this.maxbbox.getMaxY()) {
                                maxy = this.maxbbox.getMaxY();
                                changed = true;
                            }
                            if (changed) {
                                Envelope tmp = new Envelope(minx, maxx, miny, maxy);
                                try {
                                    le.setLiteral((Object)new GeometryFactory().toGeometry(tmp));
                                }
                                catch (IllegalFilterException e) {
                                    logger.warning(e.toString());
                                }
                            }
                        }
                        return;
                    }
                }
                if (leftGeometry != null) {
                    leftGeometry.accept((FilterVisitor)this);
                }
                if (rightGeometry != null) {
                    rightGeometry.accept((FilterVisitor)this);
                }
            }
        }

        public void visit(LikeFilter filter) {
            if (filter != null && filter.getValue() != null) {
                filter.getValue().accept((FilterVisitor)this);
            }
        }

        public void visit(LogicFilter filter) {
            if (filter != null) {
                Iterator i = filter.getFilterIterator();
                while (i.hasNext()) {
                    Filter tmp = (Filter)i.next();
                    tmp.accept((FilterVisitor)this);
                }
            }
        }

        public void visit(NullFilter filter) {
            if (filter != null && filter.getNullCheckValue() != null) {
                filter.getNullCheckValue().accept((FilterVisitor)this);
            }
        }

        public void visit(FidFilter filter) {
        }

        public void visit(AttributeExpression expression) {
        }

        public void visit(Expression expression) {
        }

        public void visit(LiteralExpression expression) {
        }

        public void visit(MathExpression expression) {
        }

        public void visit(FunctionExpression expression) {
        }
    }
}

