/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import java.awt.RenderingHints;
import org.geotools.factory.Hints;
import org.geotools.geometry.DirectPosition2D;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.BufferedCoordinateOperationFactory;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class ReferencedEnvelope
extends com.vividsolutions.jts.geom.Envelope
implements Envelope {
    private static final CoordinateOperationFactory nonLenientCoordinateOperationfactory = new BufferedCoordinateOperationFactory();
    private static final CoordinateOperationFactory lenientCoordinateOperationfactory = new BufferedCoordinateOperationFactory(new Hints((RenderingHints.Key)Hints.LENIENT_DATUM_SHIFT, (Object)Boolean.TRUE));
    private static final long serialVersionUID = -3188702602373537163L;
    private final CoordinateReferenceSystem crs;

    public ReferencedEnvelope(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(double x1, double x2, double y1, double y2, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(x1, x2, y1, y2);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(com.vividsolutions.jts.geom.Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(envelope);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(ReferencedEnvelope.getJTSEnvelope(envelope, crs));
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(ReferencedEnvelope envelope) throws MismatchedDimensionException {
        super((com.vividsolutions.jts.geom.Envelope)envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        this.checkCoordinateReferenceSystemDimension();
    }

    private static com.vividsolutions.jts.geom.Envelope getJTSEnvelope(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        Envelope2D envelope2D = new Envelope2D(envelope);
        envelope2D.setCoordinateReferenceSystem(crs);
        return new com.vividsolutions.jts.geom.Envelope(envelope2D.getMinX(), envelope2D.getMaxX(), envelope2D.getMinY(), envelope2D.getMaxY());
    }

    private void checkCoordinateReferenceSystemDimension() throws MismatchedDimensionException {
        if (this.crs != null) {
            int expected = this.getDimension();
            int dimension = this.crs.getCoordinateSystem().getDimension();
            if (dimension != expected) {
                throw new MismatchedDimensionException(Errors.format((int)69, (Object)this.crs.getName().getCode(), (Object)new Integer(dimension), (Object)new Integer(expected)));
            }
        }
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public int getDimension() {
        return 2;
    }

    public double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getCenter(int dimension) {
        switch (dimension) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public double getLength(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    public DirectPosition getLowerCorner() {
        return new DirectPosition2D(this.crs, this.getMinX(), this.getMinY());
    }

    public DirectPosition getUpperCorner() {
        return new DirectPosition2D(this.crs, this.getMaxX(), this.getMaxY());
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient) throws TransformException, FactoryException {
        return this.transform(targetCRS, lenient, 5);
    }

    public ReferencedEnvelope transform(CoordinateReferenceSystem targetCRS, boolean lenient, int numPointsForTransformation) throws TransformException, FactoryException {
        MathTransform transform = lenient ? lenientCoordinateOperationfactory.createOperation(this.crs, targetCRS).getMathTransform() : nonLenientCoordinateOperationfactory.createOperation(this.crs, targetCRS).getMathTransform();
        ReferencedEnvelope target = new ReferencedEnvelope(targetCRS);
        JTS.transform(this, target, transform, numPointsForTransformation);
        return target;
    }

    public int hashCode() {
        int code = super.hashCode() ^ 0xAB296275;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem otherCRS = object instanceof ReferencedEnvelope ? ((ReferencedEnvelope)((Object)object)).crs : null;
            return Utilities.equals((Object)this.crs, (Object)otherCRS);
        }
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('[');
        buffer.append(GeneralDirectPosition.toString((DirectPosition)this.getLowerCorner()));
        buffer.append(" , ");
        buffer.append(GeneralDirectPosition.toString((DirectPosition)this.getUpperCorner()));
        buffer.append(']');
        return buffer.toString();
    }
}

