/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import org.geotools.filter.Expression;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterTransformer;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.ColorMap;
import org.geotools.styling.ColorMapEntry;
import org.geotools.styling.Displacement;
import org.geotools.styling.Extent;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.FeatureTypeConstraint;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Halo;
import org.geotools.styling.LinePlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.NamedLayer;
import org.geotools.styling.PointPlacement;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.RemoteOWS;
import org.geotools.styling.Rule;
import org.geotools.styling.SLDParser;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactoryFinder;
import org.geotools.styling.StyleVisitor;
import org.geotools.styling.StyledLayer;
import org.geotools.styling.StyledLayerDescriptor;
import org.geotools.styling.Symbol;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.geotools.styling.UserLayer;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SLDTransformer
extends TransformerBase {
    static final String XLINK_NAMESPACE = "http://www.w3.org/1999/xlink";
    static /* synthetic */ Class class$org$geotools$styling$StyleVisitor;

    public Translator createTranslator(ContentHandler handler) {
        return new SLDTranslator(handler);
    }

    public static final void main(String[] args) throws Exception {
        URL url = new File(args[0]).toURL();
        SLDParser s = new SLDParser(StyleFactoryFinder.createStyleFactory(), url);
        SLDTransformer transformer = new SLDTransformer();
        transformer.setIndentation(4);
        transformer.transform((Object)s.readXML(), new FileOutputStream(System.getProperty("java.io.tmpdir") + "/junk.eraseme"));
    }

    static class SLDTranslator
    extends TransformerBase.TranslatorSupport
    implements StyleVisitor {
        FilterTransformer.FilterTranslator filterTranslator;

        public SLDTranslator(ContentHandler handler) {
            super(handler, "sld", "http://www.opengis.net/sld");
            this.filterTranslator = new FilterTransformer.FilterTranslator(handler);
            this.addNamespaceDeclarations(this.filterTranslator);
        }

        void element(String element, Expression e) {
            this.start(element);
            this.filterTranslator.encode(e);
            this.end(element);
        }

        void element(String element, Filter f) {
            this.start(element);
            this.filterTranslator.encode(f);
            this.end(element);
        }

        public void visit(PointPlacement pp) {
            this.start("LabelPlacement");
            this.start("PointPlacement");
            pp.getAnchorPoint().accept((StyleVisitor)this);
            pp.getDisplacement().accept((StyleVisitor)this);
            this.element("Rotation", pp.getRotation());
            this.end("PointPlacement");
            this.end("LabelPlacement");
        }

        public void visit(Stroke stroke) {
            this.start("Stroke");
            if (stroke.getGraphicFill() != null) {
                this.start("GraphicFill");
                stroke.getGraphicFill().accept((StyleVisitor)this);
                this.end("GraphicFill");
            }
            if (stroke.getGraphicStroke() != null) {
                this.start("GraphicStroke");
                stroke.getGraphicStroke().accept((StyleVisitor)this);
                this.end("GraphicStroke");
            }
            this.encodeCssParam("stroke", stroke.getColor());
            this.encodeCssParam("stroke-linecap", stroke.getLineCap());
            this.encodeCssParam("stroke-linejoin", stroke.getLineJoin());
            this.encodeCssParam("stroke-opacity", stroke.getOpacity());
            this.encodeCssParam("stroke-width", stroke.getWidth());
            this.encodeCssParam("stroke-dashoffset", stroke.getDashOffset());
            float[] dash = stroke.getDashArray();
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < dash.length; ++i) {
                sb.append(dash[i] + " ");
            }
            this.encodeCssParam("stroke-dasharray", sb.toString());
            this.end("Stroke");
        }

        public void visit(LinePlacement lp) {
            this.start("LabelPlacement");
            this.start("LinePlacement");
            this.element("PerpendicularOffset", lp.getPerpendicularOffset());
            this.end("LinePlacement");
            this.end("LabelPlacement");
        }

        public void visit(AnchorPoint ap) {
            this.start("AnchorPoint");
            this.element("AnchorPointX", ap.getAnchorPointX());
            this.element("AnchorPointY", ap.getAnchorPointY());
            this.end("AnchorPoint");
        }

        public void visit(TextSymbolizer text) {
            if (text == null) {
                return;
            }
            this.start("TextSymbolizer");
            if (text.getGeometryPropertyName() != null) {
                this.encodeGeometryProperty(text.getGeometryPropertyName());
            }
            if (text.getLabel() != null) {
                this.element("Label", text.getLabel());
            }
            if (text.getFonts() != null && text.getFonts().length != 0) {
                this.start("Font");
                Font[] fonts = text.getFonts();
                for (int i = 0; i < fonts.length; ++i) {
                    this.encodeCssParam("font-family", fonts[i].getFontFamily());
                }
                this.encodeCssParam("font-size", fonts[0].getFontSize());
                this.encodeCssParam("font-style", fonts[0].getFontStyle());
                this.encodeCssParam("font-weight", fonts[0].getFontWeight());
                this.end("Font");
            }
            if (text.getPlacement() != null) {
                text.getPlacement().accept((StyleVisitor)this);
            }
            if (text.getHalo() != null) {
                text.getHalo().accept((StyleVisitor)this);
            }
            if (text.getFill() != null) {
                text.getFill().accept((StyleVisitor)this);
            }
            if (text.getOptions() != null) {
                this.encodeVendorOptions(text.getOptions());
            }
            if (text.getPriority() != null) {
                this.start("Priority");
                this.element("PropertyName", text.getPriority());
                this.end("Priority");
            }
            this.end("TextSymbolizer");
        }

        public void visit(RasterSymbolizer raster) {
            if (raster == null) {
                return;
            }
            this.start("RasterSymbolizer");
            if (raster.getGeometryPropertyName() != null) {
                this.encodeGeometryProperty(raster.getGeometryPropertyName());
            }
            if (raster.getOpacity() != null) {
                this.start("Opacity");
                this.filterTranslator.encode(raster.getOpacity());
                this.end("Opacity");
            }
            if (raster.getOverlap() != null) {
                this.start("OverlapBehavior");
                this.filterTranslator.encode(raster.getOverlap());
                this.end("OverlapBehavior");
            }
            if (raster.getColorMap() != null) {
                raster.getColorMap().accept((StyleVisitor)this);
            }
            this.end("RasterSymbolizer");
        }

        public void visit(ColorMap colorMap) {
            ColorMapEntry[] mapEntries = colorMap.getColorMapEntries();
            this.start("ColorMap");
            for (int i = 0; i < mapEntries.length; ++i) {
                mapEntries[i].accept((StyleVisitor)this);
            }
            this.end("ColorMap");
        }

        public void visit(ColorMapEntry colorEntry) {
            if (colorEntry != null) {
                AttributesImpl atts = new AttributesImpl();
                atts.addAttribute("", "color", "color", "", colorEntry.getColor().toString());
                if (colorEntry.getOpacity() != null) {
                    atts.addAttribute("", "opacity", "opacity", "", colorEntry.getOpacity().toString());
                }
                if (colorEntry.getQuantity() != null) {
                    atts.addAttribute("", "quantity", "quantity", "", colorEntry.getQuantity().toString());
                }
                if (colorEntry.getLabel() != null) {
                    atts.addAttribute("", "label", "label", "", colorEntry.getLabel());
                }
                this.element("ColorMapEntry", null, atts);
            }
        }

        public void visit(Symbolizer sym) {
            try {
                this.contentHandler.startElement("", "!--", "!--", this.NULL_ATTS);
                this.chars("Unidentified Symbolizer " + sym.getClass());
                this.contentHandler.endElement("", "--", "--");
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void visit(PolygonSymbolizer poly) {
            this.start("PolygonSymbolizer");
            this.encodeGeometryProperty(poly.getGeometryPropertyName());
            if (poly.getFill() != null) {
                poly.getFill().accept((StyleVisitor)this);
            }
            if (poly.getStroke() != null) {
                poly.getStroke().accept((StyleVisitor)this);
            }
            this.end("PolygonSymbolizer");
        }

        public void visit(ExternalGraphic exgr) {
            this.start("ExternalGraphic");
            AttributesImpl atts = new AttributesImpl();
            try {
                atts.addAttribute("", "xlink", "xmlns:xlink", "", SLDTransformer.XLINK_NAMESPACE);
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "type", "xlink:type", "", "simple");
                atts.addAttribute(SLDTransformer.XLINK_NAMESPACE, "xlink", "xlink:href", "", exgr.getLocation().toString());
            }
            catch (MalformedURLException murle) {
                throw new Error("SOMEONE CODED THE X LINK NAMESPACE WRONG!!");
            }
            this.element("OnlineResource", null, atts);
            this.element("Format", exgr.getFormat());
            this.end("ExternalGraphic");
        }

        public void visit(LineSymbolizer line) {
            this.start("LineSymbolizer");
            this.encodeGeometryProperty(line.getGeometryPropertyName());
            line.getStroke().accept((StyleVisitor)this);
            this.end("LineSymbolizer");
        }

        public void visit(Fill fill) {
            this.start("Fill");
            if (fill.getGraphicFill() != null) {
                this.start("GraphicFill");
                fill.getGraphicFill().accept((StyleVisitor)this);
                this.end("GraphicFill");
            }
            this.encodeCssParam("fill", fill.getColor());
            this.encodeCssParam("fill-opacity", fill.getOpacity());
            this.end("Fill");
        }

        public void visit(Rule rule) {
            this.start("Rule");
            if (rule.getName() != null) {
                this.element("Name", rule.getName());
            }
            if (rule.getTitle() != null) {
                this.element("Title", rule.getTitle());
            }
            if (rule.getAbstract() != null) {
                this.element("Abstract", rule.getAbstract());
            }
            Graphic[] gr = rule.getLegendGraphic();
            for (int i = 0; i < gr.length; ++i) {
                this.start("LegendGraphic");
                gr[i].accept((StyleVisitor)this);
                this.end("LegendGraphic");
            }
            if (rule.getFilter() != null) {
                this.filterTranslator.encode(rule.getFilter());
            }
            if (rule.hasElseFilter()) {
                this.start("ElseFilter");
                this.end("ElseFilter");
            }
            if (rule.getMinScaleDenominator() != 0.0) {
                this.element("MinScaleDenominator", rule.getMinScaleDenominator() + "");
            }
            if (rule.getMaxScaleDenominator() != Double.POSITIVE_INFINITY) {
                this.element("MaxScaleDenominator", rule.getMaxScaleDenominator() + "");
            }
            Symbolizer[] sym = rule.getSymbolizers();
            for (int i = 0; i < sym.length; ++i) {
                sym[i].accept((StyleVisitor)this);
            }
            this.end("Rule");
        }

        public void visit(Mark mark) {
            this.start("Mark");
            if (mark.getWellKnownName() != null) {
                this.element("WellKnownName", mark.getWellKnownName().toString());
            }
            if (mark.getFill() != null) {
                mark.getFill().accept((StyleVisitor)this);
            }
            if (mark.getStroke() != null) {
                mark.getStroke().accept((StyleVisitor)this);
            }
            this.end("Mark");
        }

        public void visit(PointSymbolizer ps) {
            this.start("PointSymbolizer");
            this.encodeGeometryProperty(ps.getGeometryPropertyName());
            ps.getGraphic().accept((StyleVisitor)this);
            this.end("PointSymbolizer");
        }

        public void visit(Halo halo) {
            this.start("Halo");
            if (halo.getRadius() != null) {
                this.start("Radius");
                this.filterTranslator.encode(halo.getRadius());
                this.end("Radius");
            }
            if (halo.getFill() != null) {
                halo.getFill().accept((StyleVisitor)this);
            }
            this.end("Halo");
        }

        public void visit(Graphic gr) {
            this.start("Graphic");
            this.encodeGeometryProperty(gr.getGeometryPropertyName());
            Symbol[] symbols = gr.getSymbols();
            for (int i = 0; i < symbols.length; ++i) {
                symbols[i].accept((StyleVisitor)this);
            }
            this.element("Opacity", gr.getOpacity());
            this.element("Size", gr.getSize());
            this.element("Rotation", gr.getRotation());
            this.end("Graphic");
        }

        public void visit(StyledLayerDescriptor sld) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "version", "version", "", "1.0.0");
            this.start("StyledLayerDescriptor", atts);
            if (sld.getName() != null && sld.getName().length() > 0) {
                this.element("Name", sld.getName());
            }
            if (sld.getTitle() != null && sld.getTitle().length() > 0) {
                this.element("Title", sld.getTitle());
            }
            if (sld.getAbstract() != null && sld.getAbstract().length() > 0) {
                this.element("Abstract", sld.getAbstract());
            }
            StyledLayer[] layers = sld.getStyledLayers();
            for (int i = 0; i < layers.length; ++i) {
                if (layers[i] instanceof NamedLayer) {
                    this.visit((NamedLayer)layers[i]);
                    continue;
                }
                if (layers[i] instanceof UserLayer) {
                    this.visit((UserLayer)layers[i]);
                    continue;
                }
                throw new IllegalArgumentException("StyledLayer '" + layers[i].getClass().toString() + "' not found");
            }
            this.end("StyledLayerDescriptor");
        }

        public void visit(NamedLayer layer) {
            this.start("NamedLayer");
            this.element("Name", layer.getName());
            FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
            if (lfc != null && lfc.length > 0) {
                this.start("LayerFeatureConstraints");
                for (int i = 0; i < lfc.length; ++i) {
                    this.visit(lfc[i]);
                }
                this.end("LayerFeatureConstraints");
            }
            Style[] styles = layer.getStyles();
            for (int i = 0; i < styles.length; ++i) {
                this.visit(styles[i]);
            }
            this.end("NamedLayer");
        }

        public void visit(UserLayer layer) {
            this.start("UserLayer");
            if (layer.getName() != null && layer.getName().length() > 0) {
                this.element("Name", layer.getName());
            }
            if (layer.getRemoteOWS() != null) {
                this.visit(layer.getRemoteOWS());
            }
            this.start("LayerFeatureConstraints");
            FeatureTypeConstraint[] lfc = layer.getLayerFeatureConstraints();
            if (lfc != null && lfc.length > 0) {
                for (int i = 0; i < lfc.length; ++i) {
                    this.visit(lfc[i]);
                }
            } else {
                this.start("FeatureTypeConstraint");
                this.end("FeatureTypeConstraint");
            }
            this.end("LayerFeatureConstraints");
            Style[] styles = layer.getUserStyles();
            for (int i = 0; i < styles.length; ++i) {
                this.visit(styles[i]);
            }
            this.end("UserLayer");
        }

        public void visit(RemoteOWS remoteOWS) {
            this.start("RemoteOWS");
            this.element("Service", remoteOWS.getService());
            this.element("OnlineResource", remoteOWS.getOnlineResource());
            this.end("RemoteOWS");
        }

        public void visit(FeatureTypeConstraint ftc) {
            this.start("FeatureTypeConstraint");
            if (ftc != null) {
                this.element("FeatureTypeName", ftc.getFeatureTypeName());
                this.visit(ftc.getFilter());
                Extent[] extent = ftc.getExtents();
                for (int i = 0; i < extent.length; ++i) {
                    this.visit(extent[i]);
                }
            }
            this.end("FeatureTypeConstraint");
        }

        public void visit(Extent extent) {
            this.start("Extent");
            this.element("Name", extent.getName());
            this.element("Value", extent.getValue());
            this.end("Extent");
        }

        public void visit(Filter filter) {
        }

        public void visit(Style style) {
            this.start("UserStyle");
            this.element("Name", style.getName());
            this.element("Title", style.getTitle());
            this.element("Abstract", style.getAbstract());
            FeatureTypeStyle[] fts = style.getFeatureTypeStyles();
            for (int i = 0; i < fts.length; ++i) {
                this.visit(fts[i]);
            }
            this.end("UserStyle");
        }

        public void visit(FeatureTypeStyle fts) {
            this.start("FeatureTypeStyle");
            if (fts.getName() != null && fts.getName().length() > 0) {
                this.element("Name", fts.getName());
            }
            if (fts.getTitle() != null && fts.getTitle().length() > 0) {
                this.element("Title", fts.getTitle());
            }
            if (fts.getAbstract() != null && fts.getAbstract().length() > 0) {
                this.element("Abstract", fts.getAbstract());
            }
            if (fts.getFeatureTypeName() != null && fts.getFeatureTypeName().length() > 0) {
                this.element("FeatureTypeName", fts.getFeatureTypeName());
            }
            String[] sti = fts.getSemanticTypeIdentifiers();
            for (int i = 0; i < sti.length; ++i) {
                this.element("SemanticTypeIdentifier", sti[i]);
            }
            Rule[] rules = fts.getRules();
            for (int i = 0; i < rules.length; ++i) {
                rules[i].accept((StyleVisitor)this);
            }
            this.end("FeatureTypeStyle");
        }

        public void visit(Displacement dis) {
            this.start("Displacement");
            this.element("DisplacementX", dis.getDisplacementX());
            this.element("DisplacementY", dis.getDisplacementY());
            this.end("Displacement");
        }

        void encodeGeometryProperty(String name) {
            if (name == null || name.trim().length() == 0) {
                return;
            }
            this.start("Geometry");
            this.element("PropertyName", name);
            this.end("Geometry");
        }

        void encodeCssParam(String name, Expression expression) {
            if (expression == null) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name);
            this.start("CssParameter", atts);
            this.filterTranslator.encode(expression);
            this.end("CssParameter");
        }

        void encodeCssParam(String name, String expression) {
            if (expression.length() == 0) {
                return;
            }
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", name);
            this.start("CssParameter", atts);
            this.chars(expression);
            this.end("CssParameter");
        }

        void encodeVendorOptions(Map options) {
            if (options != null) {
                Iterator it = options.keySet().iterator();
                while (it.hasNext()) {
                    String key = (String)it.next();
                    String value = (String)options.get(key);
                    this.encodeVendorOption(key, value);
                }
            }
        }

        void encodeVendorOption(String key, String value) {
            AttributesImpl atts = new AttributesImpl();
            atts.addAttribute("", "name", "name", "", key);
            this.start("VendorOption", atts);
            this.chars(value);
            this.end("VendorOption");
        }

        public void encode(Style[] styles) {
            try {
                this.contentHandler.startDocument();
                this.start("StyledLayerDescriptor", this.NULL_ATTS);
                this.start("NamedLayer", this.NULL_ATTS);
                int ii = styles.length;
                for (int i = 0; i < ii; ++i) {
                    styles[i].accept((StyleVisitor)this);
                }
                this.end("NamedLayer");
                this.end("StyledLayerDescriptor");
                this.contentHandler.endDocument();
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void encode(StyledLayerDescriptor sld) {
            try {
                this.contentHandler.startDocument();
                sld.accept((StyleVisitor)this);
                this.contentHandler.endDocument();
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        public void encode(Object o) throws IllegalArgumentException {
            if (o instanceof StyledLayerDescriptor) {
                this.encode((StyledLayerDescriptor)o);
            } else if (o instanceof Style[]) {
                this.encode((Style[])o);
            } else {
                Class<?> c = o.getClass();
                try {
                    Method m = c.getMethod("accept", class$org$geotools$styling$StyleVisitor == null ? (class$org$geotools$styling$StyleVisitor = SLDTransformer.class$("org.geotools.styling.StyleVisitor")) : class$org$geotools$styling$StyleVisitor);
                    m.invoke(o, this);
                }
                catch (NoSuchMethodException nsme) {
                    throw new IllegalArgumentException("Cannot encode " + o);
                }
                catch (Exception e) {
                    throw new RuntimeException("Internal transformation exception", e);
                }
            }
        }
    }
}

