/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.util.CommonHandler;
import org.geotools.util.MonolineFormatter;

public final class Logging {
    public static final Logging GEOTOOLS = new Logging("org.geotools");
    public static final Logging ALL = new Logging("");
    private final String root;
    private boolean redirected;

    public Logging(String root) {
        this.root = root;
    }

    public void forceMonolineConsoleOutput() throws IllegalStateException {
        this.forceMonolineConsoleOutput(null);
    }

    public synchronized void forceMonolineConsoleOutput(Level level) throws IllegalStateException {
        if (this.redirected) {
            throw new IllegalStateException();
        }
        MonolineFormatter f = MonolineFormatter.init((String)this.root, (Level)level);
        if (f.getSourceFormat() == null) {
            f.setSourceFormat("class:long");
        }
    }

    public synchronized boolean redirectToCommonsLogging() {
        try {
            if (CommonHandler.install(this.root)) {
                this.redirected = true;
                return true;
            }
        }
        catch (NoClassDefFoundError error) {
            Logging.unexpectedException("org.geotools.util", Logging.class, "redirectToCommonsLogging", (Throwable)error);
        }
        return false;
    }

    public static boolean unexpectedException(Logger logger, Throwable error) {
        if (logger.isLoggable(Level.WARNING)) {
            Logging.unexpectedException(logger.getName(), (String)null, null, error);
            return true;
        }
        return false;
    }

    public static void unexpectedException(String paquet, Class classe, String method, Throwable error) {
        Logging.unexpectedException(paquet, classe != null ? classe.getName() : (String)null, method, error);
    }

    public static void unexpectedException(String paquet, String classe, String method, Throwable error) {
        LogRecord record = Utilities.getLogRecord((Throwable)error);
        if (paquet == null || classe == null || method == null) {
            StackTraceElement[] elements = error.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                int lg;
                StackTraceElement e = elements[i];
                String c = e.getClassName();
                if (paquet != null) {
                    if (!c.startsWith(paquet)) continue;
                    lg = paquet.length();
                    if (c.length() > lg && Character.isJavaIdentifierPart(c.charAt(lg))) continue;
                }
                if (classe != null) {
                    if (!c.endsWith(classe)) continue;
                    lg = c.length() - classe.length() - 1;
                    if (c.length() >= 0 && Character.isJavaIdentifierPart(c.charAt(lg))) continue;
                }
                String m = e.getMethodName();
                if (method != null && !m.equals(method)) continue;
                int separator = c.lastIndexOf(46);
                if (paquet == null) {
                    String string = paquet = separator >= 1 ? c.substring(0, separator - 1) : "";
                }
                if (classe == null) {
                    classe = c.substring(separator + 1);
                }
                if (method != null) break;
                method = m;
                break;
            }
        }
        record.setSourceClassName(classe);
        record.setSourceMethodName(method);
        record.setThrown(error);
        Logger.getLogger(paquet).log(record);
    }
}

