/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.OperationNotSupportedException;
import org.geotools.xml.PrintHandler;
import org.geotools.xml.SchemaFactory;
import org.geotools.xml.XSISAXHandler;
import org.geotools.xml.handlers.xsi.AttributeHandler;
import org.geotools.xml.handlers.xsi.ComplexTypeHandler;
import org.geotools.xml.schema.All;
import org.geotools.xml.schema.Any;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.Choice;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.ElementGrouping;
import org.geotools.xml.schema.Facet;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.Sequence;
import org.geotools.xml.schema.SimpleType;
import org.geotools.xml.schema.Type;
import org.geotools.xml.xsi.XSISimpleTypes;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class DocumentWriter {
    public static final Logger logger = Logger.getLogger("net.refractions.xml.write");
    private static Level level = Level.WARNING;
    public static final String WRITE_SCHEMA = "DocumentWriter_WRITE_SCHEMA";
    public static final String BASE_ELEMENT = "DocumentWriter_BASE_ELEMENT";
    public static final String SCHEMA_ORDER = "DocumentWriter_SCHEMA_ORDER";
    public static final String USE_NEAREST = "DocumentWriter_USE_NEAREST";
    public static final String SCHEMA_LOCATION_HINT = "DocumentWriter_SCHEMA_LOCATION_HINT";

    public static void setLevel(Level l) {
        level = l;
        logger.setLevel(l);
    }

    public static void writeDocument(Object value, Schema schema, File f, Map hints) throws OperationNotSupportedException, IOException {
        if (f == null || !f.canWrite()) {
            throw new IOException("Cannot write to " + f);
        }
        if (hints != null && hints.containsKey(WRITE_SCHEMA)) {
            HashMap hints2 = new HashMap(hints);
            hints2.remove(WRITE_SCHEMA);
            File f2 = new File(f.getParentFile(), f.getName().substring(0, f.getName().indexOf(".")) + ".xsd");
            FileWriter wf = new FileWriter(f2);
            DocumentWriter.writeSchema(schema, wf, hints2);
            wf.close();
        }
        FileWriter wf = new FileWriter(f);
        DocumentWriter.writeDocument(value, schema, wf, hints);
        wf.close();
    }

    public static void writeDocument(Object value, Schema schema, Writer w, Map hints) throws OperationNotSupportedException, IOException {
        if (hints != null && hints.containsKey(WRITE_SCHEMA)) {
            Writer w2 = (Writer)hints.get(WRITE_SCHEMA);
            DocumentWriter.writeSchema(schema, w2, hints);
        }
        WriterContentHandler wch = new WriterContentHandler(schema, w, hints);
        wch.startDocument();
        DocumentWriter.writeFragment(value, wch);
        wch.endDocument();
        w.flush();
    }

    public static void writeFragment(Object value, Schema schema, File f, Map hints) throws OperationNotSupportedException, IOException {
        if (f == null || !f.canWrite()) {
            throw new IOException("Cannot write to " + f);
        }
        FileWriter wf = new FileWriter(f);
        DocumentWriter.writeFragment(value, schema, wf, hints);
        wf.close();
    }

    public static void writeFragment(Object value, Schema schema, Writer w, Map hints) throws OperationNotSupportedException, IOException {
        WriterContentHandler wch = new WriterContentHandler(schema, w, hints);
        DocumentWriter.writeFragment(value, wch);
        w.flush();
    }

    private static void writeFragment(Object value, WriterContentHandler wch) throws OperationNotSupportedException, IOException {
        Element e = null;
        logger.setLevel(level);
        if (wch.hints != null && wch.hints.containsKey(BASE_ELEMENT) && (e = (Element)wch.hints.get(BASE_ELEMENT)) != null && e.getType() != null) {
            Element element = e = e.getType().canEncode(e, value, wch.hints) ? e : null;
        }
        if (e == null) {
            e = wch.findElement(value);
        }
        if (e == null) {
            throw new OperationNotSupportedException("Could not find an appropriate Element to use for encoding of a " + (value == null ? null : value.getClass().getName()));
        }
        Type type = e.getType();
        type.encode(e, value, wch, wch.hints);
    }

    public static void writeSchema(Schema schema, Writer w, Map hints) throws IOException {
        WriterContentHandler wch = new WriterContentHandler(schema, w, hints);
        Element[] elems = schema.getElements();
        if (elems == null) {
            throw new IOException("Cannot write for Schema " + schema.getTargetNamespace());
        }
        wch.startDocument();
        DocumentWriter.writeSchema(schema, wch, hints);
        wch.endDocument();
    }

    private static void writeSchema(Schema schema, PrintHandler ph, Map hints) throws IOException {
        int i;
        if (schema == null) {
            return;
        }
        AttributesImpl ai = new AttributesImpl();
        ai.addAttribute("", "targetNamespace", "", "anyUri", schema.getTargetNamespace().toString());
        ai.addAttribute("", "xmlns", "", "anyUri", XSISimpleTypes.NAMESPACE.toString());
        ai.addAttribute("", "xmlns:" + schema.getPrefix(), "", "anyUri", schema.getTargetNamespace().toString());
        Schema[] imports = schema.getImports();
        for (i = 0; i < imports.length; ++i) {
            ai.addAttribute("", "xmlns:" + imports[i].getPrefix(), "", "anyUri", imports[i].getTargetNamespace().toString());
        }
        if (schema.getId() != null && schema.getId() != "") {
            ai.addAttribute("", "id", "", "ID", schema.getId());
        }
        if (schema.getVersion() != null && schema.getVersion() != "") {
            ai.addAttribute("", "version", "", "String", schema.getVersion());
        }
        if (schema.isAttributeFormDefault()) {
            ai.addAttribute("", "attributeFormDefault", "", "NMTOKEN", "qualified");
        }
        if (schema.isElementFormDefault()) {
            ai.addAttribute("", "elementFormDefault", "", "NMTOKEN", "qualified");
        }
        if (schema.getBlockDefault() != 0) {
            ai.addAttribute("", "blockDefault", "", "NMTOKENS", ComplexTypeHandler.writeBlock(schema.getBlockDefault()));
        }
        if (schema.getFinalDefault() != 0) {
            ai.addAttribute("", "finalDefault", "", "NMTOKENS", ComplexTypeHandler.writeFinal(schema.getFinalDefault()));
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "schema", ai);
        for (i = 0; i < imports.length; ++i) {
            DocumentWriter.writeImport(imports[i], ph);
        }
        Element[] elems = schema.getElements();
        if (elems != null) {
            for (int i2 = 0; i2 < elems.length; ++i2) {
                DocumentWriter.writeElement(elems[i2], schema, ph, hints);
            }
        }
        ComplexType[] cts = schema.getComplexTypes();
        if (elems != null) {
            for (int i3 = 0; i3 < cts.length; ++i3) {
                DocumentWriter.writeComplexType(cts[i3], schema, ph, hints);
            }
        }
        SimpleType[] sts = schema.getSimpleTypes();
        if (elems != null) {
            for (int i4 = 0; i4 < sts.length; ++i4) {
                DocumentWriter.writeSimpleType(sts[i4], schema, ph, hints);
            }
        }
        Group[] groups = schema.getGroups();
        if (elems != null) {
            for (int i5 = 0; i5 < groups.length; ++i5) {
                DocumentWriter.writeGroup(groups[i5], schema, ph, hints);
            }
        }
        Attribute[] attrs = schema.getAttributes();
        if (elems != null) {
            for (int i6 = 0; i6 < attrs.length; ++i6) {
                DocumentWriter.writeAttribute(attrs[i6], schema, ph, hints);
            }
        }
        AttributeGroup[] attrgrps = schema.getAttributeGroups();
        if (elems != null) {
            for (int i7 = 0; i7 < attrgrps.length; ++i7) {
                DocumentWriter.writeAttributeGroup(attrgrps[i7], schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "schema");
    }

    private static void writeImport(Schema schema, PrintHandler ph) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (schema.getId() != null && schema.getId() != "") {
            ai.addAttribute("", "id", "", "ID", schema.getId());
        }
        ai.addAttribute("", "namespace", "", "anyUri", schema.getTargetNamespace().toString());
        if (schema.getURI() != null) {
            ai.addAttribute("", "schemaLocation", "", "anyUri", schema.getURI().toString());
        }
        ph.element(XSISimpleTypes.NAMESPACE, "import", ai);
    }

    private static void writeElement(Element element, Schema schema, PrintHandler ph, Map hints) throws IOException {
        Object s;
        AttributesImpl ai = new AttributesImpl();
        if (element.getId() != null && element.getId() != "") {
            ai.addAttribute("", "id", "", "ID", element.getId());
        }
        if (element.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", element.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + element.getMaxOccurs());
        }
        if (element.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + element.getMinOccurs());
        }
        boolean nested = false;
        if (element.getNamespace().equals(schema.getTargetNamespace())) {
            Element[] elems = schema.getElements();
            boolean found = false;
            for (int i = 0; i < elems.length && !found; ++i) {
                if (!element.getName().equals(elems[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", element.getName());
            }
            if (!found) {
                int i;
                if (!element.getType().getNamespace().equals(schema.getTargetNamespace())) {
                    found = true;
                    XSISAXHandler.setLogLevel(logger.getLevel());
                    Schema s2 = SchemaFactory.getInstance(element.getNamespace());
                    if (element.getName() != null && element.getName() != "") {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", s2.getPrefix() + ":" + element.getType().getName());
                }
                Type[] types = schema.getComplexTypes();
                for (i = 0; i < types.length && !found; ++i) {
                    if (!element.getType().getName().equals(types[i].getName())) continue;
                    found = true;
                    if (element.getName() != null && element.getName() != "") {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", element.getType().getName());
                }
                types = schema.getSimpleTypes();
                for (i = 0; i < types.length && !found; ++i) {
                    if (!element.getType().getName().equals(types[i].getName())) continue;
                    found = true;
                    if (element.getName() != null && element.getName() != "") {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", element.getType().getName());
                }
                if (!found) {
                    nested = true;
                    if (element.getName() != null && element.getName() != "") {
                        ai.addAttribute("", "name", "", "QName", element.getName());
                    }
                }
            }
        } else {
            s = SchemaFactory.getInstance(element.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + element.getName());
        }
        if (element.isNillable()) {
            ai.addAttribute("", "nillable", "", "boolean", "true");
        }
        if (element.getDefault() != null && element.getDefault() != "") {
            ai.addAttribute("", "default", "", "String", element.getDefault());
        } else if (element.getFixed() != null && element.getFixed() != "") {
            ai.addAttribute("", "fixed", "", "String", element.getFixed());
        }
        if (element.getSubstitutionGroup() != null) {
            s = "";
            if (!element.getSubstitutionGroup().getNamespace().equals(schema.getTargetNamespace())) {
                Schema sss = SchemaFactory.getInstance(element.getSubstitutionGroup().getNamespace());
                s = sss.getPrefix() + ":";
            }
            s = (String)s + element.getSubstitutionGroup().getName();
            ai.addAttribute("", "substitutionGroup", "", "QName", (String)s);
        }
        if (element.isForm()) {
            ai.addAttribute("", "form", "", "NMTOKEN", "qualified");
        }
        if (element.getFinal() != 0) {
            ai.addAttribute("", "final", "", "NMTOKENS", ComplexTypeHandler.writeFinal(element.getFinal()));
        }
        if (element.getBlock() != 0) {
            ai.addAttribute("", "block", "", "NMTOKENS", ComplexTypeHandler.writeBlock(element.getBlock()));
        }
        if (element.isAbstract()) {
            ai.addAttribute("", "abstract", "", "boolean", "true");
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "element", ai);
        if (nested) {
            if (element.getType() instanceof ComplexType) {
                DocumentWriter.writeComplexType((ComplexType)element.getType(), schema, ph, hints);
            } else {
                DocumentWriter.writeSimpleType((SimpleType)element.getType(), schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "element");
    }

    private static void writeAttribute(Attribute attribute, Schema schema, PrintHandler ph, Map hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (attribute.getId() != null && attribute.getId() != "") {
            ai.addAttribute("", "id", "", "ID", attribute.getId());
        }
        boolean nested = false;
        if (attribute.getNamespace().equals(schema.getTargetNamespace())) {
            Attribute[] elems = schema.getAttributes();
            boolean found = false;
            for (int i = 0; i < elems.length && !found; ++i) {
                if (!attribute.getName().equals(elems[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", attribute.getName());
            }
            if (!found) {
                if (!attribute.getSimpleType().getNamespace().equals(schema.getTargetNamespace())) {
                    found = true;
                    XSISAXHandler.setLogLevel(logger.getLevel());
                    Schema s = SchemaFactory.getInstance(attribute.getNamespace());
                    if (attribute.getName() != null && attribute.getName() != "") {
                        ai.addAttribute("", "name", "", "QName", attribute.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", s.getPrefix() + ":" + attribute.getSimpleType().getName());
                }
                SimpleType[] types = schema.getSimpleTypes();
                for (int i = 0; i < types.length && !found; ++i) {
                    if (!attribute.getSimpleType().getName().equals(types[i].getName())) continue;
                    found = true;
                    if (attribute.getName() != null && attribute.getName() != "") {
                        ai.addAttribute("", "name", "", "QName", attribute.getName());
                    }
                    ai.addAttribute("", "type", "", "QName", attribute.getSimpleType().getName());
                }
                if (!found) {
                    nested = true;
                    if (attribute.getName() != null && attribute.getName() != "") {
                        ai.addAttribute("", "name", "", "QName", attribute.getName());
                    }
                }
            }
        } else {
            Schema s = SchemaFactory.getInstance(attribute.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + attribute.getName());
        }
        if (attribute.getUse() != 0) {
            ai.addAttribute("", "use", "", "NMTOKEN", AttributeHandler.writeUse(attribute.getUse()));
        }
        if (attribute.getDefault() != null && attribute.getDefault() != "") {
            ai.addAttribute("", "default", "", "String", attribute.getDefault());
        } else if (attribute.getFixed() != null && attribute.getFixed() != "") {
            ai.addAttribute("", "fixed", "", "String", attribute.getFixed());
        }
        if (attribute.isForm()) {
            ai.addAttribute("", "form", "", "NMTOKEN", "qualified");
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "attribute", ai);
        if (nested) {
            DocumentWriter.writeSimpleType(attribute.getSimpleType(), schema, ph, hints);
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "attribute");
    }

    private static void writeGroup(Group group, Schema schema, PrintHandler ph, Map hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (group.getId() != null && group.getId() != "") {
            ai.addAttribute("", "id", "", "ID", group.getId());
        }
        boolean nested = false;
        if (group.getNamespace().equals(schema.getTargetNamespace())) {
            Group[] groups = schema.getGroups();
            boolean found = false;
            for (int i = 0; i < groups.length && !found; ++i) {
                if (!group.getName().equals(groups[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", group.getName());
            }
            if (!found) {
                ai.addAttribute("", "name", "", "QName", group.getName());
                nested = true;
            }
        } else {
            XSISAXHandler.setLogLevel(logger.getLevel());
            Schema s = SchemaFactory.getInstance(group.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + group.getName());
        }
        if (group.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", group.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + group.getMaxOccurs());
        }
        if (group.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + group.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "group", ai);
        if (nested) {
            if (group.getChild().getGrouping() == 16) {
                DocumentWriter.writeChoice((Choice)group.getChild(), schema, ph, hints);
            } else {
                DocumentWriter.writeSequence((Sequence)group.getChild(), schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "group");
    }

    private static void writeAttributeGroup(AttributeGroup attributeGroup, Schema schema, PrintHandler ph, Map hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (attributeGroup.getId() != null && attributeGroup.getId() != "") {
            ai.addAttribute("", "id", "", "ID", attributeGroup.getId());
        }
        boolean nested = false;
        if (attributeGroup.getNamespace().equals(schema.getTargetNamespace())) {
            Group[] groups = schema.getGroups();
            boolean found = false;
            for (int i = 0; i < groups.length && !found; ++i) {
                if (!attributeGroup.getName().equals(groups[i].getName())) continue;
                found = true;
                ai.addAttribute("", "ref", "", "QName", attributeGroup.getName());
            }
            if (!found) {
                ai.addAttribute("", "name", "", "QName", attributeGroup.getName());
                nested = true;
            }
        } else {
            XSISAXHandler.setLogLevel(logger.getLevel());
            Schema s = SchemaFactory.getInstance(attributeGroup.getNamespace());
            ai.addAttribute("", "ref", "", "QName", s.getPrefix() + ":" + attributeGroup.getName());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "group", ai);
        if (nested) {
            if (attributeGroup.getAnyAttributeNameSpace() != null) {
                ai = new AttributesImpl();
                ai.addAttribute("", "namespace", "", "special", attributeGroup.getAnyAttributeNameSpace());
                ph.element(XSISimpleTypes.NAMESPACE, "anyAttribute", ai);
            }
            if (attributeGroup.getAttributes() != null) {
                Attribute[] attrs = attributeGroup.getAttributes();
                for (int i = 0; i < attrs.length; ++i) {
                    DocumentWriter.writeAttribute(attrs[i], schema, ph, hints);
                }
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "group");
    }

    private static void writeSimpleType(SimpleType simpleType, Schema schema, PrintHandler ph, Map hints) throws IOException {
        if (XSISimpleTypes.NAMESPACE.equals(simpleType.getNamespace())) {
            // empty if block
        }
        AttributesImpl ai = new AttributesImpl();
        if (simpleType.getId() != null && simpleType.getId() != "") {
            ai.addAttribute("", "id", "", "ID", simpleType.getId());
        }
        if (simpleType.getName() != null && simpleType.getName() != "") {
            ai.addAttribute("", "name", "", "NCName", simpleType.getName());
        }
        if (simpleType.getFinal() != 0) {
            ai.addAttribute("", "final", "", "NMTOKENS", ComplexTypeHandler.writeFinal(simpleType.getFinal()));
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "simpleType", ai);
        switch (simpleType.getChildType()) {
            case 4: {
                Facet[] facets;
                int i;
                SimpleType st = simpleType.getParents()[0];
                ai = null;
                if (schema.getTargetNamespace().equals(st.getNamespace())) {
                    SimpleType[] sts;
                    if (st.getName() != null && st.getName() != "" && (sts = schema.getSimpleTypes()) != null) {
                        for (i = 0; i < sts.length; ++i) {
                            if (!st.getName().equals(sts[i].getName())) continue;
                            ai = new AttributesImpl();
                            ai.addAttribute("", "base", "", "QName", st.getName());
                        }
                    }
                } else {
                    ai = new AttributesImpl();
                    XSISAXHandler.setLogLevel(logger.getLevel());
                    Schema s = SchemaFactory.getInstance(st.getNamespace());
                    ai.addAttribute("", "base", "", "QName", s.getPrefix() + ":" + st.getName());
                }
                ph.startElement(XSISimpleTypes.NAMESPACE, "restriction", ai);
                if (ai == null) {
                    DocumentWriter.writeSimpleType(st, schema, ph, hints);
                }
                if ((facets = simpleType.getFacets()) != null) {
                    for (i = 0; i < facets.length; ++i) {
                        DocumentWriter.writeFacet(facets[i], ph);
                    }
                }
                ph.endElement(XSISimpleTypes.NAMESPACE, "restriction");
                break;
            }
            case 2: {
                SimpleType st = simpleType.getParents()[0];
                ai = null;
                if (schema.getTargetNamespace().equals(st.getNamespace())) {
                    SimpleType[] sts;
                    if (st.getName() != null && st.getName() != "" && (sts = schema.getSimpleTypes()) != null) {
                        for (int i = 0; i < sts.length; ++i) {
                            if (!st.getName().equals(sts[i].getName())) continue;
                            ai = new AttributesImpl();
                            ai.addAttribute("", "itemType", "", "QName", st.getName());
                        }
                    }
                } else {
                    ai = new AttributesImpl();
                    Schema s = SchemaFactory.getInstance(st.getNamespace());
                    ai.addAttribute("", "itemType", "", "QName", s.getPrefix() + ":" + st.getName());
                }
                ph.startElement(XSISimpleTypes.NAMESPACE, "list", ai);
                if (ai == null) {
                    DocumentWriter.writeSimpleType(st, schema, ph, hints);
                }
                ph.endElement(XSISimpleTypes.NAMESPACE, "list");
                break;
            }
            case 1: {
                SimpleType[] sts = simpleType.getParents();
                String memberTypes = null;
                LinkedList<SimpleType> childTs = new LinkedList<SimpleType>();
                if (sts != null) {
                    for (int j = 0; j < sts.length; ++j) {
                        SimpleType st = sts[j];
                        if (schema.getTargetNamespace().equals(st.getNamespace())) {
                            SimpleType[] sts2;
                            boolean found = false;
                            if (st.getName() != null && st.getName() != "" && (sts2 = schema.getSimpleTypes()) != null) {
                                for (int i = 0; i < sts2.length; ++i) {
                                    if (!st.getName().equals(sts2[i].getName())) continue;
                                    found = true;
                                    memberTypes = memberTypes == null ? st.getName() : memberTypes + " " + st.getName();
                                }
                            }
                            if (found) continue;
                            childTs.add(st);
                            continue;
                        }
                        ai = new AttributesImpl();
                        Schema s = SchemaFactory.getInstance(st.getNamespace());
                        memberTypes = memberTypes == null ? s.getPrefix() + ":" + st.getName() : memberTypes + " " + s.getPrefix() + ":" + st.getName();
                    }
                }
                if (memberTypes != null) {
                    ai = new AttributesImpl();
                    ai.addAttribute("", "memberTypes", "", "QName", memberTypes);
                }
                ph.startElement(XSISimpleTypes.NAMESPACE, "union", ai);
                if (childTs.size() > 0) {
                    Iterator i = childTs.iterator();
                    while (i.hasNext()) {
                        DocumentWriter.writeSimpleType((SimpleType)i.next(), schema, ph, hints);
                    }
                }
                ph.endElement(XSISimpleTypes.NAMESPACE, "union");
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "simpleType");
    }

    private static void writeChoice(Choice choice, Schema schema, PrintHandler ph, Map hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (choice.getId() != null && choice.getId() != "") {
            ai.addAttribute("", "id", "", "ID", choice.getId());
        }
        if (choice.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", choice.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + choice.getMaxOccurs());
        }
        if (choice.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + choice.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "choice", ai);
        ElementGrouping[] egs = choice.getChildren();
        if (egs != null) {
            block8: for (int i = 0; i < egs.length; ++i) {
                if (egs[i] == null) continue;
                switch (egs[i].getGrouping()) {
                    case 32: {
                        DocumentWriter.writeAll((All)egs[i], schema, ph, hints);
                        continue block8;
                    }
                    case 4: {
                        DocumentWriter.writeAny((Any)egs[i], ph);
                        continue block8;
                    }
                    case 16: {
                        DocumentWriter.writeChoice((Choice)egs[i], schema, ph, hints);
                        continue block8;
                    }
                    case 1: {
                        DocumentWriter.writeElement((Element)egs[i], schema, ph, hints);
                        continue block8;
                    }
                    case 2: {
                        DocumentWriter.writeGroup((Group)egs[i], schema, ph, hints);
                        continue block8;
                    }
                    case 8: {
                        DocumentWriter.writeSequence((Sequence)egs[i], schema, ph, hints);
                    }
                }
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "choice");
    }

    private static void writeSequence(Sequence sequence, Schema schema, PrintHandler ph, Map hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (sequence.getId() != null && sequence.getId() != "") {
            ai.addAttribute("", "id", "", "ID", sequence.getId());
        }
        if (sequence.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", sequence.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + sequence.getMaxOccurs());
        }
        if (sequence.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + sequence.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "sequence", ai);
        ElementGrouping[] egs = sequence.getChildren();
        if (egs != null) {
            block7: for (int i = 0; i < egs.length; ++i) {
                if (egs[i] == null) continue;
                switch (egs[i].getGrouping()) {
                    case 4: {
                        DocumentWriter.writeAny((Any)egs[i], ph);
                        continue block7;
                    }
                    case 16: {
                        DocumentWriter.writeChoice((Choice)egs[i], schema, ph, hints);
                        continue block7;
                    }
                    case 1: {
                        DocumentWriter.writeElement((Element)egs[i], schema, ph, hints);
                        continue block7;
                    }
                    case 2: {
                        DocumentWriter.writeGroup((Group)egs[i], schema, ph, hints);
                        continue block7;
                    }
                    case 8: {
                        DocumentWriter.writeSequence((Sequence)egs[i], schema, ph, hints);
                    }
                }
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "sequence");
    }

    private static void writeAll(All all, Schema schema, PrintHandler ph, Map hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (all.getId() != null && all.getId() != "") {
            ai.addAttribute("", "id", "", "ID", all.getId());
        }
        if (all.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", all.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + all.getMaxOccurs());
        }
        if (all.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + all.getMinOccurs());
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "all", ai);
        Element[] egs = all.getElements();
        if (egs != null) {
            for (int i = 0; i < egs.length; ++i) {
                if (egs[i] == null) continue;
                DocumentWriter.writeElement(egs[i], schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "all");
    }

    private static void writeAny(Any any, PrintHandler ph) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (any.getId() != null && any.getId() != "") {
            ai.addAttribute("", "id", "", "ID", any.getId());
        }
        if (any.getMaxOccurs() != 1) {
            ai.addAttribute("", "maxOccurs", "", "Union", any.getMaxOccurs() == Integer.MAX_VALUE ? "unbounded" : "" + any.getMaxOccurs());
        }
        if (any.getMinOccurs() != 1) {
            ai.addAttribute("", "minOccurs", "", "ID", "" + any.getMinOccurs());
        }
        if (any.getNamespace() != null) {
            ai.addAttribute("", "namespace", "", "special", "" + any.getNamespace());
        }
        ph.element(XSISimpleTypes.NAMESPACE, "any", ai);
    }

    private static void writeComplexType(ComplexType complexType, Schema schema, PrintHandler ph, Map hints) throws IOException {
        AttributesImpl ai = new AttributesImpl();
        if (complexType.getId() != null && complexType.getId() != "") {
            ai.addAttribute("", "id", "", "ID", complexType.getId());
        }
        if (complexType.getName() != null && complexType.getName() != "") {
            ai.addAttribute("", "name", "", "NCName", complexType.getName());
        }
        if (complexType.isAbstract()) {
            ai.addAttribute("", "abstract", "", "boolean", "true");
        }
        if (complexType.getFinal() != 0) {
            ai.addAttribute("", "final", "", "NMTOKENS", ComplexTypeHandler.writeFinal(complexType.getFinal()));
        }
        if (complexType.getBlock() != 0) {
            ai.addAttribute("", "block", "", "NMTOKENS", ComplexTypeHandler.writeBlock(complexType.getBlock()));
        }
        if (complexType.isMixed()) {
            ai.addAttribute("", "mixed", "", "boolean", "true");
        }
        ph.startElement(XSISimpleTypes.NAMESPACE, "complexType", ai);
        ElementGrouping egs = complexType.getChild();
        complexType.getChild();
        if (egs != null) {
            switch (egs.getGrouping()) {
                case 32: {
                    DocumentWriter.writeAll((All)egs, schema, ph, hints);
                    break;
                }
                case 16: {
                    DocumentWriter.writeChoice((Choice)egs, schema, ph, hints);
                    break;
                }
                case 2: {
                    DocumentWriter.writeGroup((Group)egs, schema, ph, hints);
                    break;
                }
                case 8: {
                    DocumentWriter.writeSequence((Sequence)egs, schema, ph, hints);
                }
            }
        }
        if (complexType.getAnyAttributeNameSpace() != null) {
            ai = new AttributesImpl();
            ai.addAttribute("", "namespace", "", "special", complexType.getAnyAttributeNameSpace());
            ph.element(XSISimpleTypes.NAMESPACE, "anyAttribute", ai);
        }
        if (complexType.getAttributes() != null) {
            Attribute[] attrs = complexType.getAttributes();
            for (int i = 0; i < attrs.length; ++i) {
                DocumentWriter.writeAttribute(attrs[i], schema, ph, hints);
            }
        }
        ph.endElement(XSISimpleTypes.NAMESPACE, "complexType");
    }

    private static void writeFacet(Facet facet, PrintHandler ph) throws IOException {
        if (facet == null) {
            return;
        }
        AttributesImpl ai = new AttributesImpl();
        ai.addAttribute("", "value", "", "ID", facet.getValue());
        switch (facet.getFacetType()) {
            case 1: {
                ph.element(XSISimpleTypes.NAMESPACE, "enumeration", ai);
                break;
            }
            case 2: {
                ph.element(XSISimpleTypes.NAMESPACE, "fractionDigits", ai);
                break;
            }
            case 3: {
                ph.element(XSISimpleTypes.NAMESPACE, "length", ai);
                break;
            }
            case 4: {
                ph.element(XSISimpleTypes.NAMESPACE, "maxExclusive", ai);
                break;
            }
            case 5: {
                ph.element(XSISimpleTypes.NAMESPACE, "maxInclusive", ai);
                break;
            }
            case 6: {
                ph.element(XSISimpleTypes.NAMESPACE, "maxLength", ai);
                break;
            }
            case 7: {
                ph.element(XSISimpleTypes.NAMESPACE, "minExclusive", ai);
                break;
            }
            case 8: {
                ph.element(XSISimpleTypes.NAMESPACE, "minInclusive", ai);
                break;
            }
            case 9: {
                ph.element(XSISimpleTypes.NAMESPACE, "minLength", ai);
                break;
            }
            case 10: {
                ph.element(XSISimpleTypes.NAMESPACE, "pattern", ai);
                break;
            }
            case 11: {
                ph.element(XSISimpleTypes.NAMESPACE, "totalDigits", ai);
                break;
            }
            case 12: {
                ph.element(XSISimpleTypes.NAMESPACE, "whiteSpace", ai);
            }
        }
    }

    private static class WriterContentHandler
    implements PrintHandler {
        private boolean firstElement = true;
        private Writer writer;
        private Map prefixMappings;
        private Schema schema;
        protected Map hints;
        private Schema[] searchOrder = null;

        WriterContentHandler(Schema schema, Writer writer, Map hints) {
            this.writer = writer;
            this.schema = schema;
            this.hints = hints;
            this.prefixMappings = new HashMap();
            this.prefixMappings.put(schema.getTargetNamespace(), "");
            Schema[] imports = schema.getImports();
            if (imports != null) {
                for (int i = 0; i < imports.length; ++i) {
                    this.prefixMappings.put(imports[i].getTargetNamespace(), imports[i].getPrefix());
                }
            }
        }

        private void printXMLNSDecs(Map arg0) throws IOException {
            Schema[] imports = this.getSchemaOrdering();
            String s = "";
            Map schemaLocs = arg0 == null ? null : arg0.get(DocumentWriter.SCHEMA_LOCATION_HINT);
            schemaLocs = schemaLocs == null ? new HashMap() : schemaLocs;
            for (int i = 0; i < imports.length; ++i) {
                if (imports[i] == null) continue;
                if (imports[i] == this.schema) {
                    this.writer.write(" xmlns=\"" + this.schema.getTargetNamespace() + "\"");
                    if (this.schema.getURI() != null && !this.schema.getTargetNamespace().equals(this.schema.getURI())) {
                        String endResult = this.schema.getURI().toString();
                        endResult = endResult.replaceAll("&", "&amp;");
                        s = this.schema.getTargetNamespace() + " " + endResult;
                    }
                } else {
                    this.writer.write(" xmlns:" + imports[i].getPrefix() + "=\"" + imports[i].getTargetNamespace() + "\"");
                }
                URI location = imports[i].getURI();
                boolean forced = false;
                if (schemaLocs.containsKey(imports[i].getTargetNamespace())) {
                    location = (URI)schemaLocs.get(imports[i].getTargetNamespace());
                    forced = true;
                }
                if (location == null || !location.isAbsolute() || !imports[i].includesURI(location) && !forced || location == null || location.equals(imports[i].getTargetNamespace())) continue;
                String endResult = location.toString();
                endResult = endResult.replaceAll("&", "&amp;");
                s = s + " " + imports[i].getTargetNamespace() + " " + endResult;
            }
            if (!"".equals(s = s.trim())) {
                this.writer.write(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
                this.writer.write(" xsi:schemaLocation=\"" + s + "\"");
            }
        }

        public void startElement(URI namespaceURI, String localName, Attributes attributes) throws IOException {
            String prefix = (String)this.prefixMappings.get(namespaceURI);
            if (prefix != null) {
                if (!prefix.equals("")) {
                    prefix = prefix + ":";
                }
            } else if (namespaceURI.equals(this.schema.getTargetNamespace())) {
                prefix = "";
            } else {
                XSISAXHandler.setLogLevel(logger.getLevel());
                prefix = SchemaFactory.getInstance(namespaceURI).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if (prefix != "") {
                    prefix = prefix + ":";
                }
            }
            this.writer.write("<");
            this.writer.write(prefix + localName);
            if (this.firstElement) {
                this.printXMLNSDecs(this.hints);
                this.firstElement = false;
            }
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    this.writer.write(" ");
                    this.writer.write(name);
                    this.writer.write("=\"");
                    this.writer.write(value);
                    this.writer.write("\"");
                }
            }
            this.writer.write(">");
        }

        public void element(URI namespaceURI, String localName, Attributes attributes) throws IOException {
            String prefix = (String)this.prefixMappings.get(namespaceURI);
            if (prefix != null) {
                if (!prefix.equals("")) {
                    prefix = prefix + ":";
                }
            } else if (namespaceURI.equals(this.schema.getTargetNamespace())) {
                prefix = "";
            } else {
                XSISAXHandler.setLogLevel(logger.getLevel());
                prefix = SchemaFactory.getInstance(namespaceURI).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if (prefix != "") {
                    prefix = prefix + ":";
                }
            }
            this.writer.write("<");
            this.writer.write(prefix + localName);
            if (this.firstElement) {
                this.printXMLNSDecs(this.hints);
                this.firstElement = false;
            }
            if (attributes != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String name = attributes.getLocalName(i);
                    String value = attributes.getValue(i);
                    this.writer.write(" ");
                    this.writer.write(name);
                    this.writer.write("=\"");
                    this.writer.write(value);
                    this.writer.write("\"");
                }
            }
            this.writer.write("/>");
            this.writer.write("\n");
        }

        public void endElement(URI namespaceURI, String localName) throws IOException {
            String prefix = (String)this.prefixMappings.get(namespaceURI);
            if (prefix != null) {
                if (!prefix.equals("")) {
                    prefix = prefix + ":";
                }
            } else if (namespaceURI.equals(this.schema.getTargetNamespace())) {
                prefix = "";
            } else {
                XSISAXHandler.setLogLevel(logger.getLevel());
                prefix = SchemaFactory.getInstance(namespaceURI).getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                if (prefix != "") {
                    prefix = prefix + ":";
                }
            }
            this.writer.write("</");
            this.writer.write(prefix + localName);
            this.writer.write(">");
            this.writer.write("\n");
        }

        public void characters(char[] arg0, int arg1, int arg2) throws IOException {
            this.writer.write(arg0, arg1, arg2);
        }

        public void characters(String s) throws IOException {
            this.writer.write(s);
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws IOException {
            this.writer.write(arg0, arg1, arg2);
        }

        public void startDocument() throws IOException {
            this.writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            this.writer.write("\n");
        }

        public void endDocument() throws IOException {
            this.writer.write("\n");
            this.writer.flush();
        }

        public Schema getDocumentSchema() {
            return this.schema;
        }

        public Object getHint(Object key) {
            return this.hints.get(key);
        }

        public Element findElement(Object value) {
            Schema[] searchOrder1;
            try {
                searchOrder1 = this.getSchemaOrdering();
            }
            catch (IOException e) {
                logger.warning(e.toString());
                return null;
            }
            for (int i = 0; i < searchOrder1.length; ++i) {
                Element[] elems = searchOrder1[i].getElements();
                if (elems == null) continue;
                for (int j = 0; j < elems.length; ++j) {
                    if (elems[j].getType() == null || !elems[j].getType().canEncode(elems[j], value, this.hints)) continue;
                    return elems[j];
                }
            }
            return null;
        }

        public Element findElement(String name) {
            Schema[] searchOrder1;
            try {
                searchOrder1 = this.getSchemaOrdering();
            }
            catch (IOException e) {
                logger.warning(e.toString());
                return null;
            }
            for (int i = 0; i < searchOrder1.length; ++i) {
                Element[] elems = searchOrder1[i].getElements();
                if (elems == null) continue;
                for (int j = 0; j < elems.length; ++j) {
                    if (elems[j].getName() == null || !elems[j].getName().equals(name)) continue;
                    return elems[j];
                }
            }
            return null;
        }

        private Schema[] getSchemaOrdering() throws IOException {
            if (this.searchOrder != null) {
                return this.searchOrder;
            }
            if (!(this.hints != null && this.hints.get(DocumentWriter.SCHEMA_ORDER) != null || this.schema.getImports() != null && this.schema.getImports().length != 0)) {
                this.searchOrder = new Schema[]{this.schema};
            } else {
                LinkedList<Schema> so = new LinkedList<Schema>();
                if (this.hints != null && this.hints.containsKey(DocumentWriter.SCHEMA_ORDER)) {
                    int nsIndex;
                    int i;
                    Object order = this.hints.get(DocumentWriter.SCHEMA_ORDER);
                    LinkedList<URI> targNS = new LinkedList<URI>();
                    targNS.add(this.schema.getTargetNamespace());
                    if (this.schema.getImports() != null) {
                        for (int i2 = 0; i2 < this.schema.getImports().length; ++i2) {
                            if (targNS.contains(this.schema.getImports()[i2].getTargetNamespace())) continue;
                            targNS.add(this.schema.getImports()[i2].getTargetNamespace());
                        }
                    }
                    if (order instanceof Schema[]) {
                        Schema[] sOrder = (Schema[])order;
                        for (i = 0; i < sOrder.length; ++i) {
                            nsIndex = targNS.indexOf(sOrder[i].getTargetNamespace());
                            if (nsIndex < 0) continue;
                            so.add(sOrder[i]);
                            targNS.remove(nsIndex);
                        }
                    } else {
                        String[] stringOrder = (String[])order;
                        for (i = 0; i < stringOrder.length; ++i) {
                            nsIndex = targNS.indexOf(stringOrder[i]);
                            try {
                                URI uri;
                                if (nsIndex >= 0) {
                                    uri = new URI(stringOrder[i]);
                                    XSISAXHandler.setLogLevel(logger.getLevel());
                                    so.add(SchemaFactory.getInstance(uri));
                                    targNS.remove(nsIndex);
                                    continue;
                                }
                                uri = new URI(stringOrder[i]);
                                so.add(SchemaFactory.getInstance(uri));
                                continue;
                            }
                            catch (URISyntaxException e) {
                                logger.warning(e.toString());
                                IOException t = new IOException(e.toString());
                                t.initCause(e);
                                throw t;
                            }
                        }
                    }
                    if (!targNS.contains(this.schema.getTargetNamespace())) {
                        so.add(this.schema);
                    }
                    for (int i3 = 0; i3 < this.schema.getImports().length; ++i3) {
                        int nsIndex2 = targNS.indexOf(this.schema.getImports()[i3].getTargetNamespace());
                        if (nsIndex2 < 0) continue;
                        so.add(this.schema.getImports()[i3]);
                        targNS.remove(nsIndex2);
                    }
                } else if (this.hints != null && this.hints.containsKey(DocumentWriter.USE_NEAREST)) {
                    so.add(this.schema);
                    for (int i = 0; i < this.schema.getImports().length; ++i) {
                        so.add(this.schema.getImports()[i]);
                    }
                } else {
                    so.add(this.schema);
                    for (int i = 0; i < this.schema.getImports().length; ++i) {
                        so.add(this.schema.getImports()[i]);
                    }
                }
                this.searchOrder = so.toArray(new Schema[so.size()]);
            }
            return this.searchOrder;
        }
    }
}

