/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.geotools.factory.FactoryFinder;
import org.geotools.xml.XSISAXHandler;
import org.geotools.xml.schema.Attribute;
import org.geotools.xml.schema.AttributeGroup;
import org.geotools.xml.schema.ComplexType;
import org.geotools.xml.schema.Element;
import org.geotools.xml.schema.Group;
import org.geotools.xml.schema.Schema;
import org.geotools.xml.schema.SimpleType;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SchemaFactory {
    protected static SchemaFactory is = new SchemaFactory();
    private Map schemas = this.loadSchemas();
    private SAXParser parser;

    protected static SchemaFactory getInstance() {
        return is;
    }

    private Map loadSchemas() {
        this.schemas = new HashMap();
        ClassLoader[] cls = this.findLoaders();
        String serviceId = "META-INF/services/" + Schema.class.getName();
        for (int i = 0; i < cls.length; ++i) {
            try {
                Enumeration<URL> e = cls[i].getResources(serviceId);
                while (e.hasMoreElements()) {
                    URL res = e.nextElement();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(res.openStream(), "UTF-8"));
                    while (rd.ready()) {
                        String factoryClassName = rd.readLine().trim();
                        try {
                            Schema s = (Schema)cls[i].loadClass(factoryClassName).getDeclaredMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                            this.schemas.put(s.getTargetNamespace(), s);
                        }
                        catch (IllegalArgumentException e1) {
                            XSISAXHandler.logger.warning(e1.toString());
                        }
                        catch (SecurityException e1) {
                            XSISAXHandler.logger.warning(e1.toString());
                        }
                        catch (IllegalAccessException e1) {
                            XSISAXHandler.logger.warning(e1.toString());
                        }
                        catch (InvocationTargetException e1) {
                            XSISAXHandler.logger.warning(e1.toString());
                        }
                        catch (NoSuchMethodException e1) {
                            XSISAXHandler.logger.warning(e1.toString());
                        }
                        catch (ClassNotFoundException e1) {
                            XSISAXHandler.logger.warning(e1.toString());
                        }
                    }
                    rd.close();
                }
                continue;
            }
            catch (IOException e) {
                XSISAXHandler.logger.warning(e.toString());
            }
        }
        return this.schemas;
    }

    private ClassLoader[] findLoaders() {
        ClassLoader contextLoader = null;
        try {
            contextLoader = Thread.currentThread().getContextClassLoader();
        }
        catch (SecurityException se) {
            // empty catch block
        }
        ClassLoader systemLoader = FactoryFinder.class.getClassLoader();
        ClassLoader[] classLoaders = contextLoader == null || contextLoader == systemLoader ? new ClassLoader[]{systemLoader} : new ClassLoader[]{contextLoader, systemLoader};
        return classLoaders;
    }

    public static Schema getInstance(URI targetNamespace, URI desiredSchema) throws SAXException {
        return SchemaFactory.getInstance(targetNamespace, desiredSchema, Level.WARNING);
    }

    public static Schema getInstance(URI targetNamespace, InputStream is1) throws SAXException {
        return SchemaFactory.getInstance(targetNamespace, is1, Level.WARNING);
    }

    public static synchronized Schema getInstance(URI targetNamespace) {
        return SchemaFactory.getInstance().getRealInstance(targetNamespace);
    }

    public static synchronized Schema[] getSchemas(String prefix) {
        if (prefix == null) {
            return null;
        }
        SchemaFactory sf = SchemaFactory.getInstance();
        Iterator i = sf.schemas.values().iterator();
        LinkedList<Schema> l = new LinkedList<Schema>();
        while (i.hasNext()) {
            Schema s = (Schema)i.next();
            if (!prefix.equals(s.getPrefix())) continue;
            l.add(s);
        }
        return l.toArray(new Schema[l.size()]);
    }

    private synchronized Schema getRealInstance(URI targetNamespace) {
        Schema r = (Schema)this.schemas.get(targetNamespace);
        if (r != null) {
            return r;
        }
        return null;
    }

    public static synchronized Schema getInstance(URI targetNamespace, URI desiredSchema, Level level) throws SAXException {
        return SchemaFactory.getInstance().getRealInstance(targetNamespace, desiredSchema, level);
    }

    private synchronized Schema getRealInstance(URI targetNamespace2, URI desiredSchema, Level level) throws SAXException {
        URI targetNamespace = targetNamespace2;
        if (targetNamespace == null || this.schemas.get(targetNamespace) == null) {
            this.setParser();
            XSISAXHandler contentHandler = this.getSAXHandler(desiredSchema);
            XSISAXHandler.setLogLevel(level);
            try {
                this.parser.parse(desiredSchema.toString(), (DefaultHandler)contentHandler);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            Schema schema = contentHandler.getSchema();
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = schema.getTargetNamespace();
            }
            if (this.schemas.get(targetNamespace) != null) {
                schema = this.merge(schema, (Schema)this.schemas.get(targetNamespace));
            }
            this.schemas.put(targetNamespace, schema);
            return schema;
        }
        if (!((Schema)this.schemas.get(targetNamespace)).includesURI(desiredSchema)) {
            Schema sh = (Schema)this.schemas.get(targetNamespace);
            this.setParser();
            XSISAXHandler contentHandler = this.getSAXHandler(desiredSchema);
            XSISAXHandler.setLogLevel(level);
            try {
                this.parser.parse(desiredSchema.toString(), (DefaultHandler)contentHandler);
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
            sh = this.merge(sh, contentHandler.getSchema());
            this.schemas.put(targetNamespace, sh);
        }
        return (Schema)this.schemas.get(targetNamespace);
    }

    protected XSISAXHandler getSAXHandler(URI uri) {
        return new XSISAXHandler(uri);
    }

    public static synchronized Schema getInstance(URI targetNamespace, InputStream is1, Level level) throws SAXException {
        return SchemaFactory.getInstance().getRealInstance(targetNamespace, is1, level);
    }

    private synchronized Schema getRealInstance(URI targetNamespace2, InputStream is1, Level level) throws SAXException {
        URI targetNamespace = targetNamespace2;
        if (targetNamespace == null || this.schemas.get(targetNamespace) == null) {
            XSISAXHandler contentHandler = this.parseSchema(is1, level);
            if (targetNamespace == null || "".equals(targetNamespace)) {
                targetNamespace = contentHandler.getSchema().getTargetNamespace();
            }
            Schema schema = contentHandler.getSchema();
            if (this.schemas.get(targetNamespace) != null) {
                schema = this.merge(schema, (Schema)this.schemas.get(targetNamespace));
            }
            this.schemas.put(targetNamespace, schema);
        } else {
            Schema sh = (Schema)this.schemas.get(targetNamespace);
            XSISAXHandler contentHandler = this.parseSchema(is1, level);
            sh = this.merge(sh, contentHandler.getSchema());
            this.schemas.put(targetNamespace, sh);
        }
        return (Schema)this.schemas.get(targetNamespace);
    }

    private XSISAXHandler parseSchema(InputStream is1, Level level) throws SAXException {
        this.setParser();
        XSISAXHandler contentHandler = this.getSAXHandler(null);
        XSISAXHandler.setLogLevel(level);
        try {
            this.parser.parse(is1, (DefaultHandler)contentHandler);
        }
        catch (IOException e) {
            throw new SAXException(e);
        }
        return contentHandler;
    }

    private Schema merge(Schema s1, Schema s2) throws SAXException {
        return new MergedSchema(s1, s2);
    }

    public static void registerSchema(URI targetNamespace, Schema schema) {
        SchemaFactory.getInstance().registerRealSchema(targetNamespace, schema);
    }

    private void registerRealSchema(URI targetNamespace, Schema schema) {
        this.schemas.put(targetNamespace, schema);
    }

    private void setParser() throws SAXException {
        if (this.parser == null) {
            SAXParserFactory spf = SAXParserFactory.newInstance();
            spf.setNamespaceAware(true);
            spf.setValidating(false);
            try {
                this.parser = spf.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new SAXException(e);
            }
            catch (SAXException e) {
                throw new SAXException(e);
            }
        }
    }

    private static class MergedSchema
    implements Schema {
        private AttributeGroup[] attributeGroups;
        private Attribute[] attributes;
        private int block;
        private int finaL;
        private ComplexType[] complexTypes;
        private Element[] elements;
        private Group[] groups;
        private String id;
        private String version;
        private String prefix;
        private URI targetNamespace;
        private Schema[] imports;
        private SimpleType[] simpleTypes;
        private boolean aForm;
        private boolean eForm;
        private URI uri;

        public MergedSchema(Schema s1, Schema s2) throws SAXException {
            int i;
            Schema[] i2;
            int i3;
            Group[] g2;
            int i4;
            Element[] e2;
            int i5;
            SimpleType[] ss2;
            int i6;
            ComplexType[] c2;
            int i7;
            Attribute[] a2;
            int i8;
            AttributeGroup[] ag2;
            this.id = s1.getId() == null || s1.getId().equals("") ? s2.getId() : s1.getId();
            this.version = s1.getVersion() == null || s1.getVersion().equals("") ? s2.getVersion() : s1.getVersion();
            if (s1.getTargetNamespace() == null || s1.getTargetNamespace().equals("")) {
                this.targetNamespace = s2.getTargetNamespace();
            } else {
                if (s2.getTargetNamespace() != null && !s1.getTargetNamespace().equals(s2.getTargetNamespace())) {
                    throw new SAXException("cannot merge two target namespaces. " + s1.getTargetNamespace() + " " + s2.getTargetNamespace());
                }
                this.targetNamespace = s1.getTargetNamespace();
            }
            this.aForm = s1.isAttributeFormDefault() || s2.isAttributeFormDefault();
            this.eForm = s1.isElementFormDefault() || s2.isElementFormDefault();
            HashMap<Object, Object> m = new HashMap<Object, Object>();
            AttributeGroup[] ag1 = s1.getAttributeGroups();
            if (ag1 == null) {
                ag1 = new AttributeGroup[]{};
            }
            if ((ag2 = s2.getAttributeGroups()) == null) {
                ag2 = new AttributeGroup[]{};
            }
            for (i8 = 0; i8 < ag1.length; ++i8) {
                m.put(ag1[i8].getName(), ag1[i8]);
            }
            for (i8 = 0; i8 < ag2.length; ++i8) {
                if (m.containsKey(ag2[i8].getName())) continue;
                m.put(ag2[i8].getName(), ag2[i8]);
            }
            this.attributeGroups = new AttributeGroup[m.size()];
            Object[] obj = m.values().toArray();
            for (int i9 = 0; i9 < obj.length; ++i9) {
                this.attributeGroups[i9] = (AttributeGroup)obj[i9];
            }
            m = new HashMap();
            Attribute[] a1 = s1.getAttributes();
            if (a1 == null) {
                a1 = new Attribute[]{};
            }
            if ((a2 = s2.getAttributes()) == null) {
                a2 = new Attribute[]{};
            }
            for (i7 = 0; i7 < a1.length; ++i7) {
                m.put(a1[i7].getName(), a1[i7]);
            }
            for (i7 = 0; i7 < a2.length; ++i7) {
                if (m.containsKey(a2[i7].getName())) continue;
                m.put(a2[i7].getName(), a2[i7]);
            }
            this.attributes = new Attribute[m.size()];
            obj = m.values().toArray();
            for (i7 = 0; i7 < obj.length; ++i7) {
                this.attributes[i7] = (Attribute)obj[i7];
            }
            this.block = s1.getBlockDefault() | s2.getBlockDefault();
            this.finaL = s1.getFinalDefault() | s2.getFinalDefault();
            m = new HashMap();
            ComplexType[] c1 = s1.getComplexTypes();
            if (c1 == null) {
                c1 = new ComplexType[]{};
            }
            if ((c2 = s2.getComplexTypes()) == null) {
                c2 = new ComplexType[]{};
            }
            for (i6 = 0; i6 < c1.length; ++i6) {
                m.put(c1[i6].getName(), c1[i6]);
            }
            for (i6 = 0; i6 < c2.length; ++i6) {
                if (m.containsKey(c2[i6].getName())) continue;
                m.put(c2[i6].getName(), c2[i6]);
            }
            this.complexTypes = new ComplexType[m.size()];
            obj = m.values().toArray();
            for (i6 = 0; i6 < obj.length; ++i6) {
                this.complexTypes[i6] = (ComplexType)obj[i6];
            }
            m = new HashMap();
            SimpleType[] ss1 = s1.getSimpleTypes();
            if (ss1 == null) {
                ss1 = new SimpleType[]{};
            }
            if ((ss2 = s2.getSimpleTypes()) == null) {
                ss2 = new SimpleType[]{};
            }
            for (i5 = 0; i5 < ss1.length; ++i5) {
                m.put(ss1[i5].getName(), ss1[i5]);
            }
            for (i5 = 0; i5 < ss2.length; ++i5) {
                if (m.containsKey(ss2[i5].getName())) continue;
                m.put(ss2[i5].getName(), ss2[i5]);
            }
            this.simpleTypes = new SimpleType[m.size()];
            obj = m.values().toArray();
            for (i5 = 0; i5 < obj.length; ++i5) {
                this.simpleTypes[i5] = (SimpleType)obj[i5];
            }
            m = new HashMap();
            Element[] e1 = s1.getElements();
            if (e1 == null) {
                e1 = new Element[]{};
            }
            if ((e2 = s2.getElements()) == null) {
                e2 = new Element[]{};
            }
            for (i4 = 0; i4 < e1.length; ++i4) {
                m.put(e1[i4].getName(), e1[i4]);
            }
            for (i4 = 0; i4 < e2.length; ++i4) {
                if (m.containsKey(e2[i4].getName())) continue;
                m.put(e2[i4].getName(), e2[i4]);
            }
            this.elements = new Element[m.size()];
            obj = m.values().toArray();
            for (i4 = 0; i4 < obj.length; ++i4) {
                this.elements[i4] = (Element)obj[i4];
            }
            m = new HashMap();
            Group[] g1 = s1.getGroups();
            if (g1 == null) {
                g1 = new Group[]{};
            }
            if ((g2 = s2.getGroups()) == null) {
                g2 = new Group[]{};
            }
            for (i3 = 0; i3 < g1.length; ++i3) {
                m.put(g1[i3].getName(), g1[i3]);
            }
            for (i3 = 0; i3 < g2.length; ++i3) {
                if (m.containsKey(g2[i3].getName())) continue;
                m.put(g2[i3].getName(), g2[i3]);
            }
            this.groups = new Group[m.size()];
            obj = m.values().toArray();
            for (i3 = 0; i3 < obj.length; ++i3) {
                this.groups[i3] = (Group)obj[i3];
            }
            m = new HashMap();
            Schema[] i1 = s1.getImports();
            if (i1 == null) {
                i1 = new Schema[]{};
            }
            if ((i2 = s2.getImports()) == null) {
                i2 = new Schema[]{};
            }
            for (i = 0; i < i1.length; ++i) {
                m.put(i1[i].getTargetNamespace(), i1[i]);
            }
            for (i = 0; i < i2.length; ++i) {
                if (m.containsKey(i2[i].getTargetNamespace())) continue;
                m.put(i2[i].getTargetNamespace(), i2[i]);
            }
            this.imports = new Schema[m.size()];
            obj = m.values().toArray();
            for (i = 0; i < obj.length; ++i) {
                this.imports[i] = (Schema)obj[i];
            }
            URI u1 = s1.getURI();
            URI u2 = s2.getURI();
            this.uri = u1 == null ? u2 : (u2 == null ? u1 : u2.relativize(u1));
            this.prefix = s1.getPrefix() == null || s1.getPrefix().equals("") ? s2.getPrefix() : s1.getPrefix();
        }

        public AttributeGroup[] getAttributeGroups() {
            return this.attributeGroups;
        }

        public Attribute[] getAttributes() {
            return this.attributes;
        }

        public int getBlockDefault() {
            return this.block;
        }

        public ComplexType[] getComplexTypes() {
            return this.complexTypes;
        }

        public Element[] getElements() {
            return this.elements;
        }

        public int getFinalDefault() {
            return this.finaL;
        }

        public Group[] getGroups() {
            return this.groups;
        }

        public String getId() {
            return this.id;
        }

        public Schema[] getImports() {
            return this.imports;
        }

        public SimpleType[] getSimpleTypes() {
            return this.simpleTypes;
        }

        public URI getTargetNamespace() {
            return this.targetNamespace;
        }

        public String getVersion() {
            return this.version;
        }

        public boolean includesURI(URI uri1) {
            if (uri1 == null) {
                return false;
            }
            return this.uri.equals(uri1);
        }

        public boolean isAttributeFormDefault() {
            return this.aForm;
        }

        public boolean isElementFormDefault() {
            return this.eForm;
        }

        public URI getURI() {
            return this.uri;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Map getImplementationHints() {
            return Collections.EMPTY_MAP;
        }
    }
}

