/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml.transform;

import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.geotools.xml.transform.Translator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.NamespaceSupport;
import org.xml.sax.helpers.XMLFilterImpl;

public abstract class TransformerBase {
    private int indentation = -1;
    private boolean xmlDecl = false;
    private boolean nsDecl = true;
    private Charset charset = Charset.forName("UTF-8");

    public abstract Translator createTranslator(ContentHandler var1);

    public Transformer createTransformer() throws TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        if (this.indentation > -1) {
            try {
                tFactory.setAttribute("indent-number", new Integer(this.indentation));
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        Transformer transformer = tFactory.newTransformer();
        if (this.indentation > -1) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(this.indentation));
        } else {
            transformer.setOutputProperty("indent", "no");
        }
        if (this.xmlDecl) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else {
            transformer.setOutputProperty("omit-xml-declaration", "no");
        }
        transformer.setOutputProperty("encoding", this.charset.name());
        return transformer;
    }

    public void transform(Object object, OutputStream out) throws TransformerException {
        this.transform(object, new StreamResult(out));
    }

    public void transform(Object object, Writer out) throws TransformerException {
        this.transform(object, new StreamResult(out));
    }

    public void transform(Object object, StreamResult result) throws TransformerException {
        Task t = this.createTransformTask(object, result);
        t.run();
        if (t.checkError()) {
            Exception e;
            if (!TransformerException.class.isAssignableFrom((e = t.getError()).getClass())) {
                e = new TransformerException("Translator error", e);
            }
            throw (TransformerException)e;
        }
    }

    public Task createTransformTask(Object object, StreamResult result) throws TransformerException {
        return new Task(object, result);
    }

    public String transform(Object object) throws TransformerException {
        StringWriter sw = new StringWriter();
        this.transform(object, sw);
        return sw.getBuffer().toString();
    }

    public XMLReaderSupport createXMLReader(Object object) {
        return new XMLReaderSupport(this, object);
    }

    public int getIndentation() {
        return this.indentation;
    }

    public void setIndentation(int amt) {
        this.indentation = amt;
    }

    public Charset getEncoding() {
        return this.charset;
    }

    public void setEncoding(Charset charset) {
        this.charset = charset;
    }

    public boolean isOmitXMLDeclaration() {
        return this.xmlDecl;
    }

    public void setOmitXMLDeclaration(boolean xmlDecl) {
        this.xmlDecl = xmlDecl;
    }

    public boolean isNamespaceDeclartionEnabled() {
        return this.nsDecl;
    }

    public void setNamespaceDeclarationEnabled(boolean enabled) {
        this.nsDecl = enabled;
    }

    protected static class XMLReaderSupport
    extends XMLFilterImpl {
        TransformerBase base;
        Object object;
        Translator translator;

        public XMLReaderSupport(TransformerBase transfomerBase, Object object) {
            this.base = transfomerBase;
            this.object = object;
        }

        public final Translator getTranslator() {
            return this.translator;
        }

        public void parse(InputSource in) throws SAXException {
            ContentHandler handler = this.getContentHandler();
            if (this.base.isNamespaceDeclartionEnabled()) {
                SchemaLocationSupport schemaLocSup;
                AttributesImpl atts = new AttributesImpl();
                ContentHandlerFilter filter = new ContentHandlerFilter(handler, atts);
                this.translator = this.base.createTranslator(filter);
                if (this.translator.getDefaultNamespace() != null) {
                    atts.addAttribute(null, null, "xmlns", null, this.translator.getDefaultNamespace());
                    if (this.translator.getDefaultPrefix() != null) {
                        atts.addAttribute(null, null, "xmlns:" + this.translator.getDefaultPrefix(), null, this.translator.getDefaultNamespace());
                    }
                }
                NamespaceSupport ns = this.translator.getNamespaceSupport();
                Enumeration<String> e = ns.getPrefixes();
                while (e.hasMoreElements()) {
                    String xmlns;
                    String prefix = e.nextElement().toString();
                    if (prefix.equals("xml") || atts.getValue(xmlns = "xmlns:" + prefix) != null) continue;
                    atts.addAttribute(null, null, xmlns, null, ns.getURI(prefix));
                }
                String defaultNS = ns.getURI("");
                if (defaultNS != null && atts.getValue("xmlns:") == null) {
                    atts.addAttribute(null, null, "xmlns:", null, defaultNS);
                }
                if ((schemaLocSup = this.translator.getSchemaLocationSupport()) != null && !schemaLocSup.getSchemaLocation().equals("")) {
                    atts.addAttribute(null, null, "xmlns:xsi", null, "http://www.w3.org/2001/XMLSchema-instance");
                    atts.addAttribute(null, null, "xsi:schemaLocation", null, schemaLocSup.getSchemaLocation());
                }
            } else {
                this.translator = this.base.createTranslator(handler);
            }
            handler.startDocument();
            this.translator.encode(this.object);
            handler.endDocument();
        }
    }

    public static class SchemaLocationSupport {
        private Map locations = new HashMap();

        public void setLocation(String nsURI, String uri) {
            this.locations.put(nsURI, uri);
        }

        public String getSchemaLocation() {
            return this.getSchemaLocation(this.locations.keySet());
        }

        public String getSchemaLocation(String nsURI) {
            String uri = (String)this.locations.get(nsURI);
            if (uri == null) {
                return "";
            }
            return nsURI + " " + uri;
        }

        public String getSchemaLocation(Set namespaces) {
            StringBuffer location = new StringBuffer();
            Iterator it = namespaces.iterator();
            while (it.hasNext()) {
                location.append(this.getSchemaLocation((String)it.next()));
                if (!it.hasNext()) continue;
                location.append(" ");
            }
            return location.toString();
        }
    }

    protected static abstract class TranslatorSupport
    implements Translator {
        protected final ContentHandler contentHandler;
        private String prefix;
        private String namespace;
        protected final Attributes NULL_ATTS = new AttributesImpl();
        protected NamespaceSupport nsSupport = new NamespaceSupport();
        protected SchemaLocationSupport schemaLocation;
        protected volatile boolean running = true;

        public TranslatorSupport(ContentHandler contentHandler, String prefix, String nsURI) {
            this.contentHandler = contentHandler;
            this.prefix = prefix;
            this.namespace = nsURI;
            if (prefix != null && nsURI != null) {
                this.nsSupport.declarePrefix(prefix, nsURI);
            }
        }

        public TranslatorSupport(ContentHandler contentHandler, String prefix, String nsURI, SchemaLocationSupport schemaLocation) {
            this(contentHandler, prefix, nsURI);
            this.schemaLocation = schemaLocation;
        }

        public void abort() {
            this.running = false;
        }

        protected void addNamespaceDeclarations(TranslatorSupport trans) {
            NamespaceSupport additional = trans.getNamespaceSupport();
            Enumeration<String> declared = additional.getDeclaredPrefixes();
            while (declared.hasMoreElements()) {
                String prefix1 = declared.nextElement().toString();
                this.nsSupport.declarePrefix(prefix1, additional.getURI(prefix1));
            }
        }

        protected void element(String element, String content) {
            this.element(element, content, this.NULL_ATTS);
        }

        protected void element(String element, String content, Attributes atts) {
            this.start(element, atts);
            if (content != null) {
                this.chars(content);
            }
            this.end(element);
        }

        protected void start(String element) {
            this.start(element, this.NULL_ATTS);
        }

        protected void start(String element, Attributes atts) {
            try {
                String el = this.prefix == null ? element : this.prefix + ":" + element;
                this.contentHandler.startElement("", "", el, atts);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        protected void chars(String text) {
            try {
                char[] ch = text.toCharArray();
                this.contentHandler.characters(ch, 0, ch.length);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        protected void end(String element) {
            try {
                String el = this.prefix == null ? element : this.prefix + ":" + element;
                this.contentHandler.endElement("", "", el);
            }
            catch (SAXException se) {
                throw new RuntimeException(se);
            }
        }

        protected void cdata(String cdata) {
            if (this.contentHandler instanceof LexicalHandler) {
                LexicalHandler lexicalHandler = (LexicalHandler)((Object)this.contentHandler);
                try {
                    lexicalHandler.startCDATA();
                    this.chars(cdata);
                    lexicalHandler.endCDATA();
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public String getDefaultNamespace() {
            return this.namespace;
        }

        public String getDefaultPrefix() {
            return this.prefix;
        }

        public NamespaceSupport getNamespaceSupport() {
            return this.nsSupport;
        }

        public SchemaLocationSupport getSchemaLocationSupport() {
            return this.schemaLocation;
        }
    }

    private static class ContentHandlerFilter
    implements ContentHandler,
    LexicalHandler {
        private final ContentHandler original;
        private AttributesImpl namespaceDecls;

        public ContentHandlerFilter(ContentHandler original, AttributesImpl nsDecls) {
            this.original = original;
            this.namespaceDecls = nsDecls;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.original.characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
            this.original.endDocument();
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            this.original.endElement(namespaceURI, localName, qName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.original.endPrefixMapping(prefix);
        }

        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.original.ignorableWhitespace(ch, start, length);
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.original.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            this.original.setDocumentLocator(locator);
        }

        public void skippedEntity(String name) throws SAXException {
            this.original.skippedEntity(name);
        }

        public void startDocument() throws SAXException {
            this.original.startDocument();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (this.namespaceDecls != null) {
                int ii = atts.getLength();
                for (int i = 0; i < ii; ++i) {
                    this.namespaceDecls.addAttribute(null, null, atts.getQName(i), atts.getType(i), atts.getValue(i));
                }
                atts = this.namespaceDecls;
                this.namespaceDecls = null;
            }
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if (localName == null) {
                localName = "";
            }
            this.original.startElement(namespaceURI, localName, qName, atts);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.original.startPrefixMapping(prefix, uri);
        }

        public void comment(char[] ch, int start, int length) throws SAXException {
            if (this.original instanceof LexicalHandler) {
                ((LexicalHandler)((Object)this.original)).comment(ch, start, length);
            }
        }

        public void startCDATA() throws SAXException {
            if (this.original instanceof LexicalHandler) {
                ((LexicalHandler)((Object)this.original)).startCDATA();
            }
        }

        public void endCDATA() throws SAXException {
            if (this.original instanceof LexicalHandler) {
                ((LexicalHandler)((Object)this.original)).endCDATA();
            }
        }

        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            if (this.original instanceof LexicalHandler) {
                ((LexicalHandler)((Object)this.original)).startDTD(name, publicId, systemId);
            }
        }

        public void endDTD() throws SAXException {
            if (this.original instanceof LexicalHandler) {
                ((LexicalHandler)((Object)this.original)).endDTD();
            }
        }

        public void startEntity(String name) throws SAXException {
            if (this.original instanceof LexicalHandler) {
                ((LexicalHandler)((Object)this.original)).startEntity(name);
            }
        }

        public void endEntity(String name) throws SAXException {
            if (this.original instanceof LexicalHandler) {
                ((LexicalHandler)((Object)this.original)).endEntity(name);
            }
        }
    }

    public class Task
    implements Runnable {
        private final Transformer transformer;
        private final Source xmlSource;
        private final StreamResult result;
        private final XMLReaderSupport reader;
        private Exception error;

        public Task(Object object, StreamResult result) throws TransformerException {
            this.transformer = TransformerBase.this.createTransformer();
            this.reader = TransformerBase.this.createXMLReader(object);
            this.xmlSource = new SAXSource(TransformerBase.this.createXMLReader(object), new InputSource());
            this.result = result;
        }

        public boolean checkError() {
            return this.error != null;
        }

        public Exception getError() {
            return this.error;
        }

        public void abort() {
            Translator t = this.reader.getTranslator();
            if (t != null) {
                t.abort();
            }
        }

        public void run() {
            try {
                this.transformer.transform(this.xmlSource, this.result);
            }
            catch (Exception re) {
                this.error = re;
            }
        }
    }
}

