/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import org.geotools.feature.AttributeType;
import org.geotools.feature.Feature;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.resources.Utilities;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

public class PropertyExistsFunction
extends FunctionExpressionImpl {
    public PropertyExistsFunction() {
        super("PropertyExists");
    }

    public int getArgCount() {
        return 1;
    }

    private String getPropertyName() {
        Expression expr = (Expression)this.getParameters().get(0);
        return this.getPropertyName(expr);
    }

    /*
     * WARNING - void declaration
     */
    private String getPropertyName(Expression expr) {
        void var2_2;
        String propertyName;
        if (expr instanceof Literal) {
            propertyName = String.valueOf(((Literal)expr).getValue());
        } else if (expr instanceof PropertyName) {
            propertyName = ((PropertyName)expr).getPropertyName();
        } else {
            throw new IllegalStateException("Not a property name expression: " + expr);
        }
        return var2_2;
    }

    public Object evaluate(Feature feature) {
        String propName = this.getPropertyName();
        AttributeType attributeType = null;
        try {
            attributeType = feature.getFeatureType().getAttributeType(propName);
        }
        catch (Exception e) {
            // empty catch block
        }
        return attributeType != null;
    }

    public Object evaluate(Object bean) {
        if (bean instanceof Feature) {
            return this.evaluate((Feature)bean);
        }
        return Boolean.FALSE;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("PropertyExists('");
        sb.append(this.getPropertyName());
        sb.append("')");
        String stringVal = sb.toString();
        return stringVal;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Function)) {
            return false;
        }
        Function other = (Function)obj;
        if (!Utilities.equals((Object)this.getName(), (Object)other.getName())) {
            return false;
        }
        String propName = this.getPropertyName();
        Expression otherPropNameExpr = (Expression)other.getParameters().get(0);
        String otherPropName = this.getPropertyName(otherPropNameExpr);
        return Utilities.equals((Object)propName, (Object)otherPropName);
    }
}

