/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.text.filter;

import java.util.EmptyStackException;
import java.util.Stack;
import org.geotools.text.filter.FilterBuilderException;
import org.geotools.text.filter.PeriodNode;
import org.geotools.text.filter.Result;
import org.geotools.text.filter.Token;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;

final class BuildResultStack {
    private Stack stack = new Stack();

    private BuildResultStack() {
    }

    public static BuildResultStack getInstance() {
        return new BuildResultStack();
    }

    public void clear() {
        this.stack.clear();
    }

    public Result peek() {
        return (Result)this.stack.peek();
    }

    public boolean empty() {
        return this.stack.empty();
    }

    public Result popResult() throws FilterBuilderException {
        Result item = null;
        try {
            return (Result)this.stack.pop();
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expecting Expression, but found Filter", item.getToken());
        }
        catch (EmptyStackException ese) {
            throw new FilterBuilderException("No items on stack");
        }
    }

    public Expression popExpression() throws FilterBuilderException {
        Result item = null;
        try {
            item = (Result)this.stack.pop();
            return (Expression)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expecting Expression, but found Filter", item.getToken());
        }
        catch (EmptyStackException ese) {
            throw new FilterBuilderException("No items on stack");
        }
    }

    public Literal popLiteral() throws FilterBuilderException {
        Result item = null;
        try {
            item = (Result)this.stack.pop();
            return (Literal)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expecting Expression, but found Filter", item.getToken());
        }
        catch (EmptyStackException ese) {
            throw new FilterBuilderException("No items on stack");
        }
    }

    public PropertyName popPropertyName() throws FilterBuilderException {
        Result item = null;
        try {
            item = (Result)this.stack.pop();
            return (PropertyName)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expecting Expression, but found Filter", item.getToken());
        }
        catch (EmptyStackException ese) {
            throw new FilterBuilderException("No items on stack");
        }
    }

    public Filter popFilter() throws FilterBuilderException {
        Result item = null;
        try {
            item = (Result)this.stack.pop();
            return (Filter)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expecting Filter, but found Expression", item.getToken());
        }
        catch (EmptyStackException ese) {
            throw new FilterBuilderException("No items on stack");
        }
    }

    public PeriodNode popPeriod() throws FilterBuilderException {
        Result item = null;
        try {
            item = (Result)this.stack.pop();
            return (PeriodNode)item.getBuilt();
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expecting Filter, but found Expression", item.getToken());
        }
        catch (EmptyStackException ese) {
            throw new FilterBuilderException("No items on stack");
        }
    }

    public double popDoubleValue() throws FilterBuilderException {
        try {
            Literal expr = this.popLiteral();
            Double number = new Double(expr.getValue().toString());
            return number;
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expected double");
        }
    }

    public int popIntegerValue() throws FilterBuilderException {
        try {
            Literal expr = this.popLiteral();
            Integer number = (Integer)expr.getValue();
            return number;
        }
        catch (ClassCastException cce) {
            throw new FilterBuilderException("Expected double");
        }
    }

    public String popStringValue() throws FilterBuilderException {
        Literal literal = this.popLiteral();
        return literal.toString();
    }

    public String popIdentifierPart() throws FilterBuilderException {
        try {
            Result resultPart = (Result)this.stack.pop();
            Token token = resultPart.getToken();
            return token.image;
        }
        catch (ClassCastException e) {
            throw new FilterBuilderException("identifier part is expected");
        }
    }

    public String popIdentifier() throws FilterBuilderException {
        try {
            Result result = (Result)this.stack.pop();
            String identifier = (String)result.getBuilt();
            return identifier;
        }
        catch (ClassCastException e) {
            throw new FilterBuilderException("fail in identifier parsing");
        }
    }

    public void push(Result item) {
        this.stack.push(item);
    }

    public int size() {
        return this.stack.size();
    }
}

