/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.text.filter;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FilterFactoryFinder;
import org.geotools.filter.FilterFactoryImpl;
import org.geotools.filter.FilterTransformer;
import org.geotools.filter.IllegalFilterException;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.text.filter.BuildResultStack;
import org.geotools.text.filter.CQLParser;
import org.geotools.text.filter.CQLParserTreeConstants;
import org.geotools.text.filter.FilterBuilderException;
import org.geotools.text.filter.Node;
import org.geotools.text.filter.ParseException;
import org.geotools.text.filter.PeriodNode;
import org.geotools.text.filter.Result;
import org.geotools.text.filter.Token;
import org.geotools.text.filter.TokenMgrError;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.Filter;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsGreaterThan;
import org.opengis.filter.PropertyIsGreaterThanOrEqualTo;
import org.opengis.filter.PropertyIsLessThan;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.DistanceBufferOperator;
import org.opengis.filter.spatial.Equals;

public class FilterBuilder {
    private static final Logger LOGGER = Logger.getLogger(FilterBuilder.class.getName());

    public static Filter parse(FilterFactory filterFactory, String input) throws ParseException {
        if (filterFactory == null) {
            filterFactory = FilterFactoryFinder.createFilterFactory();
        }
        CQLCompiler c = new CQLCompiler(input, filterFactory);
        try {
            c.CompilationUnit();
        }
        catch (TokenMgrError tme) {
            throw new FilterBuilderException(tme.getMessage(), c.getToken(0));
        }
        if (c.exception != null) {
            throw c.exception;
        }
        Object result = c.getResult();
        Filter builtFilter = (Filter)result;
        return builtFilter;
    }

    public static Filter parse(String input) throws ParseException {
        return FilterBuilder.parse(null, input);
    }

    public static Expression parseExpression(FilterFactory filterFactory, String input) throws ParseException {
        if (filterFactory == null) {
            filterFactory = FilterFactoryFinder.createFilterFactory();
        }
        CQLCompiler c = new CQLCompiler(input, filterFactory);
        try {
            c.ExpressionCompilationUnit();
        }
        catch (TokenMgrError tme) {
            throw new FilterBuilderException(tme.getMessage(), c.getToken(0));
        }
        if (c.exception != null) {
            throw c.exception;
        }
        Expression builtFilter = (Expression)c.getResult();
        return builtFilter;
    }

    public static Expression parseExpression(String input) throws ParseException {
        return FilterBuilder.parseExpression(null, input);
    }

    public static List parseFilterList(FilterFactory filterFactory, String input) throws ParseException {
        if (filterFactory == null) {
            filterFactory = FilterFactoryFinder.createFilterFactory();
        }
        CQLCompiler c = new CQLCompiler(input, filterFactory);
        try {
            c.MultipleCompilationUnit();
        }
        catch (TokenMgrError tme) {
            throw new FilterBuilderException(tme.getMessage(), c.getToken(0));
        }
        if (c.exception != null) {
            throw c.exception;
        }
        List results = c.getResults();
        return results;
    }

    public static String getFormattedErrorMessage(ParseException pe, String input) {
        StringBuffer sb = new StringBuffer(input);
        sb.append('\n');
        Token t = pe.currentToken;
        while (t.next != null) {
            t = t.next;
        }
        int column = t.beginColumn - 1;
        for (int i = 0; i < column; ++i) {
            sb.append(' ');
        }
        sb.append('^').append('\n');
        sb.append(pe.getMessage());
        return sb.toString();
    }

    public static final void main(String[] args) throws Exception {
        System.out.println("Expression Tester");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        FilterTransformer t = new FilterTransformer();
        t.setIndentation(4);
        while (true) {
            System.out.print(">");
            String line = r.readLine();
            if (line.equals("quit")) break;
            try {
                Filter b = FilterBuilder.parse(line);
                t.transform((Object)b, (OutputStream)System.out);
                System.out.println();
            }
            catch (ParseException pe) {
                System.out.println(FilterBuilder.getFormattedErrorMessage(pe, line));
            }
        }
    }

    private static class CQLCompiler
    extends CQLParser
    implements CQLParserTreeConstants {
        private static final String ATTRIBUTE_PATH_SEPARATOR = "/";
        private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        private static final WKTReader WKT_READER = new WKTReader();
        private BuildResultStack resultStack;
        private FilterBuilderException exception = null;
        private String input = null;
        private FilterFactory filterFactory;

        CQLCompiler(String input, FilterFactory filterFactory) {
            super(new StringReader(input));
            this.input = input;
            this.filterFactory = filterFactory;
            this.resultStack = BuildResultStack.getInstance();
        }

        public Object getResult() {
            Result item = this.resultStack.peek();
            Object result = item.getBuilt();
            return result;
        }

        public List getResults() throws FilterBuilderException {
            int size = this.resultStack.size();
            ArrayList<Object> results = new ArrayList<Object>(size);
            for (int i = 0; i < size; ++i) {
                Result item = this.resultStack.popResult();
                Object result = item.getBuilt();
                results.add(0, result);
            }
            return results;
        }

        public void jjtreeOpenNodeScope(Node n) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void jjtreeCloseNodeScope(Node n) throws ParseException {
            try {
                Object built = this.buildObject(n);
                if (built == null) {
                    throw new RuntimeException("INTERNAL ERROR : Node " + n + " resulted in null build");
                }
                this.resultStack.push(new Result(built, this.getToken(0), n.getType()));
            }
            finally {
                n.dispose();
            }
        }

        private BinaryExpression buildBinaryExpression(int nodeType) throws FilterBuilderException {
            Expression right = this.resultStack.popExpression();
            Expression left = this.resultStack.popExpression();
            Add expr = null;
            switch (nodeType) {
                case 45: {
                    expr = this.filterFactory.add(left, right);
                    break;
                }
                case 46: {
                    expr = this.filterFactory.subtract(left, right);
                    break;
                }
                case 47: {
                    expr = this.filterFactory.multiply(left, right);
                    break;
                }
                case 48: {
                    expr = this.filterFactory.divide(left, right);
                    break;
                }
            }
            return expr;
        }

        /*
         * WARNING - void declaration
         */
        private Filter buildLogicFilter(int nodeType) throws FilterBuilderException {
            try {
                void var4_5;
                Filter right = null;
                Filter left = null;
                switch (nodeType) {
                    case 2: {
                        org.geotools.filter.Filter logicFilter;
                        right = this.resultStack.popFilter();
                        left = this.resultStack.popFilter();
                        if (org.geotools.filter.Filter.NONE.equals(right)) {
                            logicFilter = left;
                            break;
                        }
                        if (org.geotools.filter.Filter.NONE.equals(left)) {
                            logicFilter = right;
                            break;
                        }
                        if (org.geotools.filter.Filter.ALL.equals(right) || org.geotools.filter.Filter.ALL.equals(left)) {
                            logicFilter = org.geotools.filter.Filter.ALL;
                            break;
                        }
                        logicFilter = this.filterFactory.and(left, right);
                        break;
                    }
                    case 1: {
                        org.geotools.filter.Filter logicFilter;
                        right = this.resultStack.popFilter();
                        left = this.resultStack.popFilter();
                        if (org.geotools.filter.Filter.NONE.equals(right) || org.geotools.filter.Filter.NONE.equals(left)) {
                            logicFilter = org.geotools.filter.Filter.NONE;
                            break;
                        }
                        if (org.geotools.filter.Filter.ALL.equals(left)) {
                            logicFilter = right;
                            break;
                        }
                        if (org.geotools.filter.Filter.ALL.equals(right)) {
                            logicFilter = left;
                            break;
                        }
                        logicFilter = this.filterFactory.or(left, right);
                        break;
                    }
                    case 3: {
                        org.geotools.filter.Filter logicFilter;
                        right = this.resultStack.popFilter();
                        if (org.geotools.filter.Filter.NONE.equals(right)) {
                            logicFilter = org.geotools.filter.Filter.ALL;
                            break;
                        }
                        if (org.geotools.filter.Filter.ALL.equals(right)) {
                            logicFilter = org.geotools.filter.Filter.NONE;
                            break;
                        }
                        logicFilter = this.filterFactory.not(right);
                        break;
                    }
                    default: {
                        throw new FilterBuilderException("Expression not supported. And, Or, Not is required", this.getToken(0));
                    }
                }
                return var4_5;
            }
            catch (IllegalFilterException ife) {
                throw new FilterBuilderException("Exception building LogicFilter", this.getToken(0), ife);
            }
        }

        private PropertyIsLike buildLikeFilter() throws FilterBuilderException {
            String WC_MULTI = "%";
            String WC_SINGLE = "_";
            String ESCAPE = "\\";
            try {
                Expression pattern = this.resultStack.popExpression();
                Expression expr = this.resultStack.popExpression();
                PropertyIsLike f = this.filterFactory.like(expr, pattern.toString(), "%", "_", "\\");
                return f;
            }
            catch (IllegalFilterException ife) {
                throw new FilterBuilderException("Exception building LikeFilter", this.getToken(0), ife);
            }
        }

        private PropertyIsNull buildPropertyIsNull() throws FilterBuilderException {
            try {
                Expression property = this.resultStack.popExpression();
                PropertyIsNull filter = this.filterFactory.isNull(property);
                return filter;
            }
            catch (FilterBuilderException e) {
                throw new FilterBuilderException("Exception building Null Predicate", this.getToken(0), e);
            }
        }

        private PropertyIsBetween buildBetween() throws FilterBuilderException {
            try {
                Expression sup = this.resultStack.popExpression();
                Expression inf = this.resultStack.popExpression();
                Expression expr = this.resultStack.popExpression();
                PropertyIsBetween filter = this.filterFactory.between(expr, inf, sup);
                return filter;
            }
            catch (IllegalFilterException ife) {
                throw new FilterBuilderException("Exception building CompareFilter", this.getToken(0), ife);
            }
        }

        protected Object buildObject(Node n) throws FilterBuilderException {
            switch (n.getType()) {
                case 54: {
                    return this.filterFactory.literal(Integer.parseInt(this.getToken((int)0).image));
                }
                case 55: {
                    return this.filterFactory.literal(Double.parseDouble(this.getToken((int)0).image));
                }
                case 58: {
                    return this.filterFactory.literal((Object)n.getToken().image);
                }
                case 49: {
                    return this.buildIdentifier();
                }
                case 50: 
                case 51: {
                    return this.buildIdentifierPart();
                }
                case 52: {
                    return this.buildSimpleAttribute();
                }
                case 53: {
                    return this.buildCompoundAttribute();
                }
                case 59: {
                    return this.buildFunction(n);
                }
                case 60: {
                    return n;
                }
                case 61: {
                    return n;
                }
                case 45: 
                case 46: 
                case 47: 
                case 48: {
                    return this.buildBinaryExpression(n.getType());
                }
                case 2: {
                    return this.buildLogicFilter(2);
                }
                case 1: {
                    return this.buildLogicFilter(1);
                }
                case 3: {
                    return this.buildLogicFilter(3);
                }
                case 44: {
                    return this.buildBetween();
                }
                case 43: {
                    return this.filterFactory.not((Filter)this.buildBetween());
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    return this.buildBinaryComparasionOperator(n.getType());
                }
                case 26: {
                    BinaryComparisonOperator eq = this.buildBinaryComparasionOperator(21);
                    Not notFilter = this.filterFactory.not((Filter)eq);
                    return notFilter;
                }
                case 42: {
                    return this.buildLikeFilter();
                }
                case 41: {
                    Not filter = this.filterFactory.not((Filter)this.buildLikeFilter());
                    return filter;
                }
                case 27: {
                    return this.buildPropertyIsNull();
                }
                case 28: {
                    return this.filterFactory.not((Filter)this.buildPropertyIsNull());
                }
                case 37: {
                    return this.buildDateTimeExpression();
                }
                case 38: {
                    return this.buildDurationExpression();
                }
                case 36: {
                    return this.buildPeriodBetweenDates();
                }
                case 35: {
                    return this.buildPeriodDateAndDuration();
                }
                case 34: {
                    return this.buildPeriodDurationAndDate();
                }
                case 29: {
                    return this.buildTemporalPredicateBefore();
                }
                case 31: {
                    return this.buildTemporalPredicateAfter();
                }
                case 32: {
                    return this.buildTemporalPredicateDuring();
                }
                case 30: {
                    return this.buildTemporalPredicateBeforeOrDuring();
                }
                case 33: {
                    return this.buildTemporalPredicateDuringOrAfter();
                }
                case 39: {
                    return this.buildPropertyExists();
                }
                case 40: {
                    Not filterPropNotExist = this.filterFactory.not((Filter)this.buildPropertyExists());
                    return filterPropNotExist;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return this.buildBinarySpatialOperator(n.getType());
                }
                case 13: 
                case 14: {
                    return this.buildBBox(n.getType());
                }
                case 12: {
                    throw new FilterBuilderException("Unsupported geooperation RELATE (is not implemented by GeoTools)", this.getToken(0));
                }
                case 17: {
                    return this.buildTolerance();
                }
                case 18: {
                    return this.buildDistanceUnit();
                }
                case 15: 
                case 16: {
                    return this.buildDistanceBufferOperator(n.getType());
                }
                case 62: {
                    return this.buildGeometry(n.getToken());
                }
                case 63: {
                    return this.buildEnvelop(n.getToken());
                }
                case 19: {
                    return org.geotools.filter.Filter.NONE;
                }
                case 20: {
                    return org.geotools.filter.Filter.ALL;
                }
                case 56: {
                    return this.filterFactory.literal((Object)Boolean.TRUE);
                }
                case 57: {
                    return this.filterFactory.literal((Object)Boolean.FALSE);
                }
            }
            return null;
        }

        private PropertyName buildCompoundAttribute() throws FilterBuilderException {
            Result r;
            ArrayList<String> arrayIdentifiers = new ArrayList<String>();
            while (this.resultStack.size() > 0 && (r = this.resultStack.peek()).getNodeType() == 52) {
                PropertyName simpleAttribute = this.resultStack.popPropertyName();
                arrayIdentifiers.add(simpleAttribute.getPropertyName());
            }
            StringBuffer attribute = new StringBuffer(100);
            int i = 0;
            for (i = arrayIdentifiers.size() - 1; i > 0; --i) {
                attribute.append(arrayIdentifiers.get(i));
                attribute.append(ATTRIBUTE_PATH_SEPARATOR);
            }
            attribute.append(arrayIdentifiers.get(i));
            PropertyName property = this.filterFactory.property(attribute.toString());
            return property;
        }

        private String buildIdentifier() throws FilterBuilderException {
            try {
                String part;
                Result r;
                ArrayList<String> arrayParts = new ArrayList<String>();
                while (this.resultStack.size() > 0 && ((r = this.resultStack.peek()).getNodeType() == 50 || r.getNodeType() == 51)) {
                    part = this.resultStack.popIdentifierPart();
                    arrayParts.add(part);
                }
                StringBuffer identifier = new StringBuffer(100);
                int i = 0;
                for (i = arrayParts.size() - 1; i > 0; --i) {
                    part = (String)arrayParts.get(i);
                    identifier.append(part).append(":");
                }
                part = (String)arrayParts.get(i);
                identifier.append(part);
                return identifier.toString();
            }
            catch (FilterBuilderException e) {
                throw new FilterBuilderException("Fail builing identifier: " + e.getMessage());
            }
        }

        private String buildIdentifierPart() {
            String part = this.getToken((int)0).image;
            return part;
        }

        private PropertyName buildSimpleAttribute() throws FilterBuilderException {
            String identifier = this.resultStack.popIdentifier();
            PropertyName property = this.filterFactory.property(identifier);
            return property;
        }

        private Literal buildDistanceUnit() throws FilterBuilderException {
            Literal unit = null;
            Token token = this.getToken(0);
            unit = this.filterFactory.literal((Object)token.image);
            return unit;
        }

        private Literal buildTolerance() throws FilterBuilderException {
            Literal tolerance = null;
            try {
                tolerance = this.resultStack.popLiteral();
                return tolerance;
            }
            catch (NumberFormatException e) {
                throw new FilterBuilderException("Unsupported number format", this.token);
            }
        }

        private BinarySpatialOperator buildBinarySpatialOperator(int nodeType) throws FilterBuilderException {
            Literal geom = this.resultStack.popLiteral();
            Expression property = this.resultStack.popExpression();
            FilterFactory ff = this.filterFactory;
            Equals filter = null;
            switch (nodeType) {
                case 4: {
                    filter = ff.equal(property, (Expression)geom);
                    break;
                }
                case 5: {
                    filter = ff.disjoint(property, (Expression)geom);
                    break;
                }
                case 6: {
                    filter = ff.intersects(property, (Expression)geom);
                    break;
                }
                case 7: {
                    filter = ff.touches(property, (Expression)geom);
                    break;
                }
                case 8: {
                    filter = ff.crosses(property, (Expression)geom);
                    break;
                }
                case 9: {
                    filter = this.filterFactory.within(property, (Expression)geom);
                    break;
                }
                case 10: {
                    filter = ff.contains(property, (Expression)geom);
                    break;
                }
                case 11: {
                    filter = ff.overlaps(property, (Expression)geom);
                    break;
                }
                default: {
                    throw new FilterBuilderException("Binary spatial operator unexpected");
                }
            }
            return filter;
        }

        private BBOX buildBBox(int nodeType) throws FilterBuilderException {
            try {
                String srs = "EPSG:4326";
                if (nodeType == 14) {
                    srs = this.resultStack.popStringValue();
                }
                double maxY = this.resultStack.popDoubleValue();
                double maxX = this.resultStack.popDoubleValue();
                double minY = this.resultStack.popDoubleValue();
                double minX = this.resultStack.popDoubleValue();
                PropertyName property = this.resultStack.popPropertyName();
                String strProperty = property.getPropertyName();
                BBOX bbox = this.filterFactory.bbox(strProperty, minX, minY, maxX, maxY, srs);
                return bbox;
            }
            catch (Exception e) {
                throw new FilterBuilderException("Fails building BBOX filter (" + e.getMessage() + ")");
            }
        }

        private DistanceBufferOperator buildDistanceBufferOperator(int nodeType) throws FilterBuilderException {
            String unit = this.resultStack.popStringValue();
            double tolerance = this.resultStack.popDoubleValue();
            Expression geom = this.resultStack.popExpression();
            Expression property = this.resultStack.popExpression();
            DWithin filter = null;
            switch (nodeType) {
                case 15: {
                    filter = this.filterFactory.dwithin(property, geom, tolerance, unit);
                    break;
                }
                case 16: {
                    break;
                }
                default: {
                    throw new FilterBuilderException("Binary spatial operator unexpected");
                }
            }
            return filter;
        }

        private PropertyIsEqualTo buildPropertyExists() throws FilterBuilderException {
            PropertyName property = this.resultStack.popPropertyName();
            Expression[] args = new Expression[1];
            String propertyName = property.getPropertyName();
            args[0] = this.filterFactory.literal((Object)propertyName);
            Function function = this.filterFactory.function("PropertyExists", args);
            Literal literalTrue = this.filterFactory.literal((Object)Boolean.TRUE);
            PropertyIsEqualTo propExistsFilter = this.filterFactory.equals((Expression)function, (Expression)literalTrue);
            return propExistsFilter;
        }

        private Filter buildTemporalPredicateBeforeOrDuring() throws FilterBuilderException {
            PropertyIsLessThanOrEqualTo filter = null;
            Result node = this.resultStack.peek();
            switch (node.getNodeType()) {
                case 34: 
                case 35: 
                case 36: {
                    filter = this.buildPropertyIsLTELastDate();
                    break;
                }
                default: {
                    throw new FilterBuilderException("unexpeted date time expression in temporal predicate.", node.getToken());
                }
            }
            return filter;
        }

        private Filter buildTemporalPredicateDuringOrAfter() throws FilterBuilderException {
            PropertyIsGreaterThanOrEqualTo filter = null;
            Result node = this.resultStack.peek();
            switch (node.getNodeType()) {
                case 34: 
                case 35: 
                case 36: {
                    filter = this.buildPropertyIsGTEFirstDate();
                    break;
                }
                default: {
                    throw new FilterBuilderException("unexpeted date time expression in temporal predicate.", node.getToken());
                }
            }
            return filter;
        }

        private Literal buildDateTimeExpression() throws FilterBuilderException {
            Literal literalDate = null;
            Token token = this.getToken(0);
            try {
                Date dateTime = DATE_FORMAT.parse(token.image);
                literalDate = this.filterFactory.literal((Object)dateTime);
                return literalDate;
            }
            catch (java.text.ParseException e) {
                throw new FilterBuilderException("Unsupported date time format", token);
            }
        }

        private PeriodNode buildPeriodBetweenDates() throws FilterBuilderException {
            Literal end = this.resultStack.popLiteral();
            Literal begin = this.resultStack.popLiteral();
            PeriodNode period = PeriodNode.createPeriodDateAndDate(begin, end);
            return period;
        }

        private PeriodNode buildPeriodDurationAndDate() throws FilterBuilderException {
            Literal date = this.resultStack.popLiteral();
            Literal duration = this.resultStack.popLiteral();
            PeriodNode period = PeriodNode.createPeriodDurationAndDate(duration, date, (org.opengis.filter.FilterFactory)this.filterFactory);
            return period;
        }

        private PeriodNode buildPeriodDateAndDuration() throws FilterBuilderException {
            Literal duration = this.resultStack.popLiteral();
            Literal date = this.resultStack.popLiteral();
            PeriodNode period = PeriodNode.createPeriodDateAndDuration(date, duration, (org.opengis.filter.FilterFactory)this.filterFactory);
            return period;
        }

        private Literal buildDurationExpression() {
            Token token = this.getToken(0);
            String duration = token.image;
            Literal literalDuration = this.filterFactory.literal((Object)duration);
            return literalDuration;
        }

        private Filter buildTemporalPredicateBefore() throws FilterBuilderException {
            PropertyIsLessThan filter = null;
            Result node = this.resultStack.peek();
            switch (node.getNodeType()) {
                case 37: {
                    filter = this.buildBinaryComparasionOperator(23);
                    break;
                }
                case 34: 
                case 35: 
                case 36: {
                    filter = this.buildPropertyIsLTFirsDate();
                    break;
                }
                default: {
                    throw new FilterBuilderException("unexpeted date time expression in temporal predicate.", node.getToken());
                }
            }
            return filter;
        }

        private Object buildTemporalPredicateDuring() throws FilterBuilderException {
            Filter filter = null;
            Result node = this.resultStack.peek();
            switch (node.getNodeType()) {
                case 34: 
                case 35: 
                case 36: {
                    filter = this.buildPropertyBetweenDates();
                    break;
                }
                default: {
                    throw new FilterBuilderException("unexpeted period expression in temporal predicate.", node.getToken());
                }
            }
            return filter;
        }

        private Filter buildPropertyBetweenDates() throws FilterBuilderException {
            Result node = this.resultStack.popResult();
            PeriodNode period = (PeriodNode)node.getBuilt();
            Literal begin = period.getBeginning();
            Literal end = period.getEnding();
            Expression property = this.resultStack.popExpression();
            And filter = this.filterFactory.and((Filter)this.filterFactory.lessOrEqual((Expression)begin, property), (Filter)this.filterFactory.lessOrEqual(property, (Expression)end));
            return filter;
        }

        private Filter buildTemporalPredicateAfter() throws FilterBuilderException {
            PropertyIsGreaterThan filter = null;
            Result node = this.resultStack.peek();
            switch (node.getNodeType()) {
                case 37: {
                    filter = this.buildBinaryComparasionOperator(22);
                    break;
                }
                case 34: 
                case 35: 
                case 36: {
                    filter = this.buildPropertyIsGTLastDate();
                    break;
                }
                default: {
                    throw new FilterBuilderException("unexpeted date time expression in temporal predicate.", node.getToken());
                }
            }
            return filter;
        }

        private PropertyIsGreaterThan buildPropertyIsGTLastDate() throws FilterBuilderException {
            Result node = this.resultStack.popResult();
            PeriodNode period = (PeriodNode)node.getBuilt();
            Literal date = period.getEnding();
            Expression property = this.resultStack.popExpression();
            PropertyIsGreaterThan filter = this.filterFactory.greater(property, (Expression)date);
            return filter;
        }

        private PropertyIsGreaterThanOrEqualTo buildPropertyIsGTEFirstDate() throws FilterBuilderException {
            Result node = this.resultStack.popResult();
            PeriodNode period = (PeriodNode)node.getBuilt();
            Literal begin = period.getBeginning();
            Expression property = this.resultStack.popExpression();
            PropertyIsGreaterThanOrEqualTo filter = this.filterFactory.greaterOrEqual(property, (Expression)begin);
            return filter;
        }

        private PropertyIsLessThan buildPropertyIsLTFirsDate() throws FilterBuilderException {
            PeriodNode period = this.resultStack.popPeriod();
            Literal date = period.getBeginning();
            Expression property = this.resultStack.popExpression();
            PropertyIsLessThan filter = this.filterFactory.less(property, (Expression)date);
            return filter;
        }

        private PropertyIsLessThanOrEqualTo buildPropertyIsLTELastDate() throws FilterBuilderException {
            PeriodNode period = this.resultStack.popPeriod();
            Literal date = period.getEnding();
            Expression property = this.resultStack.popExpression();
            PropertyIsLessThanOrEqualTo filter = this.filterFactory.lessOrEqual(property, (Expression)date);
            return filter;
        }

        private BinaryComparisonOperator buildBinaryComparasionOperator(int filterType) throws FilterBuilderException {
            Expression right = this.resultStack.popExpression();
            Expression left = this.resultStack.popExpression();
            switch (filterType) {
                case 21: {
                    return this.filterFactory.equals(left, right);
                }
                case 22: {
                    return this.filterFactory.greater(left, right);
                }
                case 23: {
                    return this.filterFactory.less(left, right);
                }
                case 24: {
                    return this.filterFactory.greaterOrEqual(left, right);
                }
                case 25: {
                    return this.filterFactory.lessOrEqual(left, right);
                }
            }
            throw new FilterBuilderException("unexpeted filter type.");
        }

        private Literal buildGeometry(Token geometry) throws FilterBuilderException {
            try {
                String wktGeom = this.scanExpression(geometry);
                String vividGeom = this.transformWKTGeometry(wktGeom);
                Geometry g = WKT_READER.read(vividGeom);
                Literal literal = this.filterFactory.literal((Object)g);
                return literal;
            }
            catch (com.vividsolutions.jts.io.ParseException e) {
                throw new FilterBuilderException(e.getMessage(), geometry);
            }
            catch (Exception e) {
                throw new FilterBuilderException("Error building WKT Geometry", geometry, e);
            }
        }

        private String scanExpression(Token initialTocken) {
            Token end = initialTocken;
            while (end.next != null) {
                end = end.next;
            }
            String wktGeom = this.input.substring(initialTocken.beginColumn - 1, end.endColumn);
            return wktGeom;
        }

        private String transformWKTGeometry(String wktGeom) {
            String MULTIPOINT_TYPE = "MULTIPOINT";
            StringBuffer transformed = new StringBuffer(30);
            StringBuffer source = new StringBuffer(wktGeom.toUpperCase());
            int cur = -1;
            cur = source.indexOf("MULTIPOINT");
            if (cur != -1) {
                String argument = source.substring(cur + "MULTIPOINT".length() + 1, source.length() - 1);
                argument = argument.replace('(', ' ');
                argument = argument.replace(')', ' ');
                transformed.append("MULTIPOINT").append("(").append(argument).append(")");
                return transformed.toString();
            }
            return wktGeom;
        }

        private Literal buildEnvelop(Token token) {
            String source = this.scanExpression(token);
            String ENVELOPE_TYPE = "ENVELOPE";
            int cur = source.indexOf("ENVELOPE");
            cur = cur + "ENVELOPE".length() + 1;
            String argument = source.substring(cur, source.length() - 1);
            String comma = ",";
            cur = 0;
            int end = argument.indexOf(",", cur);
            String west = argument.substring(cur, end);
            double minX = Double.parseDouble(west);
            cur = end + 1;
            end = argument.indexOf(",", cur);
            String east = argument.substring(cur, end);
            double maxX = Double.parseDouble(east);
            cur = end + 1;
            end = argument.indexOf(",", cur);
            String north = argument.substring(cur, end);
            double maxY = Double.parseDouble(north);
            cur = end + 1;
            String south = argument.substring(cur);
            double minY = Double.parseDouble(south);
            GeometryFactory gf = new GeometryFactory();
            Coordinate[] coords = new Coordinate[]{new Coordinate(minX, minY), new Coordinate(minX, maxY), new Coordinate(maxX, maxY), new Coordinate(maxX, minY), new Coordinate(minX, minY)};
            LinearRing shell = gf.createLinearRing(coords);
            Polygon bbox = gf.createPolygon(shell, null);
            bbox.setUserData((Object)DefaultGeographicCRS.WGS84);
            Literal literal = this.filterFactory.literal((Object)bbox);
            return literal;
        }

        private Function buildFunction(Node n) throws FilterBuilderException {
            FilterFactoryImpl ff = (FilterFactoryImpl)this.filterFactory;
            String functionName = null;
            LinkedList<Expression> argList = new LinkedList<Expression>();
            while (!this.resultStack.empty()) {
                Result node = this.resultStack.peek();
                if (node.getNodeType() == 60) {
                    Result funcNameNode = this.resultStack.popResult();
                    functionName = funcNameNode.getToken().image;
                    break;
                }
                this.resultStack.popResult();
                Expression arg = this.resultStack.popExpression();
                argList.add(arg);
            }
            Collections.reverse(argList);
            Expression[] args = argList.toArray(new Expression[argList.size()]);
            Function function = ff.function(functionName, args);
            if (function == null) {
                throw new FilterBuilderException("function not found: ", this.token);
            }
            return function;
        }
    }
}

