/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.display.canvas.AbstractGraphic;
import org.geotools.display.canvas.DisplayObject;
import org.geotools.display.canvas.HintKey;
import org.geotools.factory.Hints;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.go.display.DisplayFactory;
import org.opengis.go.display.canvas.Canvas;
import org.opengis.go.display.canvas.CanvasHandler;
import org.opengis.go.display.canvas.CanvasListener;
import org.opengis.go.display.event.EventManager;
import org.opengis.go.display.primitive.Graphic;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.operation.IncompatibleOperationException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.InternationalString;

public abstract class AbstractCanvas
extends DisplayObject
implements Canvas {
    public static final RenderingHints.Key FINEST_RESOLUTION;
    public static final RenderingHints.Key REQUIRED_RESOLUTION;
    public static final RenderingHints.Key PREFETCH;
    private static final Comparator COMPARATOR;
    static final PropertyChangeListener PROPERTIES_LISTENER;
    private static volatile int nextUID;
    private final DisplayFactory factory;
    private final String UID;
    private CharSequence title;
    private final Map graphics = new LinkedHashMap();
    private transient List sortedGraphics;
    protected final Hints hints;
    private boolean prefetch = Runtime.getRuntime().availableProcessors() >= 2;
    private double minResolution;
    private double maxResolution;
    private boolean hasGraphicsListeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractCanvas(DisplayFactory factory, Hints hints) {
        this.factory = factory;
        this.UID = Utilities.getShortClassName(this) + '-' + String.valueOf(++nextUID);
        this.hints = new Hints((Map)hints);
    }

    public DisplayFactory getFactory() {
        return this.factory;
    }

    public String getUID() {
        return this.UID;
    }

    public synchronized String getTitle() {
        return this.title instanceof InternationalString ? ((InternationalString)this.title).toString(this.getLocale()) : (String)this.title;
    }

    public synchronized void setTitle(String title) {
        CharSequence old = this.title;
        this.title = title;
        this.listeners.firePropertyChange("title", old, title);
    }

    public synchronized void setTitle(InternationalString title) {
        CharSequence old = this.title;
        this.title = title;
        this.listeners.firePropertyChange("title", old, title);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Graphic add(Graphic graphic) throws IllegalArgumentException {
        Graphic previous;
        List oldGraphics = this.sortedGraphics;
        if (graphic instanceof AbstractGraphic) {
            AbstractGraphic candidate = (AbstractGraphic)graphic;
            Object object = candidate.getTreeLock();
            synchronized (object) {
                Canvas canvas = candidate.getCanvas();
                if (canvas == this) {
                    if (!$assertionsDisabled && !this.graphics.containsKey(candidate)) {
                        throw new AssertionError(candidate);
                    }
                } else {
                    if (!$assertionsDisabled && this.graphics.containsKey(candidate)) {
                        throw new AssertionError(candidate);
                    }
                    if (canvas != null) {
                        try {
                            candidate = (AbstractGraphic)candidate.clone();
                            graphic = candidate;
                        }
                        catch (CloneNotSupportedException e) {
                            throw new IllegalArgumentException(Errors.format(121, graphic.getName()));
                        }
                    }
                    candidate.setCanvas(this);
                    candidate.addPropertyChangeListener(PROPERTIES_LISTENER);
                }
            }
            if (!$assertionsDisabled && !Thread.holdsLock(candidate.getTreeLock())) {
                throw new AssertionError();
            }
        }
        if ((previous = this.graphics.put(graphic, graphic)) != null) {
            graphic = previous;
            this.graphics.put(graphic, graphic);
        }
        this.sortedGraphics = null;
        if (!$assertionsDisabled && oldGraphics != null && !this.getGraphics().containsAll(oldGraphics)) {
            throw new AssertionError(oldGraphics);
        }
        if (this.hasGraphicsListeners) {
            this.listeners.firePropertyChange("graphics", oldGraphics, this.getGraphics());
        }
        return graphic;
    }

    public Graphic addAsEditable(Graphic graphic) {
        graphic = this.add(graphic);
        graphic.setAutoEdit(true);
        return graphic;
    }

    public synchronized void remove(Graphic graphic) throws IllegalArgumentException {
        List oldGraphics = this.sortedGraphics;
        if (graphic instanceof AbstractGraphic) {
            AbstractGraphic candidate = (AbstractGraphic)graphic;
            Canvas canvas = candidate.getCanvas();
            if (canvas == null) {
                if (!$assertionsDisabled && this.graphics.containsKey(candidate)) {
                    throw new AssertionError(candidate);
                }
                return;
            }
            if (canvas != this) {
                if (!$assertionsDisabled && this.graphics.containsKey(candidate)) {
                    throw new AssertionError(candidate);
                }
                throw new IllegalArgumentException(Errors.format(121, candidate.getName()));
            }
            if (!$assertionsDisabled && !Thread.holdsLock(candidate.getTreeLock())) {
                throw new AssertionError();
            }
            candidate.removePropertyChangeListener(PROPERTIES_LISTENER);
            candidate.clearCache();
            candidate.setCanvas(null);
        } else if (!this.graphics.containsKey(graphic)) {
            return;
        }
        if (this.graphics.remove(graphic) != graphic) {
            throw new AssertionError(graphic);
        }
        this.sortedGraphics = null;
        if (!$assertionsDisabled && oldGraphics != null && !oldGraphics.containsAll(this.getGraphics())) {
            throw new AssertionError(oldGraphics);
        }
        if (this.hasGraphicsListeners) {
            this.listeners.firePropertyChange("graphics", oldGraphics, this.getGraphics());
        }
    }

    public synchronized void removeAll() {
        List oldGraphics = this.sortedGraphics;
        Iterator it = this.graphics.keySet().iterator();
        while (it.hasNext()) {
            Graphic graphic = (Graphic)it.next();
            if (!(graphic instanceof AbstractGraphic)) continue;
            AbstractGraphic candidate = (AbstractGraphic)graphic;
            if (!$assertionsDisabled && !Thread.holdsLock(candidate.getTreeLock())) {
                throw new AssertionError();
            }
            candidate.removePropertyChangeListener(PROPERTIES_LISTENER);
            candidate.clearCache();
            candidate.setCanvas(null);
        }
        this.sortedGraphics = null;
        this.clearCache();
        if (this.hasGraphicsListeners) {
            this.listeners.firePropertyChange("graphics", oldGraphics, this.getGraphics());
        }
    }

    public synchronized List getGraphics() {
        if (this.sortedGraphics == null) {
            Set keys = this.graphics.keySet();
            Object[] list = keys.toArray(new Graphic[keys.size()]);
            Arrays.sort(list, COMPARATOR);
            this.sortedGraphics = new UnmodifiableArrayList(list);
        }
        if (!$assertionsDisabled && this.sortedGraphics.size() != this.graphics.size()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !this.graphics.keySet().containsAll(this.sortedGraphics)) {
            throw new AssertionError();
        }
        return this.sortedGraphics;
    }

    protected void graphicPropertyChanged(AbstractGraphic graphic, PropertyChangeEvent event) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        String propertyName = event.getPropertyName();
        if (propertyName.equalsIgnoreCase("zOrderHint")) {
            this.sortedGraphics = null;
            return;
        }
    }

    public void addEventManager(EventManager eventManager) {
        throw new UnsupportedOperationException();
    }

    public EventManager findEventManager(Class type) {
        return null;
    }

    public void disposeEventManagers() {
    }

    public void addCanvasListener(CanvasListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeCanvasListener(CanvasListener listener) {
    }

    public void enableCanvasHandler(CanvasHandler handler) {
        throw new UnsupportedOperationException();
    }

    public void removeCanvasHandler(CanvasHandler handler) {
    }

    public CanvasHandler getActiveCanvasHandler() {
        return null;
    }

    public final CoordinateReferenceSystem getDisplayCoordinateReferenceSystem() {
        DerivedCRS displayCRS = this.getDisplayCRS();
        if (!$assertionsDisabled && !Utilities.equals(displayCRS.getBaseCRS(), this.getObjectiveCRS())) {
            throw new AssertionError(displayCRS);
        }
        if (!$assertionsDisabled && !Utilities.equals(displayCRS.getCoordinateSystem(), this.getDeviceCRS().getCoordinateSystem())) {
            throw new AssertionError(displayCRS);
        }
        return displayCRS;
    }

    public final CoordinateReferenceSystem getObjectiveCoordinateReferenceSystem() {
        return this.getObjectiveCRS();
    }

    public final void setObjectiveCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        try {
            this.setObjectiveCRS(crs);
        }
        catch (TransformException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    public void setObjectiveCoordinateReferenceSystem(CoordinateReferenceSystem crs, MathTransform objectiveToDisplay, MathTransform displayToObjective) throws IncompatibleOperationException {
        try {
            if (objectiveToDisplay.equals(displayToObjective.inverse())) {
                throw new IncompatibleOperationException(null, null);
            }
        }
        catch (NoninvertibleTransformException exception) {
            throw new IncompatibleOperationException(exception.getLocalizedMessage(), "inverse");
        }
        try {
            this.setObjectiveToDisplayTransform(objectiveToDisplay);
        }
        catch (TransformException e) {
            throw new IncompatibleOperationException(e.getLocalizedMessage(), "createDerivedCRS");
        }
        this.setObjectiveCoordinateReferenceSystem(crs);
    }

    public abstract CoordinateReferenceSystem getObjectiveCRS();

    public abstract void setObjectiveCRS(CoordinateReferenceSystem var1) throws TransformException;

    public abstract DerivedCRS getDisplayCRS();

    public DerivedCRS getDeviceCRS() {
        return this.getDisplayCRS();
    }

    public abstract void setObjectiveToDisplayTransform(MathTransform var1) throws TransformException;

    final boolean allowPrefetch() {
        return this.prefetch;
    }

    public synchronized Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public synchronized void setRenderingHint(RenderingHints.Key key, Object value) {
        if (value != null) {
            if (!value.equals(this.hints.put(key, value))) {
                this.clearCache();
            }
        } else if (this.hints.remove(key) != null) {
            this.clearCache();
        }
        if (FINEST_RESOLUTION.equals(key)) {
            if (value != null) {
                this.minResolution = ((Number)this.hints.get(key)).floatValue();
                if (this.minResolution >= 0.0) {
                    if (this.minResolution > this.maxResolution) {
                        this.maxResolution = this.minResolution;
                    }
                    return;
                }
            }
            this.minResolution = 0.0;
            return;
        }
        if (REQUIRED_RESOLUTION.equals(key)) {
            if (value != null) {
                this.maxResolution = ((Number)this.hints.get(key)).floatValue();
                if (this.maxResolution >= 0.0) {
                    if (this.maxResolution < this.minResolution) {
                        this.minResolution = this.maxResolution;
                    }
                    return;
                }
            }
            this.maxResolution = this.minResolution;
            return;
        }
        if (PREFETCH.equals(key)) {
            this.prefetch = value != null ? (Boolean)value : Runtime.getRuntime().availableProcessors() >= 2;
            return;
        }
    }

    void listenersChanged() {
        super.listenersChanged();
        this.hasGraphicsListeners = this.listeners.hasListeners("graphics");
    }

    protected void clearCache() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        List graphics = this.getGraphics();
        int i = graphics.size();
        while (--i >= 0) {
            Graphic graphic = (Graphic)graphics.get(i);
            if (!(graphic instanceof DisplayObject)) continue;
            ((DisplayObject)graphic).clearCache();
        }
        super.clearCache();
    }

    public synchronized void dispose() {
        List graphics = this.getGraphics();
        this.removeAll();
        int i = graphics.size();
        while (--i >= 0) {
            Graphic graphic = (Graphic)graphics.get(i);
            graphic.dispose();
        }
        super.dispose();
    }

    public synchronized String toString() {
        Graphic graphic;
        int i;
        List graphics = this.getGraphics();
        String lineSeparator = System.getProperty("line.separator", "\n");
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append("[\"");
        buffer.append(this.getTitle());
        buffer.append("\", ");
        buffer.append(graphics.size());
        buffer.append(" graphics]");
        buffer.append(lineSeparator);
        int maxLength = 0;
        String[] names = new String[graphics.size()];
        for (i = 0; i < names.length; ++i) {
            graphic = (Graphic)graphics.get(i);
            names[i] = String.valueOf(graphic).trim();
            String name = names[i];
            int length = name.length();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        for (i = 0; i < names.length; ++i) {
            graphic = (Graphic)graphics.get(i);
            buffer.append("    ");
            buffer.append(names[i]);
            String ext = this.toStringExt(graphic);
            if (ext != null) {
                buffer.append(Utilities.spaces(maxLength - names[i].length() + 3));
                buffer.append('(');
                buffer.append(ext);
                buffer.append(')');
            }
            buffer.append(lineSeparator);
        }
        return buffer.toString();
    }

    String toStringExt(Graphic graphic) {
        return null;
    }

    static {
        $assertionsDisabled = !AbstractCanvas.class.desiredAssertionStatus();
        FINEST_RESOLUTION = new HintKey(0, Number.class);
        REQUIRED_RESOLUTION = new HintKey(1, Number.class);
        PREFETCH = new HintKey(2, Boolean.class);
        COMPARATOR = new Comparator(){

            public int compare(Object graphic1, Object graphic2) {
                return Double.compare(((Graphic)graphic1).getZOrderHint(), ((Graphic)graphic2).getZOrderHint());
            }
        };
        PROPERTIES_LISTENER = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent event) {
                AbstractGraphic graphic;
                Canvas target;
                Object source = event.getSource();
                if (source instanceof Graphic && (target = (graphic = (AbstractGraphic)source).getCanvas()) instanceof AbstractCanvas) {
                    Canvas canvas = target;
                    synchronized (canvas) {
                        ((AbstractCanvas)target).graphicPropertyChanged(graphic, event);
                    }
                }
            }
        };
    }
}

