/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.beans.PropertyChangeListener;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.logging.Logger;
import org.geotools.display.canvas.AbstractCanvas;
import org.geotools.display.canvas.DisplayObject;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.go.display.canvas.Canvas;
import org.opengis.go.display.event.GraphicEvent;
import org.opengis.go.display.event.GraphicListener;
import org.opengis.go.display.primitive.Graphic;
import org.opengis.go.display.style.GraphicStyle;
import org.opengis.go.display.style.Symbology;

public abstract class AbstractGraphic
extends DisplayObject
implements Graphic {
    private static final double DEFAULT_Z_ORDER = Double.POSITIVE_INFINITY;
    private static Format format;
    private Canvas canvas;
    private String name;
    private Graphic parent;
    private boolean visible = true;
    private double zOrder = Double.POSITIVE_INFINITY;
    boolean hasScaleListeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractGraphic() {
    }

    final Canvas getCanvas() {
        return this.canvas;
    }

    final void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public Locale getLocale() {
        Canvas canvas = this.getCanvas();
        if (canvas instanceof DisplayObject) {
            return ((DisplayObject)canvas).getLocale();
        }
        return super.getLocale();
    }

    public String getName() {
        String name = this.name;
        if (name != null) {
            return name;
        }
        Locale locale = this.getLocale();
        Format f = format;
        if (f == null || !f.locale.equals(locale)) {
            format = f = new Format(locale);
        }
        StringBuffer buffer = new StringBuffer("z=");
        return f.format.format(this.getZOrderHint(), buffer, new FieldPosition(0)).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String name) {
        Object object = this.getTreeLock();
        synchronized (object) {
            String old = this.name;
            this.name = name;
            this.listeners.firePropertyChange("name", old, name);
        }
    }

    public Graphic getParent() {
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParent(Graphic parent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Graphic old = this.parent;
            this.parent = parent;
            this.listeners.firePropertyChange("parent", old, this.name);
        }
    }

    public void setGraphicStyle(GraphicStyle style) {
        throw new UnsupportedOperationException();
    }

    public GraphicStyle getGraphicStyle() {
        throw new UnsupportedOperationException();
    }

    public Object getClientProperty(Object key) {
        return null;
    }

    public void putClientProperty(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setPassingEventsToParent(boolean passToParent) {
        throw new UnsupportedOperationException();
    }

    public boolean isPassingEventsToParent() {
        throw new UnsupportedOperationException();
    }

    public void setShowingEditHandles(boolean showingHandles) {
        throw new UnsupportedOperationException();
    }

    public boolean isShowingEditHandles() {
        throw new UnsupportedOperationException();
    }

    public void setShowingAnchorHandles(boolean showingHandles) {
        throw new UnsupportedOperationException();
    }

    public boolean isShowingAnchorHandles() {
        throw new UnsupportedOperationException();
    }

    public void addGraphicListener(GraphicListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeGraphicListener(GraphicListener listener) {
        throw new UnsupportedOperationException();
    }

    public void fireGraphicEvent(GraphicEvent event) {
        throw new UnsupportedOperationException();
    }

    public boolean getAutoEdit() {
        throw new UnsupportedOperationException();
    }

    public void setAutoEdit(boolean autoEdit) {
        throw new UnsupportedOperationException();
    }

    public boolean getDragSelectable() {
        throw new UnsupportedOperationException();
    }

    public void setDragSelectable(boolean dragSelectable) {
        throw new UnsupportedOperationException();
    }

    public boolean getPickable() {
        throw new UnsupportedOperationException();
    }

    public void setPickable(boolean pickable) {
        throw new UnsupportedOperationException();
    }

    public boolean getSelected() {
        throw new UnsupportedOperationException();
    }

    public void setSelected(boolean selected) {
        throw new UnsupportedOperationException();
    }

    public boolean getBlinking() {
        throw new UnsupportedOperationException();
    }

    public void setBlinking(boolean blinking) {
        throw new UnsupportedOperationException();
    }

    public float[] getBlinkPattern() {
        throw new UnsupportedOperationException();
    }

    public void setBlinkPattern(float[] blinkPattern) {
        throw new UnsupportedOperationException();
    }

    public Symbology getSymbology() {
        throw new UnsupportedOperationException();
    }

    public void setSymbology(Symbology symbology) {
        throw new UnsupportedOperationException();
    }

    public double getMaxScale() {
        throw new UnsupportedOperationException();
    }

    public void setMaxScale(double maxScale) {
        throw new UnsupportedOperationException();
    }

    public double getMinScale() {
        throw new UnsupportedOperationException();
    }

    public void setMinScale(double minScale) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getZOrderHint() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.zOrder;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setZOrderHint(double zOrderHint) {
        if (Double.isNaN(zOrderHint)) {
            throw new IllegalArgumentException(Errors.getResources(this.getLocale()).getString(42, "zOrderHint", new Double(zOrderHint)));
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            double oldZOrder = this.zOrder;
            if (zOrderHint == oldZOrder) {
                return;
            }
            this.zOrder = zOrderHint;
            this.refresh();
            this.listeners.firePropertyChange("zOrderHint", new Double(oldZOrder), new Double(zOrderHint));
        }
    }

    public boolean getVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (visible == this.visible) {
                return;
            }
            this.visible = visible;
            this.refresh();
            this.listeners.firePropertyChange("visible", !visible, visible);
        }
    }

    public void refresh() {
    }

    public final Graphic cloneGraphic() throws IllegalStateException {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                return (Graphic)this.clone();
            }
            catch (CloneNotSupportedException exception) {
                throw new IllegalStateException(exception.getLocalizedMessage());
            }
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        if (!$assertionsDisabled && !Thread.holdsLock(this.getTreeLock())) {
            throw new AssertionError();
        }
        AbstractGraphic clone = (AbstractGraphic)super.clone();
        clone.canvas = null;
        clone.parent = null;
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.getTreeLock();
        synchronized (object) {
            Canvas canvas = this.getCanvas();
            if (canvas != null) {
                canvas.remove((Graphic)this);
            }
            super.dispose();
        }
    }

    void listenersChanged() {
        super.listenersChanged();
        this.hasScaleListeners = this.hasListeners("scale");
    }

    final boolean hasListeners(String property) {
        if (this.listeners.hasListeners(property)) {
            PropertyChangeListener[] list = this.listeners.getPropertyChangeListeners();
            for (int i = 0; i < list.length; ++i) {
                if (list[i] == AbstractCanvas.PROPERTIES_LISTENER) continue;
                return true;
            }
        }
        return false;
    }

    protected Logger getLogger() {
        Canvas canvas = this.getCanvas();
        if (canvas instanceof DisplayObject) {
            return ((DisplayObject)canvas).getLogger();
        }
        return super.getLogger();
    }

    protected final Object getTreeLock() {
        Canvas canvas = this.canvas;
        return canvas != null ? canvas : this;
    }

    public String toString() {
        return Utilities.getShortClassName(this) + '[' + this.getName() + ']';
    }

    static {
        $assertionsDisabled = !AbstractGraphic.class.desiredAssertionStatus();
    }

    private static final class Format {
        public final Locale locale;
        public final NumberFormat format;

        public Format(Locale locale) {
            this.locale = locale;
            this.format = NumberFormat.getNumberInstance(locale);
        }
    }
}

