/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.VolatileImage;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.media.jai.GraphicsJAI;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import org.geotools.display.canvas.AbstractGraphic;
import org.geotools.display.canvas.GraphicPrimitive2D;
import org.geotools.display.canvas.ImageType;
import org.geotools.display.canvas.ReferencedCanvas2D;
import org.geotools.display.canvas.RenderingContext;
import org.geotools.display.canvas.RenderingStatistics;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.GraphicsUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.RangeSet;
import org.opengis.go.display.DisplayFactory;
import org.opengis.go.display.primitive.Graphic;
import org.opengis.referencing.operation.TransformException;

public class BufferedCanvas2D
extends ReferencedCanvas2D {
    private static final boolean ENABLE_JAI = true;
    private static final double SCALE_ZOOM_CHANGE = 1.000001;
    private Image[] offscreenBuffers;
    private boolean[] offscreenIsVolatile;
    private boolean[] offscreenNeedRepaint;
    private RangeSet offscreenZRanges;
    private transient RenderingStatistics statistics;
    private transient boolean isPrinting;
    private final Component owner;
    private final ComponentListener listener = new ComponentListener();
    static final /* synthetic */ boolean $assertionsDisabled;

    public BufferedCanvas2D(DisplayFactory factory, Component owner) {
        super(factory);
        this.owner = owner;
        if (owner != null) {
            owner.addComponentListener(this.listener);
        }
    }

    public String getTitle() {
        String title = super.getTitle();
        if (title == null) {
            for (Component c = this.owner; c != null; c = c.getParent()) {
                if (c instanceof Frame) {
                    title = ((Frame)c).getTitle();
                    break;
                }
                if (c instanceof Dialog) {
                    title = ((Dialog)c).getTitle();
                    break;
                }
                if (!(c instanceof JInternalFrame)) continue;
                title = ((JInternalFrame)c).getTitle();
                break;
            }
        }
        return title;
    }

    public Locale getLocale() {
        block3: {
            if (this.owner != null) {
                try {
                    return this.owner.getLocale();
                }
                catch (IllegalComponentStateException exception) {
                    if (!(this.owner instanceof JComponent)) break block3;
                    return JComponent.getDefaultLocale();
                }
            }
        }
        return super.getLocale();
    }

    public synchronized Shape getDisplayBounds() {
        Shape bounds = super.getDisplayBounds();
        if (bounds.equals(XRectangle2D.INFINITY) && this.owner != null) {
            bounds = this.owner.getBounds();
        }
        return bounds;
    }

    private void checkDisplayBounds() {
        if (super.getDisplayBounds().equals(XRectangle2D.INFINITY)) {
            this.listeners.firePropertyChange("displayBounds", null, null);
        }
    }

    public synchronized Graphic add(Graphic graphic) {
        graphic = super.add(graphic);
        this.flushOffscreenBuffer(graphic.getZOrderHint());
        this.repaint();
        return graphic;
    }

    public synchronized void remove(Graphic graphic) {
        this.repaint();
        this.flushOffscreenBuffer(graphic.getZOrderHint());
        super.remove(graphic);
    }

    public synchronized void removeAll() {
        this.repaint();
        this.flushOffscreenBuffers();
        super.removeAll();
    }

    protected void graphicPropertyChanged(AbstractGraphic graphic, PropertyChangeEvent event) {
        Object value;
        super.graphicPropertyChanged(graphic, event);
        String propertyName = event.getPropertyName();
        if (propertyName.equalsIgnoreCase("zOrderHint") && (value = event.getOldValue()) instanceof Number) {
            double oldZOrder = ((Number)value).doubleValue();
            this.flushOffscreenBuffer(oldZOrder);
        }
    }

    private static int validate(Image image, GraphicsConfiguration config) {
        if (image == null) {
            return 2;
        }
        if (image instanceof VolatileImage) {
            return ((VolatileImage)image).validate(config);
        }
        return 0;
    }

    private static boolean contentsLost(Image image) {
        if (image instanceof VolatileImage) {
            return ((VolatileImage)image).contentsLost();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void print(Graphics2D output, AffineTransform zoom) {
        this.isPrinting = true;
        try {
            this.paint(output, zoom);
        }
        finally {
            this.isPrinting = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized void paint(Graphics2D output, AffineTransform zoom) {
        if (!BufferedCanvas2D.$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (this.statistics == null) {
            this.statistics = new RenderingStatistics(this.getLogger());
        }
        this.statistics.init();
        output = GraphicsJAI.createGraphicsJAI((Graphics2D)output, (Component)this.owner);
        displayBounds = this.getDisplayBounds().getBounds();
        clipBounds = output.getClipBounds();
        dirtyArea = XRectangle2D.INFINITY;
        if (clipBounds == null) {
            clipBounds = displayBounds;
        } else if (displayBounds.contains(clipBounds)) {
            dirtyArea = clipBounds;
        }
        this.paintStarted(dirtyArea);
        config = output.getDeviceConfiguration();
        if (!this.objectiveToDisplay.equals(zoom)) {
            try {
                change = this.objectiveToDisplay.createInverse();
                change.preConcatenate(zoom);
                centerX = displayBounds.getCenterX();
                centerY = displayBounds.getCenterY();
                change.translate(centerX, centerY);
                change.scale(1.000001, 1.000001);
                change.translate(-centerX, -centerY);
                this.zoomChanged(change);
            }
            catch (NoninvertibleTransformException exception) {
                this.handleException("BufferedCanvas2D", "paint", exception);
                this.zoomChanged(null);
            }
            try {
                normalize = zoom.createInverse();
                normalize.concatenate(config.getNormalizingTransform());
                normalize.preConcatenate(this.normalizeToDots);
                this.setScale(1.0 / XAffineTransform.getScale(normalize));
            }
            catch (NoninvertibleTransformException exception) {
                this.handleException("BufferedCanvas2D", "paint", exception);
            }
            this.objectiveToDisplay.setTransform(zoom);
            try {
                this.setObjectiveToDisplayTransform(this.objectiveToDisplay);
            }
            catch (TransformException exception) {
                GraphicsUtilities.paintStackTrace(output, displayBounds, exception);
                this.paintFinished(false);
                return;
            }
        }
        this.displayToDevice.setToTranslation(-displayBounds.x, -displayBounds.y);
        try {
            this.setDisplayToDeviceTransform(this.displayToDevice);
        }
        catch (TransformException exception) {
            GraphicsUtilities.paintStackTrace(output, displayBounds, exception);
            this.paintFinished(false);
            return;
        }
        offscreenCount = this.isPrinting == false && this.offscreenZRanges != null ? this.offscreenZRanges.size() : 0;
        for (i = 0; i < offscreenCount; ++i) {
            buffer = this.offscreenBuffers[i];
            if (buffer == null || buffer.getWidth(this.owner) == displayBounds.width && buffer.getHeight(this.owner) == displayBounds.height) continue;
            buffer.flush();
            this.offscreenBuffers[i] = null;
            this.offscreenNeedRepaint[i] = true;
        }
        graphics = this.getGraphics();
        graphicCount = graphics.size();
        success = false;
        output.addRenderingHints(this.hints);
        context = new RenderingContext(this, displayBounds, this.isPrinting);
        try {
            context.setGraphics(output, zoom);
            if (this.allowPrefetch()) {
                for (i = 0; i < graphicCount; ++i) {
                    candidate = (Graphic)graphics.get(i);
                    if (!(candidate instanceof GraphicPrimitive2D)) continue;
                    ((GraphicPrimitive2D)candidate).prefetch(context);
                }
            }
            offscreenIndex = -1;
            minZOrder = -Infinity;
            maxZOrder = NaN;
            for (graphicIndex = 0; graphicIndex < graphicCount; ++graphicIndex) {
                graphicIndexUp = graphicIndex;
                candidate = (Graphic)graphics.get(graphicIndex);
                if (!(candidate instanceof GraphicPrimitive2D)) continue;
                graphic = (GraphicPrimitive2D)candidate;
                zOrder = graphic.getZOrderHint();
                while (zOrder >= minZOrder) {
                    if (!(zOrder <= maxZOrder)) {
                        if (++offscreenIndex < offscreenCount) {
                            minZOrder = this.offscreenZRanges.getMinValueAsDouble(offscreenIndex);
                            maxZOrder = this.offscreenZRanges.getMaxValueAsDouble(offscreenIndex);
                            continue;
                        }
                        minZOrder = NaN;
                        maxZOrder = NaN;
                        break;
                    }
                    if (!BufferedCanvas2D.$assertionsDisabled && this.offscreenZRanges.indexOfRange(new Double(zOrder)) != offscreenIndex) {
                        throw new AssertionError();
                    }
                    while (++graphicIndexUp < graphicCount && (candidate = (Graphic)graphics.get(graphicIndexUp)).getZOrderHint() <= maxZOrder) {
                    }
                    break block24;
                }
                if (graphicIndex == graphicIndexUp) {
                    try {
                        this.paint(graphic, context, clipBounds);
                    }
                    catch (TransformException exception) {
                        this.handleException("GraphicPrimitive2D", "paint", (Exception)exception);
                    }
                    catch (RuntimeException exception) {
                        this.handleException("GraphicPrimitive2D", "paint", exception);
                    }
                    continue;
                }
                createFromComponent = this.owner != null;
                bufferClip = clipBounds;
                buffer = this.offscreenBuffers[offscreenIndex];
                block26: while (true) {
                    switch (BufferedCanvas2D.validate(buffer, config)) {
                        case 2: {
                            if (buffer != null) {
                                buffer.flush();
                                buffer = null;
                            }
                            if (createFromComponent) {
                                createFromComponent = false;
                                if (this.offscreenIsVolatile[offscreenIndex]) {
                                    buffer = this.owner.createVolatileImage(displayBounds.width, displayBounds.height);
                                }
                            }
                            if (buffer == null) {
                                buffer = this.offscreenIsVolatile[offscreenIndex] != false ? config.createCompatibleVolatileImage(displayBounds.width, displayBounds.height) : config.createCompatibleImage(displayBounds.width, displayBounds.height, 3);
                            }
                            this.offscreenBuffers[offscreenIndex] = buffer;
                            bufferClip = displayBounds;
                            continue block26;
                        }
                        case 0: {
                            if (!this.offscreenNeedRepaint[offscreenIndex]) {
                                output.drawImage(buffer, displayBounds.x, displayBounds.y, this.owner);
                                if (!BufferedCanvas2D.contentsLost(buffer)) break block26;
                                continue block26;
                            }
                            ** GOTO lbl135
                        }
                        case 1: {
                            bufferClip = displayBounds;
                        }
lbl135:
                        // 3 sources

                        default: {
                            graphicsOff = (Graphics2D)buffer.getGraphics();
                            oldComposite = graphicsOff.getComposite();
                            graphicsOff.addRenderingHints(this.hints);
                            graphicsOff.translate(-displayBounds.x, -displayBounds.y);
                            if (this.offscreenIsVolatile[offscreenIndex]) {
                                graphicsOff.setComposite(AlphaComposite.Src);
                            } else {
                                graphicsOff.setComposite(AlphaComposite.Clear);
                            }
                            graphicsOff.setColor(this.owner != null ? this.owner.getBackground() : Color.WHITE);
                            graphicsOff.fill(bufferClip);
                            graphicsOff.setComposite(oldComposite);
                            graphicsOff.setColor(this.owner != null ? this.owner.getForeground() : Color.BLACK);
                            graphicsOff.clip(bufferClip);
                            context.setGraphics(graphicsOff, zoom);
                            this.offscreenNeedRepaint[offscreenIndex] = false;
                            for (i = graphicIndex; i < graphicIndexUp; ++i) {
                                candidate = (Graphic)graphics.get(i);
                                if (candidate instanceof GraphicPrimitive2D) {
                                    try {
                                        this.paint((GraphicPrimitive2D)candidate, context, bufferClip);
                                    }
                                    catch (Exception exception) {
                                        context.disposeGraphics();
                                        buffer.flush();
                                        buffer = null;
                                        this.offscreenBuffers[offscreenIndex] = null;
                                        graphicIndexUp = graphicIndex;
                                        minZOrder = NaN;
                                        this.handleOffscreenException(candidate, exception);
                                        break block26;
                                    }
                                }
                                if (BufferedCanvas2D.contentsLost(buffer)) break;
                            }
                            context.disposeGraphics();
                            continue block26;
                        }
                    }
                    break;
                }
                graphicIndex = graphicIndexUp - 1;
            }
            success = true;
        }
        finally {
            context.setGraphics(null, null);
            this.paintFinished(success);
        }
        this.statistics.finish(this);
    }

    private void paint(GraphicPrimitive2D graphic, RenderingContext context, Rectangle clipBounds) throws TransformException {
        Shape paintedArea;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (graphic.getVisible() && ((paintedArea = graphic.getDisplayBounds()) == null || clipBounds == null || paintedArea.intersects(clipBounds))) {
            context.paintedArea = null;
            graphic.paint(context);
            graphic.setDisplayBounds(context.paintedArea);
        }
    }

    private void repaint() {
        Component owner = this.owner;
        if (owner != null) {
            if (EventQueue.isDispatchThread()) {
                owner.repaint();
            } else {
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        BufferedCanvas2D.this.repaint();
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void repaint(final Graphic graphic, final Rectangle2D objectiveArea, final Rectangle displayArea) {
        void var4_5;
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    BufferedCanvas2D.this.repaint(graphic, objectiveArea, displayArea);
                }
            });
            return;
        }
        BufferedCanvas2D bufferedCanvas2D = this;
        synchronized (bufferedCanvas2D) {
            Rectangle bounds;
            if (objectiveArea != null) {
                if (objectiveArea.equals(XRectangle2D.INFINITY)) {
                    bounds = null;
                } else {
                    bounds = this.objectiveToDisplay(objectiveArea);
                    if (displayArea != null) {
                        bounds.add(displayArea);
                    }
                }
            } else if (displayArea != null) {
                bounds = displayArea;
            } else {
                return;
            }
            if (this.isDirtyArea((Rectangle)var4_5)) {
                return;
            }
            if (graphic != null) {
                this.flushOffscreenBuffer(graphic.getZOrderHint());
            } else {
                this.flushOffscreenBuffers();
            }
            if (this.owner != null) {
                if (var4_5 != null) {
                    this.owner.repaint(var4_5.x, var4_5.y, var4_5.width, var4_5.height);
                } else {
                    this.owner.repaint();
                }
            }
        }
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINEST)) {
            Logging resources = Logging.getResources(this.getLocale());
            String name = graphic != null ? graphic.getName() : Vocabulary.format(176);
            LogRecord record = var4_5 != null ? resources.getLogRecord(Level.FINEST, 18, new Object[]{name, new Integer(var4_5.x), new Integer(var4_5.x + var4_5.width - 1), new Integer(var4_5.y), new Integer(var4_5.y + var4_5.height - 1)}) : resources.getLogRecord(Level.FINEST, 17, name);
            record.setSourceClassName("BufferedCanvas2D");
            record.setSourceMethodName("repaint");
            logger.log(record);
        }
    }

    protected void zoomChanged(AffineTransform change) {
        if (change != null && change.isIdentity()) {
            return;
        }
        this.flushOffscreenBuffers();
        if (change == null && this.offscreenBuffers != null) {
            Arrays.fill(this.offscreenBuffers, null);
        }
        super.zoomChanged(change);
    }

    private void handleOffscreenException(Graphic graphic, Exception exception) {
        Locale locale = this.getLocale();
        LogRecord record = Logging.getResources(locale).getLogRecord(Level.FINE, 12, graphic.getName());
        record.setSourceClassName("BufferedCanvas2D");
        record.setSourceMethodName("paint");
        record.setThrown(exception);
        this.getLogger().log(record);
    }

    public synchronized ImageType getOffscreenBuffered(double zOrder) {
        int index;
        if (this.offscreenZRanges != null && (index = this.offscreenZRanges.indexOfRange(new Double(zOrder))) >= 0) {
            return this.offscreenIsVolatile[index] ? ImageType.VOLATILE : ImageType.BUFFERED;
        }
        return ImageType.NONE;
    }

    private void setOffscreenBuffered(double zOrder, ImageType type) {
        int index = this.offscreenZRanges.indexOfRange(new Double(zOrder));
        if (index >= 0) {
            this.offscreenIsVolatile[index] = ((Object)((Object)ImageType.VOLATILE)).equals((Object)type);
        }
    }

    public synchronized void setOffscreenBuffered(double lower, double upper, ImageType type) {
        ImageType upperType;
        ImageType lowerType;
        Map oldIndexMap;
        Image[] oldBuffers = this.offscreenBuffers;
        boolean[] oldTypes = this.offscreenIsVolatile;
        boolean[] oldNeeds = this.offscreenNeedRepaint;
        if (this.offscreenZRanges == null) {
            if (((Object)((Object)ImageType.NONE)).equals((Object)type)) {
                return;
            }
            this.offscreenZRanges = new RangeSet(Double.class);
            oldIndexMap = Collections.EMPTY_MAP;
        } else {
            int index = 0;
            oldIndexMap = new HashMap();
            Iterator it = this.offscreenZRanges.iterator();
            while (it.hasNext()) {
                if (oldIndexMap.put(it.next(), new Integer(index++)) != null) {
                    throw new AssertionError();
                }
            }
            if (!$assertionsDisabled && index != this.offscreenBuffers.length) {
                throw new AssertionError(index);
            }
        }
        if (((Object)((Object)ImageType.NONE)).equals((Object)type)) {
            lowerType = this.getOffscreenBuffered(lower);
            upperType = this.getOffscreenBuffered(upper);
            this.offscreenZRanges.remove(lower, upper);
        } else {
            lowerType = upperType = type;
            this.offscreenZRanges.add(lower, upper);
        }
        this.offscreenBuffers = new Image[this.offscreenZRanges.size()];
        this.offscreenIsVolatile = new boolean[this.offscreenBuffers.length];
        this.offscreenNeedRepaint = new boolean[this.offscreenBuffers.length];
        int index = 0;
        Iterator it = this.offscreenZRanges.iterator();
        while (it.hasNext()) {
            Integer oldInteger = (Integer)oldIndexMap.remove(it.next());
            if (oldInteger != null) {
                int oldIndex = oldInteger;
                this.offscreenBuffers[index] = oldBuffers[oldIndex];
                this.offscreenIsVolatile[index] = oldTypes[oldIndex];
                this.offscreenNeedRepaint[index] = oldNeeds[oldIndex];
            }
            ++index;
        }
        if (!$assertionsDisabled && index != this.offscreenBuffers.length) {
            throw new AssertionError(index);
        }
        this.setOffscreenBuffered(lower, lowerType);
        this.setOffscreenBuffered(upper, upperType);
        it = oldIndexMap.values().iterator();
        while (it.hasNext()) {
            Image image = oldBuffers[(Integer)it.next()];
            if (image == null) continue;
            image.flush();
        }
    }

    private void flushOffscreenBuffer(double zOrder) {
        int index;
        if (this.offscreenZRanges != null && (index = this.offscreenZRanges.indexOfRange(new Double(zOrder))) >= 0) {
            this.offscreenNeedRepaint[index] = true;
        }
    }

    private void flushOffscreenBuffers() {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.offscreenBuffers != null) {
            for (int i = 0; i < this.offscreenBuffers.length; ++i) {
                Image image = this.offscreenBuffers[i];
                if (image == null) continue;
                image.flush();
            }
            Arrays.fill(this.offscreenNeedRepaint, true);
        }
    }

    String toStringExt(Graphic graphic) {
        ImageType type = this.getOffscreenBuffered(graphic.getZOrderHint());
        return ((Object)((Object)ImageType.NONE)).equals((Object)type) ? super.toStringExt(graphic) : type.name();
    }

    protected void clearCache() {
        this.flushOffscreenBuffers();
        if (this.offscreenBuffers != null) {
            Arrays.fill(this.offscreenBuffers, null);
        }
        this.statistics = null;
        super.clearCache();
    }

    public void dispose() {
        this.flushOffscreenBuffers();
        this.offscreenZRanges = null;
        this.offscreenBuffers = null;
        this.offscreenIsVolatile = null;
        this.offscreenNeedRepaint = null;
        super.dispose();
    }

    static {
        $assertionsDisabled = !BufferedCanvas2D.class.desiredAssertionStatus();
    }

    private final class ComponentListener
    extends ComponentAdapter {
        private ComponentListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentResized(ComponentEvent event) {
            BufferedCanvas2D bufferedCanvas2D = BufferedCanvas2D.this;
            synchronized (bufferedCanvas2D) {
                BufferedCanvas2D.this.checkDisplayBounds();
                BufferedCanvas2D.this.zoomChanged(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentMoved(ComponentEvent event) {
            BufferedCanvas2D bufferedCanvas2D = BufferedCanvas2D.this;
            synchronized (bufferedCanvas2D) {
                BufferedCanvas2D.this.checkDisplayBounds();
                BufferedCanvas2D.this.zoomChanged(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void componentHidden(ComponentEvent event) {
            BufferedCanvas2D bufferedCanvas2D = BufferedCanvas2D.this;
            synchronized (bufferedCanvas2D) {
                BufferedCanvas2D.this.clearCache();
            }
        }
    }
}

