/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.resources.Utilities;
import org.opengis.go.display.canvas.CanvasState;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.util.Cloneable;

public class DefaultCanvasState
implements CanvasState,
Cloneable,
Serializable {
    private static final long serialVersionUID = 8473318790311715748L;
    private final String title;
    private final GeneralDirectPosition center;

    public DefaultCanvasState(String title, DirectPosition center) {
        this.title = title;
        this.center = center != null ? new GeneralDirectPosition(center) : null;
    }

    public DefaultCanvasState(String title, Envelope envelope) {
        this.title = title;
        if (envelope != null) {
            int dimension = envelope.getDimension();
            this.center = new GeneralDirectPosition(dimension);
            this.center.setCoordinateReferenceSystem(envelope.getLowerCorner().getCoordinateReferenceSystem());
            for (int i = 0; i < dimension; ++i) {
                this.center.ordinates[i] = envelope.getCenter(i);
            }
        } else {
            this.center = null;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public DirectPosition getCenter() {
        return this.center != null ? new GeneralDirectPosition(this.center) : this.center;
    }

    public int hashCode() {
        int code = -718527580;
        if (this.title != null) {
            code ^= this.title.hashCode();
        }
        if (this.center != null) {
            code ^= this.center.hashCode();
        }
        return code;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            DefaultCanvasState that = (DefaultCanvasState)object;
            return Utilities.equals(this.title, that.title) && Utilities.equals(this.center, that.center);
        }
        return false;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(Utilities.getShortClassName(this));
        buffer.append('[');
        if (this.title != null) {
            buffer.append('\"');
            buffer.append(this.title);
            buffer.append('\"');
        }
        if (this.center != null) {
            buffer.append(", (");
            buffer.append(this.center);
            buffer.append(')');
        }
        buffer.append(']');
        return buffer.toString();
    }
}

