/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.RenderingHints;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Logging;

public class DisplayObject {
    private static final Logger LOGGER = Logger.getLogger("org.geotools.display");
    private static final String[] HINT_CLASSES = new String[]{"java.awt.RenderingHints", "org.geotools.factory.Hints", "org.geotools.display.canvas.AbstractCanvas", "javax.media.jai.JAI"};
    public static final String NAME_PROPERTY = "name";
    public static final String TITLE_PROPERTY = "title";
    public static final String OBJECTIVE_CRS_PROPERTY = "objectiveCRS";
    public static final String DISPLAY_CRS_PROPERTY = "displayCRS";
    public static final String GRAPHICS_PROPERTY = "graphics";
    public static final String VISIBLE_PROPERTY = "visible";
    public static final String Z_ORDER_HINT_PROPERTY = "zOrderHint";
    public static final String ENVELOPE_PROPERTY = "envelope";
    public static final String SCALE_PROPERTY = "scale";
    public static final String DISPLAY_BOUNDS_PROPERTY = "displayBounds";
    public static final String PARENT_PROPERTY = "parent";
    protected final PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    protected DisplayObject() {
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return null;
    }

    public void setRenderingHint(RenderingHints.Key key, Object value) {
    }

    public Object getImplHint(String name) throws IllegalArgumentException {
        return this.getRenderingHint(this.toRenderingHintKey(name, "getImplHint"));
    }

    public void setImplHint(String name, Object value) {
        RenderingHints.Key key = this.toRenderingHintKey(name, "setImplHint");
        if (key != null) {
            this.setRenderingHint(key, value);
        } else {
            this.getLogger().fine(Logging.getResources(this.getLocale()).getString(33, name));
        }
    }

    private RenderingHints.Key toRenderingHintKey(String name, String methodName) {
        int length = name.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i != 0 && Character.isLowerCase(name.charAt(i - 1))) {
                    buffer.append('_');
                }
            } else {
                c = Character.toUpperCase(c);
            }
            buffer.append(c);
        }
        name = buffer.toString();
        for (int i = 0; i < HINT_CLASSES.length; ++i) {
            try {
                return (RenderingHints.Key)Class.forName(HINT_CLASSES[i]).getField(name).get(null);
            }
            catch (Exception e) {
                LogRecord record = new LogRecord(Level.FINEST, name);
                record.setSourceClassName("AbstractCanvas");
                record.setSourceMethodName(methodName);
                record.setThrown(e);
                this.getLogger().log(record);
                continue;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        PropertyChangeSupport propertyChangeSupport = this.listeners;
        synchronized (propertyChangeSupport) {
            this.listeners.addPropertyChangeListener(listener);
            this.listenersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport propertyChangeSupport = this.listeners;
        synchronized (propertyChangeSupport) {
            this.listeners.addPropertyChangeListener(propertyName, listener);
            this.listenersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        PropertyChangeSupport propertyChangeSupport = this.listeners;
        synchronized (propertyChangeSupport) {
            this.listeners.removePropertyChangeListener(listener);
            this.listenersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        PropertyChangeSupport propertyChangeSupport = this.listeners;
        synchronized (propertyChangeSupport) {
            this.listeners.removePropertyChangeListener(propertyName, listener);
            this.listenersChanged();
        }
    }

    void listenersChanged() {
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    protected void handleException(String sourceClassName, String sourceMethodName, Exception exception) {
        Utilities.unexpectedException(this.getLogger().getName(), sourceClassName, sourceMethodName, exception);
    }

    protected void clearCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        PropertyChangeSupport propertyChangeSupport = this.listeners;
        synchronized (propertyChangeSupport) {
            PropertyChangeListener[] list = this.listeners.getPropertyChangeListeners();
            int i = list.length;
            while (--i >= 0) {
                this.listeners.removePropertyChangeListener(list[i]);
            }
            this.listenersChanged();
        }
    }
}

