/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.geom.Point2D;
import org.geotools.display.canvas.GraphicVisitor;
import org.geotools.display.canvas.ReferencedGraphic;
import org.geotools.display.canvas.ReferencedGraphic2D;
import org.geotools.display.event.ReferencedEvent;
import org.opengis.go.display.primitive.Graphic;

abstract class GraphicVisitor2D
extends GraphicVisitor {
    private final double x;
    private final double y;

    public GraphicVisitor2D(ReferencedEvent event) {
        Point2D point = event.getDisplayPoint2D();
        this.x = point.getX();
        this.y = point.getY();
    }

    protected final boolean into(ReferencedGraphic2D graphic) {
        return graphic.getDisplayBounds().contains(this.x, this.y);
    }

    static final class Format
    extends GraphicVisitor2D {
        protected final StringBuffer buffer;

        public Format(ReferencedEvent event, StringBuffer buffer) {
            super(event);
            this.buffer = buffer;
        }

        public Object visit(Graphic graphic, ReferencedEvent event) {
            if (graphic instanceof ReferencedGraphic2D ? !this.into((ReferencedGraphic2D)graphic) : !(graphic instanceof ReferencedGraphic)) {
                return null;
            }
            return ((ReferencedGraphic)graphic).format(event, this.buffer);
        }
    }

    static final class Action
    extends GraphicVisitor2D {
        public Action(ReferencedEvent event) {
            super(event);
        }

        public Object visit(Graphic graphic, ReferencedEvent event) {
            if (graphic instanceof ReferencedGraphic2D ? !this.into((ReferencedGraphic2D)graphic) : !(graphic instanceof ReferencedGraphic)) {
                return null;
            }
            return ((ReferencedGraphic)graphic).getAction(event);
        }
    }

    static final class ToolTipText
    extends GraphicVisitor2D {
        public ToolTipText(ReferencedEvent event) {
            super(event);
        }

        public Object visit(Graphic graphic, ReferencedEvent event) {
            if (graphic instanceof ReferencedGraphic2D ? !this.into((ReferencedGraphic2D)graphic) : !(graphic instanceof ReferencedGraphic)) {
                return null;
            }
            return ((ReferencedGraphic)graphic).getToolTipText(event);
        }
    }
}

