/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.Action;
import org.geotools.display.canvas.AbstractCanvas;
import org.geotools.display.canvas.AbstractGraphic;
import org.geotools.display.canvas.DefaultCanvasState;
import org.geotools.display.canvas.GraphicVisitor;
import org.geotools.display.canvas.ReferencedGraphic;
import org.geotools.display.event.ReferencedEvent;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.TransformedDirectPosition;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultDerivedCRS;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.factory.FactoryGroup;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Logging;
import org.opengis.go.display.DisplayFactory;
import org.opengis.go.display.canvas.CanvasState;
import org.opengis.go.display.primitive.Graphic;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.DerivedCRS;
import org.opengis.referencing.crs.GeneralDerivedCRS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;

public abstract class ReferencedCanvas
extends AbstractCanvas {
    private DerivedCRS displayCRS;
    private DerivedCRS deviceCRS;
    private Map displayProperties;
    private Map deviceProperties;
    private transient TransformedDirectPosition objectivePosition;
    private transient TransformedDirectPosition displayPosition;
    private final GeneralEnvelope envelope;
    private final transient Map transforms = new HashMap();
    private transient OperationMethod affineMethod;
    private transient FactoryGroup crsFactories;
    private transient CoordinateOperationFactory opFactory;
    private boolean useDefaultCRS;
    private Double scaleFactor;
    private boolean hasScaleListeners;
    private boolean hasDisplayListeners;
    private boolean hasEnvelopeListeners;
    private transient boolean disableGraphicListener;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ReferencedCanvas(DisplayFactory factory, int dimension) throws IllegalArgumentException {
        this(factory, ReferencedCanvas.getDefaultCRS(dimension), null);
        this.useDefaultCRS = true;
    }

    protected ReferencedCanvas(DisplayFactory factory, CoordinateReferenceSystem objectiveCRS, Hints hints) {
        super(factory, hints);
        this.envelope = new GeneralEnvelope(objectiveCRS);
        this.envelope.setToNull();
    }

    private static CoordinateReferenceSystem getDefaultCRS(int dimension) throws IllegalArgumentException {
        switch (dimension) {
            case 2: {
                return DefaultEngineeringCRS.GENERIC_2D;
            }
            case 3: {
                return DefaultEngineeringCRS.GENERIC_3D;
            }
        }
        throw new IllegalArgumentException(Errors.format(42, "dimension", new Integer(dimension)));
    }

    public synchronized Envelope getEnvelope() {
        return new GeneralEnvelope(this.envelope);
    }

    synchronized Rectangle2D getEnvelope2D() {
        return this.envelope.toRectangle2D();
    }

    public synchronized CanvasState getState() {
        return new DefaultCanvasState(this.getTitle(), this.envelope);
    }

    public synchronized double[] getTypicalCellDimension(DirectPosition position) {
        int i;
        CoordinateReferenceSystem objectiveCRS = this.getObjectiveCRS();
        double[] size = new double[objectiveCRS.getCoordinateSystem().getDimension()];
        Arrays.fill(size, Double.POSITIVE_INFINITY);
        if (this.objectivePosition == null) {
            this.objectivePosition = new TransformedDirectPosition(null, objectiveCRS, this.hints);
        }
        if (position != null) {
            try {
                this.objectivePosition.transform(position);
            }
            catch (TransformException exception) {
                this.handleException("getTypicalCellDimension", (Exception)((Object)exception));
                position = null;
            }
        }
        if (position == null) {
            int i2 = this.objectivePosition.getDimension();
            while (--i2 >= 0) {
                this.objectivePosition.setOrdinate(i2, this.envelope.getCenter(i2));
            }
        }
        List graphics = this.getGraphics();
        int graphicCount = graphics.size();
        for (i = 0; i < graphicCount; ++i) {
            MathTransform transform;
            ReferencedGraphic graphic;
            double[] cellSize;
            Graphic candidate = (Graphic)graphics.get(i);
            if (!(candidate instanceof ReferencedGraphic) || (cellSize = (graphic = (ReferencedGraphic)candidate).getTypicalCellDimension(position)) == null) continue;
            CoordinateReferenceSystem graphicCRS = graphic.getObjectiveCRS();
            try {
                transform = this.getMathTransform(graphicCRS, objectiveCRS, "ReferencedCanvas", "getTypicalCellDimension");
            }
            catch (FactoryException exception) {
                this.handleException("getTypicalCellDimension", (Exception)((Object)exception));
                continue;
            }
            if (!transform.isIdentity()) {
                try {
                    GeneralEnvelope cellPrototype = new GeneralEnvelope(graphicCRS);
                    position = this.objectivePosition.inverseTransform(graphicCRS);
                    int j = position.getDimension();
                    while (--j >= 0) {
                        double center = position.getOrdinate(j);
                        double width = j < cellSize.length ? cellSize[j] : 0.0;
                        cellPrototype.setRange(j, center - width, center + width);
                    }
                    cellPrototype = CRSUtilities.transform(transform, cellPrototype);
                    j = Math.min(cellSize.length, cellPrototype.getDimension());
                    while (--j >= 0) {
                        cellSize[j] = cellPrototype.getLength(j);
                    }
                }
                catch (TransformException exception) {
                    this.handleException("getTypicalCellDimension", (Exception)((Object)exception));
                    continue;
                }
            }
            int j = Math.min(size.length, cellSize.length);
            while (--j >= 0) {
                double c = cellSize[j];
                if (!(c > 0.0) || !(c < size[j])) continue;
                size[j] = c;
            }
        }
        i = size.length;
        while (--i >= 0) {
            double c = size[i];
            if (!Double.isInfinite(c)) continue;
            return null;
        }
        return size;
    }

    public double getScale() {
        Double scaleFactor = this.scaleFactor;
        return scaleFactor != null ? scaleFactor : Double.NaN;
    }

    protected void setScale(double scaleFactor) {
        Double oldScale = this.scaleFactor;
        if (oldScale == null || oldScale != scaleFactor) {
            Double newScale;
            this.scaleFactor = newScale = new Double(scaleFactor);
            List graphics = this.getGraphics();
            int i = graphics.size();
            while (--i >= 0) {
                Graphic candidate = (Graphic)graphics.get(i);
                if (!(candidate instanceof AbstractGraphic)) continue;
                AbstractGraphic graphic = (AbstractGraphic)candidate;
                if (!graphic.hasScaleListeners) continue;
                graphic.listeners.firePropertyChange("scale", oldScale, newScale);
            }
            if (this.hasScaleListeners) {
                this.listeners.firePropertyChange("scale", oldScale, newScale);
            }
        }
    }

    public synchronized Graphic add(Graphic graphic) {
        GeneralEnvelope oldEnvelope = null;
        if ((graphic = super.add(graphic)) instanceof ReferencedGraphic) {
            ReferencedGraphic referenced = (ReferencedGraphic)graphic;
            CoordinateReferenceSystem graphicCRS = referenced.getObjectiveCRS();
            CoordinateReferenceSystem objectiveCRS = this.getObjectiveCRS();
            if (this.useDefaultCRS) {
                try {
                    this.setObjectiveCRS(graphicCRS);
                    objectiveCRS = graphicCRS;
                    this.useDefaultCRS = false;
                }
                catch (TransformException unexpected) {
                    this.handleException("add", (Exception)((Object)unexpected));
                }
            }
            try {
                referenced.setObjectiveCRS(objectiveCRS);
            }
            catch (TransformException exception) {
                IllegalArgumentException e = new IllegalArgumentException(exception.getLocalizedMessage());
                e.initCause(exception);
                throw e;
            }
            if (this.hasEnvelopeListeners) {
                oldEnvelope = new GeneralEnvelope(this.envelope);
            }
            graphicCRS = referenced.getObjectiveCRS();
            Envelope graphicEnvelope = referenced.getEnvelope();
            this.graphicEnvelopeChanged(null, graphicEnvelope, graphicCRS, "ReferencedCanvas", "add");
        }
        if (oldEnvelope != null) {
            this.listeners.firePropertyChange("envelope", oldEnvelope, this.envelope);
        }
        return graphic;
    }

    public synchronized void remove(Graphic graphic) {
        ReferencedGraphic referenced;
        GeneralEnvelope oldEnvelope = null;
        if (graphic instanceof ReferencedGraphic && (referenced = (ReferencedGraphic)graphic).getCanvas() == this) {
            if (this.hasEnvelopeListeners) {
                oldEnvelope = new GeneralEnvelope(this.envelope);
            }
            CoordinateReferenceSystem graphicCRS = referenced.getObjectiveCRS();
            Envelope graphicEnvelope = referenced.getEnvelope();
            this.graphicEnvelopeChanged(graphicEnvelope, null, graphicCRS, "ReferencedCanvas", "remove");
        }
        super.remove(graphic);
        if (oldEnvelope != null) {
            this.listeners.firePropertyChange("envelope", oldEnvelope, this.envelope);
        }
    }

    public synchronized void removeAll() {
        GeneralEnvelope oldEnvelope = new GeneralEnvelope(this.envelope);
        super.removeAll();
        this.envelope.setToNull();
        this.listeners.firePropertyChange("envelope", oldEnvelope, this.envelope);
    }

    /*
     * WARNING - void declaration
     */
    protected void graphicPropertyChanged(AbstractGraphic graphic, PropertyChangeEvent event) {
        void var4_4;
        GeneralEnvelope oldEnvelope;
        super.graphicPropertyChanged(graphic, event);
        if (this.disableGraphicListener) {
            return;
        }
        String propertyName = event.getPropertyName();
        if (propertyName.equalsIgnoreCase("envelope")) {
            oldEnvelope = this.hasEnvelopeListeners ? new GeneralEnvelope(this.envelope) : null;
            Object source = event.getSource();
            CoordinateReferenceSystem crs = source instanceof ReferencedGraphic ? ((ReferencedGraphic)source).getObjectiveCRS() : this.getObjectiveCRS();
            this.graphicEnvelopeChanged((Envelope)event.getOldValue(), (Envelope)event.getNewValue(), crs, "ReferencedGraphic", "setEnvelope");
        } else if (propertyName.equalsIgnoreCase("objectiveCRS")) {
            oldEnvelope = new GeneralEnvelope(this.envelope);
            this.computeEnvelope("ReferencedGraphic", "setObjectiveCRS");
        } else {
            return;
        }
        if (var4_4 != null) {
            this.listeners.firePropertyChange("envelope", var4_4, this.envelope);
        }
    }

    public Graphic getTopGraphicAt(DirectPosition directPosition) {
        throw new UnsupportedOperationException();
    }

    public Graphic[] getGraphicsAt(DirectPosition directPosition) {
        throw new UnsupportedOperationException();
    }

    public Graphic[] getGraphicsIn(Envelope bounds) {
        throw new UnsupportedOperationException();
    }

    public synchronized boolean isVisible(DirectPosition coordinate) {
        try {
            return this.envelope.contains(this.toObjectivePosition(coordinate));
        }
        catch (TransformException e) {
            return false;
        }
    }

    final synchronized Object visit(GraphicVisitor visitor, ReferencedEvent event) {
        List graphics = this.getGraphics();
        int i = graphics.size();
        while (--i >= 0) {
            Object value;
            Graphic candidate = (Graphic)graphics.get(i);
            if (!candidate.getVisible() || (value = visitor.visit(candidate, event)) == null) continue;
            return value;
        }
        return null;
    }

    public boolean format(ReferencedEvent event, StringBuffer toAppendTo) {
        return (Boolean)this.visit(new GraphicVisitor.Format(toAppendTo), event);
    }

    public String getToolTipText(ReferencedEvent event) {
        return (String)this.visit(GraphicVisitor.ToolTipText.SHARED, event);
    }

    public Action getAction(ReferencedEvent event) {
        return (Action)this.visit(GraphicVisitor.Action.SHARED, event);
    }

    public final CoordinateReferenceSystem getObjectiveCRS() {
        return this.envelope.getCoordinateReferenceSystem();
    }

    public synchronized void setObjectiveCRS(CoordinateReferenceSystem crs) throws TransformException {
        int changed;
        CoordinateReferenceSystem oldCRS = this.getObjectiveCRS();
        if (!$assertionsDisabled && oldCRS != this.getObjectiveCoordinateReferenceSystem()) {
            throw new AssertionError();
        }
        if (CRSUtilities.equalsIgnoreMetadata(crs, oldCRS)) {
            return;
        }
        GeneralEnvelope oldEnvelope = new GeneralEnvelope(this.envelope);
        this.envelope.setCoordinateReferenceSystem(crs);
        DerivedCRS displayCRS = this.displayCRS;
        if (displayCRS != null) {
            try {
                Conversion objectiveToDisplay = displayCRS.getConversionFromBase();
                displayCRS = ReferencedCanvas.createDerivedCRS(this.displayProperties, objectiveToDisplay, crs, displayCRS.getCoordinateSystem());
            }
            catch (FactoryException exception) {
                throw new TransformException(Errors.format(46), (Throwable)exception);
            }
        }
        List graphics = this.getGraphics();
        int graphicCount = graphics.size();
        try {
            this.disableGraphicListener = true;
            for (changed = 0; changed < graphicCount; ++changed) {
                Graphic graphic = (Graphic)graphics.get(changed);
                if (!(graphic instanceof ReferencedGraphic)) continue;
                ((ReferencedGraphic)graphic).setObjectiveCRS(crs);
            }
        }
        catch (TransformException exception) {
            while (--changed >= 0) {
                Graphic graphic = (Graphic)graphics.get(changed);
                if (!(graphic instanceof ReferencedGraphic)) continue;
                try {
                    ((ReferencedGraphic)graphic).setObjectiveCRS(oldCRS);
                }
                catch (TransformException unexpected) {
                    this.handleException("setObjectiveCRS", (Exception)((Object)unexpected));
                }
            }
            this.envelope.setCoordinateReferenceSystem(oldCRS);
            this.clearCache();
            throw exception;
        }
        finally {
            this.disableGraphicListener = false;
        }
        this.clearCache();
        this.scaleFactor = null;
        this.useDefaultCRS = false;
        this.updateNormalizationFactor(crs);
        this.computeEnvelope("ReferencedCanvas", "setObjectiveCRS");
        if (displayCRS != null) {
            this.setDisplayCRS(displayCRS);
        }
        if (!$assertionsDisabled && this.getObjectiveCRS() != crs) {
            throw new AssertionError();
        }
        this.listeners.firePropertyChange("objectiveCRS", oldCRS, crs);
        this.listeners.firePropertyChange("envelope", oldEnvelope, this.envelope);
    }

    void updateNormalizationFactor(CoordinateReferenceSystem crs) {
    }

    private void computeEnvelope(String sourceClassName, String sourceMethodName) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.envelope.setToNull();
        CoordinateReferenceSystem lastCRS = null;
        MathTransform transform = null;
        List graphics = this.getGraphics();
        int graphicCount = graphics.size();
        for (int i = 0; i < graphicCount; ++i) {
            Graphic candidate = (Graphic)graphics.get(i);
            if (!(candidate instanceof ReferencedGraphic)) continue;
            ReferencedGraphic graphic = (ReferencedGraphic)candidate;
            Envelope graphicEnvelope = graphic.getEnvelope();
            CoordinateReferenceSystem crs = graphic.getObjectiveCRS();
            try {
                if (!CRSUtilities.equalsIgnoreMetadata(crs, lastCRS)) {
                    transform = this.getMathTransform(crs, this.getObjectiveCRS(), sourceClassName, sourceMethodName);
                    lastCRS = crs;
                }
                GeneralEnvelope bounds = CRSUtilities.transform(transform, graphicEnvelope);
                if (this.envelope.isNull()) {
                    this.envelope.setEnvelope(bounds);
                    continue;
                }
                this.envelope.add(bounds);
                continue;
            }
            catch (FactoryException exception) {
                this.handleException(sourceClassName, sourceMethodName, (Exception)((Object)exception));
                continue;
            }
            catch (TransformException exception) {
                this.handleException(sourceClassName, sourceMethodName, (Exception)((Object)exception));
            }
        }
    }

    private void graphicEnvelopeChanged(Envelope oldEnvelope, Envelope newEnvelope, CoordinateReferenceSystem crs, String sourceClassName, String sourceMethodName) {
        GeneralEnvelope newProjected;
        GeneralEnvelope oldProjected;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        try {
            MathTransform transform = this.getMathTransform(crs, this.getObjectiveCRS(), sourceClassName, sourceMethodName);
            oldProjected = CRSUtilities.transform(transform, oldEnvelope);
            newProjected = CRSUtilities.transform(transform, newEnvelope);
        }
        catch (FactoryException exception) {
            this.handleException(sourceClassName, sourceMethodName, (Exception)((Object)exception));
            this.computeEnvelope(sourceClassName, sourceMethodName);
            return;
        }
        catch (TransformException exception) {
            this.handleException(sourceClassName, sourceMethodName, (Exception)((Object)exception));
            this.computeEnvelope(sourceClassName, sourceMethodName);
            return;
        }
        if (!ReferencedCanvas.replace(this.envelope, oldProjected, newProjected)) {
            this.computeEnvelope(sourceClassName, sourceMethodName);
        }
    }

    private static boolean replace(GeneralEnvelope envelope, GeneralEnvelope oldEnvelope, GeneralEnvelope newEnvelope) {
        if (envelope.isEmpty()) {
            if (newEnvelope != null) {
                envelope.setEnvelope(newEnvelope);
            }
            return true;
        }
        if (newEnvelope == null || newEnvelope.isNull()) {
            return oldEnvelope == null || envelope.contains(oldEnvelope, false);
        }
        if (oldEnvelope != null && !oldEnvelope.isNull()) {
            int i = envelope.getDimension();
            while (--i >= 0) {
                double t = oldEnvelope.getMinimum(i);
                if (!(t > envelope.getMinimum(i)) && !(t >= newEnvelope.getMinimum(i))) {
                    return false;
                }
                t = oldEnvelope.getMaximum(i);
                if (t < envelope.getMaximum(i) || t <= newEnvelope.getMaximum(i)) continue;
                return false;
            }
        }
        envelope.add(newEnvelope);
        return true;
    }

    public final synchronized DerivedCRS getDisplayCRS() {
        if (this.displayCRS == null) {
            try {
                FactoryGroup crsFactories = this.getFactoryGroup();
                CoordinateReferenceSystem objectiveCRS = this.getObjectiveCRS();
                DefaultCartesianCS displayCS = DefaultCartesianCS.DISPLAY;
                int sourceDim = objectiveCRS.getCoordinateSystem().getDimension();
                int targetDim = displayCS.getDimension();
                XMatrix identity = MatrixFactory.create(targetDim + 1, sourceDim + 1);
                MathTransform mt = crsFactories.getMathTransformFactory().createAffineTransform((Matrix)identity);
                this.displayProperties = AbstractIdentifiedObject.getProperties(displayCS, null);
                this.displayCRS = crsFactories.getCRSFactory().createDerivedCRS(this.displayProperties, this.affineMethod, objectiveCRS, mt, (CoordinateSystem)displayCS);
            }
            catch (FactoryException exception) {
                throw new IllegalStateException(Errors.format(46));
            }
        }
        if (!$assertionsDisabled && (this.displayProperties == null || this.displayProperties.isEmpty())) {
            throw new AssertionError(this.displayProperties);
        }
        if (!$assertionsDisabled && this.displayCRS.getBaseCRS() != this.getObjectiveCRS()) {
            throw new AssertionError(this.displayCRS);
        }
        return this.displayCRS;
    }

    protected synchronized void setDisplayCRS(DerivedCRS crs) throws TransformException {
        DerivedCRS oldCRS = this.displayCRS;
        try {
            this.displayCRS = this.validateBaseCRS(crs, this.getObjectiveCRS());
        }
        catch (FactoryException exception) {
            throw new TransformException(Errors.format(46), (Throwable)exception);
        }
        if (this.displayProperties == null) {
            this.displayProperties = AbstractIdentifiedObject.getProperties((IdentifiedObject)crs, null);
        }
        this.scaleFactor = null;
        this.displayPosition = null;
        if (this.hasDisplayListeners) {
            this.listeners.firePropertyChange("displayCRS", oldCRS, crs);
        }
    }

    public final synchronized DerivedCRS getDeviceCRS() {
        DerivedCRS displayCRS = this.getDisplayCRS();
        if (this.deviceCRS == null) {
            try {
                FactoryGroup crsFactories = this.getFactoryGroup();
                CoordinateSystem deviceCS = displayCRS.getCoordinateSystem();
                XMatrix identity = MatrixFactory.create(deviceCS.getDimension() + 1);
                MathTransform mt = crsFactories.getMathTransformFactory().createAffineTransform((Matrix)identity);
                this.deviceProperties = AbstractIdentifiedObject.getProperties((IdentifiedObject)deviceCS, null);
                this.deviceCRS = crsFactories.getCRSFactory().createDerivedCRS(this.deviceProperties, this.affineMethod, (CoordinateReferenceSystem)displayCRS, mt, deviceCS);
            }
            catch (FactoryException exception) {
                throw new IllegalStateException(Errors.format(46));
            }
        }
        if (this.deviceCRS.getBaseCRS() != displayCRS) {
            try {
                Conversion displayToDevice = this.deviceCRS.getConversionFromBase();
                this.deviceCRS = ReferencedCanvas.createDerivedCRS(this.deviceProperties, displayToDevice, (CoordinateReferenceSystem)displayCRS, this.deviceCRS.getCoordinateSystem());
            }
            catch (FactoryException exception) {
                throw new IllegalStateException(Errors.format(46));
            }
        }
        if (!$assertionsDisabled && (this.deviceProperties == null || this.deviceProperties.isEmpty())) {
            throw new AssertionError(this.deviceProperties);
        }
        if (!$assertionsDisabled && this.deviceCRS.getBaseCRS() != this.getDisplayCRS()) {
            throw new AssertionError(this.deviceCRS);
        }
        if (!$assertionsDisabled && this.deviceCRS.getCoordinateSystem() != displayCRS.getCoordinateSystem()) {
            throw new AssertionError(this.deviceCRS);
        }
        return this.deviceCRS;
    }

    protected synchronized void setDeviceCRS(DerivedCRS crs) throws TransformException {
        try {
            this.deviceCRS = this.validateBaseCRS(crs, (CoordinateReferenceSystem)this.getDisplayCRS());
        }
        catch (FactoryException exception) {
            throw new TransformException(Errors.format(46), (Throwable)exception);
        }
        if (this.deviceProperties == null) {
            this.deviceProperties = AbstractIdentifiedObject.getProperties((IdentifiedObject)crs, null);
        }
    }

    private final DerivedCRS validateBaseCRS(DerivedCRS crs, CoordinateReferenceSystem baseCRS) throws FactoryException {
        if (crs.getBaseCRS() != baseCRS) {
            Conversion conversion;
            CoordinateOperationFactory factory = this.getCoordinateOperationFactory();
            CoordinateOperation operation = factory.createOperation(baseCRS, (CoordinateReferenceSystem)crs);
            try {
                conversion = (Conversion)operation;
            }
            catch (ClassCastException exception) {
                throw new FactoryException(Errors.format(46), (Throwable)exception);
            }
            crs = ReferencedCanvas.createDerivedCRS(AbstractIdentifiedObject.getProperties((IdentifiedObject)crs, null), conversion, baseCRS, crs.getCoordinateSystem());
        }
        return crs;
    }

    private static DerivedCRS createDerivedCRS(Map properties, Conversion conversionFromBase, CoordinateReferenceSystem base, CoordinateSystem derivedCS) throws FactoryException {
        return new DefaultDerivedCRS(properties, conversionFromBase, base, conversionFromBase.getMathTransform(), derivedCS);
    }

    private DerivedCRS createDerivedCRS(boolean device, Matrix transform) throws FactoryException {
        Map properties;
        DerivedCRS crs;
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (device) {
            crs = this.getDeviceCRS();
            properties = this.deviceProperties;
        } else {
            crs = this.getDisplayCRS();
            properties = this.displayProperties;
        }
        FactoryGroup crsFactories = this.getFactoryGroup();
        MathTransform mt = crsFactories.getMathTransformFactory().createAffineTransform(transform);
        crs = crsFactories.getCRSFactory().createDerivedCRS(properties, this.affineMethod, crs.getBaseCRS(), mt, crs.getCoordinateSystem());
        return crs;
    }

    protected synchronized void setDisplayToDeviceTransform(Matrix transform) throws TransformException {
        DerivedCRS crs;
        try {
            crs = this.createDerivedCRS(true, transform);
        }
        catch (FactoryException exception) {
            throw new TransformException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.setDeviceCRS(crs);
    }

    public synchronized void setObjectiveToDisplayTransform(Matrix transform) throws TransformException {
        DerivedCRS crs;
        try {
            crs = this.createDerivedCRS(false, transform);
        }
        catch (FactoryException exception) {
            throw new TransformException(exception.getLocalizedMessage(), (Throwable)exception);
        }
        this.setDisplayCRS(crs);
    }

    public void setObjectiveToDisplayTransform(MathTransform transform) throws TransformException {
        if (!(transform instanceof LinearTransform)) {
            throw new TransformException(Errors.format(85));
        }
        this.setObjectiveToDisplayTransform(((LinearTransform)transform).getMatrix());
    }

    public synchronized MathTransform getObjectiveToDisplayTransform() {
        DerivedCRS displayCRS = this.getDisplayCRS();
        if (!$assertionsDisabled && !displayCRS.getBaseCRS().equals(this.getObjectiveCRS())) {
            throw new AssertionError(displayCRS);
        }
        return displayCRS.getConversionFromBase().getMathTransform();
    }

    public MathTransform getDisplayToObjectiveTransform() {
        try {
            return this.getObjectiveToDisplayTransform().inverse();
        }
        catch (NoninvertibleTransformException exception) {
            throw new IllegalStateException(Errors.format(75));
        }
    }

    final synchronized MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, String sourceClassName, String sourceMethodName) throws FactoryException {
        GeneralDerivedCRS derivedCRS;
        MathTransform tr;
        if (sourceCRS == targetCRS) {
            return IdentityTransform.create(sourceCRS.getCoordinateSystem().getDimension());
        }
        CoordinateReferenceSystem objectiveCRS = this.getObjectiveCRS();
        boolean cachedTransform = CRSUtilities.equalsIgnoreMetadata(targetCRS, objectiveCRS);
        if (cachedTransform && (tr = (MathTransform)this.transforms.get(sourceCRS)) != null) {
            return tr;
        }
        if (targetCRS instanceof GeneralDerivedCRS && CRSUtilities.equalsIgnoreMetadata(sourceCRS, (derivedCRS = (GeneralDerivedCRS)targetCRS).getBaseCRS())) {
            return derivedCRS.getConversionFromBase().getMathTransform();
        }
        Logger logger = this.getLogger();
        if (logger.isLoggable(Level.FINER)) {
            LogRecord record = Logging.getResources(this.getLocale()).getLogRecord(Level.FINER, 9, ReferencedCanvas.toString(sourceCRS), ReferencedCanvas.toString(targetCRS));
            record.setSourceClassName(sourceClassName);
            record.setSourceMethodName(sourceMethodName);
            logger.log(record);
        }
        CoordinateOperationFactory factory = this.getCoordinateOperationFactory();
        tr = factory.createOperation(sourceCRS, targetCRS).getMathTransform();
        if (cachedTransform) {
            this.transforms.put(sourceCRS, tr);
        }
        return tr;
    }

    private CoordinateOperationFactory getCoordinateOperationFactory() throws FactoryException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.opFactory == null) {
            Hints tmp = new Hints((Map)this.hints);
            tmp.putAll((Map<?, ?>)this.getFactoryGroup().getImplementationHints());
            this.opFactory = FactoryFinder.getCoordinateOperationFactory(tmp);
        }
        return this.opFactory;
    }

    private FactoryGroup getFactoryGroup() throws FactoryException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.crsFactories == null) {
            this.crsFactories = FactoryGroup.createInstance(this.hints);
            this.affineMethod = this.crsFactories.getOperationMethod("affine");
        }
        return this.crsFactories;
    }

    private static String toString(CoordinateReferenceSystem crs) {
        return Utilities.getShortClassName(crs) + "[\"" + crs.getName().getCode() + "\"]";
    }

    protected final GeneralDirectPosition toObjectivePosition(DirectPosition coordinate) throws TransformException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.objectivePosition == null) {
            this.objectivePosition = new TransformedDirectPosition(null, this.getObjectiveCRS(), this.hints);
        }
        if (!$assertionsDisabled && !Utilities.equals(this.objectivePosition.getCoordinateReferenceSystem(), this.getObjectiveCRS())) {
            throw new AssertionError();
        }
        this.objectivePosition.transform(coordinate);
        return this.objectivePosition;
    }

    protected final GeneralDirectPosition toDisplayPosition(DirectPosition coordinate) throws TransformException {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.displayPosition == null) {
            this.displayPosition = new TransformedDirectPosition(null, (CoordinateReferenceSystem)this.getDisplayCRS(), this.hints);
        }
        if (!$assertionsDisabled && !Utilities.equals(this.displayPosition.getCoordinateReferenceSystem(), this.getDisplayCRS())) {
            throw new AssertionError();
        }
        this.displayPosition.transform(coordinate);
        return this.displayPosition;
    }

    private void handleException(String sourceMethodName, Exception exception) {
        this.handleException("ReferencedCanvas", sourceMethodName, exception);
    }

    void listenersChanged() {
        super.listenersChanged();
        this.hasScaleListeners = this.listeners.hasListeners("scale");
        this.hasDisplayListeners = this.listeners.hasListeners("displayCRS");
        this.hasEnvelopeListeners = this.listeners.hasListeners("envelope");
    }

    protected void clearCache() {
        super.clearCache();
        this.transforms.clear();
        this.opFactory = null;
        this.crsFactories = null;
        this.affineMethod = null;
        this.objectivePosition = null;
        this.displayPosition = null;
    }

    static {
        $assertionsDisabled = !ReferencedCanvas.class.desiredAssertionStatus();
    }
}

