/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.Action;
import javax.units.ConversionException;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.display.canvas.GraphicVisitor2D;
import org.geotools.display.canvas.ReferencedCanvas;
import org.geotools.display.canvas.ReferencedGraphic2D;
import org.geotools.display.event.ReferencedEvent;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.AffineTransform2D;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.Utilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.geotools.resources.i18n.Logging;
import org.opengis.go.display.DisplayFactory;
import org.opengis.go.display.primitive.Graphic;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;

public abstract class ReferencedCanvas2D
extends ReferencedCanvas {
    protected final AffineTransform2D objectiveToDisplay = new AffineTransform2D();
    protected final AffineTransform2D displayToDevice = new AffineTransform2D();
    protected final AffineTransform normalizeToDots = new AffineTransform();
    private Shape displayBounds = XRectangle2D.INFINITY;
    private transient Shape dirtyArea;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ReferencedCanvas2D(DisplayFactory factory) {
        super(factory, 2);
        this.updateNormalizationFactor(this.getObjectiveCRS());
    }

    public void setObjectiveCRS(CoordinateReferenceSystem crs) throws TransformException {
        super.setObjectiveCRS(CRSUtilities.getCRS2D(crs));
    }

    public Rectangle2D getEnvelope2D() {
        return super.getEnvelope2D();
    }

    public Shape getDisplayBounds() {
        return this.displayBounds;
    }

    public synchronized void setDisplayBounds(Shape bounds) {
        if (bounds == null) {
            bounds = XRectangle2D.INFINITY;
        }
        Shape old = this.displayBounds;
        this.displayBounds = bounds;
        this.listeners.firePropertyChange("displayBounds", old, bounds);
    }

    protected final Rectangle objectiveToDisplay(Rectangle2D bounds) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        return (Rectangle)XAffineTransform.transform(this.objectiveToDisplay, bounds, new Rectangle());
    }

    public abstract void repaint(Graphic var1, Rectangle2D var2, Rectangle var3);

    final boolean isDirtyArea(Rectangle area) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        if (this.dirtyArea == null) {
            return true;
        }
        if (area == null) {
            return this.dirtyArea.equals(XRectangle2D.INFINITY);
        }
        return this.dirtyArea.contains(area);
    }

    protected void paintStarted(Shape dirtyArea) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.dirtyArea = dirtyArea;
    }

    protected void paintFinished(boolean success) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        this.dirtyArea = null;
    }

    public synchronized boolean isVisible(DirectPosition coordinate) {
        GeneralDirectPosition position;
        try {
            position = this.toDisplayPosition(coordinate);
        }
        catch (TransformException e) {
            return false;
        }
        return this.getDisplayBounds().contains(position.ordinates[0], position.ordinates[1]);
    }

    public boolean format(ReferencedEvent event, StringBuffer toAppendTo) {
        return (Boolean)this.visit(new GraphicVisitor2D.Format(event, toAppendTo), event);
    }

    public String getToolTipText(ReferencedEvent event) {
        return (String)this.visit(new GraphicVisitor2D.ToolTipText(event), event);
    }

    public Action getAction(ReferencedEvent event) {
        return (Action)this.visit(new GraphicVisitor2D.Action(event), event);
    }

    protected void updateNormalizationFactor(CoordinateReferenceSystem crs) {
        super.updateNormalizationFactor(crs);
        Ellipsoid ellipsoid = CRSUtilities.getHeadGeoEllipsoid(crs);
        CoordinateSystem cs = crs.getCoordinateSystem();
        Unit unit0 = cs.getAxis(0).getUnit();
        Unit unit1 = cs.getAxis(1).getUnit();
        boolean sameUnit = Utilities.equals(unit0, unit1);
        this.normalizeToDots.setToScale(this.getNormalizationFactor(unit0, ellipsoid, true), this.getNormalizationFactor(unit1, ellipsoid, !sameUnit));
    }

    private double getNormalizationFactor(Unit unit, Ellipsoid ellipsoid, boolean log) {
        double m;
        block5: {
            m = 1.0;
            try {
                if (ellipsoid != null) {
                    if (unit == null) {
                        unit = NonSI.DEGREE_ANGLE;
                    }
                    m = unit.getConverterTo(SI.RADIAN).convert(m) * 0.5 * (ellipsoid.getSemiMajorAxis() + ellipsoid.getSemiMinorAxis());
                    unit = ellipsoid.getAxisUnit();
                }
                if (unit != null) {
                    m = unit.getConverterTo(SI.METER).convert(m);
                }
            }
            catch (ConversionException exception) {
                if (!log) break block5;
                LogRecord record = Logging.getResources(this.getLocale()).getLogRecord(Level.WARNING, 19, unit);
                record.setSourceClassName("ReferencedCanvas2D");
                record.setSourceMethodName("setObjectiveCRS");
                record.setThrown(exception);
                this.getLogger().log(record);
            }
        }
        return 2834.6456692913384 * m;
    }

    protected void zoomChanged(AffineTransform change) {
        if (!$assertionsDisabled && !Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        List graphics = this.getGraphics();
        int i = graphics.size();
        while (--i >= 0) {
            Graphic graphic = (Graphic)graphics.get(i);
            if (!(graphic instanceof ReferencedGraphic2D)) continue;
            ((ReferencedGraphic2D)graphic).zoomChanged(change);
        }
    }

    static {
        $assertionsDisabled = !ReferencedCanvas2D.class.desiredAssertionStatus();
    }
}

