/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import javax.swing.Action;
import org.geotools.display.canvas.AbstractGraphic;
import org.geotools.display.canvas.ReferencedCanvas;
import org.geotools.display.event.ReferencedEvent;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.FactoryFinder;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.go.display.canvas.Canvas;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public abstract class ReferencedGraphic
extends AbstractGraphic {
    private final GeneralEnvelope envelope;
    private double[] typicalCellDimension;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ReferencedGraphic(CoordinateReferenceSystem crs) throws IllegalArgumentException {
        if (crs == null) {
            throw new IllegalArgumentException(Errors.getResources(this.getLocale()).getString(42, "crs", crs));
        }
        this.envelope = new GeneralEnvelope(crs);
        this.envelope.setToNull();
    }

    public final CoordinateReferenceSystem getObjectiveCRS() {
        return this.envelope.getCoordinateReferenceSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setObjectiveCRS(CoordinateReferenceSystem crs) throws TransformException {
        if (crs == null) {
            throw new IllegalArgumentException(Errors.getResources(this.getLocale()).getString(42, "crs", crs));
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            CoordinateReferenceSystem oldCRS = this.getObjectiveCRS();
            if (CRSUtilities.equalsIgnoreMetadata(oldCRS, crs)) {
                this.envelope.setCoordinateReferenceSystem(crs);
            } else {
                MathTransform transform = this.getMathTransform(oldCRS, crs, "ReferencedGraphic", "setObjectiveCRS");
                if (!transform.isIdentity()) {
                    GeneralEnvelope newEnvelope;
                    GeneralDirectPosition origin;
                    if (this.envelope.isNull() || this.envelope.isInfinite()) {
                        origin = new GeneralDirectPosition(oldCRS);
                        newEnvelope = new GeneralEnvelope(this.envelope);
                    } else {
                        origin = this.envelope.getCenter();
                        newEnvelope = CRSUtilities.transform(transform, this.envelope);
                    }
                    newEnvelope.setCoordinateReferenceSystem(crs);
                    double[] cellDimension = this.typicalCellDimension;
                    if (cellDimension != null) {
                        GeneralDirectPosition vector = new GeneralDirectPosition(cellDimension);
                        vector = CRSUtilities.deltaTransform(transform, origin, vector);
                        cellDimension = vector.getCoordinates();
                        for (int i = 0; i < cellDimension.length; ++i) {
                            cellDimension[i] = Math.abs(cellDimension[i]);
                        }
                    }
                    this.transform(transform);
                    this.envelope.setEnvelope(newEnvelope);
                    this.typicalCellDimension = cellDimension;
                    this.clearCache();
                }
            }
            this.listeners.firePropertyChange("objectiveCRS", oldCRS, crs);
            this.refresh();
        }
    }

    private MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, String sourceClassName, String sourceMethodName) throws TransformException {
        try {
            Canvas owner = this.getCanvas();
            if (owner instanceof ReferencedCanvas) {
                return ((ReferencedCanvas)owner).getMathTransform(sourceCRS, targetCRS, sourceClassName, sourceMethodName);
            }
            return FactoryFinder.getCoordinateOperationFactory(null).createOperation(sourceCRS, targetCRS).getMathTransform();
        }
        catch (FactoryException exception) {
            Errors.getResources(this.getLocale());
            throw new TransformException(Errors.format(46), (Throwable)exception);
        }
    }

    protected void transform(MathTransform mt) throws TransformException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Envelope getEnvelope() {
        Object object = this.getTreeLock();
        synchronized (object) {
            return new GeneralEnvelope(this.envelope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEnvelope(Envelope newEnvelope) throws TransformException {
        Object object = this.getTreeLock();
        synchronized (object) {
            CoordinateReferenceSystem sourceCRS = this.getObjectiveCRS();
            CoordinateReferenceSystem targetCRS = newEnvelope.getLowerCorner().getCoordinateReferenceSystem();
            if (targetCRS == null) {
                targetCRS = sourceCRS;
            }
            MathTransform mt = this.getMathTransform(sourceCRS, targetCRS, "ReferencedGraphic", "setEnvelope");
            GeneralEnvelope old = new GeneralEnvelope(this.envelope);
            this.envelope.setEnvelope(CRSUtilities.transform(mt, newEnvelope));
            if (!$assertionsDisabled && this.envelope.getCoordinateReferenceSystem() != old.getCoordinateReferenceSystem()) {
                throw new AssertionError();
            }
            this.listeners.firePropertyChange("envelope", old, this.envelope);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getTypicalCellDimension(DirectPosition position) {
        Object object = this.getTreeLock();
        synchronized (object) {
            return this.typicalCellDimension != null ? (double[])this.typicalCellDimension.clone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTypicalCellDimension(double[] size) throws MismatchedDimensionException {
        Object object = this.getTreeLock();
        synchronized (object) {
            int expectedDimension;
            int dimension;
            if (size != null && (dimension = size.length) != (expectedDimension = this.envelope.getDimension())) {
                throw new MismatchedDimensionException(Errors.getResources(this.getLocale()).getString(69, new Integer(dimension), new Integer(expectedDimension)));
            }
            double[] oldSize = this.typicalCellDimension;
            this.typicalCellDimension = size != null ? (double[])size.clone() : null;
        }
    }

    protected String getToolTipText(ReferencedEvent event) {
        return null;
    }

    protected Action getAction(ReferencedEvent event) {
        return null;
    }

    protected boolean format(ReferencedEvent event, StringBuffer toAppendTo) {
        return false;
    }

    static {
        $assertionsDisabled = !ReferencedGraphic.class.desiredAssertionStatus();
    }
}

