/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import org.geotools.display.canvas.ReferencedCanvas2D;
import org.geotools.display.canvas.ReferencedGraphic;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.geometry.XRectangle2D;
import org.opengis.go.display.canvas.Canvas;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public abstract class ReferencedGraphic2D
extends ReferencedGraphic {
    private transient Shape displayBounds = XRectangle2D.INFINITY;
    private boolean hasBoundsListeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ReferencedGraphic2D() {
        super(DefaultEngineeringCRS.GENERIC_2D);
    }

    protected ReferencedGraphic2D(CoordinateReferenceSystem crs) throws IllegalArgumentException {
        super(ReferencedGraphic2D.to2D(crs));
    }

    private static CoordinateReferenceSystem to2D(CoordinateReferenceSystem crs) {
        try {
            return CRSUtilities.getCRS2D(crs);
        }
        catch (TransformException e) {
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    protected void setObjectiveCRS(CoordinateReferenceSystem crs) throws TransformException {
        super.setObjectiveCRS(CRSUtilities.getCRS2D(crs));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setEnvelope(Envelope envelope) throws TransformException {
        Object object = this.getTreeLock();
        synchronized (object) {
            super.setEnvelope(envelope);
            this.displayBounds = XRectangle2D.INFINITY;
        }
    }

    final Shape getDisplayBounds() {
        return this.displayBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setDisplayBounds(Shape bounds) {
        if (bounds == null) {
            bounds = XRectangle2D.INFINITY;
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            Shape old = this.displayBounds;
            this.displayBounds = bounds;
            if (this.hasBoundsListeners) {
                this.listeners.firePropertyChange("displayBounds", old, bounds);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.displayBounds.equals(XRectangle2D.INFINITY)) {
                this.refresh(null, this.displayBounds.getBounds());
            } else {
                this.refresh(XRectangle2D.INFINITY, null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Rectangle2D bounds) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.refresh(bounds != null ? bounds : XRectangle2D.INFINITY, null);
        }
    }

    private void refresh(Rectangle2D objectiveArea, Rectangle displayArea) {
        Canvas owner = this.getCanvas();
        if (owner instanceof ReferencedCanvas2D) {
            ReferencedCanvas2D canvas = (ReferencedCanvas2D)owner;
            canvas.repaint(this, objectiveArea, displayArea);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void zoomChanged(AffineTransform change) {
        Object object = this.getTreeLock();
        synchronized (object) {
            ReferencedCanvas2D canvas;
            Shape canvasBounds;
            Canvas owner;
            Shape displayBounds = this.getDisplayBounds();
            if (displayBounds.equals(XRectangle2D.INFINITY)) {
                return;
            }
            if (change != null && (owner = this.getCanvas()) instanceof ReferencedCanvas2D && !(canvasBounds = (canvas = (ReferencedCanvas2D)owner).getDisplayBounds()).equals(XRectangle2D.INFINITY)) {
                Area newArea = new Area(canvasBounds);
                newArea.subtract(newArea.createTransformedArea(change));
                Area area = displayBounds instanceof Area ? (Area)displayBounds : new Area(displayBounds);
                area.transform(change);
                area.add(newArea);
                this.setDisplayBounds(area);
                return;
            }
            this.setDisplayBounds(XRectangle2D.INFINITY);
        }
    }

    void listenersChanged() {
        super.listenersChanged();
        this.hasBoundsListeners = this.hasListeners("displayBounds");
    }

    protected void clearCache() {
        if (!$assertionsDisabled && !Thread.holdsLock(this.getTreeLock())) {
            throw new AssertionError();
        }
        this.displayBounds = null;
        super.clearCache();
    }

    static {
        $assertionsDisabled = !ReferencedGraphic2D.class.desiredAssertionStatus();
    }
}

