/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import org.geotools.display.canvas.ReferencedCanvas;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.i18n.Errors;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public final class RenderingContext {
    private final ReferencedCanvas canvas;
    private Graphics2D graphics;
    public final CoordinateReferenceSystem objectiveCRS;
    public final CoordinateReferenceSystem displayCRS;
    private AffineTransform objectiveToDevice;
    private AffineTransform displayToDevice;
    Shape paintedArea;
    private final Rectangle displayBounds;
    private transient Shape objectiveBounds;
    private final boolean isPrinting;

    RenderingContext(ReferencedCanvas canvas, Rectangle displayBounds, boolean isPrinting) {
        this.canvas = canvas;
        this.objectiveCRS = canvas.getObjectiveCRS();
        this.displayCRS = canvas.getDisplayCRS();
        this.displayBounds = displayBounds;
        this.isPrinting = isPrinting;
    }

    final void setGraphics(Graphics2D graphics, AffineTransform objectiveToDisplay) {
        this.graphics = graphics;
        if (graphics != null) {
            this.displayToDevice = graphics.getTransform();
            this.objectiveToDevice = new AffineTransform(this.displayToDevice);
            this.objectiveToDevice.concatenate(objectiveToDisplay);
        } else {
            this.objectiveToDevice = null;
            this.displayToDevice = null;
        }
        this.paintedArea = null;
    }

    final void disposeGraphics() {
        this.graphics.dispose();
        this.graphics = null;
    }

    public final Graphics2D getGraphics() {
        return this.graphics;
    }

    public Shape getPaintingArea(CoordinateReferenceSystem crs) throws TransformException {
        MathTransform2D mt;
        if (CRSUtilities.equalsIgnoreMetadata(this.displayCRS, crs = CRSUtilities.getCRS2D(crs))) {
            return this.displayBounds;
        }
        boolean isObjectiveCRS = CRSUtilities.equalsIgnoreMetadata(this.objectiveCRS, crs);
        if (isObjectiveCRS && this.objectiveBounds != null) {
            return this.objectiveBounds;
        }
        try {
            mt = (MathTransform2D)this.getMathTransform(this.displayCRS, crs);
        }
        catch (FactoryException e) {
            throw new TransformException(Errors.format(26), (Throwable)e);
        }
        Shape userBounds = mt.createTransformedShape((Shape)this.displayBounds);
        if (isObjectiveCRS) {
            this.objectiveBounds = userBounds;
        }
        return userBounds;
    }

    final Rectangle getPaintingArea() {
        return this.displayBounds;
    }

    /*
     * WARNING - void declaration
     */
    public void setGraphicsCRS(CoordinateReferenceSystem crs) throws TransformException {
        void var2_2;
        AffineTransform at;
        if (crs == this.objectiveCRS) {
            at = this.objectiveToDevice;
        } else if (crs == this.displayCRS) {
            at = this.displayToDevice;
        } else {
            try {
                crs = CRSUtilities.getCRS2D(crs);
                at = this.getAffineTransform(crs, this.displayCRS);
                at.preConcatenate(this.displayToDevice);
            }
            catch (FactoryException e) {
                throw new TransformException(Errors.format(46), (Throwable)e);
            }
        }
        this.graphics.setTransform((AffineTransform)var2_2);
    }

    public AffineTransform getAffineTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        MathTransform mt = this.canvas.getMathTransform(sourceCRS, targetCRS, "RenderingContext", "getAffineTransform");
        try {
            return (AffineTransform)mt;
        }
        catch (ClassCastException cause) {
            throw new FactoryException(Errors.format(85), (Throwable)cause);
        }
    }

    public MathTransform getMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException {
        return this.canvas.getMathTransform(sourceCRS, targetCRS, "RenderingContext", "getMathTransform");
    }

    public double getScale() {
        return this.canvas.getScale();
    }

    public boolean isPrinting() {
        return this.isPrinting;
    }

    public void addPaintedArea(Shape area) {
        try {
            this.addPaintedArea(area, null);
        }
        catch (TransformException exception) {
            throw new AssertionError((Object)exception);
        }
    }

    public void addPaintedArea(Shape area, CoordinateReferenceSystem crs) throws TransformException {
        Shape userArea = area;
        if (crs != null) {
            MathTransform mt;
            crs = CRSUtilities.getCRS2D(crs);
            try {
                mt = this.canvas.getMathTransform(this.displayCRS, crs, "RenderingContext", "addPaintedArea");
            }
            catch (FactoryException e) {
                throw new TransformException(Errors.format(26, (Object)e));
            }
            MathTransform2D transform = (MathTransform2D)mt.inverse();
            if (!transform.isIdentity()) {
                area = transform.createTransformedShape(area);
            }
        } else {
            AffineTransform transform = this.graphics.getTransform();
            if (!transform.isIdentity()) {
                area = transform.createTransformedShape(area);
            }
        }
        if (this.paintedArea == null) {
            if (area == userArea && area instanceof Area) {
                area = new Area(area);
            }
            this.paintedArea = area;
        } else {
            if (!(this.paintedArea instanceof Area)) {
                this.paintedArea = new Area(area);
            }
            ((Area)this.paintedArea).add(area instanceof Area ? (Area)area : new Area(area));
        }
    }
}

