/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.units.Unit;
import org.geotools.display.canvas.AbstractCanvas;
import org.geotools.resources.Utilities;
import org.geotools.resources.i18n.Logging;
import org.geotools.resources.i18n.Vocabulary;

final class RenderingStatistics {
    private static final int TIME_THRESHOLD = 250;
    private static final Level LEVEL = Level.FINE;
    private boolean loggable;
    private long startTime;
    private long ellapsedTime;
    private int recomputed;
    private int rendered;
    private int total;
    private double resolution;
    private double resolutionScale = 1.0;
    private Unit units;
    private final Logger logger;

    public RenderingStatistics(Logger logger) {
        this.logger = logger;
    }

    final void init() {
        this.startTime = System.currentTimeMillis();
        this.ellapsedTime = 0L;
        this.recomputed = 0;
        this.rendered = 0;
        this.total = 0;
        this.resolution = 0.0;
        this.resolutionScale = 1.0;
        this.units = Unit.ONE;
        this.loggable = this.logger.isLoggable(LEVEL);
    }

    final void setResolutionScale(double scale, Unit units) {
        this.resolutionScale = scale;
        this.units = units;
    }

    final void addGeometry(int total, int rendered, int recomputed, double resolution) {
        this.total += total;
        this.rendered += rendered;
        this.recomputed += recomputed;
        if (!Double.isNaN(resolution *= (double)rendered)) {
            this.resolution += resolution * this.resolutionScale;
        }
    }

    final void finish(AbstractCanvas canvas) {
        this.ellapsedTime = System.currentTimeMillis() - this.startTime;
        if (this.isLoggable() && this.ellapsedTime >= 250L) {
            this.logger.log(this.createLogRecord(canvas));
        }
    }

    private LogRecord createLogRecord(AbstractCanvas canvas) {
        String title;
        Locale locale;
        Double ellapsed = new Double((this.ellapsedTime != 0L ? this.ellapsedTime : System.currentTimeMillis() - this.startTime) / 1000L);
        if (canvas != null) {
            locale = canvas.getLocale();
            title = canvas.getTitle();
        } else {
            locale = Locale.getDefault();
            title = Vocabulary.format(176);
        }
        Logging resources = Logging.getResources(locale);
        LogRecord record = this.total == 0 || this.rendered == 0 ? resources.getLogRecord(LEVEL, 13, title, ellapsed) : new LogRecord(LEVEL, resources.getString(13, title, ellapsed) + System.getProperty("line.separator", "\n") + resources.getString(14, new Double((double)this.rendered / (double)this.total), new Double((double)(this.rendered - this.recomputed) / (double)this.rendered), new Double(this.resolution / (double)this.rendered), this.units));
        record.setSourceClassName(Utilities.getShortClassName(canvas));
        record.setSourceMethodName("paint");
        return record;
    }

    final boolean isLoggable() {
        return this.loggable;
    }

    public String toString() {
        return this.createLogRecord(null).getMessage();
    }
}

