/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.canvas.map;

import java.awt.Rectangle;
import javax.units.Unit;
import org.geotools.display.canvas.DefaultCanvasState;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.Utilities;
import org.opengis.go.display.canvas.map2d.Map2DState;
import org.opengis.spatialschema.geometry.Envelope;

public class DefaultMapState
extends DefaultCanvasState
implements Map2DState {
    private static final long serialVersionUID = 1753033112812208638L;
    private final GeneralEnvelope envelope;
    private final int width;
    private final int height;
    private final double scale;

    public DefaultMapState(String title, Envelope envelope, Rectangle bounds, double scale) {
        super(title, envelope);
        this.envelope = new GeneralEnvelope(envelope);
        this.width = bounds.width;
        this.height = bounds.height;
        this.scale = scale;
    }

    public int getPixelWidth() {
        return this.width;
    }

    public int getPixelHeight() {
        return this.height;
    }

    public double getMapWidth(Unit unit) {
        return this.envelope.getLength(0, unit);
    }

    public double getMapHeight(Unit unit) {
        return this.envelope.getLength(1, unit);
    }

    public double getScale() {
        return this.scale;
    }

    public Envelope getEnvelope() {
        return (Envelope)this.envelope.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            DefaultMapState that = (DefaultMapState)object;
            return this.width == that.width && this.height == that.height && Utilities.equals(this.envelope, that.envelope) && Double.doubleToLongBits(this.scale) == Double.doubleToLongBits(that.scale);
        }
        return false;
    }
}

