/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.NoSuchElementException;

public class Arrow2D
extends RectangularShape {
    private double minX;
    private double minY;
    private double length;
    private double thickness;
    private double sy0 = 0.0;
    private double sy1 = 0.3333333333333333;
    private double sx = 0.6666666666666666;

    public Arrow2D() {
    }

    public Arrow2D(double x, double y, double width, double height) {
        this.minX = x;
        this.minY = y;
        this.length = width;
        this.thickness = height;
    }

    public void setTailProportion(double sx, double sy1, double sy0) {
        if (sy1 < 0.0) {
            sy1 = 0.0;
        }
        if (sy1 > 1.0) {
            sy1 = 1.0;
        }
        if (sy0 < 0.0) {
            sy0 = 0.0;
        }
        if (sy0 > 1.0) {
            sy0 = 1.0;
        }
        if (sx < 0.0) {
            sx = 0.0;
        }
        if (sx > 1.0) {
            sx = 1.0;
        }
        this.sy1 = sy1;
        this.sy0 = sy0;
        this.sx = sx;
    }

    public double getTailLength() {
        return this.sx * this.length;
    }

    public double getX() {
        return this.minX;
    }

    public double getY() {
        return this.minY;
    }

    public double getWidth() {
        return this.length;
    }

    public double getHeight() {
        return this.thickness;
    }

    public double getHeight(double x) {
        if ((x = (x - this.minX) / (this.sx * this.length)) < 0.0 || x > 1.0) {
            return 0.0;
        }
        if (x <= 1.0) {
            return (this.sy0 + (this.sy1 - this.sy0) * x) * this.thickness;
        }
        return (x - 1.0) * this.sx / (1.0 - this.sx) * this.thickness;
    }

    public boolean isEmpty() {
        return !(this.length > 0.0) || !(this.thickness > 0.0);
    }

    public void setFrame(double x, double y, double width, double height) {
        this.minX = x;
        this.minY = y;
        this.length = width;
        this.thickness = height;
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Double(this.minX, this.minY, this.length, this.thickness);
    }

    public boolean contains(double x, double y) {
        if (x < this.minX) {
            return false;
        }
        double base = this.minX + this.sx * this.length;
        if (x <= base) {
            double yMaxAtX = 0.5 * this.thickness;
            y -= this.minY + yMaxAtX;
            return Math.abs(y) <= (yMaxAtX *= this.sy0 + (this.sy1 - this.sy0) * ((x - this.minX) / (base - this.minX)));
        }
        double maxX = this.minX + this.length;
        if (x > maxX) {
            return false;
        }
        double yMaxAtX = 0.5 * this.thickness;
        y -= this.minY + yMaxAtX;
        return Math.abs(y) <= (yMaxAtX *= (maxX - x) / (maxX - base));
    }

    public boolean contains(double x, double y, double width, double height) {
        return this.contains(x, y) && this.contains(x + width, y) && this.contains(x + width, y + height) && this.contains(x, y + height);
    }

    public boolean intersects(double x, double y, double width, double height) {
        double right = x + width;
        double maxX = this.minX + this.length;
        if (x <= maxX && right >= this.minX) {
            double top = y + height;
            double maxY = this.minY + this.thickness;
            if (y <= maxY && top >= this.minY) {
                double yMaxAtX;
                double centerY;
                double base = this.minX + this.length * this.sx;
                return !(x > base ? (y >= (centerY = this.minY + (yMaxAtX = 0.5 * this.thickness)) ? !(y - centerY <= (yMaxAtX *= (maxX - x) / (maxX - base))) : top <= centerY && !(centerY - top <= (yMaxAtX *= (maxX - x) / (maxX - base)))) : right < base && (y >= (centerY = this.minY + (yMaxAtX = 0.5 * this.thickness)) ? !(y - centerY <= (yMaxAtX *= this.sy0 + (this.sy1 - this.sy0) * ((x - this.minX) / (base - this.minX)))) : top <= centerY && !(centerY - top <= (yMaxAtX *= this.sy0 + (this.sy1 - this.sy0) * ((x - this.minX) / (base - this.minX))))));
            }
        }
        return false;
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return new Iterator(at);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass().equals(obj.getClass())) {
            Arrow2D cast = (Arrow2D)obj;
            return Double.doubleToLongBits(this.thickness) == Double.doubleToLongBits(cast.thickness) && Double.doubleToLongBits(this.length) == Double.doubleToLongBits(cast.length) && Double.doubleToLongBits(this.minX) == Double.doubleToLongBits(cast.minX) && Double.doubleToLongBits(this.minY) == Double.doubleToLongBits(cast.minY) && Double.doubleToLongBits(this.sx) == Double.doubleToLongBits(cast.sx) && Double.doubleToLongBits(this.sy0) == Double.doubleToLongBits(cast.sy1) && Double.doubleToLongBits(this.sy1) == Double.doubleToLongBits(cast.sy0);
        }
        return false;
    }

    public int hashCode() {
        long code = Double.doubleToLongBits(this.thickness) + 37L * (Double.doubleToLongBits(this.length) + 37L * (Double.doubleToLongBits(this.minX) + 37L * (Double.doubleToLongBits(this.minY) + 37L * (Double.doubleToLongBits(this.sx) + 37L * (Double.doubleToLongBits(this.sy0) + 37L * Double.doubleToLongBits(this.sy1))))));
        return (int)code + (int)(code >>> 32);
    }

    private class Iterator
    implements PathIterator {
        private final AffineTransform at;
        private final double halfBottom0;
        private final double halfBottom1;
        private final double center;
        private final double halfTop1;
        private final double halfTop0;
        private final double base;
        private int code;

        Iterator(AffineTransform at) {
            this.at = at;
            double halfheight = 0.5 * Arrow2D.this.thickness;
            this.halfBottom0 = Arrow2D.this.minY + halfheight * (1.0 - Arrow2D.this.sy0);
            this.halfBottom1 = Arrow2D.this.minY + halfheight * (1.0 - Arrow2D.this.sy1);
            this.center = Arrow2D.this.minY + halfheight;
            this.halfTop1 = Arrow2D.this.minY + halfheight * (1.0 + Arrow2D.this.sy1);
            this.halfTop0 = Arrow2D.this.minY + halfheight * (1.0 + Arrow2D.this.sy0);
            this.base = Arrow2D.this.minX + Arrow2D.this.sx * Arrow2D.this.length;
        }

        public int getWindingRule() {
            return 0;
        }

        public void next() {
            ++this.code;
        }

        public int currentSegment(float[] coords) {
            switch (this.code) {
                case 0: {
                    coords[0] = (float)Arrow2D.this.minX;
                    coords[1] = (float)this.halfBottom0;
                    break;
                }
                case 1: {
                    coords[0] = (float)this.base;
                    coords[1] = (float)this.halfBottom1;
                    break;
                }
                case 2: {
                    coords[0] = (float)this.base;
                    coords[1] = (float)Arrow2D.this.minY;
                    break;
                }
                case 3: {
                    coords[0] = (float)(Arrow2D.this.minX + Arrow2D.this.length);
                    coords[1] = (float)this.center;
                    break;
                }
                case 4: {
                    coords[0] = (float)this.base;
                    coords[1] = (float)(Arrow2D.this.minY + Arrow2D.this.thickness);
                    break;
                }
                case 5: {
                    coords[0] = (float)this.base;
                    coords[1] = (float)this.halfTop1;
                    break;
                }
                case 6: {
                    coords[0] = (float)Arrow2D.this.minX;
                    coords[1] = (float)this.halfTop0;
                    break;
                }
                case 7: {
                    coords[0] = (float)Arrow2D.this.minX;
                    coords[1] = (float)this.halfBottom0;
                    break;
                }
                case 8: {
                    return 4;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            if (this.at != null) {
                this.at.transform(coords, 0, coords, 0, 1);
            }
            return this.code == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            switch (this.code) {
                case 0: {
                    coords[0] = Arrow2D.this.minX;
                    coords[1] = this.halfBottom0;
                    break;
                }
                case 1: {
                    coords[0] = this.base;
                    coords[1] = this.halfBottom1;
                    break;
                }
                case 2: {
                    coords[0] = this.base;
                    coords[1] = Arrow2D.this.minY;
                    break;
                }
                case 3: {
                    coords[0] = Arrow2D.this.minX + Arrow2D.this.length;
                    coords[1] = this.center;
                    break;
                }
                case 4: {
                    coords[0] = this.base;
                    coords[1] = Arrow2D.this.minY + Arrow2D.this.thickness;
                    break;
                }
                case 5: {
                    coords[0] = this.base;
                    coords[1] = this.halfTop1;
                    break;
                }
                case 6: {
                    coords[0] = Arrow2D.this.minX;
                    coords[1] = this.halfTop0;
                    break;
                }
                case 7: {
                    coords[0] = Arrow2D.this.minX;
                    coords[1] = this.halfBottom0;
                    break;
                }
                case 8: {
                    return 4;
                }
                default: {
                    throw new NoSuchElementException();
                }
            }
            if (this.at != null) {
                this.at.transform(coords, 0, coords, 0, 1);
            }
            return this.code == 0 ? 0 : 1;
        }

        public boolean isDone() {
            return this.code > 8;
        }
    }
}

