/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.style;

import java.awt.Color;
import java.awt.RenderingHints;
import org.geotools.display.canvas.DisplayObject;
import org.geotools.display.style.GraphicStyleListenerList;
import org.geotools.factory.Hints;
import org.opengis.go.display.style.GraphicStyle;
import org.opengis.go.display.style.event.GraphicStyleListener;

public class DefaultGraphicStyle
extends DisplayObject
implements GraphicStyle {
    private Hints hints = new Hints(null);
    private GraphicStyleListenerList graphicStyleListeners = new GraphicStyleListenerList(this);

    public synchronized Object getRenderingHint(RenderingHints.Key key) {
        return this.hints.get(key);
    }

    public synchronized void setRenderingHint(RenderingHints.Key key, Object value) {
        if (value != null) {
            this.hints.put(key, value);
        } else {
            this.hints.remove(key);
        }
    }

    public synchronized void addGraphicStyleListener(GraphicStyleListener listener) {
        if (this.graphicStyleListeners.add(listener)) {
            this.listeners.addPropertyChangeListener(this.graphicStyleListeners);
        }
    }

    public synchronized void removeGraphicStyleListener(GraphicStyleListener listener) {
        if (this.graphicStyleListeners.remove(listener)) {
            this.listeners.removePropertyChangeListener(this.graphicStyleListeners);
        }
    }

    protected void acquireEventLock() {
        this.graphicStyleListeners.acquireEventLock();
    }

    protected void releaseEventLock() {
        this.graphicStyleListeners.releaseEventLock();
    }

    static Color fixAlphaChannel(Color color, float opacity) {
        int alpha = Math.max(0, Math.min(255, Math.round(256.0f * opacity))) << 24;
        int RGB = color.getRGB();
        if ((RGB & 0xFF000000) != alpha) {
            color = new Color(RGB & 0xFFFFFF | alpha, true);
        }
        return color;
    }

    public void setPropertiesFrom(GraphicStyle graphicStyle) {
    }

    public Object clone() {
        DefaultGraphicStyle clone;
        try {
            clone = (DefaultGraphicStyle)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
        clone.hints = (Hints)this.hints.clone();
        clone.graphicStyleListeners = new GraphicStyleListenerList(this.graphicStyleListeners);
        return clone;
    }
}

