/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.style;

import java.awt.Color;
import org.geotools.display.style.DefaultGraphicStyle;
import org.opengis.go.display.style.ArrowStyle;
import org.opengis.go.display.style.DashArray;
import org.opengis.go.display.style.FillPattern;
import org.opengis.go.display.style.FillStyle;
import org.opengis.go.display.style.GraphicStyle;
import org.opengis.go.display.style.LineCap;
import org.opengis.go.display.style.LineJoin;
import org.opengis.go.display.style.LinePattern;
import org.opengis.go.display.style.LineStyle;
import org.opengis.go.display.style.LineSymbolizer;

public class DefaultLineSymbolizer
extends DefaultGraphicStyle
implements LineSymbolizer {
    private ArrowStyle strokeBeginArrowStyle = DEFAULT_STROKE_BEGIN_ARROW_STYLE;
    private Color strokeColor = DEFAULT_STROKE_FILL_COLOR;
    private DashArray strokeDashArray = DEFAULT_STROKE_DASH_ARRAY;
    private float strokeDashOffset = 0.0f;
    private ArrowStyle strokeEndArrowStyle = DEFAULT_STROKE_END_ARROW_STYLE;
    private Color strokeFillBackgroundColor = DEFAULT_STROKE_FILL_BACKGROUND_COLOR;
    private Color strokeFillColor = DEFAULT_STROKE_FILL_COLOR;
    private float[] strokeFillGradientPoints = DEFAULT_STROKE_FILL_GRADIENT_POINTS;
    private float strokeFillOpacity = 1.0f;
    private FillPattern strokeFillPattern = DEFAULT_STROKE_FILL_PATTERN;
    private FillStyle strokeFillStyle = DEFAULT_STROKE_FILL_STYLE;
    private LineCap strokeLineCap = DEFAULT_STROKE_LINE_CAP;
    private float strokeLineGap = 10.0f;
    private LineJoin strokeLineJoin = DEFAULT_STROKE_LINE_JOIN;
    private LinePattern strokeLinePattern = DEFAULT_STROKE_LINE_PATTERN;
    private LineStyle strokeLineStyle = DEFAULT_STROKE_LINE_STYLE;
    private float strokeOpacity = 1.0f;
    private float strokeWidth = 1.0f;

    public synchronized ArrowStyle getStrokeBeginArrowStyle() {
        return this.strokeBeginArrowStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeBeginArrowStyle(ArrowStyle strokeBeginArrowStyle) {
        ArrowStyle old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeBeginArrowStyle;
            this.strokeBeginArrowStyle = strokeBeginArrowStyle;
        }
        this.listeners.firePropertyChange("strokeBeginArrowStyle", old, strokeBeginArrowStyle);
    }

    public synchronized ArrowStyle getStrokeEndArrowStyle() {
        return this.strokeEndArrowStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeEndArrowStyle(ArrowStyle strokeEndArrowStyle) {
        ArrowStyle old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeEndArrowStyle;
            this.strokeEndArrowStyle = strokeEndArrowStyle;
        }
        this.listeners.firePropertyChange("strokeEndArrowStyle", old, strokeEndArrowStyle);
    }

    public synchronized Color getStrokeColor() {
        this.strokeColor = DefaultLineSymbolizer.fixAlphaChannel(this.strokeColor, this.strokeOpacity);
        return this.strokeColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeColor(Color strokeColor) {
        Color old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeColor;
            this.strokeColor = strokeColor;
        }
        this.listeners.firePropertyChange("strokeColor", old, strokeColor);
    }

    public synchronized DashArray getStrokeDashArray() {
        return this.strokeDashArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeDashArray(DashArray strokeDashArray) {
        DashArray old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeDashArray;
            this.strokeDashArray = strokeDashArray;
        }
        this.listeners.firePropertyChange("strokeDashArray", old, strokeDashArray);
    }

    public synchronized float getStrokeDashOffset() {
        return this.strokeDashOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeDashOffset(float strokeDashOffset) {
        float old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeDashOffset;
            this.strokeDashOffset = strokeDashOffset;
        }
        this.listeners.firePropertyChange("strokeDashOffset", new Float(old), new Float(strokeDashOffset));
    }

    public synchronized Color getStrokeFillColor() {
        this.strokeFillColor = DefaultLineSymbolizer.fixAlphaChannel(this.strokeFillColor, this.strokeFillOpacity);
        return this.strokeFillColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeFillColor(Color strokeFillColor) {
        Color old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeFillColor;
            this.strokeFillColor = strokeFillColor;
        }
        this.listeners.firePropertyChange("strokeFillColor", old, strokeFillColor);
    }

    public synchronized Color getStrokeFillBackgroundColor() {
        return this.strokeFillBackgroundColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeFillBackgroundColor(Color strokeFillBackgroundColor) {
        Color old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeFillBackgroundColor;
            this.strokeFillBackgroundColor = strokeFillBackgroundColor;
        }
        this.listeners.firePropertyChange("strokeFillBackgroundColor", old, strokeFillBackgroundColor);
    }

    public synchronized float[] getStrokeFillGradientPoints() {
        return (float[])this.strokeFillGradientPoints.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeFillGradientPoints(float[] strokeFillGradientPoints) {
        float[] old;
        strokeFillGradientPoints = (float[])strokeFillGradientPoints.clone();
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeFillGradientPoints;
            this.strokeFillGradientPoints = strokeFillGradientPoints;
        }
        this.listeners.firePropertyChange("strokeFillGradientPoints", old, strokeFillGradientPoints);
    }

    public synchronized float getStrokeFillOpacity() {
        return this.strokeFillOpacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeFillOpacity(float strokeFillOpacity) {
        float old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeFillOpacity;
            this.strokeFillOpacity = strokeFillOpacity;
        }
        this.listeners.firePropertyChange("strokeFillOpacity", new Float(old), new Float(strokeFillOpacity));
    }

    public synchronized FillPattern getStrokeFillPattern() {
        return this.strokeFillPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeFillPattern(FillPattern strokeFillPattern) {
        FillPattern old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeFillPattern;
            this.strokeFillPattern = strokeFillPattern;
        }
        this.listeners.firePropertyChange("strokeFillPattern", old, strokeFillPattern);
    }

    public synchronized FillStyle getStrokeFillStyle() {
        return this.strokeFillStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeFillStyle(FillStyle strokeFillStyle) {
        FillStyle old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeFillStyle;
            this.strokeFillStyle = strokeFillStyle;
        }
        this.listeners.firePropertyChange("strokeFillStyle", old, strokeFillStyle);
    }

    public synchronized LineCap getStrokeLineCap() {
        return this.strokeLineCap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeLineCap(LineCap strokeLineCap) {
        LineCap old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeLineCap;
            this.strokeLineCap = strokeLineCap;
        }
        this.listeners.firePropertyChange("strokeLineCap", old, strokeLineCap);
    }

    public synchronized float getStrokeLineGap() {
        return this.strokeLineGap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeLineGap(float strokeLineGap) {
        float old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeLineGap;
            this.strokeLineGap = strokeLineGap;
        }
        this.listeners.firePropertyChange("strokeLineGap", new Float(old), new Float(strokeLineGap));
    }

    public synchronized LineJoin getStrokeLineJoin() {
        return this.strokeLineJoin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeLineJoin(LineJoin strokeLineJoin) {
        LineJoin old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeLineJoin;
            this.strokeLineJoin = strokeLineJoin;
        }
        this.listeners.firePropertyChange("strokeLineJoin", old, strokeLineJoin);
    }

    public synchronized LinePattern getStrokeLinePattern() {
        return this.strokeLinePattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeLinePattern(LinePattern strokeLinePattern) {
        LinePattern old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeLinePattern;
            this.strokeLinePattern = strokeLinePattern;
        }
        this.listeners.firePropertyChange("strokeLinePattern", old, strokeLinePattern);
    }

    public synchronized LineStyle getStrokeLineStyle() {
        return this.strokeLineStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeLineStyle(LineStyle strokeLineStyle) {
        LineStyle old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeLineStyle;
            this.strokeLineStyle = strokeLineStyle;
        }
        this.listeners.firePropertyChange("strokeLineStyle", old, strokeLineStyle);
    }

    public synchronized float getStrokeOpacity() {
        return this.strokeOpacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeOpacity(float strokeOpacity) {
        float old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeOpacity;
            this.strokeOpacity = strokeOpacity;
        }
        this.listeners.firePropertyChange("strokeOpacity", new Float(old), new Float(strokeOpacity));
    }

    public synchronized float getStrokeWidth() {
        return this.strokeWidth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStrokeWidth(float strokeWidth) {
        float old;
        DefaultLineSymbolizer defaultLineSymbolizer = this;
        synchronized (defaultLineSymbolizer) {
            old = this.strokeWidth;
            this.strokeWidth = strokeWidth;
        }
        this.listeners.firePropertyChange("strokeWidth", new Float(old), new Float(strokeWidth));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPropertiesFrom(GraphicStyle graphicStyle) {
        this.acquireEventLock();
        try {
            super.setPropertiesFrom(graphicStyle);
            if (graphicStyle instanceof LineSymbolizer) {
                LineSymbolizer ls = (LineSymbolizer)graphicStyle;
                this.setStrokeBeginArrowStyle(ls.getStrokeBeginArrowStyle());
                this.setStrokeColor(ls.getStrokeColor());
                this.setStrokeDashArray(ls.getStrokeDashArray());
                this.setStrokeDashOffset(ls.getStrokeDashOffset());
                this.setStrokeEndArrowStyle(ls.getStrokeEndArrowStyle());
                this.setStrokeFillBackgroundColor(ls.getStrokeFillBackgroundColor());
                this.setStrokeFillColor(ls.getStrokeFillColor());
                this.setStrokeFillGradientPoints(ls.getStrokeFillGradientPoints());
                this.setStrokeFillOpacity(ls.getStrokeFillOpacity());
                this.setStrokeFillPattern(ls.getStrokeFillPattern());
                this.setStrokeFillStyle(ls.getStrokeFillStyle());
                this.setStrokeLineCap(ls.getStrokeLineCap());
                this.setStrokeLineGap(ls.getStrokeLineGap());
                this.setStrokeLineJoin(ls.getStrokeLineJoin());
                this.setStrokeLinePattern(ls.getStrokeLinePattern());
                this.setStrokeLineStyle(ls.getStrokeLineStyle());
                this.setStrokeOpacity(ls.getStrokeOpacity());
                this.setStrokeWidth(ls.getStrokeWidth());
            }
        }
        finally {
            this.releaseEventLock();
        }
    }
}

