/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.style;

import java.awt.Color;
import org.geotools.display.style.DefaultLineSymbolizer;
import org.opengis.go.display.style.FillPattern;
import org.opengis.go.display.style.FillStyle;
import org.opengis.go.display.style.GraphicStyle;
import org.opengis.go.display.style.PolygonSymbolizer;

public class DefaultPolygonSymbolizer
extends DefaultLineSymbolizer
implements PolygonSymbolizer {
    private Color fillBackgroundColor = DEFAULT_FILL_BACKGROUND_COLOR;
    private Color fillColor = DEFAULT_FILL_COLOR;
    private float[] fillGradientPoints = DEFAULT_FILL_GRADIENT_POINTS;
    private float fillOpacity = 1.0f;
    private FillPattern fillPattern = DEFAULT_FILL_PATTERN;
    private FillStyle fillStyle = DEFAULT_FILL_STYLE;

    public synchronized Color getFillColor() {
        this.fillColor = DefaultPolygonSymbolizer.fixAlphaChannel(this.fillColor, this.fillOpacity);
        return this.fillColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillColor(Color fillColor) {
        Color old;
        DefaultPolygonSymbolizer defaultPolygonSymbolizer = this;
        synchronized (defaultPolygonSymbolizer) {
            old = this.fillColor;
            this.fillColor = fillColor;
        }
        this.listeners.firePropertyChange("fillColor", old, fillColor);
    }

    public synchronized Color getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillBackgroundColor(Color fillBackgroundColor) {
        Color old;
        DefaultPolygonSymbolizer defaultPolygonSymbolizer = this;
        synchronized (defaultPolygonSymbolizer) {
            old = this.fillBackgroundColor;
            this.fillBackgroundColor = fillBackgroundColor;
        }
        this.listeners.firePropertyChange("fillBackgroundColor", old, fillBackgroundColor);
    }

    public synchronized float[] getFillGradientPoints() {
        return this.fillGradientPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillGradientPoints(float[] fillGradientPoints) {
        float[] old;
        DefaultPolygonSymbolizer defaultPolygonSymbolizer = this;
        synchronized (defaultPolygonSymbolizer) {
            old = this.fillGradientPoints;
            this.fillGradientPoints = fillGradientPoints;
        }
        this.listeners.firePropertyChange("fillGradientPoints", old, fillGradientPoints);
    }

    public synchronized float getFillOpacity() {
        return this.fillOpacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillOpacity(float fillOpacity) {
        float old;
        DefaultPolygonSymbolizer defaultPolygonSymbolizer = this;
        synchronized (defaultPolygonSymbolizer) {
            old = this.fillOpacity;
            this.fillOpacity = fillOpacity;
        }
        this.listeners.firePropertyChange("fillOpacity", new Float(old), new Float(fillOpacity));
    }

    public synchronized FillPattern getFillPattern() {
        return this.fillPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillPattern(FillPattern fillPattern) {
        FillPattern old;
        DefaultPolygonSymbolizer defaultPolygonSymbolizer = this;
        synchronized (defaultPolygonSymbolizer) {
            old = this.fillPattern;
            this.fillPattern = fillPattern;
        }
        this.listeners.firePropertyChange("fillPattern", old, fillPattern);
    }

    public synchronized FillStyle getFillStyle() {
        return this.fillStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillStyle(FillStyle fillStyle) {
        FillStyle old;
        DefaultPolygonSymbolizer defaultPolygonSymbolizer = this;
        synchronized (defaultPolygonSymbolizer) {
            old = this.fillStyle;
            this.fillStyle = fillStyle;
        }
        this.listeners.firePropertyChange("fillStyle", old, fillStyle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPropertiesFrom(GraphicStyle graphicStyle) {
        this.acquireEventLock();
        try {
            super.setPropertiesFrom(graphicStyle);
            if (graphicStyle instanceof PolygonSymbolizer) {
                PolygonSymbolizer ps = (PolygonSymbolizer)graphicStyle;
                this.setFillBackgroundColor(ps.getFillBackgroundColor());
                this.setFillColor(ps.getFillColor());
                this.setFillGradientPoints(ps.getFillGradientPoints());
                this.setFillOpacity(ps.getFillOpacity());
                this.setFillPattern(ps.getFillPattern());
                this.setFillStyle(ps.getFillStyle());
            }
        }
        finally {
            this.releaseEventLock();
        }
    }
}

