/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.style;

import java.awt.Color;
import java.awt.Font;
import org.geotools.display.style.DefaultGraphicStyle;
import org.opengis.go.display.style.FillPattern;
import org.opengis.go.display.style.FillStyle;
import org.opengis.go.display.style.GraphicStyle;
import org.opengis.go.display.style.TextSymbolizer;
import org.opengis.go.display.style.XAnchor;
import org.opengis.go.display.style.YAnchor;

public class DefaultTextSymbolizer
extends DefaultGraphicStyle
implements TextSymbolizer {
    private Color backgroundColor = DEFAULT_FILL_BACKGROUND_COLOR;
    private Color fillBackgroundColor = DEFAULT_FILL_BACKGROUND_COLOR;
    private Color fillColor = DEFAULT_FILL_COLOR;
    private float[] fillGradientPoints = null;
    private float fillOpacity = 1.0f;
    private FillPattern fillPattern = DEFAULT_FILL_PATTERN;
    private FillStyle fillStyle = DEFAULT_FILL_STYLE;
    private Font font = DEFAULT_FONT;
    private float haloRadius = 0.0f;
    private Color haloColor = null;
    private float rotation = 0.0f;
    private XAnchor xAnchor = DEFAULT_X_ANCHOR;
    private float xDisplacement = 0.0f;
    private YAnchor yAnchor = DEFAULT_Y_ANCHOR;
    private float yDisplacement = 0.0f;

    public synchronized Color getFillColor() {
        this.fillColor = DefaultTextSymbolizer.fixAlphaChannel(this.fillColor, this.fillOpacity);
        return this.fillColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillColor(Color fillColor) {
        Color old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.fillColor;
            this.fillColor = fillColor;
        }
        this.listeners.firePropertyChange("fillColor", old, fillColor);
    }

    public synchronized Color getFillBackgroundColor() {
        return this.fillBackgroundColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillBackgroundColor(Color fillBackgroundColor) {
        Color old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.fillBackgroundColor;
            this.fillBackgroundColor = fillBackgroundColor;
        }
        this.listeners.firePropertyChange("fillBackgroundColor", old, fillBackgroundColor);
    }

    public synchronized float[] getFillGradientPoints() {
        return this.fillGradientPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillGradientPoints(float[] fillGradientPoints) {
        float[] old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.fillGradientPoints;
            this.fillGradientPoints = fillGradientPoints;
        }
        this.listeners.firePropertyChange("fillGradientPoints", old, fillGradientPoints);
    }

    public synchronized float getFillOpacity() {
        return this.fillOpacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillOpacity(float fillOpacity) {
        float old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.fillOpacity;
            this.fillOpacity = fillOpacity;
        }
        this.listeners.firePropertyChange("fillOpacity", new Float(old), new Float(fillOpacity));
    }

    public synchronized FillPattern getFillPattern() {
        return this.fillPattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillPattern(FillPattern fillPattern) {
        FillPattern old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.fillPattern;
            this.fillPattern = fillPattern;
        }
        this.listeners.firePropertyChange("fillPattern", old, fillPattern);
    }

    public synchronized FillStyle getFillStyle() {
        return this.fillStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFillStyle(FillStyle fillStyle) {
        FillStyle old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.fillStyle;
            this.fillStyle = fillStyle;
        }
        this.listeners.firePropertyChange("fillStyle", old, fillStyle);
    }

    public synchronized Font getFont() {
        return this.font;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFont(Font font) {
        Font old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.font;
            this.font = font;
        }
        this.listeners.firePropertyChange("font", old, font);
    }

    public synchronized float getHaloRadius() {
        return this.haloRadius;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHaloRadius(float haloRadius) {
        float old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.haloRadius;
            this.haloRadius = haloRadius;
        }
        this.listeners.firePropertyChange("haloRadius", new Float(old), new Float(haloRadius));
    }

    public synchronized Color getHaloColor() {
        return this.haloColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHaloColor(Color haloColor) {
        Color old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.haloColor;
            this.haloColor = haloColor;
        }
        this.listeners.firePropertyChange("haloColor", old, haloColor);
    }

    public synchronized Color getBackgroundColor() {
        return this.backgroundColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBackgroundColor(Color backgroundColor) {
        Color old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.backgroundColor;
            this.backgroundColor = backgroundColor;
        }
        this.listeners.firePropertyChange("backgroundColor", old, backgroundColor);
    }

    public synchronized float getRotation() {
        return this.rotation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotation(float rotation) {
        float old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.rotation;
            this.rotation = rotation;
        }
        this.listeners.firePropertyChange("rotation", new Float(old), new Float(rotation));
    }

    public synchronized XAnchor getXAnchor() {
        return this.xAnchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXAnchor(XAnchor xAnchor) {
        XAnchor old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.xAnchor;
            this.xAnchor = xAnchor;
        }
        this.listeners.firePropertyChange("xAnchor", old, xAnchor);
    }

    public synchronized float getXDisplacement() {
        return this.xDisplacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXDisplacement(float xDisplacement) {
        float old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.xDisplacement;
            this.xDisplacement = xDisplacement;
        }
        this.listeners.firePropertyChange("xDisplacement", new Float(old), new Float(xDisplacement));
    }

    public synchronized YAnchor getYAnchor() {
        return this.yAnchor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYAnchor(YAnchor yAnchor) {
        YAnchor old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.yAnchor;
            this.yAnchor = yAnchor;
        }
        this.listeners.firePropertyChange("yAnchor", old, yAnchor);
    }

    public synchronized float getYDisplacement() {
        return this.yDisplacement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setYDisplacement(float yDisplacement) {
        float old;
        DefaultTextSymbolizer defaultTextSymbolizer = this;
        synchronized (defaultTextSymbolizer) {
            old = this.yDisplacement;
            this.yDisplacement = yDisplacement;
        }
        this.listeners.firePropertyChange("yDisplacement", new Float(old), new Float(yDisplacement));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setPropertiesFrom(GraphicStyle graphicStyle) {
        this.acquireEventLock();
        try {
            super.setPropertiesFrom(graphicStyle);
            if (graphicStyle instanceof DefaultTextSymbolizer) {
                TextSymbolizer ts = (TextSymbolizer)graphicStyle;
                this.setBackgroundColor(ts.getBackgroundColor());
                this.setFillBackgroundColor(ts.getFillBackgroundColor());
                this.setFillColor(ts.getFillColor());
                this.setFillGradientPoints(ts.getFillGradientPoints());
                this.setFillOpacity(ts.getFillOpacity());
                this.setFillPattern(ts.getFillPattern());
                this.setFillStyle(ts.getFillStyle());
                this.setFont(ts.getFont());
                this.setHaloColor(ts.getHaloColor());
                this.setHaloRadius(ts.getHaloRadius());
                this.setRotation(ts.getRotation());
                this.setXAnchor(ts.getXAnchor());
                this.setXDisplacement(ts.getXDisplacement());
                this.setYAnchor(ts.getYAnchor());
                this.setYDisplacement(ts.getYDisplacement());
            }
        }
        finally {
            this.releaseEventLock();
        }
    }
}

