/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.display.style;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedHashMap;
import java.util.Map;
import org.geotools.display.style.DefaultGraphicStyleEvent;
import org.geotools.display.style.ValuePair;
import org.geotools.resources.Utilities;
import org.geotools.resources.XArray;
import org.opengis.go.display.style.GraphicStyle;
import org.opengis.go.display.style.event.GraphicStyleEvent;
import org.opengis.go.display.style.event.GraphicStyleListener;

final class GraphicStyleListenerList
implements PropertyChangeListener {
    private final GraphicStyle source;
    private GraphicStyleListener[] listeners;
    private final Map changes = new LinkedHashMap();
    private int groupCount;
    static final /* synthetic */ boolean $assertionsDisabled;

    public GraphicStyleListenerList(GraphicStyle source) {
        this.source = source;
        this.listeners = new GraphicStyleListener[0];
    }

    public GraphicStyleListenerList(GraphicStyleListenerList clone) {
        this.source = clone.source;
        this.listeners = clone.listeners;
    }

    public boolean add(GraphicStyleListener listener) {
        int count;
        if (!$assertionsDisabled && !Thread.holdsLock(this.source)) {
            throw new AssertionError();
        }
        int i = count = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] != listener) continue;
            return false;
        }
        this.listeners = (GraphicStyleListener[])XArray.resize(this.listeners, count + 1);
        this.listeners[count] = listener;
        return count == 0;
    }

    public boolean remove(GraphicStyleListener listener) {
        if (!$assertionsDisabled && !Thread.holdsLock(this.source)) {
            throw new AssertionError();
        }
        int i = this.listeners.length;
        while (--i >= 0) {
            if (this.listeners[i] != listener) continue;
            this.listeners = (GraphicStyleListener[])XArray.remove(this.listeners, i, 1);
            return this.listeners.length == 0;
        }
        return false;
    }

    private static void fire(GraphicStyleListener[] listeners, GraphicStyleEvent event) {
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].styleChanged(event);
                continue;
            }
            catch (RuntimeException exception) {
                Utilities.unexpectedException("org.geotools.display.style", "GraphicStyleListener", "styleChanged", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireEventLock() {
        GraphicStyle graphicStyle = this.source;
        synchronized (graphicStyle) {
            ++this.groupCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseEventLock() {
        DefaultGraphicStyleEvent event;
        GraphicStyleListener[] listeners;
        GraphicStyle graphicStyle = this.source;
        synchronized (graphicStyle) {
            if (this.groupCount == 0) {
                throw new IllegalStateException();
            }
            if (--this.groupCount != 0 || this.changes.isEmpty()) {
                return;
            }
            listeners = this.listeners;
            event = new DefaultGraphicStyleEvent(this.source, this.changes);
            this.changes.clear();
        }
        GraphicStyleListenerList.fire(listeners, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent change) {
        DefaultGraphicStyleEvent event;
        GraphicStyleListener[] listeners;
        GraphicStyle graphicStyle = this.source;
        synchronized (graphicStyle) {
            String name = change.getPropertyName();
            ValuePair pair = new ValuePair(change);
            ValuePair previous = this.changes.put(name, pair);
            if (previous != null) {
                if (previous.concatenate(pair)) {
                    this.changes.remove(name);
                } else {
                    this.changes.put(name, previous);
                }
            }
            if (this.groupCount != 0) {
                return;
            }
            listeners = this.listeners;
            event = new DefaultGraphicStyleEvent(this.source, this.changes);
            this.changes.clear();
        }
        GraphicStyleListenerList.fire(listeners, event);
    }

    static {
        $assertionsDisabled = !GraphicStyleListenerList.class.desiredAssertionStatus();
    }
}

